/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import weblogic.rmi.cluster.BasicReplicaList;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.cluster.ServerInfo;
import weblogic.rmi.cluster.ServerInfoManager;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.spi.HostID;

public final class RichReplicaList
extends BasicReplicaList {
    private static final long serialVersionUID = -5818437427224059485L;
    private int maxWeight = -1;
    private int previousSize = 1;
    private ServerInfo[] serverInfoArray = null;
    private int loopIter = 1;
    private Object localServerInfo;

    public RichReplicaList(RemoteReference primary) {
        super(primary);
        this.maxWeight = -1;
        this.loopIter = 1;
    }

    private RichReplicaList(RemoteReference primary, Object localServerInfo) {
        this(primary);
        this.localServerInfo = localServerInfo;
    }

    public RemoteReference findReplicaHostedBy(String serverName) {
        HostID serverId = null;
        ServerInfo info = ServerInfoManager.theOne().getServerInfo(serverName);
        if (info != null) {
            serverId = info.getID();
        }
        if (serverId == null) {
            return null;
        }
        return this.findReplicaHostedBy(serverId);
    }

    public boolean isChanged() {
        int currentSize = this.size();
        if (this.previousSize != currentSize) {
            this.previousSize = currentSize;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxServerWeight() {
        if (this.isChanged()) {
            this.maxWeight = -1;
        }
        if (this.maxWeight == -1) {
            ServerInfoManager infoManager = ServerInfoManager.theOne();
            RichReplicaList richReplicaList = this;
            synchronized (richReplicaList) {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    int weight;
                    RemoteReference ror = (RemoteReference)it.next();
                    ServerInfo serverInfo = infoManager.getServerInfo(ror);
                    if (serverInfo == null || (weight = serverInfo.getLoadWeight()) <= this.maxWeight) continue;
                    this.maxWeight = weight;
                }
            }
        }
        return this.maxWeight;
    }

    @Override
    public void reset(ReplicaList newList) {
        super.reset(newList);
        this.maxWeight = -1;
        this.loopIter = 1;
        this.resetAndNormalizeWeights();
    }

    public RichReplicaList() {
        this.loopIter = 1;
    }

    @Override
    public ReplicaList getListWithRefHostedBy(HostID hostID) {
        return new RichReplicaList(this.findReplicaHostedBy(hostID), new Object[]{ServerInfoManager.theOne().getServerInfo(hostID)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetAndNormalizeWeights() {
        RichReplicaList richReplicaList = this;
        synchronized (richReplicaList) {
            this.serverInfoArray = ServerInfoManager.theOne().getServerInfos();
            int tmpGds = this.serverInfoArray[0].getLoadWeight();
            for (int i = 1; i < this.serverInfoArray.length; ++i) {
                tmpGds = RichReplicaList.gcd(tmpGds, this.serverInfoArray[i].getLoadWeight());
            }
            this.normalizeWeights(tmpGds, this.serverInfoArray);
        }
    }

    private void normalizeWeights(int norWeight, ServerInfo[] infoArray) {
        this.loopIter = 1;
        for (int i = 0; i < infoArray.length; ++i) {
            infoArray[i].setNormalizedWeight(infoArray[i].getLoadWeight() / norWeight);
            if (infoArray[i].getNormalizedWeight() <= this.loopIter) continue;
            this.loopIter = infoArray[i].getNormalizedWeight();
        }
    }

    int getLoopIter() {
        return this.loopIter;
    }

    ServerInfo[] getServerInfos() {
        return this.serverInfoArray;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.localServerInfo != null) {
            out.writeObject(this.localServerInfo);
        } else {
            out.writeObject(ServerInfoManager.theOne().writeUpdate());
        }
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ServerInfoManager.theOne().readUpdate(in.readObject());
        super.readExternal(in);
    }

    private static int gcd(int a, int b) {
        while (b != 0) {
            int z = a % b;
            a = b;
            b = z;
        }
        return a;
    }
}

