/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.cluster;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import weblogic.rmi.cluster.BasicReplicaHandler;
import weblogic.rmi.cluster.ReplicaAwareInfo;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.cluster.RetryHandler;
import weblogic.rmi.cluster.RichReplicaList;
import weblogic.rmi.cluster.ServerInfo;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;

public class WeightBasedReplicaHandler
extends BasicReplicaHandler {
    private static final long serialVersionUID = 2841813223614351417L;
    private static final boolean DEBUG = false;
    private ServerInfo[] infoArray = null;
    private int size;
    private int maxIter;
    private int loopCounter;
    private int listIter;
    private int lastIndex = 0;

    public WeightBasedReplicaHandler(ReplicaAwareInfo info, RemoteReference primary) {
        super(info, new RichReplicaList(primary));
        this.listIter = -1;
        this.maxIter = 0;
        this.loopCounter = -1;
    }

    public WeightBasedReplicaHandler(ReplicaAwareInfo info, RichReplicaList replicaList) {
        super(info, replicaList);
        this.listIter = -1;
        this.maxIter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RemoteReference chooseReplica(RemoteReference currentRef, Method method, Object[] params) {
        RemoteReference ref = currentRef;
        WeightBasedReplicaHandler weightBasedReplicaHandler = this;
        synchronized (weightBasedReplicaHandler) {
            RichReplicaList replicaList = (RichReplicaList)this.getReplicaList();
            if (this.infoArray == null || this.infoArray.length == 0) {
                this.reinitializeWeightInfo();
            }
            if (this.size != 0) {
                for (int i = this.lastIndex; i < this.size + this.lastIndex; ++i) {
                    int temp;
                    ++this.listIter;
                    this.listIter %= this.size;
                    if (this.listIter == 0) {
                        ++this.loopCounter;
                        this.loopCounter %= this.maxIter;
                    }
                    if (this.infoArray[temp = i % this.size].getNormalizedWeight() <= this.loopCounter || (ref = replicaList.findReplicaHostedBy(this.infoArray[temp].getID())) == null) continue;
                    this.lastIndex = ++temp;
                    break;
                }
            }
        }
        return ref;
    }

    @Override
    protected RemoteReference chooseReplicaAfterFailure(RemoteReference failedRef, Method method, Object[] params, RemoteException exception) {
        RemoteReference currentRef = null;
        if (this.getReplicaList().size() > 0) {
            currentRef = this.getReplicaList().get(0);
        }
        if (currentRef == null) {
            currentRef = failedRef;
        }
        return this.chooseReplica(currentRef, method, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteReference failOver(RemoteReference failedRef, RuntimeMethodDescriptor md, Method m, Object[] params, RemoteException re, RetryHandler retryHandler) throws RemoteException {
        RemoteReference ref = null;
        WeightBasedReplicaHandler weightBasedReplicaHandler = this;
        synchronized (weightBasedReplicaHandler) {
            ReplicaList list;
            ReplicaList replicaList = list = this.getReplicaList();
            synchronized (replicaList) {
                for (int index = 0; index < list.size(); ++index) {
                    ref = list.get(index);
                    if (ref.equals(failedRef)) continue;
                }
            }
            this.reinitializeWeightInfo();
        }
        ref = super.failOver(failedRef, md, m, params, re, retryHandler);
        return ref;
    }

    private void reinitializeWeightInfo() {
        RichReplicaList replicaList = (RichReplicaList)this.getReplicaList();
        replicaList.resetAndNormalizeWeights();
        this.infoArray = replicaList.getServerInfos();
        this.size = this.infoArray.length;
        this.listIter = -1;
        this.loopCounter = -1;
        this.maxIter = replicaList.getLoopIter();
        int current = 0;
        for (int i = 0; i < this.size; ++i) {
            current += this.infoArray[i].getNormalizedWeight();
        }
        int chosen = (int)(Math.random() * (double)current);
        current = 0;
        for (int i = 0; i < this.size; ++i) {
            if (chosen >= (current += this.infoArray[i].getNormalizedWeight())) continue;
            this.lastIndex = i;
            break;
        }
    }

    @Override
    public synchronized void resetReplicaList(ReplicaList newList) {
        super.resetReplicaList(newList);
        this.infoArray = null;
        if (this.getReplicaList().size() < 1) {
            return;
        }
        this.reinitializeWeightInfo();
    }

    public WeightBasedReplicaHandler() {
        this.loopCounter = -1;
        this.listIter = -1;
    }
}

