/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.extensions;

import java.rmi.Remote;
import java.util.HashMap;
import java.util.HashSet;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.rmi.extensions.DisconnectEventImpl;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitorException;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.rmi.extensions.server.DisconnectMonitorProvider;
import weblogic.rmi.extensions.server.HeartbeatHelper;

public abstract class AbstractDisconnectMonitorDelegate
implements DisconnectMonitorProvider {
    private static final DebugLogger debugDGC = DebugLogger.getDebugLogger("DebugDGC");
    private static final boolean DEBUG = AbstractDisconnectMonitorDelegate.getDebug();
    private final HashMap listenerSet = new HashMap();
    private final HashMap remote2Helper = new HashMap();
    private static ThreadGroup hbmThreadGroup = null;
    private static boolean hasThreadGroupAccess = true;

    private static boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.dgc");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void debug(String msg) {
        debugDGC.debug("<AbstractDisconnectMonitorDelegate>: " + msg);
    }

    public AbstractDisconnectMonitorDelegate() {
        DisconnectMonitorListImpl.getDisconnectMonitorList().addDisconnectMonitor(this);
    }

    protected abstract HeartbeatHelper getHeartbeatHelper(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addDisconnectListener(Remote r, DisconnectListener listener) {
        HeartbeatHelper helper = this.getHeartbeatHelper(r);
        if (helper == null) {
            return false;
        }
        if (DEBUG) {
            AbstractDisconnectMonitorDelegate.debug("addDisconnectMonitorListener...");
        }
        HashMap hashMap = this.listenerSet;
        synchronized (hashMap) {
            this.remote2Helper.put(listener, helper);
            HelperEntry entry = (HelperEntry)this.listenerSet.get(helper);
            if (entry == null) {
                entry = new HelperEntry(this.startPinger(helper));
                this.listenerSet.put(helper, entry);
            }
            entry.listeners.add(listener);
        }
        return true;
    }

    private Timer startPinger(HeartbeatHelper helper) {
        Timer timer = new Timer(this, helper);
        Thread timerThread = AbstractDisconnectMonitorDelegate.createThread(timer, "Request Timer Thread");
        timerThread.setDaemon(true);
        Pinger pinger = new Pinger(this, helper, timer);
        Thread pingerThread = AbstractDisconnectMonitorDelegate.createThread(pinger, "Heartbeat Request Thread");
        pingerThread.setDaemon(true);
        pingerThread.start();
        timerThread.start();
        if (DEBUG) {
            AbstractDisconnectMonitorDelegate.debug("timer/pinger started");
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDisconnectListener(Remote r, DisconnectListener listener) {
        HashMap hashMap = this.listenerSet;
        synchronized (hashMap) {
            HeartbeatHelper helper = (HeartbeatHelper)this.remote2Helper.remove(listener);
            if (helper == null) {
                return false;
            }
            HelperEntry entry = (HelperEntry)this.listenerSet.get(helper);
            if (entry != null) {
                entry.listeners.remove(listener);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverDisconnectEvent(Throwable reason, Object key) {
        HelperEntry entry = null;
        if (DEBUG) {
            AbstractDisconnectMonitorDelegate.debug("deliver [" + reason + "] to listeners");
        }
        HashMap hashMap = this.listenerSet;
        synchronized (hashMap) {
            entry = (HelperEntry)this.listenerSet.remove(key);
            if (entry == null) {
                return;
            }
        }
        for (DisconnectListener l : (HashSet)entry.listeners.clone()) {
            l.onDisconnect(new DisconnectEventImpl(reason));
        }
    }

    private static Thread createThread(Runnable runnable, String name) {
        if (!KernelStatus.isApplet()) {
            return new Thread(runnable, name);
        }
        AbstractDisconnectMonitorDelegate.initializeHBMThreadGroup();
        if (hbmThreadGroup != null) {
            return new Thread(hbmThreadGroup, runnable, name);
        }
        return new Thread(runnable, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initializeHBMThreadGroup() {
        if (!hasThreadGroupAccess || hbmThreadGroup != null) return;
        Class<AbstractDisconnectMonitorDelegate> clazz = AbstractDisconnectMonitorDelegate.class;
        synchronized (AbstractDisconnectMonitorDelegate.class) {
            if (hbmThreadGroup != null) return;
            try {
                ThreadGroup tg = Thread.currentThread().getThreadGroup();
                while (true) {
                    if (tg.getName().equals("main") && tg.getParent().getName().equals("system")) {
                        ThreadGroup theParent = tg;
                        hbmThreadGroup = new ThreadGroup(theParent, "HeartbeatMonitor ThreadGroup"){

                            @Override
                            public String toString() {
                                return "HBMThreadGroup(name=" + this.getName() + ", parent=" + this.getParent() + ')';
                            }
                        };
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                    tg = tg.getParent();
                }
            }
            catch (SecurityException se) {
                AbstractDisconnectMonitorDelegate.debug(" +++ <Warning> Don't have permissions to access ThreadGroup.  We strongly recommend to use signed applet.");
                AbstractDisconnectMonitorDelegate.debug(" +++ <Warning> Proceed further without creating ThreadGroup.");
                hasThreadGroupAccess = false;
            }
            return;
        }
    }

    protected static class Pinger
    implements Runnable {
        protected AbstractDisconnectMonitorDelegate delegate;
        protected HeartbeatHelper helper;
        protected Timer timer;

        protected Pinger(AbstractDisconnectMonitorDelegate delegate, HeartbeatHelper helper, Timer timer) {
            this.delegate = delegate;
            this.helper = helper;
            this.timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    if (DEBUG) {
                        AbstractDisconnectMonitorDelegate.debug("pinger called");
                    }
                    this.helper.ping();
                    if (DEBUG) {
                        AbstractDisconnectMonitorDelegate.debug("pinger renews lease");
                    }
                    this.timer.renewLease();
                    continue;
                }
                catch (Exception e) {
                    if (DEBUG) {
                        debugDGC.debug("pinger caught:", e);
                    }
                    this.delegate.deliverDisconnectEvent(e, this.helper);
                    return;
                }
                finally {
                    HashMap hashMap = this.delegate.listenerSet;
                    synchronized (hashMap) {
                        HelperEntry entry = (HelperEntry)this.delegate.listenerSet.get(this.helper);
                        if (entry == null || entry.listeners.isEmpty()) {
                            this.timer.cancel();
                            this.delegate.listenerSet.remove(this.helper);
                            return;
                        }
                    }
                    continue;
                }
                break;
            }
        }
    }

    protected static class Timer
    implements Runnable {
        protected AbstractDisconnectMonitorDelegate delegate;
        protected Object key;
        protected int lease = 1;
        protected volatile boolean cancel = false;

        protected Timer(AbstractDisconnectMonitorDelegate delegate, Object key) {
            this.delegate = delegate;
            this.key = key;
        }

        protected void renewLease() {
            ++this.lease;
        }

        protected synchronized void cancel() {
            this.cancel = true;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long t1 = System.currentTimeMillis();
            int oldLease = this.lease;
            try {
                long delta;
                while (true) {
                    if (DEBUG) {
                        AbstractDisconnectMonitorDelegate.debug("timer waits...");
                    }
                    try {
                        Timer timer = this;
                        synchronized (timer) {
                            this.wait(60000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.cancel) {
                        if (DEBUG) {
                            AbstractDisconnectMonitorDelegate.debug("timer canceled");
                        }
                        return;
                    }
                    if (oldLease < this.lease) {
                        oldLease = this.lease;
                        t1 = System.currentTimeMillis();
                        continue;
                    }
                    delta = System.currentTimeMillis() - t1;
                    if (DEBUG) {
                        AbstractDisconnectMonitorDelegate.debug("timer fires after " + delta + "ms, oldLease=" + oldLease + ", lease=" + this.lease);
                    }
                    if (delta >= 240000L) break;
                }
                this.delegate.deliverDisconnectEvent(new DisconnectMonitorException("DisconnectMonitor timed out after " + delta / 1000L + "s."), this.key);
                return;
            }
            catch (Throwable t) {
                if (DEBUG) {
                    debugDGC.debug(t.getMessage(), t);
                }
                this.delegate.deliverDisconnectEvent(t, this.key);
                return;
            }
        }
    }

    private static class HelperEntry {
        private Timer timer;
        private HashSet listeners = new HashSet();

        private HelperEntry(Timer timer) {
            this.timer = timer;
        }
    }
}

