/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.facades;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jvnet.hk2.annotations.Service;
import weblogic.rmi.client.facades.RmiClientSecurityFacade;
import weblogic.rmi.client.facades.RmiClientSecurityFacadeDelegateImpl;
import weblogic.rmi.facades.RmiInvocationFacade;
import weblogic.rmi.facades.RmiSecurityFacadeDelegate;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.service.CredentialManager;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.LocatorUtilities;

public abstract class RmiSecurityFacade
extends RmiClientSecurityFacade {
    public static String getDefaultRealm() {
        return RmiSecurityFacade.getInstance().doGetDefaultRealm();
    }

    public static PrincipalAuthenticator getPrincipalAuthenticator(AuthenticatedSubject kernelId, String realmName) {
        return RmiSecurityFacade.getInstance().doGetPrincipalAuthenticator(kernelId, realmName);
    }

    private static RmiSecurityFacadeDelegate getInstance() {
        return RmiSecurityFacadeInitializer.instance;
    }

    public static boolean isSecurityServiceInitialized() {
        return RmiSecurityFacade.getInstance().doIsSecurityServiceInitialized();
    }

    public static AuthenticatedSubject getAnonymousSubject() {
        return RmiSecurityFacade.getInstance().doGetAnonymousSubject();
    }

    public static boolean isUserAnAdministrator(AuthenticatedSubject subject) {
        return RmiSecurityFacade.getInstance().doIsUserAnAdministrator(subject);
    }

    public static CredentialManager getCredentialManager(AuthenticatedSubject kernelId, String realmName) {
        return RmiSecurityFacade.getInstance().doGetCredentialManager(kernelId, realmName);
    }

    public static String getSecurityRealmName(AuthenticatedSubject kernelId) {
        if (RmiInvocationFacade.isGlobalPartition(kernelId)) {
            return "weblogicDEFAULT";
        }
        return RmiInvocationFacade.getCurrentPartitionName(kernelId);
    }

    public static AuthenticatedUser convertToAuthenticatedUser(AuthenticatedSubject subject) {
        return RmiSecurityFacade.getInstance().doConvertToAuthenticatedUser(subject);
    }

    public static AuthenticatedSubject getASFromAUInServerOrClient(AuthenticatedUser user) {
        return RmiSecurityFacade.getInstance().doGetASFromAUInServerOrClient(user);
    }

    public static AuthenticatedSubject sendASToWire(AuthenticatedSubject subject) {
        return RmiSecurityFacade.getInstance().doSendASToWire(subject);
    }

    public static boolean hasAdminRoles(AuthenticatedSubject subject) {
        return RmiSecurityFacade.getInstance().doDoesUserHaveAnyAdminRoles(subject);
    }

    public static <T> T runAs(AuthenticatedSubject kernelId, AuthenticatedSubject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        return RmiSecurityFacade.getInstance().doRunAs(kernelId, subject, action);
    }

    @Service
    private static class FFSecurityFacade
    extends RmiClientSecurityFacadeDelegateImpl
    implements RmiSecurityFacadeDelegate {
        private FFSecurityFacade() {
        }

        @Override
        public String doGetDefaultRealm() {
            return "weblogicDEFAULT";
        }

        @Override
        public PrincipalAuthenticator doGetPrincipalAuthenticator(AuthenticatedSubject kernelId, String realmName) {
            return (PrincipalAuthenticator)FFSecurityFacade.getSecurityService(kernelId, realmName, SecurityService.ServiceType.AUTHENTICATION);
        }

        private static SecurityService getSecurityService(AuthenticatedSubject kernelId, String realmName, SecurityService.ServiceType serviceType) {
            return SecurityServiceManager.getSecurityService(kernelId, realmName, serviceType);
        }

        @Override
        public boolean doIsKernelIdentity(AuthenticatedSubject subject) {
            return SecurityServiceManager.isKernelIdentity(subject);
        }

        @Override
        public boolean doIsSecurityServiceInitialized() {
            return SecurityServiceManager.isSecurityServiceInitialized();
        }

        @Override
        public boolean doIsUserAnAdministrator(AuthenticatedSubject subject) {
            return SubjectUtils.isUserAnAdministrator(subject);
        }

        @Override
        public CredentialManager doGetCredentialManager(AuthenticatedSubject kernelId, String realmName) {
            return (CredentialManager)FFSecurityFacade.getSecurityService(kernelId, realmName, SecurityService.ServiceType.CREDENTIALMANAGER);
        }

        @Override
        public AuthenticatedUser doConvertToAuthenticatedUser(AuthenticatedSubject subject) {
            return SecurityServiceManager.convertToAuthenticatedUser(subject);
        }

        @Override
        public AuthenticatedSubject doSendASToWire(AuthenticatedSubject subject) {
            return SecurityServiceManager.sendASToWire(subject);
        }

        @Override
        public AuthenticatedSubject doGetASFromAUInServerOrClient(AuthenticatedUser user) {
            return SecurityServiceManager.getASFromAUInServerOrClient(user);
        }

        @Override
        public boolean doDoesUserHaveAnyAdminRoles(AuthenticatedSubject subject) {
            return SubjectUtils.doesUserHaveAnyAdminRoles(subject);
        }

        @Override
        public <T> T doRunAs(AuthenticatedSubject kernelId, AuthenticatedSubject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
            return (T)SecurityServiceManager.runAs(kernelId, subject, action);
        }
    }

    private static final class RmiSecurityFacadeInitializer {
        private static final RmiSecurityFacadeDelegate instance = (RmiSecurityFacadeDelegate)LocatorUtilities.getService(RmiSecurityFacadeDelegate.class);

        private RmiSecurityFacadeInitializer() {
        }
    }
}

