/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.util.concurrent.TimeoutException;
import weblogic.rmi.extensions.AsyncResult;
import weblogic.rmi.extensions.RequestTimeoutException;
import weblogic.rmi.spi.AsyncCallback;
import weblogic.rmi.spi.InboundRequest;
import weblogic.rmi.spi.InboundResponse;
import weblogic.rmi.spi.MsgOutput;
import weblogic.rmi.spi.OutboundResponse;

public class AsyncResultImpl
implements AsyncResult,
AsyncCallback {
    protected boolean objectRetrieved;
    protected InboundResponse inboundResponse;
    private InboundRequest request;
    private OutboundResponse response;
    protected Throwable throwable;
    protected Object result;
    private long timeOut = -1L;

    public AsyncResultImpl() {
    }

    public AsyncResultImpl(InboundRequest ir, OutboundResponse or) {
        this.request = ir;
        this.response = or;
    }

    protected synchronized Object getResults() throws Throwable {
        if (!this.hasResults()) {
            if (this.timeOut == -1L) {
                this.wait();
            } else {
                this.wait(this.timeOut);
            }
            if (!this.hasResults()) {
                throw new RequestTimeoutException();
            }
        }
        if (this.throwable != null) {
            throw this.throwable;
        }
        return this.inboundResponse.unmarshalReturn();
    }

    @Override
    public synchronized boolean hasResults() {
        return this.inboundResponse != null || this.throwable != null;
    }

    @Override
    public final void setTimeOut(long msecs) {
        this.timeOut = msecs;
    }

    @Override
    public final void setResult(Object o) throws RemoteException {
        this.result = o;
        this.objectRetrieved = true;
        if (this.response == null) {
            return;
        }
        try {
            this.response.transferThreadLocalContext(this.request);
            MsgOutput sos = this.response.getMsgOutput();
            if (sos == null) {
                return;
            }
            sos.writeObject(o, o == null ? null : o.getClass());
        }
        catch (IOException ioe) {
            throw new MarshalException("error marshalling return", ioe);
        }
    }

    public final Object getObjectNoWait() throws Throwable {
        return this.result;
    }

    @Override
    public Object getObject() throws Throwable {
        if (this.objectRetrieved) {
            return this.result;
        }
        this.objectRetrieved = true;
        try {
            this.result = this.getResults();
        }
        finally {
            this.closeResponse();
        }
        return this.result;
    }

    @Override
    public synchronized void setThrowable(Throwable throwable) {
        this.throwable = throwable;
        this.notify();
    }

    protected synchronized void closeResponse() throws IOException {
        if (this.inboundResponse != null) {
            this.inboundResponse.close();
        }
    }

    @Override
    public synchronized void setInboundResponse(InboundResponse inboundResponse) {
        this.inboundResponse = inboundResponse;
        this.notify();
    }

    protected Object throwUserDefinedException(Throwable throwable, Class exceptionClass, Constructor constructor) {
        Exception exception = throwable instanceof RequestTimeoutException ? new TimeoutException() : new RuntimeException();
        exception.initCause(throwable);
        if (exceptionClass != null && constructor != null) {
            try {
                return constructor.newInstance(exception);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        return exception;
    }
}

