/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.IOException;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import weblogic.rmi.cluster.PiggybackResponse;
import weblogic.rmi.extensions.server.FutureResponse;
import weblogic.rmi.internal.BasicServerRef;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.spi.InboundRequest;
import weblogic.rmi.spi.MsgOutput;
import weblogic.rmi.spi.OutboundResponse;
import weblogic.utils.NestedException;
import weblogic.utils.StackTraceUtilsClient;

public class BasicFutureResponse
implements FutureResponse,
OutboundResponse {
    private final OutboundResponse response;
    private final InboundRequest request;
    private boolean txSet;
    private Throwable sendTxTrace = null;

    public BasicFutureResponse(InboundRequest req, OutboundResponse res) {
        this.request = req;
        this.response = res;
    }

    @Override
    public MsgOutput getMsgOutput() throws RemoteException {
        this.associateResponseData();
        return this.response.getMsgOutput();
    }

    @Override
    public void send() throws RemoteException {
        this.associateResponseData();
        this.response.send();
        try {
            this.request.close();
        }
        catch (IOException ioe) {
            throw new MarshalException("failed to close inbound request", ioe);
        }
    }

    @Override
    public void sendThrowable(Throwable problem) {
        Throwable t = problem;
        if (!RMIEnvironment.getEnvironment().printExceptionStackTrace()) {
            StackTraceUtilsClient.scrubExceptionStackTrace(t);
        }
        try {
            this.associateResponseData();
        }
        catch (Throwable throwable) {
            t = new NestedException(problem);
        }
        BasicServerRef.handleThrowable(t, this.response);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void setTxContext(Object txContext) throws RemoteException {
        if (this.txSet) {
            throw new IllegalStateException("Attempt to send tx context twice");
        }
        this.response.setTxContext(txContext);
        this.txSet = true;
    }

    @Override
    public void transferThreadLocalContext(InboundRequest request) throws IOException {
    }

    @Override
    public void setContext(int id, Object data) throws IOException {
    }

    private final void associateResponseData() throws RemoteException {
        if (!this.txSet) {
            if (this.response != null) {
                try {
                    this.response.transferThreadLocalContext(this.request);
                }
                catch (IOException ioe) {
                    throw new RemoteException(ioe.getMessage(), ioe);
                }
            }
            this.txSet = true;
        }
    }

    @Override
    public void setPiggybackResponse(PiggybackResponse piggybackResponse) throws IOException {
        this.response.setPiggybackResponse(piggybackResponse);
    }
}

