/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.lang.reflect.Method;
import java.rmi.ConnectException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.concurrent.Future;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolStack;
import weblogic.protocol.ServerChannelManager;
import weblogic.rmi.RemoteEJBInvokeException;
import weblogic.rmi.extensions.UnrecoverableConnectionException;
import weblogic.rmi.extensions.server.OutboundRequestBuilder;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.AsyncResultImpl;
import weblogic.rmi.internal.FutureResultImpl;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.ObjectIO;
import weblogic.rmi.internal.OperationConstants;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.ReferenceConstants;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.rmi.spi.AsyncCallback;
import weblogic.rmi.spi.Channel;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.InboundResponse;
import weblogic.rmi.spi.Interceptor;
import weblogic.rmi.spi.InterceptorManager;
import weblogic.rmi.spi.MsgOutput;
import weblogic.rmi.spi.OutboundRequest;
import weblogic.rmi.spi.RMIRuntime;
import weblogic.trace.Trace;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;

public class BasicRemoteRef
implements RemoteReference,
ReferenceConstants,
OperationConstants,
Externalizable,
OutboundRequestBuilder {
    private static final boolean ASSERT = true;
    static final long serialVersionUID = 215700904493420587L;
    protected int oid;
    private EndPoint endPoint;
    private PeerInfo peerInfo = null;
    protected HostID hostID;
    private String channelName;
    private Protocol protocol;
    private static boolean enableQOSOnStub;
    private static final boolean tracingEnabled;
    private transient boolean hostReachable = true;
    private int staleStubInvocationCount;
    private transient boolean timedOut;
    private transient long timeStamp;

    public BasicRemoteRef(int oid, HostID hostID) {
        this(oid, hostID, null);
    }

    public BasicRemoteRef(int oid, HostID hostID, String channelName) {
        this.oid = oid;
        this.hostID = hostID;
        this.channelName = channelName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BasicRemoteRef)) {
            return false;
        }
        BasicRemoteRef other = (BasicRemoteRef)obj;
        if (other.oid != this.oid) {
            return false;
        }
        return this.hostID.equals(other.hostID);
    }

    public int hashCode() {
        return this.oid;
    }

    public String toString() {
        return this.getClass().getName() + " - hostID: '" + this.hostID + " channel: '" + this.channelName + '\'';
    }

    private boolean couldBeAStaleStub(RuntimeMethodDescriptor md) {
        if (KernelStatus.isServer()) {
            return false;
        }
        String className = md.getDeclaringClass().getName();
        if (className == null) {
            return false;
        }
        return className.indexOf("weblogic.jms.frontend.FEConnectionFactory") >= 0;
    }

    private synchronized void incrementStaleStubInvocationCount() {
        ++this.staleStubInvocationCount;
    }

    private synchronized void decrementStaleStubInvocationCount() {
        if (this.staleStubInvocationCount > 0) {
            --this.staleStubInvocationCount;
        }
    }

    @Override
    public OutboundRequest getOutboundRequest(RuntimeMethodDescriptor md, int contextID, Object context, String partitionURL) throws IOException {
        if (!this.hostReachable) {
            throw new ConnectException("Unable to reach host");
        }
        boolean couldBeAStaleStub = this.ensureStubIsUsable(md);
        EndPoint curEndPoint = this.getEndPoint();
        OutboundRequest req = this.getRequest(md, couldBeAStaleStub, curEndPoint, partitionURL);
        this.setServiceContexts(md, curEndPoint, req);
        this.setCustomContexts(req, contextID, context);
        req.transferThreadLocalContext();
        return req;
    }

    private void setCustomContexts(OutboundRequest req, int contextID, Object context) throws IOException {
        req.setContext(contextID, context);
    }

    @Override
    public OutboundRequest getOutboundRequest(RuntimeMethodDescriptor md, String partitionName, String partitionURL) throws IOException {
        return this.getOutboundRequest(md, partitionURL);
    }

    @Override
    @Deprecated
    public OutboundRequest getOutboundRequest(RuntimeMethodDescriptor md, String partitionURL) throws IOException {
        if (!this.hostReachable) {
            throw new ConnectException("Unable to reach host");
        }
        boolean couldBeAStaleStub = this.ensureStubIsUsable(md);
        EndPoint curEndPoint = this.getEndPoint();
        OutboundRequest req = this.getRequest(md, couldBeAStaleStub, curEndPoint, partitionURL);
        this.setServiceContexts(md, curEndPoint, req);
        req.transferThreadLocalContext();
        return req;
    }

    private void setServiceContexts(RuntimeMethodDescriptor md, EndPoint curEndPoint, OutboundRequest req) throws IOException {
        Interceptor ti;
        if (md.isTransactional() && (ti = InterceptorManager.getManager().getTransactionInterceptor()) != null) {
            Object txContext = ti.sendRequest(curEndPoint);
            req.setTxContext(txContext);
        }
        if (tracingEnabled) {
            req.setContext(4, Trace.currentTrace());
        }
        this.transferContext(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutboundRequest getRequest(RuntimeMethodDescriptor md, boolean couldBeAStaleStub, EndPoint curEndPoint, String partitionURL) throws IOException {
        OutboundRequest req;
        try {
            req = enableQOSOnStub && this.protocol != null ? curEndPoint.getOutboundRequest(this, md, this.channelName, this.protocol, partitionURL) : curEndPoint.getOutboundRequest(this, md, this.channelName, partitionURL);
            if (couldBeAStaleStub) {
                this.decrementStaleStubInvocationCount();
            }
        }
        catch (UnrecoverableConnectionException urce) {
            BasicRemoteRef basicRemoteRef = this;
            synchronized (basicRemoteRef) {
                this.hostReachable = false;
            }
            String host = curEndPoint != null ? curEndPoint.getHostID().toString() : "";
            throw new ConnectException("Unable to reach host " + host + "\ncaused by: " + urce.getMessage() + '\n' + StackTraceUtils.throwable2StackTrace(urce));
        }
        catch (IOException ioe) {
            if (couldBeAStaleStub) {
                this.incrementStaleStubInvocationCount();
            }
            throw ioe;
        }
        req.setTimeOut(md.getTimeOut());
        return req;
    }

    private boolean ensureStubIsUsable(RuntimeMethodDescriptor md) throws ConnectException {
        boolean couldBeAStaleStub = this.couldBeAStaleStub(md);
        if (couldBeAStaleStub && this.staleStubInvocationCount >= 3) {
            throw new ConnectException("Repeated invocation from a stale stub. Preventing further bootstraps from this remote reference");
        }
        return couldBeAStaleStub;
    }

    protected void transferContext(OutboundRequest req) throws IOException {
    }

    @Override
    public Object invoke(Remote stub, RuntimeMethodDescriptor md, Object[] args, Method m) throws Throwable {
        if (md.hasAsyncResponse() || md.hasAsyncParameter()) {
            return this.sendAsync(stub, md, args);
        }
        String purl = this.getPartitionURL(stub);
        OutboundRequest request = this.getOutboundRequest(md, purl);
        InboundResponse response = null;
        try {
            if (md.isOneway()) {
                BasicRemoteRef.sendOneway(request, args);
                Object var8_8 = null;
                return var8_8;
            }
            request.marshalArgs(args);
            this.setOverrideMethodTimeout(stub, md, request);
            response = request.sendReceive();
            try {
                Object object = response.unmarshalReturn();
                return object;
            }
            catch (Throwable e) {
                if (e instanceof RemoteEJBInvokeException) {
                    throw e.getCause();
                }
                throw e;
            }
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException ioe) {
                throw new UnmarshalException("failed to close response stream", ioe);
            }
        }
    }

    protected String getPartitionURL(Remote stub) {
        if (stub == null) {
            return null;
        }
        if (stub instanceof StubInfoIntf) {
            return ((StubInfoIntf)((Object)stub)).getStubInfo().getPartitionURL();
        }
        throw new IllegalArgumentException("Unknown Remote Object: " + stub);
    }

    private void setOverrideMethodTimeout(Remote stub, RuntimeMethodDescriptor md, OutboundRequest request) {
        StubInfo si;
        int timeout;
        if (stub instanceof StubInfoIntf && (timeout = (si = ((StubInfoIntf)((Object)stub)).getStubInfo()).getTimeOut(md.getSignature())) > 0) {
            request.setTimeOut(timeout);
        }
    }

    private AsyncCallback sendAsync(Remote stub, RuntimeMethodDescriptor md, Object[] args) throws IOException {
        AsyncCallback result = null;
        OutboundRequest req = null;
        if (md.hasAsyncParameter()) {
            req = this.getOutboundRequest(md, this.getPartitionURL(stub));
            result = this.handleAsyncMarshalArgs(req, md, args);
        } else if (md.hasAsyncResponse()) {
            Debug.assertion(md.hasAsyncResponse());
            if (md.getReturnType().isAssignableFrom(Future.class)) {
                FutureResultImpl fri = this.createFutureResultObject(stub, md);
                req = this.getOutboundRequest(md, 25, fri.getId(), this.getPartitionURL(stub));
                result = fri;
            } else if (md.getReturnType().isAssignableFrom(Void.class)) {
                FutureResultImpl fri = this.createFutureResultObject(stub, md);
                req = this.getOutboundRequest(md, 25, fri.getId(), this.getPartitionURL(stub));
                result = null;
            } else {
                req = this.getOutboundRequest(md, this.getPartitionURL(stub));
                result = new AsyncResultImpl();
            }
            req.marshalArgs(args);
        }
        if (req == null) {
            throw new IOException("Failed to send request");
        }
        req.sendAsync(result);
        if (md.hasAsyncResponse()) {
            return result;
        }
        return null;
    }

    private FutureResultImpl createFutureResultObject(Remote stub, RuntimeMethodDescriptor md) throws RemoteException {
        FutureResultImpl fri = md.getRemoteExceptionWrapperClassName() != null && !md.getRemoteExceptionWrapperClassName().isEmpty() ? new FutureResultImpl(stub, md) : new FutureResultImpl(stub);
        return fri;
    }

    @Override
    public final String getCodebase() {
        return null;
    }

    @Override
    public synchronized void setRequestTimedOut(boolean flag) {
        if (RMIEnvironment.getEnvironment().getTimedOutRefIsolationTime() <= 0L) {
            return;
        }
        this.timedOut = flag;
        this.timeStamp = System.currentTimeMillis();
    }

    @Override
    public synchronized boolean hasRequestTimedOut() {
        if (!this.timedOut) {
            return false;
        }
        if (System.currentTimeMillis() - this.timeStamp > RMIEnvironment.getEnvironment().getTimedOutRefIsolationTime()) {
            this.setRequestTimedOut(false);
            return false;
        }
        return true;
    }

    protected static void sendOneway(OutboundRequest request, Object[] args) throws Exception {
        request.marshalArgs(args);
        request.sendOneWay();
    }

    private AsyncCallback handleAsyncMarshalArgs(OutboundRequest req, RuntimeMethodDescriptor md, Object[] args) throws MarshalException {
        try {
            MsgOutput out = req.getMsgOutput();
            int index = md.getAsyncParameterIndex();
            Class[] argTypes = md.getParameterTypes();
            short[] argTypeCodes = md.getParameterTypeAbbrevs();
            Debug.assertion(argTypes.length > 0);
            for (int i = 0; i < args.length; ++i) {
                if (index == i) continue;
                ObjectIO.writeObject(out, args[i], argTypes[i], argTypeCodes[i]);
            }
            if (args[index] == null) {
                return new AsyncResultImpl();
            }
            return (AsyncCallback)args[index];
        }
        catch (IOException e) {
            throw new MarshalException("failed to marshal " + md.getSignature(), e);
        }
    }

    @Override
    public final int getObjectID() {
        return this.oid;
    }

    @Override
    public final HostID getHostID() {
        return this.hostID;
    }

    @Override
    public final Channel getChannel() {
        return this.getEndPoint().getRemoteChannel();
    }

    public final EndPoint getEndPoint() {
        if (this.endPoint == null || this.endPoint.isDead()) {
            PeerInfo pi;
            this.endPoint = RMIRuntime.findOrCreateEndPoint(this.hostID);
            if (this.endPoint instanceof PeerInfoable && (pi = ((PeerInfoable)((Object)this.endPoint)).getPeerInfo()) != null) {
                this.peerInfo = pi;
            }
        }
        if (this.channelName == null && !this.hostID.isLocal()) {
            Channel ch = (Channel)((Object)this.hostID);
            this.channelName = ServerChannelManager.findServerChannelNameForPeer(ch.getPublicInetAddress());
        }
        return this.endPoint;
    }

    public EndPoint getCurrentEndPoint() {
        return this.endPoint;
    }

    public PeerInfo getCurrentPeerInfo() {
        return this.peerInfo;
    }

    public BasicRemoteRef() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.oid);
        out.writeObject(this.hostID);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.oid = in.readInt();
        this.hostID = (HostID)in.readObject();
        if (enableQOSOnStub) {
            this.protocol = ProtocolStack.get();
        }
    }

    public Object readResolve() throws ObjectStreamException {
        if (!this.getHostID().isLocal()) {
            return this;
        }
        try {
            ServerReference serverRef = OIDManager.getInstance().getServerReference(this.getObjectID());
            return serverRef.getLocalRef();
        }
        catch (NoSuchObjectException nsoe) {
            if (this.couldBeNonLocalOnNoSuchObjectException()) {
                return this;
            }
            throw (InvalidObjectException)new InvalidObjectException("Local reference could not be found").initCause(nsoe);
        }
    }

    protected boolean couldBeNonLocalOnNoSuchObjectException() {
        return false;
    }

    static {
        String setQOSOnStub;
        enableQOSOnStub = true;
        tracingEnabled = RMIEnvironment.getEnvironment().isTracingEnabled();
        if (!KernelStatus.isApplet() && (setQOSOnStub = System.getProperty("weblogic.t3.setQOSOnStub")) != null) {
            enableQOSOnStub = !setQOSOnStub.equalsIgnoreCase("false");
        }
    }
}

