/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.rmi.UnexpectedException;
import java.rmi.server.ExportException;
import java.rmi.server.SkeletonNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.omg.CORBA.Object;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.LocalServerIdentity;
import weblogic.rmi.RemoteObject;
import weblogic.rmi.extensions.NotImplementedException;
import weblogic.rmi.extensions.activation.Activatable;
import weblogic.rmi.extensions.activation.Activator;
import weblogic.rmi.extensions.server.ActivatableServerReference;
import weblogic.rmi.extensions.server.FutureResponse;
import weblogic.rmi.extensions.server.InvokableServerReference;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.internal.CBVWrapperGenerator;
import weblogic.rmi.internal.ClientMethodDescriptor;
import weblogic.rmi.internal.ClientRuntimeDescriptor;
import weblogic.rmi.internal.ClusterAwareServerReference;
import weblogic.rmi.internal.DescriptorConstants;
import weblogic.rmi.internal.GenericInfo;
import weblogic.rmi.internal.GenericMethodDescriptor;
import weblogic.rmi.internal.MethodDescriptor;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.RemoteType;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.internal.SkelGenerator;
import weblogic.rmi.internal.Skeleton;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.internal.StubInfoIntf;
import weblogic.rmi.internal.ThreadPreferredHost;
import weblogic.rmi.internal.UnresolvedTypeException;
import weblogic.rmi.internal.dgc.DGCPolicyConstants;
import weblogic.rmi.rmic.XMLDescriptorCreator;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.InboundRequest;
import weblogic.rmi.utils.Utilities;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.ByteArraySource;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.Source;
import weblogic.utils.collections.ArrayMap;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

final class BasicRuntimeDescriptor
implements RuntimeDescriptor,
DescriptorConstants,
DGCPolicyConstants {
    private static final boolean debug = false;
    private static final boolean GENERATE_SKELETON = true;
    private final MethodDescriptor defaultMethodDescriptor = new MethodDescriptor();
    private final Class remoteClass;
    private final RemoteType remoteType;
    private final String[] interfaceNames;
    private final Class[] remoteInterfaces;
    private final String applicationName;
    private final String moduleName;
    private ArrayMap rtd;
    private ArrayMap rmiDescriptor;
    private ArrayMap clusterDescriptor;
    private ArrayMap lifecyleDescriptor;
    private ArrayMap methodDescriptors;
    private ArrayMap securityDescriptors;
    private Class cbvWrapperClass;
    private Constructor cbvWrapperConstructor;
    private final Skeleton skelInstance;
    private Method[] remoteMethods;
    private Set remoteMethodSet;
    private String remoteClassName;
    private String skeletonClassName;
    private String stubClassName;
    private String remoteRefClassName;
    private String serverRefClassName;
    private String initialReference;
    private String dispatchPolicy = "weblogic.kernel.Default";
    private boolean useServerSideStubs = false;
    private boolean enableCallByReference = true;
    private boolean clusterable = false;
    private boolean defaultidempotent = true;
    private boolean defaultTransactional = true;
    private boolean propagateEnvironment = false;
    private boolean stickToFirstServer = false;
    private String loadAlgorithm;
    private String callRouterClassName;
    private String replicaHandlerClassName;
    private int dgcPolicy = -1;
    private boolean activatableObject;
    private boolean corbaObject;
    private final HashMap<String, ClientMethodDescriptor> clientMethodDescMap = new HashMap();
    private MethodDescriptor[] mds;
    private HashMap methodSignatureAndIndexMap = new HashMap();
    private ClientMethodDescriptor defaultClientMD;
    private Constructor remoteRefCon;
    private Constructor serverRefCon;
    private ArrayMap methodMap;
    private ArrayMap methodDescMap;
    private boolean isIIOPInitialized = false;
    private String clientCertAuthentication = "supported";
    private String clientAuthentication = "supported";
    private String identityAssertion = "supported";
    private String confidentiality = "supported";
    private String integrity = "supported";
    private static String iiopSecurity = RMIEnvironment.getEnvironment().getIIOPSystemSecurity();
    private boolean statefulAuthentication = true;
    private String networkAccessPoint;
    private ByteArraySource arraySource = null;
    private boolean customMethodDescriptors = false;
    private final Class[] SREF_ARGS_ACT_IR = new Class[]{Class.class, Integer.TYPE, Activator.class};
    private final Class[] SREF_ARGS_ACT = new Class[]{Class.class, Activator.class};
    private final Class[] SREF_ARGS = new Class[]{java.lang.Object.class};
    private final Class[] SREF_ARGS_IR = new Class[]{Integer.TYPE, java.lang.Object.class};
    private final ClientRuntimeDescriptor crd;

    public BasicRuntimeDescriptor(ArrayMap rtd, Class c) throws RemoteException {
        this(rtd, c, Utilities.getRemoteInterfaces(c), true);
    }

    public BasicRuntimeDescriptor(Class c) throws RemoteException {
        this(null, c, Utilities.getRemoteInterfaces(c), true);
    }

    private BasicRuntimeDescriptor(ArrayMap rtd, Class c, Class[] remoteInterfaces, boolean generateSkeleton) throws RemoteException {
        this.rtd = rtd;
        this.remoteClass = c;
        this.remoteInterfaces = remoteInterfaces;
        this.remoteType = new RemoteType(remoteInterfaces);
        this.interfaceNames = BasicRuntimeDescriptor.getInterfaceNames(remoteInterfaces);
        this.applicationName = BasicRuntimeDescriptor.getApplicationName(this.remoteClass);
        this.moduleName = this.getCurrentModuleName();
        this.initializeRuntimeDescriptor();
        this.skelInstance = generateSkeleton ? BasicRuntimeDescriptor.createSkeleton(this.remoteClass, this.createSkeletonClass()) : null;
        ClientRuntimeDescriptor temp = new ClientRuntimeDescriptor(this.interfaceNames, this.applicationName, this.clientMethodDescMap, this.defaultClientMD, this.getStubClassName());
        this.crd = temp.intern();
    }

    BasicRuntimeDescriptor(ArrayMap rtd, String remoteClassName, Class[] remoteInterfaces) throws RemoteException {
        this.remoteClass = null;
        this.moduleName = null;
        this.applicationName = null;
        this.skelInstance = null;
        this.remoteClassName = remoteClassName;
        this.rtd = rtd;
        this.remoteInterfaces = remoteInterfaces;
        this.remoteType = new RemoteType(remoteInterfaces);
        this.interfaceNames = Utilities.getRemoteInterfaceNames(remoteInterfaces);
        this.initializeRuntimeDescriptor();
        ClientRuntimeDescriptor temp = new ClientRuntimeDescriptor(this.interfaceNames, null, this.clientMethodDescMap, this.defaultClientMD, this.getStubClassName());
        this.crd = temp.intern();
    }

    static BasicRuntimeDescriptor getRuntimeDescriptorForRMIC(ArrayMap rtd, Class c) throws RemoteException {
        return new BasicRuntimeDescriptor(rtd, c, Utilities.getRemoteInterfaces(c), false);
    }

    private static String[] getInterfaceNames(Class[] remoteInterfaces) {
        String[] interfaceNames = new String[remoteInterfaces.length + 1];
        for (int i = 0; i < remoteInterfaces.length; ++i) {
            interfaceNames[i] = remoteInterfaces[i].getName();
        }
        interfaceNames[remoteInterfaces.length] = StubInfoIntf.class.getName();
        return interfaceNames;
    }

    private static String getApplicationName(Class remoteClass) {
        if (remoteClass == null) {
            return null;
        }
        ClassLoader cl = remoteClass.getClassLoader();
        if (cl instanceof GenericClassLoader) {
            GenericClassLoader gcl = (GenericClassLoader)cl;
            return gcl.getAnnotation().getAnnotationString();
        }
        return null;
    }

    private String getCurrentModuleName() {
        if (this.applicationName != null) {
            try {
                InitialContext ic = new InitialContext();
                return (String)ic.lookup("java:/bea/ModuleName");
            }
            catch (NamingException ignore) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Class getRemoteClass() {
        return this.remoteClass;
    }

    @Override
    public String getRemoteClassName() {
        return this.remoteClassName;
    }

    @Override
    public String getSkeletonClassName() {
        return this.skeletonClassName;
    }

    @Override
    public String getStubClassName() {
        return this.stubClassName;
    }

    @Override
    public Method[] getRemoteMethods() {
        return this.remoteMethods;
    }

    @Override
    public final Class[] getRemoteInterfaces() {
        return this.remoteInterfaces;
    }

    private void initializeRuntimeDescriptor() throws RemoteException {
        this.initClassNames();
        this.initRemoteMethods();
        if (this.rtd != null) {
            this.rmiDescriptor = (ArrayMap)this.rtd.get("rmidescriptor");
            this.clusterDescriptor = (ArrayMap)this.rtd.get("clusterdescriptor");
            this.lifecyleDescriptor = (ArrayMap)this.rtd.get("lifecycledescriptor");
            this.methodDescriptors = (ArrayMap)this.rtd.get("methoddescriptor");
            this.securityDescriptors = (ArrayMap)this.rtd.get("securitydescriptor");
        }
        if (this.rmiDescriptor != null) {
            this.initializeRMIDescriptorInfo();
        }
        if (this.lifecyleDescriptor != null) {
            this.initializeLifecycleDescriptor();
        }
        if (this.clusterDescriptor != null) {
            this.initializeClusterDescriptor();
        }
        if (this.securityDescriptors != null) {
            this.initializeSecurityDescriptor();
        }
        this.createMethodDescriptors();
    }

    private Class createSkeletonClass() throws SkeletonNotFoundException {
        Class clazz = null;
        if (this.getRemoteClass() == null) {
            return null;
        }
        ClassLoader cl = this.getRemoteClass().getClassLoader();
        if (cl == null) {
            cl = StubInfo.class.getClassLoader();
        }
        try {
            clazz = cl.loadClass(this.getSkeletonClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = this.generateSkeletonClass(cl);
        }
        return clazz;
    }

    private Class generateSkeletonClass(ClassLoader cl) throws SkeletonNotFoundException {
        SkelGenerator skelGenerator = new SkelGenerator(this);
        try {
            return skelGenerator.generateClass(cl);
        }
        catch (SecurityException applet) {
            try {
                return Class.forName(this.skeletonClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SkeletonNotFoundException("Failed to download the Skeleton into applet from server through ClasspathServlet.", cnfe);
            }
        }
    }

    @Override
    public Constructor getCBVWrapper() {
        if (this.cbvWrapperConstructor == null) {
            ClassLoader cl = this.getRemoteClass().getClassLoader();
            CBVWrapperGenerator cbvGenerator = new CBVWrapperGenerator(this);
            this.cbvWrapperClass = cbvGenerator.generateClass(cl);
            try {
                this.cbvWrapperConstructor = this.cbvWrapperClass.getConstructor(this.getRemoteClass());
            }
            catch (NoSuchMethodException nsme) {
                throw new AssertionError((java.lang.Object)nsme);
            }
        }
        return this.cbvWrapperConstructor;
    }

    private static Skeleton createSkeleton(Class remoteClass, Class clazz) throws SkeletonNotFoundException {
        if (clazz == null && remoteClass == null) {
            return null;
        }
        try {
            return (Skeleton)clazz.newInstance();
        }
        catch (InstantiationException ie) {
            throw new SkeletonNotFoundException("Could not create skeleton", ie);
        }
        catch (IllegalAccessException iae) {
            throw new SkeletonNotFoundException("Could not access skeleton", iae);
        }
    }

    @Override
    public Skeleton getSkeleton() {
        return this.skelInstance;
    }

    @Override
    public int getDGCPolicy() {
        return this.dgcPolicy;
    }

    @Override
    public String getRemoteReferenceClassName() {
        if (this.remoteRefClassName == null) {
            return this.getDefaultRemoteRefClassName();
        }
        return this.remoteRefClassName;
    }

    public Class getRemoteReferenceClass() throws ClassNotFoundException {
        return Class.forName(this.getRemoteReferenceClassName());
    }

    @Override
    public int getInitialReference() {
        if (this.initialReference == null || this.initialReference.equals("")) {
            return -1;
        }
        try {
            return Integer.parseInt(this.initialReference);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    @Override
    public String getNetworkAccessPoint() {
        return this.networkAccessPoint;
    }

    @Override
    public boolean isClusterable() {
        return this.clusterable;
    }

    @Override
    public String[] getRemoteInterfacesClassNames() {
        return this.interfaceNames;
    }

    @Override
    public boolean getPropagateEnvironment() {
        return this.propagateEnvironment;
    }

    @Override
    public String getCallRouterClassName() {
        return this.callRouterClassName;
    }

    @Override
    public String getReplicaHandlerClassName() {
        return this.replicaHandlerClassName;
    }

    @Override
    public String getLoadAlgorithm() {
        return this.loadAlgorithm;
    }

    @Override
    public boolean getMethodsAreIdempotent() {
        return this.defaultidempotent;
    }

    @Override
    public boolean getMethodsAreTransactional() {
        return this.defaultTransactional;
    }

    @Override
    public boolean getStickToFirstServer() {
        return this.stickToFirstServer;
    }

    @Override
    public boolean getEnableServerSideStubs() {
        Debug.assertion(!this.corbaObject || !this.useServerSideStubs);
        return this.useServerSideStubs;
    }

    @Override
    public boolean getEnforceCallByValue() {
        return !this.enableCallByReference;
    }

    @Override
    public String getDispatchPolicyName() {
        return this.dispatchPolicy;
    }

    @Override
    public ServerReference createServerReference(java.lang.Object impl) throws RemoteException {
        int ir = this.getInitialReference();
        try {
            java.lang.Object[] args = ir < 0 ? new java.lang.Object[]{impl} : new java.lang.Object[]{new Integer(ir), impl};
            if (this.serverRefCon == null) {
                this.serverRefCon = ir < 0 ? this.getServerReferenceClass().getConstructor(this.SREF_ARGS) : this.getServerReferenceClass().getConstructor(this.SREF_ARGS_IR);
            }
            ServerReference sref = (ServerReference)this.serverRefCon.newInstance(args);
            if (this.isClusterable() && !(sref instanceof ClusterAwareServerReference) && sref instanceof InvokableServerReference) {
                return RMIEnvironment.getEnvironment().createClusteredServerRef((InvokableServerReference)sref);
            }
            return sref;
        }
        catch (NoSuchMethodException nsme) {
            throw new ExportException("Server reference class missing constructor: '" + this.getServerReferenceClassName() + "'", nsme);
        }
        catch (IllegalAccessException iae) {
            throw new ExportException("Server reference class constructor not public: '" + this.getServerReferenceClassName() + "'", iae);
        }
        catch (InstantiationException ie) {
            throw new ExportException("Failed to instantiate server reference: '" + this.getServerReferenceClassName() + "'", ie);
        }
        catch (InvocationTargetException ite) {
            Throwable nested = ite.getTargetException();
            if (!(nested instanceof Exception)) {
                nested = ite;
            }
            throw new ExportException("Failed to invoke contructor for server reference: '" + this.getServerReferenceClassName() + "'", (Exception)nested);
        }
        catch (ClassCastException cce) {
            throw new StubNotFoundException("Server reference not an instance of ServerReference: '" + this.getServerReferenceClassName() + "'", cce);
        }
    }

    private String getServerReferenceClassName() {
        if (this.serverRefClassName == null) {
            return this.getDefaultServerRefClassName();
        }
        return this.serverRefClassName;
    }

    private Class getServerReferenceClass() throws UnexpectedException {
        try {
            return Class.forName(this.getServerReferenceClassName());
        }
        catch (ClassNotFoundException cnfe) {
            throw new UnexpectedException("Failed to load: '" + this.getServerReferenceClassName() + "'", cnfe);
        }
    }

    ActivatableServerReference createActivatableServerReference(java.lang.Object o, Activator activator) throws RemoteException {
        if (!this.isClusterable()) {
            return this.createActivatableServerReference(o.getClass(), activator);
        }
        try {
            if (this.serverRefCon == null) {
                this.serverRefCon = this.getServerReferenceClass().getConstructor(java.lang.Object.class, Activator.class);
            }
            return (ActivatableServerReference)this.serverRefCon.newInstance(o, activator);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExportException("Server reference class missing constructor: '" + this.getServerReferenceClassName() + "'", nsme);
        }
        catch (IllegalAccessException iae) {
            throw new ExportException("Server reference class constructor not public: '" + this.getServerReferenceClassName() + "'", iae);
        }
        catch (InstantiationException ie) {
            throw new ExportException("Failed to instantiate server reference: '" + this.getServerReferenceClassName() + "'", ie);
        }
        catch (InvocationTargetException ite) {
            Throwable nested = ite.getTargetException();
            if (!(nested instanceof Exception)) {
                nested = ite;
            }
            throw new ExportException("Failed to invoke contructor for server reference: '" + this.getServerReferenceClassName() + "'", (Exception)nested);
        }
        catch (ClassCastException cce) {
            throw new StubNotFoundException("Server reference not an instance of ServerReference: '" + this.getServerReferenceClassName() + "'", cce);
        }
    }

    ActivatableServerReference createActivatableServerReference(Class c, Activator activator) throws RemoteException {
        Debug.assertion(this.isActivatable() && !this.isClusterable(), "Can only export activatable objects");
        int initialReference = this.getInitialReference();
        try {
            if (this.serverRefCon == null) {
                this.serverRefCon = this.getInitialReference() > 0 ? this.getServerReferenceClass().getConstructor(this.SREF_ARGS_ACT_IR) : this.getServerReferenceClass().getConstructor(this.SREF_ARGS_ACT);
            }
            if (initialReference < 0) {
                return (ActivatableServerReference)this.serverRefCon.newInstance(c, activator);
            }
            return (ActivatableServerReference)this.serverRefCon.newInstance(c, new Integer(initialReference), activator);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExportException("Server reference class missing constructor: '" + this.getServerReferenceClassName() + "'", nsme);
        }
        catch (IllegalAccessException iae) {
            throw new ExportException("Server reference class constructor not public: '" + this.getServerReferenceClassName() + "'", iae);
        }
        catch (InstantiationException ie) {
            throw new ExportException("Failed to instantiate server reference: '" + this.getServerReferenceClassName() + "'", ie);
        }
        catch (InvocationTargetException ite) {
            Throwable nested = ite.getTargetException();
            if (!(nested instanceof Exception)) {
                nested = ite;
            }
            throw new ExportException("Failed to invoke contructor for server reference: '" + this.getServerReferenceClassName() + "'", (Exception)nested);
        }
        catch (ClassCastException cce) {
            throw new StubNotFoundException("Server reference not an instance of ServerReference: '" + this.getServerReferenceClassName() + "'", cce);
        }
    }

    @Override
    public RemoteReference getRemoteReference(int oid, java.lang.Object o) throws RemoteException {
        if (this.activatableObject) {
            return this.getActivatableRemoteReference(oid, o);
        }
        try {
            HostID hostID = ThreadPreferredHost.get() != null ? ThreadPreferredHost.get() : LocalServerIdentity.getIdentity();
            return (RemoteReference)this.getRemoteRefConstructor().newInstance(new Integer(oid), hostID);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ExportException("RemoteReference class missing: " + this.getRemoteReferenceClassName(), cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExportException("RemoteReference class missing constructor: " + this.getRemoteReferenceClassName(), nsme);
        }
        catch (IllegalAccessException iae) {
            throw new ExportException("RemoteReference class constructor not public: " + this.getRemoteReferenceClassName(), iae);
        }
        catch (InstantiationException ie) {
            throw new ExportException("Failed to instantiate RemoteReference: " + this.getRemoteReferenceClassName(), ie);
        }
        catch (InvocationTargetException ite) {
            Throwable nested = ite.getTargetException();
            if (!(nested instanceof Exception)) {
                nested = ite;
            }
            throw new ExportException("Failed to invoke contructor for RemoteReference: " + this.getRemoteReferenceClassName(), (Exception)nested);
        }
    }

    @Override
    public RuntimeMethodDescriptor getControlDescriptor(RuntimeMethodDescriptor md) {
        if (this.mds == null) {
            return null;
        }
        int pos = this.getIndex(md);
        if (pos == -1 || pos >= this.mds.length) {
            return null;
        }
        return this.mds[pos];
    }

    private int getIndex(RuntimeMethodDescriptor md) {
        Integer pos = (Integer)this.methodSignatureAndIndexMap.get(md.getSignature());
        if (pos == null) {
            return -1;
        }
        return pos;
    }

    @Override
    public HashMap<String, ClientMethodDescriptor> getClientMethodDescriptors() {
        return this.clientMethodDescMap;
    }

    @Override
    public ClientMethodDescriptor getClientMethodDescriptor(String sig) {
        return this.clientMethodDescMap.get(sig);
    }

    @Override
    public ClientMethodDescriptor getDefaultClientMethodDescriptor() {
        return this.defaultClientMD;
    }

    @Override
    public RemoteType getRemoteType() {
        return this.remoteType;
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        return this.mds;
    }

    @Override
    public ClientRuntimeDescriptor getClientRuntimeDescriptor(String appName) {
        return this.crd;
    }

    @Override
    public MethodDescriptor getMethodDescriptor(String name) {
        MethodDescriptor returnMD;
        if (!this.isIIOPInitialized) {
            this.initIIOP();
        }
        if ((returnMD = (MethodDescriptor)this.methodDescMap.get(name)) == null) {
            // empty if block
        }
        return returnMD;
    }

    @Override
    public Method getMethod(String name) {
        if (!this.isIIOPInitialized) {
            this.initIIOP();
        }
        return (Method)this.methodMap.get(name);
    }

    private void initClassNames() {
        if (this.getRemoteClass() != null) {
            this.remoteClassName = this.getRemoteClass().getName();
            if (!Remote.class.isAssignableFrom(this.getRemoteClass()) && Object.class.isAssignableFrom(this.getRemoteClass())) {
                this.corbaObject = true;
            }
        }
        if (this.remoteClassName != null) {
            this.skeletonClassName = this.remoteClassName + "_WLSkel";
            this.stubClassName = ServerHelper.getStubClassName(this.remoteClassName);
        }
    }

    static String getRemoteClassNameFromStubName(String stubName) {
        if (stubName == null) {
            return null;
        }
        int versionIndex = stubName.indexOf(ServerHelper.getWlsStubVersion());
        if (versionIndex < 0) {
            return null;
        }
        String remoteName = stubName.substring(0, versionIndex);
        return remoteName;
    }

    private void initRemoteMethods() {
        Debug.assertion(this.remoteInterfaces != null);
        Map<String, Method> sigMap = Utilities.getRemoteMethodsAndSignatures(this.remoteInterfaces);
        this.remoteMethods = new Method[sigMap.size()];
        this.remoteMethods = sigMap.values().toArray(this.remoteMethods);
        this.remoteMethodSet = new HashSet();
        this.remoteMethodSet.addAll(sigMap.keySet());
        if (MethodDescriptor.isGenericMethodSignatureModeEnabled()) {
            GenericInfo gInfo = null;
            gInfo = this.remoteClass != null ? new GenericInfo(this.remoteClass) : new GenericInfo(this.remoteInterfaces);
            for (Method m : this.remoteMethods) {
                if (!GenericMethodDescriptor.isGenericMethod(m)) continue;
                try {
                    this.remoteMethodSet.add(GenericMethodDescriptor.computeGenericMethodSignature(m, gInfo));
                }
                catch (UnresolvedTypeException ute) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean isActivatable() {
        return this.activatableObject;
    }

    private void initializeRMIDescriptorInfo() {
        String temp = (String)this.rmiDescriptor.get("use-server-side-stubs");
        if (temp != null) {
            this.useServerSideStubs = this.toBoolean(temp);
        }
        if ((temp = (String)this.rmiDescriptor.get("enable-call-by-reference")) != null) {
            this.enableCallByReference = this.toBoolean(temp);
        }
        if ((temp = (String)this.rmiDescriptor.get("remote-ref-classname")) != null) {
            this.remoteRefClassName = temp;
        }
        if ((temp = (String)this.rmiDescriptor.get("server-ref-classname")) != null) {
            this.serverRefClassName = temp;
        }
        if ((temp = (String)this.rmiDescriptor.get("initial-reference")) != null) {
            this.initialReference = temp;
        }
        this.dispatchPolicy = (String)this.rmiDescriptor.get("dispatch-policy");
        temp = (String)this.rmiDescriptor.get("network-access-point");
        if (temp != null) {
            this.networkAccessPoint = temp;
        }
        if (this.remoteRefClassName != null) {
            this.activatableObject = this.remoteRefClassName.equals("weblogic.rmi.internal.activation.ActivatableRemoteRef") || this.remoteRefClassName.equals("weblogic.rmi.cluster.ClusterActivatableRemoteRef");
        }
    }

    private void initializeClusterDescriptor() {
        String temp = (String)this.clusterDescriptor.get("clusterable");
        if (temp != null) {
            boolean bl = this.clusterable = this.toBoolean(temp) && KernelStatus.isServer();
        }
        if ((temp = (String)this.clusterDescriptor.get("propagate-environment")) != null) {
            this.propagateEnvironment = this.toBoolean(temp);
        }
        this.loadAlgorithm = (temp = (String)this.clusterDescriptor.get("load-algorithm")) != null ? temp : "default";
        this.callRouterClassName = (String)this.clusterDescriptor.get("call-router-classname");
        this.replicaHandlerClassName = (String)this.clusterDescriptor.get("replica-handler-classname");
        temp = (String)this.clusterDescriptor.get("stick-to-first-server");
        if (temp != null) {
            this.stickToFirstServer = this.toBoolean(temp);
        }
        if (this.remoteRefClassName == null) {
            this.remoteRefClassName = this.getDefaultRemoteRefClassName();
        }
        if (this.serverRefClassName == null) {
            this.serverRefClassName = this.getDefaultServerRefClassName();
        }
    }

    private void initializeSecurityDescriptor() {
        this.confidentiality = this.getSecurityElementValue("confidentiality");
        this.clientCertAuthentication = this.getSecurityElementValue("client-cert-authentication");
        this.clientAuthentication = this.getSecurityElementValue("client-authentication");
        this.identityAssertion = this.getSecurityElementValue("identity-assertion");
        this.integrity = this.getSecurityElementValue("integrity");
        this.statefulAuthentication = this.toBoolean(this.getSecurityElementValue("stateful-authentication"));
    }

    private String getSecurityElementValue(String key) {
        String value = (String)this.securityDescriptors.get(key);
        if (value != null && value.equalsIgnoreCase("config")) {
            return iiopSecurity;
        }
        return value;
    }

    private void createMethodDescriptors() throws RemoteException {
        ArrayList<MethodDescriptor> methodList = new ArrayList<MethodDescriptor>();
        Debug.assertion(this.remoteMethods != null);
        ArrayMap defaultMethodDescriptorMap = null;
        this.validateXMLDescriptor();
        if (this.methodDescriptors != null) {
            defaultMethodDescriptorMap = (ArrayMap)this.methodDescriptors.get("*");
            if (defaultMethodDescriptorMap != null) {
                this.populate(defaultMethodDescriptorMap, this.defaultMethodDescriptor, null, new HashMap<String, WorkManager>());
                this.defaultClientMD = this.defaultMethodDescriptor.getClientDescriptor();
            }
        } else {
            this.defaultidempotent = this.defaultMethodDescriptor.isIdempotent();
            this.defaultTransactional = this.defaultMethodDescriptor.isTransactional();
        }
        GenericInfo gInfo = null;
        if (MethodDescriptor.isGenericMethodSignatureModeEnabled()) {
            gInfo = new GenericInfo(this.remoteClass);
        }
        HashMap<String, WorkManager> wms = new HashMap<String, WorkManager>();
        for (int i = 0; i < this.remoteMethods.length; ++i) {
            String genericSignature;
            MethodDescriptor md = new MethodDescriptor(this.remoteMethods[i], this.remoteClass, this.applicationName, this.moduleName, i);
            String signature = md.getSignature();
            if (defaultMethodDescriptorMap != null) {
                this.populate(defaultMethodDescriptorMap, md, null, wms);
            }
            if (this.methodDescriptors != null) {
                ArrayMap h = (ArrayMap)this.methodDescriptors.get(signature);
                if (h != null) {
                    this.defaultClientMD = null;
                }
                this.populate(h, md, this.remoteMethods[i], wms);
                h = null;
            }
            ClientMethodDescriptor cd = md.getClientDescriptor();
            this.clientMethodDescMap.put(cd.getSignature(), cd);
            methodList.add(md);
            this.methodSignatureAndIndexMap.put(signature, new Integer(i));
            if (!MethodDescriptor.isGenericMethodSignatureModeEnabled() || !GenericMethodDescriptor.isGenericMethod(this.remoteMethods[i])) continue;
            try {
                genericSignature = GenericMethodDescriptor.computeGenericMethodSignature(this.remoteMethods[i], gInfo);
            }
            catch (UnresolvedTypeException ute) {
                continue;
            }
            assert (!genericSignature.equals(signature)) : "For generic method = " + this.remoteMethods[i] + " got erased signature = " + genericSignature;
            this.methodSignatureAndIndexMap.put(genericSignature, new Integer(i));
        }
        this.mds = methodList.toArray(new MethodDescriptor[methodList.size()]);
    }

    private synchronized void initIIOP() {
        if (this.isIIOPInitialized) {
            return;
        }
        this.methodMap = new ArrayMap();
        this.methodDescMap = new ArrayMap();
        Debug.assertion(this.mds.length == this.remoteMethods.length);
        for (int i = 0; i < this.mds.length; ++i) {
            String mangledName = RMIEnvironment.getEnvironment().getIIOPMangledName(this.remoteMethods[i], this.remoteClass);
            this.methodMap.put(mangledName, this.remoteMethods[i]);
            this.methodDescMap.put(mangledName, this.mds[i]);
        }
        this.isIIOPInitialized = true;
    }

    private void populate(ArrayMap h, MethodDescriptor md, Method m, Map<String, WorkManager> workManagers) throws RemoteException {
        if (h == null) {
            return;
        }
        boolean transactional = false;
        String temp = (String)h.get("oneway");
        boolean b = false;
        if (temp != null) {
            b = this.toBoolean(temp);
            if (b && m != null) {
                Class<?> returnType = m.getReturnType();
                if (returnType != Void.TYPE) {
                    throw new ExportException(md.getSignature() + " is declared as a oneway method, hence cannot return a value");
                }
                Class<?>[] exceptionTypes = m.getExceptionTypes();
                if (exceptionTypes != null && exceptionTypes.length > 0) {
                    for (Class<Exception> clazz : exceptionTypes) {
                        if (clazz.isAssignableFrom(RemoteException.class) || clazz.isAssignableFrom(RuntimeException.class)) continue;
                        throw new ExportException(md.getSignature() + " is declared as a oneway method, hence cannot throw a checked exception: " + clazz.getName());
                    }
                }
            }
            md.setOneway(b);
        }
        if ((temp = (String)h.get("transactional")) != null) {
            b = this.toBoolean(temp);
            md.setTransactional(b);
            this.defaultTransactional &= b;
            transactional = b;
        }
        if ((temp = (String)h.get("requires-transaction")) != null) {
            b = this.toBoolean(temp);
            md.setRequiresTransaction(b);
        }
        if ((temp = (String)h.get("oneway-transactional-request")) != null) {
            b = this.toBoolean(temp);
            md.setOnewayTransactionalRequest(b);
        }
        if ((temp = (String)h.get("oneway-transactional-response")) != null) {
            b = this.toBoolean(temp);
            md.setOnewayTransactionalResponse(b);
        }
        if ((temp = (String)h.get("dispatch-policy")) != null) {
            if (KernelStatus.isServer()) {
                WorkManager wm = workManagers.get(temp);
                if (wm == null) {
                    wm = WorkManagerFactory.getInstance().find(temp);
                    workManagers.put(temp, wm);
                }
                md.setDispatchPolicy(temp, wm);
            } else {
                md.setDispatchPolicy(temp, null);
            }
        }
        if ((temp = (String)h.get("timeout")) != null) {
            int timeout = Integer.parseInt(temp);
            if (!(!transactional && !md.requiresTransaction() || md.requiresTransaction() && this.remoteClass != null && RemoteObject.class.isAssignableFrom(this.remoteClass))) {
                timeout = Math.max(timeout, ServerHelper.getTransactionTimeoutMillis());
            }
            md.setTimeOut(timeout);
            if (timeout > 0) {
                this.customMethodDescriptors = true;
            }
        }
        if ((temp = (String)h.get("idempotent")) != null) {
            b = this.toBoolean(temp);
            md.setIdempotent(b);
            this.defaultidempotent &= b;
        }
        if ((temp = (String)h.get("asynchronous")) != null) {
            b = this.toBoolean(temp);
            md.setAsynchronous(b);
        }
        if ((temp = (String)h.get("future")) != null && (b = this.toBoolean(temp))) {
            md.setDispatchMethod(m, this.remoteClass, FutureResponse.class);
        }
        if ((temp = (String)h.get("dispatch-context")) != null) {
            if (temp.equals("future")) {
                md.setDispatchMethod(m, this.remoteClass, FutureResponse.class);
            } else if (temp.equals("request")) {
                md.setDispatchMethod(m, this.remoteClass, InboundRequest.class);
            }
        }
        if ((temp = (String)h.get("remote-exception-wrapper-classname")) != null) {
            md.setRemoteExceptionWrapperClassName(temp);
            this.customMethodDescriptors = true;
        }
    }

    private void validateXMLDescriptor() throws RemoteException {
        if (this.methodDescriptors != null) {
            for (String signature : this.methodDescriptors.keySet()) {
                if (signature.equals("*") || this.remoteMethodSet.contains(signature)) continue;
                throw new ExportException("Failed to export " + this.remoteClass + "; problem with rmi descriptor signature " + signature + "; RemoteMethodSet=" + this.remoteMethodSet);
            }
        }
    }

    private void initializeLifecycleDescriptor() {
        String temp = (String)this.lifecyleDescriptor.get("dgc-policy");
        this.dgcPolicy = this.getDGCPolicy(temp);
    }

    private int getDGCPolicy(String dgcPolicyStr) {
        if (dgcPolicyStr == null || dgcPolicyStr.equals("")) {
            return -1;
        }
        if (dgcPolicyStr.equalsIgnoreCase("leased")) {
            return 0;
        }
        if (dgcPolicyStr.equalsIgnoreCase("referenceCounted")) {
            return 1;
        }
        if (dgcPolicyStr.equalsIgnoreCase("managed")) {
            return 2;
        }
        if (dgcPolicyStr.equalsIgnoreCase("useItOrLoseIt")) {
            return 3;
        }
        if (dgcPolicyStr.equalsIgnoreCase("deactivateOnMethodBoundries")) {
            return 4;
        }
        return -1;
    }

    private Constructor getRemoteRefConstructor() throws ClassNotFoundException, NoSuchMethodException {
        if (this.remoteRefCon != null) {
            return this.remoteRefCon;
        }
        this.remoteRefCon = this.activatableObject ? (this.isClusterable() ? this.getRemoteReferenceClass().getConstructor(Integer.TYPE, HostID.class, java.lang.Object.class, java.lang.Object.class) : this.getRemoteReferenceClass().getConstructor(Integer.TYPE, HostID.class, java.lang.Object.class)) : this.getRemoteReferenceClass().getConstructor(Integer.TYPE, HostID.class);
        return this.remoteRefCon;
    }

    private RemoteReference getActivatableRemoteReference(int oid, java.lang.Object impl) throws RemoteException {
        java.lang.Object activationID = ((Activatable)impl).getActivationID();
        try {
            return (RemoteReference)this.getRemoteRefConstructor().newInstance(new Integer(oid), LocalServerIdentity.getIdentity(), activationID);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExportException("RemoteReference class missing constructor: " + this.getRemoteReferenceClassName(), nsme);
        }
        catch (IllegalAccessException iae) {
            throw new ExportException("RemoteReference class constructor not public: " + this.getRemoteReferenceClassName(), iae);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ExportException("Failed to load class: " + this.getRemoteReferenceClassName(), cnfe);
        }
        catch (InstantiationException ie) {
            throw new ExportException("Failed to instantiate RemoteReference: " + this.getRemoteReferenceClassName(), ie);
        }
        catch (InvocationTargetException ite) {
            Throwable nested = ite.getTargetException();
            if (!(nested instanceof Exception)) {
                nested = ite;
            }
            throw new ExportException("Failed to invoke constructor for RemoteReference: " + this.getRemoteReferenceClassName(), (Exception)nested);
        }
    }

    private String getDefaultServerRefClassName() {
        if (this.activatableObject) {
            return "weblogic.rmi.internal.activation.ActivatableServerRef";
        }
        if (this.corbaObject) {
            return "weblogic.corba.idl.CorbaServerRef";
        }
        return "weblogic.rmi.internal.BasicServerRef";
    }

    private String getDefaultRemoteRefClassName() {
        switch (this.dgcPolicy) {
            case -1: 
            case 0: {
                return "weblogic.rmi.internal.LeasedRemoteRef";
            }
            case 1: {
                throw new NotImplementedException();
            }
            case 2: 
            case 3: 
            case 4: {
                return "weblogic.rmi.internal.BasicRemoteRef";
            }
        }
        throw new AssertionError((java.lang.Object)("Unknown DGC Policy specified: " + this.dgcPolicy));
    }

    @Override
    public String getConfidentiality() {
        return this.confidentiality;
    }

    @Override
    public String getClientCertAuthentication() {
        return this.clientCertAuthentication;
    }

    @Override
    public String getClientAuthentication() {
        return this.clientAuthentication;
    }

    @Override
    public String getIdentityAssertion() {
        return this.identityAssertion;
    }

    @Override
    public String getIntegrity() {
        return this.integrity;
    }

    @Override
    public boolean getStatefulAuthentication() {
        return this.statefulAuthentication;
    }

    private boolean toBoolean(String b) {
        return Boolean.valueOf(b);
    }

    void nullifyActivationRuntimeProperties() {
        this.dgcPolicy = 0;
        this.remoteRefClassName = "weblogic.rmi.internal.BasicRemoteRef";
        this.serverRefClassName = "weblogic.rmi.internal.BasicServerRef";
        this.remoteRefCon = null;
        this.serverRefCon = null;
        this.activatableObject = false;
        try {
            this.getRemoteRefConstructor();
        }
        catch (Exception cnfe) {
            throw (Error)((Throwable)((java.lang.Object)new AssertionError((java.lang.Object)"Interop properties are corrupted"))).initCause(cnfe);
        }
    }

    @Override
    public Source getRuntimeDescriptorSource() throws IOException {
        if (this.arraySource == null) {
            this.generateXMLDescriptorSource();
        }
        return this.arraySource;
    }

    @Override
    public boolean hasCustomMethodDescriptors() {
        return this.customMethodDescriptors;
    }

    private Source generateXMLDescriptorSource() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String fileName = "";
        if (this.remoteClass != null) {
            fileName = this.remoteClass.getName();
        }
        XMLDescriptorCreator xmlDesc = new XMLDescriptorCreator(out, fileName);
        this.writeXMLDescriptorStream(xmlDesc);
        this.arraySource = new ByteArraySource(out.toByteArray(), null);
        return this.arraySource;
    }

    @Override
    public void generateXMLDescriptor(String className, String rootDirName) throws IOException {
        XMLDescriptorCreator xmldesc = new XMLDescriptorCreator(className, rootDirName);
        this.writeXMLDescriptorStream(xmldesc);
    }

    private void writeXMLDescriptorStream(XMLDescriptorCreator xmlDesc) throws IOException {
        String dgcPolicyStr;
        int initialRef;
        if (this.useServerSideStubs) {
            xmlDesc.useServerSideStubs();
        }
        if (!this.enableCallByReference) {
            xmlDesc.disableLocalCallsByReference();
        }
        if (this.remoteRefClassName != null) {
            xmlDesc.setRemoteRefClassName(this.remoteRefClassName);
        }
        if (this.serverRefClassName != null) {
            xmlDesc.setServerRefClassName(this.serverRefClassName);
        }
        if ((initialRef = this.getInitialReference()) != -1) {
            xmlDesc.setInitialReference(String.valueOf(initialRef));
        }
        if (this.dispatchPolicy != null) {
            xmlDesc.setDispatchPolicy(this.dispatchPolicy);
        }
        if (this.networkAccessPoint != null) {
            xmlDesc.setNetworkAccessPoint(this.networkAccessPoint);
        }
        if ((dgcPolicyStr = this.getDGCPolicyString(this.dgcPolicy)) != null && dgcPolicyStr.length() > 0) {
            xmlDesc.setDGCPolicy(dgcPolicyStr);
        }
        if (this.clusterable) {
            xmlDesc.setClusterable();
        }
        if (this.propagateEnvironment) {
            xmlDesc.setPropagateEnvironment();
        }
        if (this.loadAlgorithm != null && !this.loadAlgorithm.equals("default")) {
            xmlDesc.setLoadAlgorithm(this.loadAlgorithm);
        }
        if (this.callRouterClassName != null) {
            xmlDesc.setCallRouter(this.callRouterClassName);
        }
        if (this.replicaHandlerClassName != null) {
            xmlDesc.setReplicaHandler(this.replicaHandlerClassName);
        }
        if (this.stickToFirstServer) {
            xmlDesc.setStickToFirstServer();
        }
        if (this.confidentiality != null) {
            xmlDesc.setConfidentiality(this.confidentiality);
        }
        if (this.clientCertAuthentication != null) {
            xmlDesc.setClientCertAuthentication(this.clientCertAuthentication);
        }
        if (this.clientAuthentication != null) {
            xmlDesc.setClientAuthentication(this.clientAuthentication);
        }
        if (this.identityAssertion != null) {
            xmlDesc.setIdentityAssertion(this.identityAssertion);
        }
        if (this.integrity != null) {
            xmlDesc.setIntegrity(this.integrity);
        }
        ArrayList<ArrayMap> list = new ArrayList<ArrayMap>();
        if (this.methodDescriptors != null) {
            for (String signature : this.methodDescriptors.keySet()) {
                ArrayMap methodDesc = (ArrayMap)this.methodDescriptors.get(signature);
                methodDesc.put("name", signature);
                list.add(methodDesc);
            }
        } else {
            list.add(this.getMethodDescriptorAttributesMap(this.defaultMethodDescriptor, true));
        }
        xmlDesc.setMethodDescriptors(list);
        xmlDesc.createDescriptor();
    }

    private String getDGCPolicyString(int dgcPolicy) {
        switch (dgcPolicy) {
            case -1: {
                return "";
            }
            case 0: {
                return "leased";
            }
            case 1: {
                return "referenceCounted";
            }
            case 2: {
                return "managed";
            }
            case 3: {
                return "useItOrLoseIt";
            }
            case 4: {
                return "deactivateOnMethodBoundries";
            }
        }
        return "";
    }

    private ArrayMap getMethodDescriptorAttributesMap(MethodDescriptor md, boolean defaultDescriptor) {
        if (md == null) {
            return null;
        }
        ArrayMap<String, String> methodAttributes = new ArrayMap<String, String>();
        if (defaultDescriptor) {
            methodAttributes.put("name", "*");
        } else {
            methodAttributes.put("name", md.getSignature());
        }
        Class dispatchType = md.getDispatchType();
        if (dispatchType == FutureResponse.class) {
            methodAttributes.put("dispatch-context", "future");
        } else if (dispatchType == InboundRequest.class) {
            methodAttributes.put("dispatch-context", "request");
        }
        if (!md.isTransactional()) {
            methodAttributes.put("transactional", "false");
        }
        if (md.isOneway()) {
            methodAttributes.put("oneway", "true");
        }
        if (md.isOnewayTransactionalRequest()) {
            methodAttributes.put("oneway-transactional-request", "true");
        }
        if (md.isTransactionalOnewayResponse()) {
            methodAttributes.put("oneway-transactional-response", "true");
        }
        if (md.isIdempotent()) {
            methodAttributes.put("idempotent", "true");
        }
        if (md.requiresTransaction()) {
            methodAttributes.put("requires-transaction", "true");
        }
        if (md.getTimeOut() > 0) {
            methodAttributes.put("timeout", String.valueOf(md.getTimeOut()));
        }
        if (md.getRemoteExceptionWrapperClassName() != null) {
            methodAttributes.put("remote-exception-wrapper-classname", md.getRemoteExceptionWrapperClassName());
        }
        if (md.hasAsyncResponse()) {
            methodAttributes.put("asynchronous", "true");
        }
        return methodAttributes;
    }
}

