/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import weblogic.rmi.internal.CBVWrapper;

final class CBVFutureImpl<V>
implements Future<V> {
    private volatile Future<V> del;
    private volatile boolean resultCaptured = false;
    private volatile V copiedResult;
    private volatile CBVWrapper cbvWrapper;

    public CBVFutureImpl(Future<V> f, CBVWrapper wrapper) {
        this.del = f;
        this.cbvWrapper = wrapper;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.del.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.del.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.del.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (!this.resultCaptured) {
            this.getResultInternal(this.del.get());
        }
        return this.copiedResult;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.resultCaptured) {
            this.getResultInternal(this.del.get(timeout, unit));
        }
        return this.copiedResult;
    }

    private synchronized void getResultInternal(V v) {
        if (this.resultCaptured) {
            return;
        }
        if (v != null) {
            this.copiedResult = this.shouldCopy(v.getClass()) ? this.cbvWrapper.copy(v) : v;
        }
        this.resultCaptured = true;
    }

    private boolean shouldCopy(Class<?> c) {
        if (c.isPrimitive()) {
            return false;
        }
        if (c == String.class) {
            return false;
        }
        if (c == Boolean.class) {
            return false;
        }
        if (c == Byte.class) {
            return false;
        }
        if (c == Character.class) {
            return false;
        }
        if (c == Double.class) {
            return false;
        }
        if (c == Float.class) {
            return false;
        }
        if (c == Integer.class) {
            return false;
        }
        if (c == Long.class) {
            return false;
        }
        if (c == Short.class) {
            return false;
        }
        return c != Void.class;
    }
}

