/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.WriteAbortedException;
import java.rmi.RemoteException;
import weblogic.protocol.LocalServerIdentity;
import weblogic.rmi.extensions.server.Collectable;
import weblogic.rmi.extensions.server.CollocatedRemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.BasicRemoteRef;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.internal.ServerRequest;
import weblogic.rmi.spi.OutboundRequest;

final class CollocatedRemoteRef
extends BasicRemoteRef
implements CollocatedRemoteReference {
    private static final long serialVersionUID = 5777536927492434313L;
    private final ServerReference sor;

    public CollocatedRemoteRef(ServerReference sor) {
        super(sor.getObjectID(), LocalServerIdentity.getIdentity());
        this.sor = sor;
        if (sor instanceof Collectable) {
            ((Collectable)((Object)sor)).incrementRefCount();
        }
    }

    @Override
    public ServerReference getServerReference() {
        return this.sor;
    }

    @Override
    public OutboundRequest getOutboundRequest(RuntimeMethodDescriptor md, int contextID, Object context, String partitionURL) throws IOException {
        OIDManager.getInstance().getServerReference(this.getObjectID());
        ServerRequest request = new ServerRequest(this.sor, md, partitionURL);
        if (md.hasAsyncResponse()) {
            request.setContext(contextID, context);
        }
        return request;
    }

    @Override
    public OutboundRequest getOutboundRequest(RuntimeMethodDescriptor md, String partitionName, String partitionURL) throws IOException {
        return this.getOutboundRequest(md, partitionURL);
    }

    @Override
    @Deprecated
    public OutboundRequest getOutboundRequest(RuntimeMethodDescriptor md, String partitionURL) throws IOException {
        OIDManager.getInstance().getServerReference(this.getObjectID());
        return new ServerRequest(this.sor, md, partitionURL);
    }

    public Object writeReplace() throws ObjectStreamException {
        try {
            OIDManager.getInstance().ensureExported(this.sor);
            return this.sor.getRemoteRef();
        }
        catch (RemoteException re) {
            throw new WriteAbortedException("Unexpected exception", re);
        }
    }
}

