/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import weblogic.rmi.extensions.server.CBVOutputStream;
import weblogic.rmi.extensions.server.ColocatedStream;
import weblogic.rmi.internal.CBVOutput;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkOutput;
import weblogic.utils.io.DelegatingOutputStream;
import weblogic.utils.io.Replacer;
import weblogic.utils.io.StringOutput;

public class DefaultCBVOutput
extends ObjectOutputStream
implements CBVOutput,
ChunkOutput,
StringOutput,
ColocatedStream,
ObjectOutput {
    private CBVOutputStream cbv;
    private DelegatingOutputStream delegate;
    private Replacer replacer;

    public DefaultCBVOutput(CBVOutputStream cbv, OutputStream out) throws IOException {
        this(new DelegatingOutputStream(out));
        this.cbv = cbv;
    }

    private DefaultCBVOutput(DelegatingOutputStream dos) throws IOException {
        super(dos);
        this.delegate = dos;
        try {
            this.enableReplaceObject(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void setDelegate(CBVOutputStream cbv, OutputStream out) {
        this.cbv = cbv;
        this.delegate.setDelegate(out);
    }

    @Override
    public void setReplacer(Replacer replacer) {
        this.replacer = replacer;
    }

    @Override
    protected Object replaceObject(Object obj) throws IOException {
        if (this.replacer == null) {
            return obj;
        }
        return this.replacer.replaceObject(obj);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.cbv.writeObjectSpecial(s);
    }

    @Override
    public void writeChunks(Chunk c) throws IOException {
        this.cbv.writeObjectSpecial(c);
    }

    @Override
    public void writeASCII(String s) throws IOException {
        this.cbv.writeObjectSpecial(s);
    }

    @Override
    public void writeUTF8(String s) throws IOException {
        this.cbv.writeObjectSpecial(s);
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass descriptor) throws IOException {
        this.cbv.writeObjectSpecial(descriptor);
    }

    public final void writeImmutable(Object o) throws IOException {
        this.cbv.writeObjectSpecial(o);
    }

    @Override
    public void close() throws IOException {
        this.cbv = null;
        super.close();
    }
}

