/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.util.Map;
import java.util.WeakHashMap;
import weblogic.rmi.extensions.server.DescriptorHelper;
import weblogic.rmi.internal.BasicRuntimeDescriptor;
import weblogic.rmi.internal.RMIAnnotationProcessor;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.collections.ArrayMap;

public final class DescriptorManager {
    static final String RTD_SUFFIX = "RTD.xml";
    private static final boolean DEBUG = false;
    private static final boolean POSTJDK8 = !System.getProperty("java.version").startsWith("1.");
    private static final Map<Class, Map<ClassLoader, RuntimeDescriptor>> DESCRIPTOR_MAP = new WeakHashMap<Class, Map<ClassLoader, RuntimeDescriptor>>();

    private DescriptorManager() {
    }

    public static void removeDescriptor(Class c) {
        if (c != null) {
            ClassLoader cl = DescriptorManager.getClassLoaderForKey(c);
            Map<ClassLoader, RuntimeDescriptor> m = DESCRIPTOR_MAP.get(c);
            if (m != null) {
                RuntimeDescriptor descriptor = m.remove(cl);
                if (m.isEmpty()) {
                    DESCRIPTOR_MAP.remove(c);
                }
            }
        }
    }

    public static RuntimeDescriptor getDescriptor(Object o) throws RemoteException {
        return DescriptorManager.getDescriptor(o.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RuntimeDescriptor getDescriptor(Class c) throws RemoteException {
        Map<ClassLoader, RuntimeDescriptor> m;
        RuntimeDescriptor desc = null;
        ClassLoader cl = DescriptorManager.getClassLoaderForKey(c);
        Map<Class, Map<ClassLoader, RuntimeDescriptor>> map = DESCRIPTOR_MAP;
        synchronized (map) {
            m = DESCRIPTOR_MAP.get(c);
            if (m != null) {
                desc = m.get(cl);
            }
        }
        if (desc == null) {
            desc = DescriptorManager.getBasicRuntimeDescriptor(c);
            map = DESCRIPTOR_MAP;
            synchronized (map) {
                m = DESCRIPTOR_MAP.get(c);
                if (m != null) {
                    m.put(cl, desc);
                } else {
                    m = new WeakHashMap<ClassLoader, RuntimeDescriptor>();
                    m.put(cl, desc);
                    DESCRIPTOR_MAP.put(c, m);
                }
            }
        }
        return desc;
    }

    public static RuntimeDescriptor getDescriptorForRMIC(Class c) throws RemoteException {
        ArrayMap desc = null;
        try {
            desc = DescriptorManager.getDescriptorAsMap(c);
            return BasicRuntimeDescriptor.getRuntimeDescriptorForRMIC(desc, c);
        }
        catch (Exception e) {
            throw new UnexpectedException("Failed to parse descriptor file", e);
        }
    }

    public static BasicRuntimeDescriptor getBasicRuntimeDescriptor(Class c) throws RemoteException {
        RuntimeDescriptor rtd = DescriptorManager.createRuntimeDescriptor(c);
        if (rtd == null) {
            rtd = new BasicRuntimeDescriptor(c);
        }
        return (BasicRuntimeDescriptor)rtd;
    }

    public static RuntimeDescriptor createRuntimeDescriptor(Class c) throws RemoteException {
        try {
            ArrayMap desc = DescriptorManager.getDescriptorAsMap(c);
            if (desc != null) {
                return new BasicRuntimeDescriptor(desc, c);
            }
            return null;
        }
        catch (Exception ioe) {
            throw new UnexpectedException("Failed to parse descriptor file", ioe);
        }
    }

    public static RuntimeDescriptor createRuntimeDescriptor(InputStream in, String remoteClassName, Class[] remoteInterfaces) throws RemoteException {
        try {
            ArrayMap desc = DescriptorManager.getDescriptorAsMapFromXml(in);
            if (desc != null) {
                return new BasicRuntimeDescriptor(desc, remoteClassName, remoteInterfaces);
            }
            return null;
        }
        catch (Exception ioe) {
            throw new UnexpectedException("Failed to parse descriptor file", ioe);
        }
    }

    private static boolean isJavaOrJavax(String className) {
        return className.matches("^javax?\\..*");
    }

    static String getDescriptorFileName(String remoteClassName) {
        int index = remoteClassName.lastIndexOf(46);
        StringBuilder sb = new StringBuilder();
        if (index > 0) {
            if (POSTJDK8 && DescriptorManager.isJavaOrJavax(remoteClassName)) {
                sb.append("/");
                sb.append(remoteClassName.replaceAll("\\.", "/"));
            } else {
                sb.append(remoteClassName.substring(index + 1));
            }
        } else {
            sb.append(remoteClassName);
        }
        sb.append(RTD_SUFFIX);
        return sb.toString();
    }

    static ArrayMap getDescriptorAsMap(Class c) throws Exception {
        ArrayMap m = DescriptorManager.getDescriptorAsMapFromAnnotation(c);
        if (m != null) {
            return m;
        }
        String fileName = DescriptorManager.getDescriptorFileName(c.getName());
        if (POSTJDK8 && DescriptorManager.isJavaOrJavax(c.getName())) {
            return DescriptorManager.getDescriptorAsMapFromXml(DescriptorManager.class.getResourceAsStream(fileName));
        }
        return DescriptorManager.getDescriptorAsMapFromXml(c.getResourceAsStream(fileName));
    }

    static ArrayMap getDescriptorAsMapFromAnnotation(Class c) throws IOException {
        return RMIAnnotationProcessor.getDescriptorAsMap(c);
    }

    static ArrayMap getDescriptorAsMapFromXml(InputStream in) throws Exception {
        if (in != null) {
            try {
                ArrayMap arrayMap = DescriptorHelper.getDescriptorAsMap(in);
                return arrayMap;
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static ClassLoader getClassLoaderForKey(Class c) {
        ClassLoader cl = c.getClassLoader();
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        while (cl instanceof GenericClassLoader) {
            GenericClassLoader gcl = (GenericClassLoader)cl;
            String appName = gcl.getAnnotation().getAnnotationString();
            if (appName != null && appName.length() != 0) {
                return cl;
            }
            cl = gcl.getParent();
        }
        return cl;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("usage: java weblogic.rmi.internal.DescriptorManager<remote class name>");
            return;
        }
        try {
            String className = args[0];
            Class<?> c = Class.forName(className);
            DescriptorManager.getBasicRuntimeDescriptor(c);
            System.out.println("Descriptor Parse and Validation Succeeded");
        }
        catch (Exception e) {
            System.err.println("Descriptor Parse and Validation Failed");
            e.printStackTrace();
        }
    }
}

