/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import weblogic.rmi.extensions.RequestTimeoutException;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.AsyncResultImpl;
import weblogic.rmi.internal.FutureResultHandle;
import weblogic.rmi.internal.FutureResultID;
import weblogic.rmi.spi.FutureResult;
import weblogic.rmi.spi.InboundResponse;

public final class FutureResultImpl
extends AsyncResultImpl
implements Future,
FutureResult {
    private Remote invoker;
    private final FutureResultID id;
    private boolean cancelled;
    private Class remoteExceptionWrapperClass;
    private Constructor constructor;
    private static final int NUM_BITS = 32;

    public FutureResultImpl(Remote stub) throws RemoteException {
        this.invoker = stub;
        this.id = new FutureResultID(this.getUniqueID());
    }

    public FutureResultImpl(Remote stub, RuntimeMethodDescriptor md) throws RemoteException {
        this.invoker = stub;
        this.id = new FutureResultID(this.hashCode());
        String remoteExceptionWrapperName = md.getRemoteExceptionWrapperClassName();
        try {
            this.remoteExceptionWrapperClass = Class.forName(remoteExceptionWrapperName);
            this.constructor = this.remoteExceptionWrapperClass.getConstructor(Exception.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RemoteException("Creation of FutureResult failed.", e);
        }
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled || this.isDone()) {
            return false;
        }
        this.cancelled = ((FutureResultHandle)this.invoker).__WL_cancel(this.id, mayInterruptIfRunning);
        return this.cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.cancelled || this.hasResults();
    }

    public Object get() throws InterruptedException, ExecutionException, CancellationException {
        try {
            return this.unWrappedFutureResult();
        }
        catch (Throwable throwable) {
            if (throwable instanceof CancellationException) {
                throw (CancellationException)throwable;
            }
            if (throwable instanceof RemoteException) {
                throw (RuntimeException)this.throwUserDefinedException(throwable, this.remoteExceptionWrapperClass, this.constructor);
            }
            throw new ExecutionException(throwable);
        }
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException, CancellationException {
        long timeoutVal = timeout;
        if (unit != TimeUnit.MILLISECONDS) {
            timeoutVal = TimeUnit.SECONDS.convert(timeout, TimeUnit.MILLISECONDS);
        }
        this.setTimeOut(timeoutVal);
        try {
            return this.unWrappedFutureResult();
        }
        catch (Throwable throwable) {
            if (throwable instanceof TimeoutException || throwable instanceof RequestTimeoutException) {
                throw new TimeoutException("Timed out. Unable to retrieve object after " + timeoutVal + " milliseconds.");
            }
            if (throwable instanceof CancellationException) {
                throw (CancellationException)throwable;
            }
            if (throwable instanceof RemoteException) {
                throw (RuntimeException)this.throwUserDefinedException(throwable, this.remoteExceptionWrapperClass, this.constructor);
            }
            throw new ExecutionException(throwable);
        }
    }

    private Object unWrappedFutureResult() throws Throwable {
        if (this.cancelled) {
            throw new CancellationException("This task has been cancelled already!");
        }
        Future future = (Future)this.getObject();
        return future.get();
    }

    @Override
    public FutureResultID getId() {
        return this.id;
    }

    @Override
    public synchronized void setInboundResponse(InboundResponse inboundResponse) {
        super.setInboundResponse(inboundResponse);
        if (this.cancelled) {
            try {
                this.closeResponse();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private long getUniqueID() {
        return System.nanoTime() << 32 | (long)(this.hashCode() & 2 ^ 0x1F);
    }
}

