/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Timer;
import java.util.TimerTask;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.platform.VM;
import weblogic.rmi.internal.TimeoutChecker;
import weblogic.workarea.LongWorkContext;
import weblogic.workarea.PrimitiveContextFactory;
import weblogic.workarea.PropertyReadOnlyException;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextMap;

public class RMIDiagnosticUtil {
    private static Timer THE_ONE;
    private static boolean timerInitialized;
    private static final int interval = 30000;
    private static final DebugLogger debugLogger;

    private RMIDiagnosticUtil() {
    }

    static boolean isStarted() {
        return THE_ONE != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initializeTimerIfNeeded() {
        if (timerInitialized) return;
        Class<RMIDiagnosticUtil> clazz = RMIDiagnosticUtil.class;
        synchronized (RMIDiagnosticUtil.class) {
            if (timerInitialized) return;
            if (KernelStatus.isServer() && debugLogger.isDebugEnabled()) {
                RMIDiagnosticUtil.startObserver();
            }
            timerInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static synchronized void startObserver() {
        if (RMIDiagnosticUtil.isStarted()) {
            return;
        }
        try {
            THE_ONE = new Timer("RMI diagnostic timer", true);
            THE_ONE.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (TimeoutChecker.isThereTimedOutThreads()) {
                        RMIDiagnosticUtil.logThreadDump();
                    }
                }
            }, 30000L, 30000L);
            debugLogger.debug("RMIDiagnosticUtil.startObserver scheduled diag TimerTask.");
        }
        catch (Throwable e) {
            debugLogger.debug("RMIDiagnosticUtil.startObserver failed to schedule diag TimerTask. : " + e);
        }
    }

    public static void logThreadDump() {
        debugLogger.debug("found a thread that reaches client-side read timeout. dump full threads to identify root cause of timeout.");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        VM.getVM().threadDump(pw);
        pw.close();
        debugLogger.debug(sw.toString());
    }

    public static void setTimeoutToWorkContext(long timeout) {
        if (!debugLogger.isDebugEnabled()) {
            return;
        }
        if (timeout > 0L) {
            WorkContextMap wcm = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
            WorkContext wcTimeout = PrimitiveContextFactory.create(timeout);
            try {
                wcm.put("rmi.clientTimeout", wcTimeout, 4);
            }
            catch (PropertyReadOnlyException e) {
                debugLogger.debug("sending timeout property failed : " + e);
            }
        }
    }

    public static long getTimeoutFromWorkContext() {
        if (!debugLogger.isDebugEnabled()) {
            return -1L;
        }
        RMIDiagnosticUtil.initializeTimerIfNeeded();
        WorkContextMap wcm = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
        WorkContext wcTimeout = wcm.get("rmi.clientTimeout");
        if (wcTimeout == null || !(wcTimeout instanceof LongWorkContext)) {
            return -1L;
        }
        LongWorkContext lwc = (LongWorkContext)wcTimeout;
        return lwc.longValue();
    }

    public static TimeoutChecker initTimeoutCheckerIfNeeded() {
        return TimeoutChecker.init(RMIDiagnosticUtil.getTimeoutFromWorkContext());
    }

    static {
        timerInitialized = false;
        debugLogger = DebugLogger.getDebugLogger("DebugRMIRequestPerf");
    }
}

