/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.UnmarshalException;
import java.security.AccessController;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIServerImpl;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.invocation.ManagedInvocationContext;
import weblogic.protocol.ServerChannel;
import weblogic.rmi.RMILogger;
import weblogic.rmi.cluster.PiggybackResponse;
import weblogic.rmi.cluster.Version;
import weblogic.rmi.extensions.activation.Activatable;
import weblogic.rmi.extensions.activation.Activator;
import weblogic.rmi.extensions.server.CBVInputStream;
import weblogic.rmi.extensions.server.CBVOutputStream;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.facades.RmiInvocationFacade;
import weblogic.rmi.internal.ClusterAwareServerReference;
import weblogic.rmi.internal.FutureResultHandle;
import weblogic.rmi.internal.FutureResultID;
import weblogic.rmi.internal.OperationConstants;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.internal.Skeleton;
import weblogic.rmi.internal.WLSAsyncExecuteRequest;
import weblogic.rmi.internal.activation.ActivatableServerRef;
import weblogic.rmi.spi.AsyncCallback;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.InboundResponse;
import weblogic.rmi.spi.MsgInput;
import weblogic.rmi.spi.MsgOutput;
import weblogic.rmi.spi.OutboundRequest;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.AssertionError;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.spi.WorkContextMapInterceptor;
import weblogic.workarea.utils.BaseWorkContextInput;
import weblogic.workarea.utils.BaseWorkContextOutput;

public final class ServerRequest
implements OutboundRequest,
InboundResponse,
OperationConstants {
    private static final Object CBV_PLACEHOLDER = new Object();
    private static final ClassLoader SYSTEM_CLASSLOADER = ClassLoader.getSystemClassLoader();
    private RuntimeMethodDescriptor md;
    private ServerReference dispatcher;
    private Object txContext;
    private Object[] args;
    private Object result;
    private Object activationID;
    private Throwable throwable;
    private Object replicaInfo;
    private String partitionURL;

    public ServerRequest(ServerReference dispatcher, RuntimeMethodDescriptor md) throws IOException {
        this.dispatcher = dispatcher;
        this.md = md;
    }

    public ServerRequest(ServerReference dispatcher, RuntimeMethodDescriptor md, String partitionURL) throws IOException {
        this.dispatcher = dispatcher;
        this.md = md;
        this.partitionURL = partitionURL;
    }

    void init(ServerReference dispatcher, RuntimeMethodDescriptor md) {
        this.dispatcher = dispatcher;
        this.md = md;
    }

    public synchronized Throwable getThrowable() {
        if (this.throwable != null) {
            this.unmarshalThrowable();
        }
        return this.throwable;
    }

    @Override
    public MsgInput getMsgInput() {
        throw new AssertionError();
    }

    @Override
    public MsgOutput getMsgOutput() {
        throw new AssertionError();
    }

    @Override
    public EndPoint getEndPoint() {
        throw new AssertionError();
    }

    @Override
    public void marshalArgs(Object[] args) throws MarshalException {
        this.args = args;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object unmarshalReturn() throws UnmarshalException {
        if (this.result == null) {
            return this.result;
        }
        Object replacement = ServerRequest.getReplacement(this.result);
        if (replacement != null) {
            return replacement;
        }
        ComponentInvocationContextManager mgr = ComponentInvocationContextManager.getInstance();
        ComponentInvocationContext cic = mgr.getCurrentComponentInvocationContext();
        if (cic.getApplicationName() == null) {
            cic = mgr.createComponentInvocationContext(cic.getPartitionName(), "_SERVER_REQUEST_", cic.getApplicationVersion(), cic.getModuleName(), cic.getComponentName());
        }
        try (ManagedInvocationContext mic = this.setCIC(cic);){
            CBVOutputStream out = new CBVOutputStream();
            out.writeObject(this.result);
            out.flush();
            CBVInputStream in = out.makeCBVInputStream();
            Object returnValue = in.readObject();
            out.close();
            in.close();
            Object object = returnValue;
            return object;
        }
        catch (IOException ioe) {
            throw new UnmarshalException("failed to unmarshal return type: " + this.md.getReturnType(), ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new UnmarshalException("failed to load return type: " + this.md.getReturnType(), cnfe);
        }
    }

    @Override
    public PiggybackResponse getReplicaInfo() {
        Object impl;
        if (this.replicaInfo != null && (impl = this.dispatcher.getImplementation()) instanceof Remote) {
            try {
                ServerReference serverReference = ServerHelper.getServerReference((Remote)impl);
                if (serverReference instanceof ClusterAwareServerReference) {
                    ClusterAwareServerReference cAwareServerRef = (ClusterAwareServerReference)serverReference;
                    return cAwareServerRef.handlePiggybackRequest(this.replicaInfo);
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Object getTxContext() {
        return this.txContext;
    }

    @Override
    public void setTxContext(Object txContext) {
        this.txContext = txContext;
    }

    @Override
    public void close() {
    }

    @Override
    public void sendOneWay() throws RemoteException {
        throw new AssertionError("collocated oneway calls not supported");
    }

    @Override
    public void sendAsync(AsyncCallback callback) throws RemoteException {
        if (callback == null) {
            throw new RemoteException("collocated oneway calls not supported");
        }
        if (!this.md.hasAsyncResponse()) {
            throw new RemoteException("md = " + this.md + " is not marked with an asynchronous annotation!");
        }
        WorkManager wm = this.md.workManagerAvailable() ? this.md.getWorkManager() : WorkManagerFactory.getInstance().getDefault();
        wm.schedule(new WLSAsyncExecuteRequest(this, callback));
    }

    public synchronized void setThrowable(Throwable t) {
        this.throwable = t;
        this.notify();
    }

    private ManagedInvocationContext setCIC(ComponentInvocationContext cic) {
        if (cic != null) {
            return RmiInvocationFacade.setInvocationContext(KernelIdProvider.INSTANCE.getKernelId(), cic);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InboundResponse sendReceive() throws Throwable {
        try {
            ClassLoader loader;
            Object replacement;
            ServerChannel scSave;
            EndPoint epSave;
            block40: {
                this.md = this.md.getCanonical(this.dispatcher.getDescriptor());
                Thread currentThread = null;
                ClassLoader clSave = null;
                ClassLoader newCCL = this.dispatcher.getApplicationClassLoader();
                ComponentInvocationContext newCIC = this.isMBeanServerObject() ? null : this.dispatcher.getInvocationContext();
                epSave = ServerHelper.getClientEndPointInternal();
                scSave = ServerHelper.getServerChannel();
                ServerHelper.setClientInfo(null, null);
                Activatable impl = null;
                Activator activator = null;
                WorkContextMapInterceptor currentWcmi = null;
                if (this.activationID != null) {
                    activator = ((ActivatableServerRef)this.dispatcher).getActivator();
                }
                try {
                    if (newCCL != null) {
                        currentThread = Thread.currentThread();
                        clSave = currentThread.getContextClassLoader();
                        currentThread.setContextClassLoader(newCCL);
                    }
                    try (ManagedInvocationContext mic = this.setCIC(newCIC);){
                        Skeleton skeleton = null;
                        try {
                            skeleton = this.dispatcher.getDescriptor().getSkeleton();
                        }
                        catch (RemoteException re) {
                            throw new UnmarshalException("Failed to load skeleton", re);
                        }
                        if (newCCL != null) {
                            currentWcmi = this.propagateWorkContext();
                        }
                        if (this.args != null || this.activationID != null) {
                            this.copy(this.args);
                        }
                        try {
                            if (this.activationID != null) {
                                impl = activator.activate(this.activationID);
                                this.result = skeleton.invoke(this.md.getIndex(), this.args, impl);
                            } else {
                                this.result = skeleton.invoke(this.md.getIndex(), this.args, this.dispatcher.getImplementation());
                            }
                            if (this.activationID != null) {
                                activator.deactivate(impl);
                            }
                        }
                        catch (Throwable t) {
                            try {
                                this.throwable = t;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (this.activationID != null) {
                                    activator.deactivate(impl);
                                }
                            }
                        }
                    }
                    if (clSave == null) break block40;
                    currentThread.setContextClassLoader(clSave);
                }
                catch (Throwable throwable) {
                    ClassLoader loader2;
                    Object replacement2;
                    if (clSave != null) {
                        currentThread.setContextClassLoader(clSave);
                        this.restoreWorkContext(currentWcmi);
                    }
                    ServerHelper.setClientInfo(epSave, scSave);
                    if (this.result != null && (replacement2 = ServerRequest.getReplacement(this.result)) != null && !(replacement2 instanceof Serializable) && (loader2 = replacement2.getClass().getClassLoader()) != null && loader2 != SYSTEM_CLASSLOADER) {
                        this.throwable = new MarshalException("Failed to serialize " + replacement2.getClass().getName());
                    }
                    throw throwable;
                }
                this.restoreWorkContext(currentWcmi);
            }
            ServerHelper.setClientInfo(epSave, scSave);
            if (this.result != null && (replacement = ServerRequest.getReplacement(this.result)) != null && !(replacement instanceof Serializable) && (loader = replacement.getClass().getClassLoader()) != null && loader != SYSTEM_CLASSLOADER) {
                this.throwable = new MarshalException("Failed to serialize " + replacement.getClass().getName());
            }
            Throwable t = this.getThrowable();
            if (t == null) {
                return this;
            }
            Throwable t2 = t.fillInStackTrace();
            if (t2 != null) {
                throw t2;
            }
            t.initCause(new Exception("an exception is thrown from ServerRequest."));
            throw t;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (OutOfMemoryError oom) {
            throw oom;
        }
        catch (Error er) {
            RMILogger.logErrorServer(this.dispatcher.getImplementation().toString(), this.md.toString());
            throw new ServerError("A error occurred the server", er);
        }
    }

    private boolean isMBeanServerObject() {
        return this.dispatcher.getImplementation() instanceof RMIServerImpl || this.dispatcher.getImplementation() instanceof RMIConnection;
    }

    private void setFutureObjectID(Object impl, Object obj) throws UnmarshalException {
        if (obj != null) {
            ((FutureResultHandle)impl).__WL_setFutureResultID((FutureResultID)obj, KernelIdProvider.INSTANCE.getKernelId());
        }
    }

    private void copy(Object[] args) throws ClassNotFoundException, IOException {
        CBVOutputStream cbvout = new CBVOutputStream();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object toCopy = args[i];
                if (toCopy == null) continue;
                Object replacement = ServerRequest.getReplacement(toCopy);
                if (replacement != null) {
                    this.checkObjectSerialization(replacement);
                    args[i] = replacement;
                    continue;
                }
                cbvout.writeObject(toCopy);
                args[i] = CBV_PLACEHOLDER;
            }
        }
        if (this.activationID != null) {
            Object replacement = ServerRequest.getReplacement(this.activationID);
            if (replacement != null) {
                this.activationID = replacement;
            } else {
                cbvout.writeObject(this.activationID);
                this.activationID = CBV_PLACEHOLDER;
            }
        }
        cbvout.flush();
        CBVInputStream cbvin = cbvout.makeCBVInputStream();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != CBV_PLACEHOLDER) continue;
                args[i] = cbvin.readObject();
            }
        }
        if (this.activationID == CBV_PLACEHOLDER) {
            this.activationID = cbvin.readObject();
        }
        cbvout.close();
        cbvin.close();
    }

    @Override
    public void setTimeOut(int msecs) {
    }

    @Override
    public void setReplicaInfo(Version replicaInfo) throws IOException {
        this.replicaInfo = replicaInfo;
    }

    @Override
    public void setActivationID(Object activationID) {
        this.activationID = activationID;
    }

    @Override
    public void retrieveThreadLocalContext() throws IOException {
    }

    @Override
    public void retrieveThreadLocalContext(boolean forceReset) throws IOException {
    }

    @Override
    public void transferThreadLocalContext() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkContextMapInterceptor propagateWorkContext() throws IOException {
        WorkContextMapInterceptor suspendedWorkContext = WorkContextHelper.getWorkContextHelper().getInterceptor().suspendThreadContexts();
        if (suspendedWorkContext == null) {
            return null;
        }
        CBVOutputStream coo = null;
        CBVInputStream cin = null;
        try {
            coo = new CBVOutputStream();
            CollocatedWorkContextOutput cwcout = new CollocatedWorkContextOutput(coo);
            suspendedWorkContext.sendRequest(cwcout, 4);
            coo.flush();
            cin = coo.makeCBVInputStream();
            CollocatedWorkContextInput cwcin = new CollocatedWorkContextInput(cin);
            WorkContextHelper.getWorkContextHelper().getInterceptor().receiveRequest(cwcin);
        }
        finally {
            if (coo != null) {
                coo.close();
            }
            if (cin != null) {
                cin.close();
            }
        }
        return suspendedWorkContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreWorkContext(WorkContextMapInterceptor wcmi) throws IOException {
        WorkContextMapInterceptor callerWorkContextInterceptor = WorkContextHelper.getWorkContextHelper().getLocalInterceptor();
        WorkContextHelper.getWorkContextHelper().getInterceptor().resumeThreadContexts(wcmi);
        if (callerWorkContextInterceptor == null) {
            return;
        }
        CBVOutputStream coo = null;
        CBVInputStream cin = null;
        try {
            coo = new CBVOutputStream();
            CollocatedWorkContextOutput cwcout = new CollocatedWorkContextOutput(coo);
            callerWorkContextInterceptor.sendResponse(cwcout, 4);
            coo.flush();
            cin = coo.makeCBVInputStream();
            CollocatedWorkContextInput cwcin = new CollocatedWorkContextInput(cin);
            WorkContextHelper.getWorkContextHelper().getInterceptor().receiveResponse(cwcin);
        }
        finally {
            if (coo != null) {
                coo.close();
            }
            if (cin != null) {
                cin.close();
            }
        }
    }

    @Override
    public void setContext(int id, Object data) throws IOException {
        if (this.md.hasAsyncResponse()) {
            Object impl;
            if (this.activationID != null) {
                Activator activator = ((ActivatableServerRef)this.dispatcher).getActivator();
                impl = activator.activate(this.activationID);
            } else {
                impl = this.dispatcher.getImplementation();
            }
            this.setFutureObjectID(impl, data);
        }
    }

    @Override
    public Object getContext(int id) throws IOException {
        return null;
    }

    public void setRuntimeMethodDescriptor(RuntimeMethodDescriptor descriptor) throws IOException {
        this.md = descriptor;
    }

    @Override
    public Object getActivatedPinnedRef() {
        return null;
    }

    private static Object getReplacement(Object o) {
        if (o instanceof String) {
            return o;
        }
        Class<?> c = o.getClass();
        if (o instanceof Number && c.getClassLoader() == ClassLoader.getSystemClassLoader()) {
            return o;
        }
        if (o instanceof Boolean) {
            return o;
        }
        if (o instanceof Character) {
            return o;
        }
        if (c.isArray()) {
            if (o instanceof String[]) {
                return ((String[])o).clone();
            }
            if (o instanceof Number[] && c.getClassLoader() == ClassLoader.getSystemClassLoader()) {
                return ((Number[])o).clone();
            }
            if (o instanceof Boolean[]) {
                return ((Boolean[])o).clone();
            }
            if (o instanceof Character[]) {
                return ((Character[])o).clone();
            }
            if (c.getComponentType().isPrimitive()) {
                if (o instanceof byte[]) {
                    return ((byte[])o).clone();
                }
                if (o instanceof int[]) {
                    return ((int[])o).clone();
                }
                if (o instanceof char[]) {
                    return ((char[])o).clone();
                }
                if (o instanceof boolean[]) {
                    return ((boolean[])o).clone();
                }
                if (o instanceof short[]) {
                    return ((short[])o).clone();
                }
                if (o instanceof long[]) {
                    return ((long[])o).clone();
                }
                if (o instanceof double[]) {
                    return ((double[])o).clone();
                }
                if (o instanceof float[]) {
                    return ((float[])o).clone();
                }
            }
        }
        if (o instanceof Serializable) {
            return null;
        }
        if (o instanceof Remote) {
            return null;
        }
        return o;
    }

    private void unmarshalThrowable() {
        try {
            CBVOutputStream out = new CBVOutputStream();
            out.writeObject(this.throwable);
            out.flush();
            CBVInputStream in = out.makeCBVInputStream();
            Throwable thr = (Throwable)in.readObject();
            out.close();
            in.close();
            this.throwable = thr;
        }
        catch (IOException ioe) {
            throw new AssertionError("cannot unmarshaling throwable", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AssertionError("error unmarshaling throwable", cnfe);
        }
    }

    private void checkObjectSerialization(Object replacement) throws MarshalException {
        ClassLoader loader;
        if (replacement != null && !(replacement instanceof Serializable) && (loader = replacement.getClass().getClassLoader()) != null && loader != SYSTEM_CLASSLOADER) {
            throw new MarshalException("Failed to serialize " + replacement.getClass().getName());
        }
    }

    private class CollocatedWorkContextInput
    extends BaseWorkContextInput {
        private CBVInputStream cin;

        public CollocatedWorkContextInput(CBVInputStream cin) {
            this.cin = cin;
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            byte[] src = (byte[])this.cin.readObjectSpecial();
            System.arraycopy(src, 0, b, 0, src.length);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            byte[] src = (byte[])this.cin.readObjectSpecial();
            System.arraycopy(src, 0, b, off, len);
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return 0;
        }

        @Override
        public boolean readBoolean() throws IOException {
            return (Boolean)this.cin.readObjectSpecial();
        }

        @Override
        public byte readByte() throws IOException {
            return (Byte)this.cin.readObjectSpecial();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return (Integer)this.cin.readObjectSpecial();
        }

        @Override
        public short readShort() throws IOException {
            return (Short)this.cin.readObjectSpecial();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return (Integer)this.cin.readObjectSpecial();
        }

        @Override
        public char readChar() throws IOException {
            return ((Character)this.cin.readObjectSpecial()).charValue();
        }

        @Override
        public int readInt() throws IOException {
            return (Integer)this.cin.readObjectSpecial();
        }

        @Override
        public long readLong() throws IOException {
            return (Long)this.cin.readObjectSpecial();
        }

        @Override
        public float readFloat() throws IOException {
            return ((Float)this.cin.readObjectSpecial()).floatValue();
        }

        @Override
        public double readDouble() throws IOException {
            return (Double)this.cin.readObjectSpecial();
        }

        @Override
        public String readLine() throws IOException {
            return null;
        }

        @Override
        public String readUTF() throws IOException {
            return (String)this.cin.readObjectSpecial();
        }
    }

    private class CollocatedWorkContextOutput
    extends BaseWorkContextOutput {
        private CBVOutputStream coo;

        public CollocatedWorkContextOutput(CBVOutputStream coo) {
            this.coo = coo;
        }

        @Override
        public void write(int i) throws IOException {
            this.coo.writeObjectSpecial(i);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.coo.writeObjectSpecial(bytes);
        }

        @Override
        public void write(byte[] bytes, int i, int i1) throws IOException {
            byte[] b1 = new byte[i1 - i];
            System.arraycopy(bytes, i, b1, 0, i1 - i);
            this.coo.writeObjectSpecial(b1);
        }

        @Override
        public void writeBoolean(boolean b) throws IOException {
            this.coo.writeObjectSpecial(b);
        }

        @Override
        public void writeByte(int i) throws IOException {
            this.coo.writeObjectSpecial(i);
        }

        @Override
        public void writeShort(int i) throws IOException {
            this.coo.writeObjectSpecial(i);
        }

        @Override
        public void writeChar(int i) throws IOException {
            this.coo.writeObjectSpecial(i);
        }

        @Override
        public void writeInt(int i) throws IOException {
            this.coo.writeObjectSpecial(i);
        }

        @Override
        public void writeLong(long l) throws IOException {
            this.coo.writeObjectSpecial(l);
        }

        @Override
        public void writeFloat(float v) throws IOException {
            this.coo.writeObjectSpecial(Float.valueOf(v));
        }

        @Override
        public void writeDouble(double v) throws IOException {
            this.coo.writeObjectSpecial(v);
        }

        @Override
        public void writeBytes(String s) throws IOException {
            this.coo.writeObjectSpecial(s.getBytes());
        }

        @Override
        public void writeChars(String s) throws IOException {
            this.coo.writeObjectSpecial(s);
        }

        @Override
        public void writeUTF(String s) throws IOException {
            this.coo.writeObjectSpecial(s);
        }
    }

    private static enum KernelIdProvider {
        INSTANCE;

        private final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

        private AuthenticatedSubject getKernelId() {
            return this.kernelId;
        }
    }
}

