/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal.dgc;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.LocalServerIdentity;
import weblogic.rmi.RMILogger;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.internal.Enrollable;
import weblogic.rmi.internal.PartitionAwareRef;
import weblogic.rmi.internal.dgc.DGCClientImpl;
import weblogic.rmi.internal.dgc.DGCReferenceCounter;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.HostID;
import weblogic.rmi.spi.RMIRuntime;
import weblogic.utils.Debug;
import weblogic.utils.KeyTable;
import weblogic.utils.SyncKeyTable;

public final class DGCClientHelper
implements Enrollable {
    private static boolean DEBUG = false;
    private static final Object chainLock = new Object();
    private static final Hashtable hostTable = new Hashtable();
    private static final Stack stack = new Stack();
    private static volatile DGCClientHelper chain = null;
    private volatile DGCClientHelper next = null;
    private volatile boolean hasBeenStacked = false;
    private static final DGCClientImpl dgcClientImpl = DGCClientImpl.getDGCClientImpl();
    private final DGCReferenceCounter counter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Vector getHeartBeats() {
        Hashtable hashtable = hostTable;
        synchronized (hashtable) {
            Vector heartBeats = new Vector();
            Enumeration e = hostTable.keys();
            while (e.hasMoreElements()) {
                HostID hostID = (HostID)e.nextElement();
                EndPoint endPoint = RMIRuntime.findEndPoint(hostID);
                if (endPoint == null || endPoint.isDead()) continue;
                ConcurrentHashMap partitionMap = (ConcurrentHashMap)hostTable.get(hostID);
                if (partitionMap == null || partitionMap.isEmpty()) {
                    RMILogger.logEmptyWS(hostID.toString());
                    continue;
                }
                for (String partition : partitionMap.keySet()) {
                    KeyTable workingSet = (KeyTable)partitionMap.get(partition);
                    if (workingSet == null || workingSet.size() == 0) {
                        RMILogger.logEmptyWS("partition[" + partition + "] of " + hostID.toString());
                        continue;
                    }
                    Vector<DGCReferenceCounter> heartBeatEntry = new Vector<DGCReferenceCounter>();
                    heartBeats.addElement(heartBeatEntry);
                    Enumeration ea = workingSet.elements();
                    while (ea.hasMoreElements()) {
                        DGCReferenceCounter xRef = (DGCReferenceCounter)ea.nextElement();
                        if (xRef == null || xRef.getCount() <= 0 && !xRef.leaseRenewed()) continue;
                        heartBeatEntry.addElement(xRef);
                        xRef.renewLease(false);
                    }
                }
            }
            return heartBeats;
        }
    }

    public static DGCClientHelper dequeue() {
        if (stack.empty()) {
            DGCClientHelper current = chain;
            while (current != null) {
                if (!current.hasBeenStacked) {
                    current.hasBeenStacked = true;
                    stack.push(current);
                }
                current = current.next;
            }
            if (stack.empty()) {
                return null;
            }
        }
        DGCClientHelper l = (DGCClientHelper)stack.pop();
        l.next = null;
        if (DEBUG) {
            System.out.println("\n*** returning " + l.counter.getOID());
        }
        return l;
    }

    public static void mark(Map remoteHostIDMap) {
        DGCClientHelper helper = DGCClientHelper.dequeue();
        while (helper != null) {
            helper.decrement(remoteHostIDMap);
            if (DEBUG) {
                Debug.say("Finalized " + helper.counter.getOID() + " count = " + helper.counter.getCount());
            }
            helper = DGCClientHelper.dequeue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DGCClientHelper findAndEnroll(RemoteReference ror) {
        DGCReferenceCounter counter;
        Hashtable hashtable = hostTable;
        synchronized (hashtable) {
            ConcurrentHashMap<String, KeyTable> partitionMap = (ConcurrentHashMap<String, KeyTable>)hostTable.get(ror.getHostID());
            if (partitionMap == null) {
                if (ror.getHostID().isLocal()) {
                    return null;
                }
                partitionMap = new ConcurrentHashMap<String, KeyTable>();
                hostTable.put(ror.getHostID(), partitionMap);
                if (DEBUG) {
                    Debug.say("\n\n\n***********Made partitionMap set for " + ror.getHostID());
                }
            }
            String currentPartition = "DOMAIN";
            if (KernelStatus.isServer()) {
                currentPartition = ComponentInvocationContextManager.getInstance().getCurrentComponentInvocationContext().getPartitionName();
            } else if (ror instanceof PartitionAwareRef) {
                currentPartition = ((PartitionAwareRef)((Object)ror)).getPartitionName();
            }
            KeyTable workingSet = (KeyTable)partitionMap.get(currentPartition);
            if (workingSet == null) {
                if (ror.getHostID().isLocal()) {
                    return null;
                }
                workingSet = new SyncKeyTable();
                partitionMap.put(currentPartition, workingSet);
                if (DEBUG) {
                    Debug.say("\n\n\n***********Made working set for " + ror.getHostID());
                }
            }
            if ((counter = (DGCReferenceCounter)workingSet.get(ror.getObjectID())) == null) {
                counter = new DGCReferenceCounter(ror, currentPartition);
                workingSet.put(counter);
            }
            counter.increment();
        }
        return new DGCClientHelper(counter);
    }

    private DGCClientHelper(DGCReferenceCounter counter) {
        this.counter = counter;
    }

    @Override
    public synchronized void enroll() {
        this.counter.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unenroll() {
        Object object = chainLock;
        synchronized (object) {
            this.next = chain;
            chain = this;
        }
    }

    @Override
    public void renewLease() {
        this.counter.renewLease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrement(Map remoteHostIDMap) {
        Hashtable hashtable = hostTable;
        synchronized (hashtable) {
            if (this.counter.decrement() == 0) {
                ConcurrentHashMap partitionMap = (ConcurrentHashMap)hostTable.get(this.counter.getHostID());
                if (partitionMap == null) {
                    return;
                }
                KeyTable workingSet = (KeyTable)partitionMap.get(this.counter.getPartitionName());
                if (workingSet == null) {
                    RMILogger.logNoWS(this.counter.getOID(), this.counter.getHostID().toString());
                    return;
                }
                Object deadGuy = workingSet.remove(this.counter.getOID());
                if (deadGuy == null) {
                    RMILogger.logNoRef(this.counter.getOID());
                }
                if (DEBUG) {
                    Debug.say("... removed " + this.counter.getOID() + "");
                }
                if (workingSet.size() == 0) {
                    partitionMap.remove(this.counter.getPartitionName());
                    if (partitionMap.isEmpty()) {
                        hostTable.remove(this.counter.getHostID());
                        remoteHostIDMap.remove(this.counter.getHostID());
                        if (DEBUG) {
                            Debug.say("\n\n\n**********Removing workingSet  " + this.counter.getHostID() + "for all partitions from " + LocalServerIdentity.getIdentity());
                        }
                    }
                }
            }
        }
    }
}

