/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.internal.dgc;

import java.lang.ref.ReferenceQueue;
import java.rmi.NoSuchObjectException;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.rmi.RMILogger;
import weblogic.rmi.extensions.server.Collectable;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.PhantomRef;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.internal.dgc.DGCServer;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;

public final class DGCServerImpl
implements DGCServer,
NakedTimerListener {
    private static DGCServerImpl theDGCServerImpl = null;
    private static OIDManager oidMngr = null;
    private static final ReferenceQueue refQueue = new ReferenceQueue();
    private static final ConcurrentHashMap map = new ConcurrentHashMap();
    private static final Object dummy = new Object();
    private static final boolean DEBUG = false;
    private final Timer timer;
    private final int idleTimeout;
    private static final DebugLogger debugLogStatistics = DebugLogger.getDebugLogger("LogDGCStatistics");
    private static final DebugLogger debugDgcEnrollment = DebugLogger.getDebugLogger("DebugDGCEnrollment");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final DGCServerImpl getDGCServerImpl() {
        if (theDGCServerImpl != null) return theDGCServerImpl;
        Class<DGCServerImpl> clazz = DGCServerImpl.class;
        synchronized (DGCServerImpl.class) {
            if (theDGCServerImpl == null) {
                theDGCServerImpl = new DGCServerImpl();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            oidMngr = OIDManager.getInstance();
            return theDGCServerImpl;
        }
    }

    private DGCServerImpl() {
        theDGCServerImpl = this;
        this.idleTimeout = this.getIdleTimeout();
        this.timer = TimerManagerFactory.getTimerManagerFactory().getTimerManager("DGCServer", "weblogic.kernel.System").schedule((TimerListener)this, this.idleTimeout, (long)this.idleTimeout);
    }

    private int getIdleTimeout() {
        int period = RMIEnvironment.getEnvironment().getHeartbeatPeriodLength();
        if (period == 0) {
            period = 60000;
        }
        return period * RMIEnvironment.getEnvironment().getDGCIdlePeriodsUntilTimeout();
    }

    @Override
    public void timerExpired(Timer t) {
        int before = 0;
        long tb = 0L;
        if (KernelStatus.DEBUG && debugLogStatistics.isDebugEnabled()) {
            tb = System.currentTimeMillis();
        }
        this.mark();
        if (KernelStatus.DEBUG && debugLogStatistics.isDebugEnabled()) {
            long ta = System.currentTimeMillis();
            RMILogger.logMarked(ta - tb);
            before = oidMngr.size();
            tb = System.currentTimeMillis();
        }
        try {
            oidMngr.sweep();
        }
        catch (Exception e) {
            RMILogger.logSweepException(e);
        }
        if (KernelStatus.DEBUG && debugLogStatistics.isDebugEnabled()) {
            long ta = System.currentTimeMillis();
            int after = oidMngr.size();
            RMILogger.logSweepFreed(before - after, ta - tb, after);
        }
    }

    @Override
    public void enroll(int[] oids) {
        int end = oids.length;
        for (int i = 0; i < end; ++i) {
            try {
                ((Collectable)((Object)oidMngr.getServerReference(oids[i]))).incrementRefCount();
                continue;
            }
            catch (NoSuchObjectException nsoe) {
                if (!KernelStatus.DEBUG || !debugDgcEnrollment.isDebugEnabled()) continue;
                RMILogger.logEnrollLostRef(oids[i]);
            }
        }
    }

    @Override
    public void unenroll(int[] oids) {
        int end = oids.length;
        for (int i = 0; i < end; ++i) {
            try {
                ((Collectable)((Object)oidMngr.getServerReference(oids[i]))).decrementRefCount();
                continue;
            }
            catch (NoSuchObjectException nsoe) {
                if (!KernelStatus.DEBUG || !debugDgcEnrollment.isDebugEnabled()) continue;
                RMILogger.logUnenrollLostRef(oids[i]);
            }
        }
    }

    @Override
    public void renewLease(int[] oids) {
        int end = oids.length;
        for (int i = 0; i < end; ++i) {
            try {
                ((Collectable)((Object)oidMngr.getServerReference(oids[i]))).renewLease();
                continue;
            }
            catch (NoSuchObjectException nsoe) {
                if (!KernelStatus.DEBUG || !debugDgcEnrollment.isDebugEnabled()) continue;
                RMILogger.logRenewLease(oids[i]);
            }
        }
    }

    public static final ReferenceQueue getReferenceQueue() {
        return refQueue;
    }

    public static final void addPhantomRef(PhantomRef ph) {
        map.put(ph, dummy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mark() {
        PhantomRef ref = (PhantomRef)refQueue.poll();
        while (ref != null) {
            map.remove(ref);
            int oid = ref.getOID();
            try {
                ((Collectable)((Object)oidMngr.getServerReference(oid))).decrementRefCount();
            }
            catch (NoSuchObjectException nsoe) {
                if (KernelStatus.DEBUG && debugDgcEnrollment.isDebugEnabled()) {
                    RMILogger.logUnenrollLostRef(oid);
                }
            }
            finally {
                ref.clear();
            }
            ref = (PhantomRef)refQueue.poll();
        }
    }
}

