/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.spi;

import java.io.IOException;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.EndPointFinder;
import weblogic.rmi.spi.HostID;
import weblogic.utils.collections.ArraySet;

public class RMIRuntime {
    private static HostID localHostID;
    private static final ArraySet endPointFinderTable;

    private static void setLocalHost(HostID local) {
        localHostID = local;
    }

    public static final RMIRuntime getRMIRuntime() {
        return RMIRuntimeSingleton.runtime;
    }

    public void setLocalHostID(HostID localHostID) {
        RMIRuntime.setLocalHost(localHostID);
    }

    public void addEndPointFinder(EndPointFinder endPointFinder) {
        endPointFinderTable.add(endPointFinder);
    }

    public static EndPoint findOrCreateEndPoint(HostID hostID) {
        return RMIRuntime.getEndPointFinder(hostID).findOrCreateEndPoint(hostID);
    }

    public static EndPoint findOrCreateEndPoint(String url) throws IOException {
        return RMIRuntime.getEndPointFinder(url).findOrCreateEndPoint(url);
    }

    public static EndPoint findEndPoint(String url) throws IOException {
        return RMIRuntime.getEndPointFinder(url).findEndPoint(url);
    }

    public static EndPoint findEndPoint(HostID hostID) {
        return RMIRuntime.getEndPointFinder(hostID).findEndPoint(hostID);
    }

    @Deprecated
    public static HostID getLocalHostID() {
        return localHostID;
    }

    private static EndPointFinder getEndPointFinder(String url) {
        for (EndPointFinder endPointFinder : endPointFinderTable) {
            if (!endPointFinder.claimServerURL(url)) continue;
            return endPointFinder;
        }
        throw new AssertionError((Object)("unable to find EndPointFinder for " + url));
    }

    private static EndPointFinder getEndPointFinder(HostID hostID) {
        for (EndPointFinder endPointFinder : endPointFinderTable) {
            if (!endPointFinder.claimHostID(hostID)) continue;
            return endPointFinder;
        }
        return new EndPointFinder(){

            @Override
            public boolean claimHostID(HostID hostID) {
                return true;
            }

            @Override
            public boolean claimServerURL(String url) {
                return false;
            }

            @Override
            public EndPoint findOrCreateEndPoint(HostID hostID) {
                return null;
            }

            @Override
            public EndPoint findEndPoint(HostID hostID) {
                return null;
            }

            @Override
            public EndPoint findOrCreateEndPoint(String url) {
                return null;
            }

            @Override
            public EndPoint findEndPoint(String url) throws IOException {
                return null;
            }
        };
    }

    public static boolean supportServerURL(String url) {
        for (EndPointFinder endPointFinder : endPointFinderTable) {
            if (!endPointFinder.claimServerURL(url)) continue;
            return true;
        }
        return false;
    }

    static {
        endPointFinderTable = new ArraySet(4);
    }

    private static final class RMIRuntimeSingleton {
        private static final RMIRuntime runtime = new RMIRuntime();

        private RMIRuntimeSingleton() {
        }
    }
}

