/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.utils;

import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.rmi.server.RMIClassLoaderSpi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import weblogic.kernel.KernelStatus;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.rmi.utils.ClassLoaderEnvironment;
import weblogic.rmi.utils.RMIURLClassFinder;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.Source;

public class WLRMIClassLoaderDelegate
extends RMIClassLoaderSpi {
    private static final Map cache = Collections.synchronizedMap(new WeakHashMap());
    private ClassLoaderEnvironment environmentLoader;

    public static final WLRMIClassLoaderDelegate getInstance() {
        return SingletonMaker.singleton;
    }

    private WLRMIClassLoaderDelegate() {
        try {
            Class<?> envClass = Class.forName("weblogic.rmi.internal.wls.WLSClassLoaderEnvironment");
            this.environmentLoader = (ClassLoaderEnvironment)envClass.newInstance();
        }
        catch (Throwable t) {
            this.environmentLoader = new ClassLoaderEnvironment();
        }
    }

    @Override
    public ClassLoader getClassLoader(String codebase) throws MalformedURLException {
        throw new AssertionError((Object)"Not yet implemented");
    }

    public String getClassAnnotation(Class clazz) {
        ClassLoader loader = clazz.getClassLoader();
        if (loader instanceof GenericClassLoader) {
            GenericClassLoader gcl = (GenericClassLoader)loader;
            return gcl.getAnnotation().getAnnotationString();
        }
        return null;
    }

    public Class loadProxyClass(String codebase, String[] interfaces, ClassLoader defaultLoader) throws ClassNotFoundException {
        Debug.assertion(defaultLoader instanceof GenericClassLoader, " defaultLoader should be an instanceof GenericClassLoader");
        GenericClassLoader gcl = (GenericClassLoader)defaultLoader;
        ArrayList<Class> list = new ArrayList<Class>();
        RMIURLClassFinder classFinder = WLRMIClassLoaderDelegate.getClassFinder(codebase);
        for (int i = 0; i < interfaces.length; ++i) {
            Class clazz = null;
            try {
                clazz = WLRMIClassLoaderDelegate.loadClass(interfaces[i], classFinder, gcl);
                list.add(clazz);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (list.size() == 0) {
            throw new ClassNotFoundException("Couldn't load any of the interfaces " + Arrays.asList(interfaces));
        }
        Class[] classes = list.toArray(new Class[list.size()]);
        return Proxy.getProxyClass(gcl, classes);
    }

    public Class loadClass(String codebase, String name, ClassLoader defaultLoader) throws ClassNotFoundException, MalformedURLException {
        Debug.assertion(defaultLoader instanceof GenericClassLoader, "defaultLoader should be instanceof GenericClassLoader");
        GenericClassLoader gcl = (GenericClassLoader)defaultLoader;
        RMIURLClassFinder classFinder = WLRMIClassLoaderDelegate.getClassFinder(codebase);
        return WLRMIClassLoaderDelegate.loadClass(name, classFinder, gcl);
    }

    public static Class loadClass(String codebase, String annotation, String name, GenericClassLoader gcl) throws ClassNotFoundException {
        try {
            return gcl.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (KernelStatus.isServer()) {
                return WLRMIClassLoaderDelegate.loadClassOnServer(codebase, annotation, name, gcl);
            }
            if (codebase == null) {
                throw new ClassNotFoundException("Failed to load class " + name);
            }
            RMIURLClassFinder finder = WLRMIClassLoaderDelegate.getClassFinder(codebase + annotation + "/");
            return WLRMIClassLoaderDelegate.loadClass(name, finder, gcl);
        }
    }

    private static Class loadClassOnServer(String codebase, String annotation, String name, GenericClassLoader gcl) throws ClassNotFoundException {
        if (annotation != null) {
            ClassLoader loader = WLRMIClassLoaderDelegate.getInstance().findClassLoader(annotation);
            if (loader == null) {
                throw new ClassNotFoundException("Failed to load class " + name);
            }
            if (loader instanceof GenericClassLoader) {
                GenericClassLoader appClassLoader = (GenericClassLoader)loader;
                Source source = appClassLoader.getClassFinder().getClassSource(name);
                if (source == null && RMIEnvironment.getEnvironment().isNetworkClassLoadingEnabled()) {
                    RMIURLClassFinder finder = WLRMIClassLoaderDelegate.getClassFinder(codebase + annotation + "/");
                    return WLRMIClassLoaderDelegate.loadClass(name, finder, gcl);
                }
                return new GenericClassLoader(appClassLoader.getClassFinder(), (ClassLoader)gcl).loadClass(name);
            }
            return loader.loadClass(name);
        }
        throw new ClassNotFoundException("Failed to load class " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class loadClass(String name, RMIURLClassFinder finder, GenericClassLoader gcl) throws ClassNotFoundException {
        try {
            return Class.forName(name, false, gcl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (finder == null || finder.getClassSource(name) == null) {
                throw new ClassNotFoundException("Failed to load class " + name);
            }
            GenericClassLoader genericClassLoader = gcl;
            synchronized (genericClassLoader) {
                try {
                    return Class.forName(name, false, gcl);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    gcl.addClassFinder(finder);
                    return gcl.defineClass(name, finder.getClassSource(name));
                }
            }
        }
    }

    private static RMIURLClassFinder getClassFinder(String codebase) {
        if (codebase == null) {
            return null;
        }
        if (!RMIEnvironment.getEnvironment().isNetworkClassLoadingEnabled()) {
            return null;
        }
        RMIURLClassFinder classFinder = (RMIURLClassFinder)cache.get(codebase);
        if (classFinder == null) {
            classFinder = new RMIURLClassFinder(codebase);
            cache.put(codebase, classFinder);
        }
        return classFinder;
    }

    public ClassLoader findClassLoader(String appName) {
        return this.environmentLoader.findLoader(appName);
    }

    public ClassLoader findInterAppClassLoader(String appName, ClassLoader parent) {
        return this.environmentLoader.findInterAppLoader(appName, parent);
    }

    static class SingletonMaker {
        private static final WLRMIClassLoaderDelegate singleton = new WLRMIClassLoaderDelegate();

        SingletonMaker() {
        }
    }
}

