/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Vector;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.security.acl.UserInfo;

@Deprecated
public class DefaultUserInfoImpl
implements UserInfo,
Serializable {
    private static final long serialVersionUID = -419061834872911373L;
    protected String realmName = null;
    protected String id = null;
    protected Vector certificates = new Vector(0);
    private byte[] obfuscatedPassword = null;
    private static final String CHAR_ENCODING = "UTF-8";
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger("DebugSecurityAtn");

    public DefaultUserInfoImpl() {
    }

    @Override
    public String getRealmName() {
        return this.realmName;
    }

    @Override
    public String getName() {
        return this.id;
    }

    public void setName(String newName) {
        this.id = newName;
    }

    @Override
    public String toString() {
        return "{" + this.getRealmName() + "," + this.getName() + "}";
    }

    public DefaultUserInfoImpl(String name, Object credential) {
        this(name, credential, "weblogic");
    }

    public DefaultUserInfoImpl(String name, Object credential, String realmName) {
        this.id = name;
        this.realmName = realmName;
        this.setCredential(credential);
        if (this.id == null && this.certificates != null && this.certificates.size() > 0) {
            this.id = ((X509Certificate)this.certificates.elementAt(0)).getSubjectDN().getName();
        }
    }

    protected void setCredential(Object c) {
        if (c instanceof String) {
            this.obfuscatedPassword = DefaultUserInfoImpl.obfuscate((String)c);
        } else if (c instanceof X509Certificate) {
            this.certificates.addElement(c);
        } else if (c instanceof char[]) {
            byte[] clearBytes = DefaultUserInfoImpl.getClearTextBytes((char[])c);
            this.obfuscatedPassword = DefaultUserInfoImpl.obfuscate(clearBytes);
            Arrays.fill(clearBytes, (byte)0);
        } else if (c instanceof Object[]) {
            Object[] cs = (Object[])c;
            for (int i = 0; i < cs.length; ++i) {
                this.setCredential(cs[i]);
            }
        }
    }

    public boolean hasPassword() {
        return this.obfuscatedPassword != null;
    }

    public String getPassword() {
        block3: {
            if (this.obfuscatedPassword != null) {
                try {
                    byte[] clearBytes = DefaultUserInfoImpl.unobfuscate(this.obfuscatedPassword);
                    String clear = new String(clearBytes, CHAR_ENCODING);
                    Arrays.fill(clearBytes, (byte)0);
                    return clear;
                }
                catch (UnsupportedEncodingException impossible) {
                    if (!DEBUG.isDebugEnabled()) break block3;
                    DebugLogger.println("The impossible happened: 1");
                }
            }
        }
        return null;
    }

    public char[] getPasswordAsCharArray() {
        char[] clearText = null;
        if (this.obfuscatedPassword != null) {
            byte[] clearBytes = DefaultUserInfoImpl.unobfuscate(this.obfuscatedPassword);
            clearText = DefaultUserInfoImpl.getClearTextChars(clearBytes);
            Arrays.fill(clearBytes, (byte)0);
        }
        return clearText;
    }

    public boolean hasCertificates() {
        return this.certificates.size() > 0;
    }

    public Vector getCertificates() {
        return (Vector)this.certificates.clone();
    }

    private static byte[] obfuscate(String clear) {
        try {
            byte[] clearBytes = clear.getBytes(CHAR_ENCODING);
            byte[] obfuscatedBytes = DefaultUserInfoImpl.obfuscate(clearBytes);
            Arrays.fill(clearBytes, (byte)0);
            return obfuscatedBytes;
        }
        catch (UnsupportedEncodingException impossible) {
            if (DEBUG.isDebugEnabled()) {
                DebugLogger.println("The impossible happened: 2");
            }
            return null;
        }
    }

    private static byte[] obfuscate(byte[] clearBytes) {
        return DefaultUserInfoImpl.flipBytes(clearBytes);
    }

    private static byte[] unobfuscate(byte[] obfuscatedBytes) {
        return DefaultUserInfoImpl.flipBytes(obfuscatedBytes);
    }

    private static byte[] flipBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        byte[] flipped = new byte[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            flipped[i] = bytes[i];
            int n = i++;
            flipped[n] = (byte)(flipped[n] ^ 0xFF);
        }
        return flipped;
    }

    private static byte[] getClearTextBytes(char[] clearText) {
        block5: {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(clearText.length * 2);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, CHAR_ENCODING);
                writer.write(clearText, 0, clearText.length);
                writer.flush();
                byte[] bytes = bos.toByteArray();
                bos.reset();
                for (int i = 0; i < bytes.length; ++i) {
                    bos.write(0);
                }
                return bytes;
            }
            catch (UnsupportedEncodingException ex) {
                if (DEBUG.isDebugEnabled()) {
                    DebugLogger.println("The impossible happened: 3");
                }
            }
            catch (IOException ex) {
                if (!DEBUG.isDebugEnabled()) break block5;
                DebugLogger.println("The impossible happened: 4");
            }
        }
        return null;
    }

    private static char[] getClearTextChars(byte[] clearBytes) {
        block5: {
            try {
                ByteArrayInputStream bos = new ByteArrayInputStream(clearBytes);
                InputStreamReader reader = new InputStreamReader((InputStream)bos, CHAR_ENCODING);
                char[] plainText = new char[clearBytes.length];
                int charsRead = reader.read(plainText, 0, plainText.length);
                bos.reset();
                if (charsRead < plainText.length) {
                    char[] temp = new char[charsRead];
                    System.arraycopy(plainText, 0, temp, 0, charsRead);
                    Arrays.fill(plainText, '0');
                    plainText = temp;
                }
                return plainText;
            }
            catch (UnsupportedEncodingException ex) {
                if (DEBUG.isDebugEnabled()) {
                    DebugLogger.println("The impossible happened: 5");
                }
            }
            catch (IOException ex) {
                if (!DEBUG.isDebugEnabled()) break block5;
                DebugLogger.println("The impossible happened: 6");
            }
        }
        return null;
    }

    @Override
    public int hashCode() {
        return (this.realmName == null ? 0 : this.realmName.hashCode()) ^ (this.id == null ? 0 : this.id.hashCode()) ^ (this.obfuscatedPassword == null ? 0 : Arrays.hashCode(this.obfuscatedPassword)) ^ (this.certificates == null ? 0 : this.certificates.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DefaultUserInfoImpl) {
            DefaultUserInfoImpl that = (DefaultUserInfoImpl)obj;
            return (this.id == null ? that.id == null : this.id.equals(that.id)) && this.equalsInAllButName(that);
        }
        return false;
    }

    public boolean equalsInAllButName(DefaultUserInfoImpl that) {
        String thatRealmName = that.getRealmName();
        byte[] thatPassword = that.obfuscatedPassword;
        return (this.realmName == null ? thatRealmName == null : this.realmName.equals(thatRealmName)) && (this.obfuscatedPassword == null ? thatPassword == null : Arrays.equals(this.obfuscatedPassword, thatPassword)) && this.equalsCertificatesOnly(that);
    }

    private boolean equalsCertificatesOnly(DefaultUserInfoImpl other) {
        Vector otherCertificates = other.getCertificates();
        int thisNum = this.certificates.size();
        int otherNum = otherCertificates.size();
        if (thisNum == 0 && otherNum == 0) {
            return true;
        }
        if (thisNum != otherNum) {
            return false;
        }
        Vector thisClone = (Vector)this.certificates.clone();
        Vector otherClone = (Vector)otherCertificates.clone();
        return thisClone.equals(otherClone);
    }
}

