/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import javax.security.auth.Subject;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.service.SecurityManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.utils.AssertionError;

public final class AuthenticatedSubject
extends AuthenticatedUser
implements InteropWriteReplaceable,
AbstractSubject {
    static final long serialVersionUID = -5562362296231458788L;
    public static final AuthenticatedSubject ANON = new AuthenticatedSubject(true);
    private final SealableSet principals;
    private transient SealableSet pubCredentials;
    private transient SealableSet privCredentials;
    private transient Subject subject;
    private transient boolean sealed = false;

    public AuthenticatedSubject() {
        this.principals = new SealableSet(true);
        this.pubCredentials = new SealableSet();
        this.privCredentials = new SealableSet();
    }

    public AuthenticatedSubject(boolean readOnly, Set principals) {
        this.principals = new SealableSet(principals, true);
        this.pubCredentials = new SealableSet();
        this.privCredentials = new SealableSet();
        if (readOnly) {
            this.sealInternal();
        }
    }

    public AuthenticatedSubject(AuthenticatedUser au) {
        super(au);
        this.principals = new SealableSet(true);
        this.pubCredentials = new SealableSet();
        this.privCredentials = new SealableSet();
    }

    private AuthenticatedSubject(boolean ignore) {
        this();
        this.sealInternal();
        this.subject = new Subject(true, this.principals, this.pubCredentials, this.privCredentials);
    }

    public AuthenticatedSubject(Subject subject) {
        this.principals = new SealableSet(subject.getPrincipals(), true);
        this.pubCredentials = new SealableSet(subject.getPublicCredentials());
        this.privCredentials = new SealableSet(subject.getPrivateCredentials());
        this.subject = subject;
    }

    public static AuthenticatedSubject getFromSubject(Subject subject) {
        final Subject s = subject;
        return (AuthenticatedSubject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Object obj : s.getPrivateCredentials()) {
                    if (!(obj instanceof AuthenticatedSubject)) continue;
                    return obj;
                }
                return new AuthenticatedSubject(s);
            }
        });
    }

    @Override
    public Set getPrincipals() {
        return this.principals;
    }

    @Override
    public Set getPrincipals(Class c) {
        return this.getClassSubset(this.principals, c);
    }

    @Override
    public Set getPublicCredentials() {
        return this.pubCredentials;
    }

    @Override
    public Set getPublicCredentials(Class c) {
        return this.getClassSubset(this.pubCredentials, c);
    }

    @Override
    public Set getPrivateCredentials(AbstractSubject kernelID) {
        SecurityManager.checkKernelIdentity((AuthenticatedSubject)kernelID);
        return this.privCredentials;
    }

    @Override
    public Set getPrivateCredentials(AbstractSubject kernelID, Class c) {
        SecurityManager.checkKernelIdentity((AuthenticatedSubject)kernelID);
        return this.getClassSubset(this.privCredentials, c);
    }

    private Set getClassSubset(Set principals, Class c) {
        if (c == null) {
            throw new NullPointerException(SecurityLogger.getNullClass());
        }
        HashSet ret = new HashSet();
        for (Object principal : principals) {
            if (!c.isAssignableFrom(principal.getClass())) continue;
            ret.add(principal);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Subject getSubject() {
        Subject tmp;
        if (this.subject != null) {
            return this.subject;
        }
        Subject subject = tmp = new Subject(false, this.principals, this.pubCredentials, this.privCredentials);
        synchronized (subject) {
            this.subject = tmp;
        }
        final AuthenticatedSubject as = this;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AuthenticatedSubject.this.subject.getPrivateCredentials().add(as);
                return null;
            }
        });
        return this.subject;
    }

    public void seal(AbstractSubject kernelID) {
        SecurityManager.checkKernelIdentity((AuthenticatedSubject)kernelID);
        this.sealInternal();
    }

    @Override
    public void setReadOnly(AbstractSubject kernelID) {
        this.seal(kernelID);
    }

    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public boolean isReadOnly() {
        return this.sealed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doAs(AbstractSubject kernelId, PrivilegedAction action) {
        if (action == null) {
            throw new SecurityException(SecurityLogger.getNullAction());
        }
        int sizeBeforePush = SubjectManager.getSubjectManager().getSize();
        SubjectManager.getSubjectManager().pushSubject(kernelId, this);
        Object actionResult = null;
        try {
            actionResult = action.run();
        }
        finally {
            int sizeBeforePop = SubjectManager.getSubjectManager().getSize();
            while (sizeBeforePop-- > sizeBeforePush) {
                SubjectManager.getSubjectManager().popSubject(kernelId);
            }
        }
        return actionResult;
    }

    @Override
    public Object doAs(AbstractSubject kernelId, PrivilegedExceptionAction action) throws PrivilegedActionException {
        if (action == null) {
            throw new SecurityException(SecurityLogger.getNullAction());
        }
        int sizeBeforePush = SubjectManager.getSubjectManager().getSize();
        SubjectManager.getSubjectManager().pushSubject(kernelId, this);
        Object actionResult = null;
        try {
            actionResult = action.run();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            int sizeBeforePop = SubjectManager.getSubjectManager().getSize();
            while (sizeBeforePop-- > sizeBeforePush) {
                SubjectManager.getSubjectManager().popSubject(kernelId);
            }
        }
        return actionResult;
    }

    private void sealInternal() {
        this.sealed = true;
        this.principals.seal();
        this.pubCredentials.seal();
        this.privCredentials.seal();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.pubCredentials = new SealableSet();
        this.privCredentials = new SealableSet();
    }

    @Override
    public int hashCode() {
        if (this.principals == null) {
            return 0;
        }
        return this.principals.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof AuthenticatedSubject)) {
            return false;
        }
        AuthenticatedSubject other = (AuthenticatedSubject)o;
        return this.principals.equals(other.principals);
    }

    @Override
    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        if (peerInfo.getMajor() < 7) {
            return this.convertToAuthenticatedUser(this);
        }
        return this;
    }

    private Object convertToAuthenticatedUser(AuthenticatedSubject as) {
        try {
            Class<?> clzSSM = Class.forName("weblogic.security.service.SecurityServiceManager");
            Method mtdConvert = clzSSM.getMethod("convertToAuthenticatedUser", AuthenticatedUser.class);
            return mtdConvert.invoke(null, as);
        }
        catch (Exception ex) {
            throw new AssertionError(SecurityLogger.getCouldNotConvertASToAU("" + as));
        }
    }

    @Override
    public String toString() {
        return "principals=" + this.principals;
    }

    private static final class SealableSet
    extends AbstractSet
    implements Set,
    Serializable {
        static final long serialVersionUID = -6020057914807495674L;
        final LinkedList elements;
        transient LinkedHashSet elementsToCompare = null;
        private boolean sealed = false;
        private boolean hashCodeValid = false;
        private int hashCode;
        private final boolean isPrincipalSet;

        SealableSet() {
            this(false);
        }

        SealableSet(boolean isPrincipalSet) {
            this.elements = new LinkedList();
            this.isPrincipalSet = isPrincipalSet;
        }

        SealableSet(Set s) {
            this(s, false);
        }

        SealableSet(Set s, boolean isPrincipalSet) {
            this.elements = new LinkedList(s);
            this.isPrincipalSet = isPrincipalSet;
        }

        @Override
        public boolean add(Object o) {
            if (this.sealed) {
                throw new SecurityException(SecurityLogger.getAttemptingToModifySealedSubject());
            }
            if (o == null) {
                throw new NullPointerException();
            }
            if (this.isPrincipalSet && !(o instanceof Principal)) {
                throw new SecurityException(SecurityLogger.getNotAPrincipal(o.getClass().getName()));
            }
            if (!this.elements.contains(o)) {
                boolean bOk = this.elements.add(o);
                if (this.elementsToCompare != null) {
                    this.elementsToCompare.add(o);
                }
                return bOk;
            }
            return false;
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                ListIterator i;
                {
                    this.i = elements.listIterator(0);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                public Object next() {
                    return this.i.next();
                }

                @Override
                public void remove() {
                    if (sealed) {
                        throw new SecurityException(SecurityLogger.getAttemptingToModifySealedSubject());
                    }
                    hashCodeValid = false;
                    this.i.remove();
                }
            };
        }

        @Override
        public void clear() {
            if (this.sealed) {
                throw new SecurityException(SecurityLogger.getAttemptingToModifySealedSubject());
            }
            this.hashCodeValid = false;
            this.elements.clear();
        }

        void seal() {
            this.sealed = true;
        }

        @Override
        public int hashCode() {
            if (!this.hashCodeValid) {
                this.hashCode = super.hashCode();
                this.hashCodeValid = true;
            }
            return this.hashCode;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            try {
                if (this.elementsToCompare == null) {
                    this.elementsToCompare = new LinkedHashSet(this.elements);
                }
                return this.elementsToCompare.containsAll(c);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }
    }
}

