/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.acl.internal;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.Protocol;
import weblogic.rjvm.LocalRJVM;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMManager;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.SecurityService;
import weblogic.security.acl.SecurityServiceGenerator;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.GenericLocatorUtilities;

public final class RemoteAuthenticate {
    private static AuthenticatedSubject kernelID;
    private static boolean enableDefaultUserProperty;

    public static AuthenticatedUser authenticate(final UserInfo ui, RJVM rjvm, Protocol protocol, String channel, boolean enableDefaultUser, int timeout, String partitionURL) throws RemoteException, SecurityException {
        AuthenticatedUser user;
        SecurityService stub;
        if (rjvm.isDead()) {
            rjvm = RJVMManager.getRJVMManager().findOrCreate(rjvm.getID());
        }
        SecurityServiceGenerator generator = GenericLocatorUtilities.getService(SecurityServiceGenerator.class);
        if (RemoteAuthenticate.isRMIBootstrapPossible(rjvm)) {
            stub = generator.createRMIBootService(rjvm, channel, timeout, null, partitionURL);
            try {
                AuthenticatedSubject anon = SubjectUtils.getAnonymousSubject();
                user = (AuthenticatedUser)SecurityManager.runAs(kernelID, anon, new PrivilegedExceptionAction(){

                    public Object run() throws RemoteException {
                        return stub.authenticate(ui);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                RemoteException re = (RemoteException)pae.getException();
                if (re.getCause() instanceof SecurityException) {
                    throw (SecurityException)re.getCause();
                }
                throw re;
            }
        } else {
            stub = generator.createBootService(rjvm, protocol, null, null, partitionURL);
            user = stub.authenticate(ui);
        }
        if (!KernelStatus.isServer()) {
            AuthenticatedSubject defaultUser;
            AuthenticatedSubject authenticatedSubject = defaultUser = user == null ? null : SecurityServiceManager.getASFromAU(user);
            if (enableDefaultUser || enableDefaultUserProperty) {
                SecurityManager.setDefaultUser((AuthenticatedSubject)defaultUser);
            }
        }
        rjvm.setUser(partitionURL, user);
        return user;
    }

    private static boolean isRMIBootstrapPossible(RJVM rjvm) {
        if (rjvm instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)((Object)rjvm)).getPeerInfo();
            if (LocalRJVM.getLocalRJVM().getPeerInfo().equals(peerInfo)) {
                return true;
            }
            if (peerInfo == null) {
                return false;
            }
            int major = peerInfo.getMajor();
            int minor = peerInfo.getMinor();
            int sp = peerInfo.getServicePack();
            return major > 8 || major == 6 && minor == 1 && sp >= 5 || major == 7 && minor == 0 && sp >= 3 || major == 8 && minor == 1 && sp >= 1;
        }
        return false;
    }

    static {
        String enableDefaultUser;
        kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        enableDefaultUserProperty = false;
        if (!KernelStatus.isServer() && !KernelStatus.isApplet() && (enableDefaultUser = System.getProperty("weblogic.jndi.enableDefaultUser")) != null) {
            enableDefaultUserProperty = true;
        }
    }
}

