/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.auth;

import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import weblogic.jndi.Environment;
import weblogic.jndi.api.ServerEnvironment;
import weblogic.jndi.internal.ThreadEnvironment;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolManager;
import weblogic.rjvm.ClientServerURL;
import weblogic.rjvm.RJVM;
import weblogic.rjvm.RJVMManager;
import weblogic.rjvm.t3.client.ProtocolHandlerT3;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.acl.internal.WlT3ClientSecurity;
import weblogic.security.auth.login.PasswordCredential;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.SubjectManager;
import weblogic.utils.AssertionError;

public final class Authenticate {
    public static void authenticate(ServerEnvironment env, Subject subject) throws LoginException, IOException, RemoteException {
        Authenticate.authenticate((Environment)env, subject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void authenticate(Environment env, Subject subject) throws LoginException, IOException, RemoteException {
        String url = env.getProviderUrl();
        ClientServerURL clntSrvrURL = null;
        RJVM hostVM = null;
        if (url == null || url.length() == 0 || url == "local://") {
            if (!KernelStatus.isServer()) return;
            hostVM = RJVMManager.getLocalRJVM();
            env.setProperty("java.naming.provider.url", null);
        } else {
            ThreadEnvironment.push(env);
            try {
                clntSrvrURL = new ClientServerURL(url);
                hostVM = clntSrvrURL.findOrCreateRJVM(env.getProviderChannel());
            }
            finally {
                ThreadEnvironment.pop();
            }
        }
        UserInfo user = env.getSecurityUser();
        AuthenticatedUser au = null;
        boolean isServer = hostVM.equals(RJVMManager.getLocalRJVM());
        if (user == null && env.isClientCertAvailable()) {
            user = new DefaultUserInfoImpl(null, null);
        }
        if (user == null) return;
        ThreadEnvironment.push(env);
        try {
            au = WlT3ClientSecurity.authenticate(user, hostVM, Authenticate.getProtocol(env), env.getProviderChannel(), url);
        }
        catch (SecurityException e) {
            String msg = e.toString();
            int idx = msg.indexOf("Start server side stack trace:");
            if (idx <= 0) throw new LoginException(msg);
            msg = msg.substring(0, idx - 1);
            throw new LoginException(msg);
        }
        finally {
            ThreadEnvironment.pop();
        }
        AuthenticatedSubject auSubject = SecurityServiceManager.getASFromAU(au);
        env.setSecuritySubject(auSubject);
        try {
            if (Boolean.getBoolean("weblogic.security.authenticatePushSubject")) {
                AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                SecurityServiceManager.pushSubject(kernelId, auSubject);
            }
        }
        catch (SecurityException kernelId) {
            // empty catch block
        }
        subject.getPrincipals().addAll(auSubject.getPrincipals());
        if (!(user instanceof DefaultUserInfoImpl)) return;
        DefaultUserInfoImpl defUser = (DefaultUserInfoImpl)user;
        if (defUser.getName() != null && defUser.getPassword() != null) {
            final PasswordCredential passwordCred = new PasswordCredential(defUser.getName(), defUser.getPassword());
            final Subject localSubject = subject;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    localSubject.getPrivateCredentials().add(passwordCred);
                    return null;
                }
            });
        }
        env.setSecurityUser(au);
        if (KernelStatus.isServer() || au == null) return;
        hostVM.setUser(clntSrvrURL.getCurrentPartitionURL(), au);
    }

    private static Protocol getProtocol(Environment env) {
        try {
            String url = env.getProviderUrl();
            Protocol protocol = null;
            protocol = url == "local://" ? ProtocolHandlerT3.PROTOCOL_T3 : ProtocolManager.getProtocolByName(new ClientServerURL(url).getProtocol());
            return protocol;
        }
        catch (MalformedURLException mue) {
            throw new AssertionError(mue);
        }
    }

    public static void logout(Subject subject) throws LoginException, IOException, RemoteException {
        Set<Object> s = subject.getPrincipals();
        s.clear();
        s = subject.getPrivateCredentials();
        s.clear();
        s = subject.getPublicCredentials();
        s.clear();
    }

    static {
        SubjectManager.ensureInitialized();
    }
}

