/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.auth.callback;

public class IdentityDomainNames {
    private final String name;
    private final String idd;

    public IdentityDomainNames(String name, String identityDomain) {
        IdentityDomainNames.validateNames(name, identityDomain);
        this.name = name == null || name.isEmpty() ? null : name;
        this.idd = identityDomain == null || identityDomain.isEmpty() ? null : identityDomain;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentityDomain() {
        return this.idd;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.idd == null ? 0 : this.idd.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        boolean isNameEqual;
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        IdentityDomainNames otherIdd = (IdentityDomainNames)other;
        boolean bl = this.name == null ? otherIdd.name == null : (isNameEqual = this.name.equals(otherIdd.name));
        boolean isIddEqual = this.idd == null ? otherIdd.idd == null : this.idd.equals(otherIdd.idd);
        return isNameEqual && isIddEqual;
    }

    public String toString() {
        return "" + this.name + " [" + this.idd + "]";
    }

    private static void validateNames(String name, String identityDomain) {
        if (name == null && identityDomain != null) {
            throw new IllegalArgumentException("identity domain must be null if name is null");
        }
    }
}

