/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.principal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import weblogic.security.principal.IdentityDomainPrincipal;
import weblogic.security.principal.WLSPrincipal;

public abstract class WLSAbstractPrincipal
implements WLSPrincipal,
IdentityDomainPrincipal {
    private byte[] signature = null;
    private byte[] salt = null;
    private String name = null;
    private volatile transient boolean isIddSet = false;
    private static boolean useSignature;
    private static final long serialVersionUID = -5765092415154848004L;
    private String dn = null;
    private String guid = null;
    private boolean equalsCaseInsensitive = false;
    private boolean equalsCompareDnAndGuid = false;
    protected boolean principalFactoryCreated = false;
    private String idd;

    public boolean isEqualsCaseInsensitive() {
        return this.equalsCaseInsensitive;
    }

    public boolean isEqualsCompareDnAndGuid() {
        return this.equalsCompareDnAndGuid;
    }

    public void setEqualsCaseInsensitive(boolean equalsCaseInsensitive) {
        this.equalsCaseInsensitive = equalsCaseInsensitive;
    }

    public void setEqualsCompareDnAndGuid(boolean equalsCompareDnAndGuid) {
        this.equalsCompareDnAndGuid = equalsCompareDnAndGuid;
    }

    protected WLSAbstractPrincipal() {
        this.salt = String.valueOf(System.currentTimeMillis()).getBytes();
    }

    protected WLSAbstractPrincipal(boolean createSalt) {
        if (createSalt) {
            this.salt = String.valueOf(System.currentTimeMillis()).getBytes();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object another) {
        if (another == null) {
            return false;
        }
        if (this == another) {
            return true;
        }
        if (!(another instanceof WLSAbstractPrincipal)) {
            return false;
        }
        WLSAbstractPrincipal anotherPrincipal = (WLSAbstractPrincipal)another;
        if (this.name == null || anotherPrincipal.name == null) {
            return this.name == anotherPrincipal.name;
        }
        if (this.equalsCompareDnAndGuid ? (this.guid != null && anotherPrincipal.guid != null ? !this.guid.equalsIgnoreCase(anotherPrincipal.guid) : (this.dn != null && anotherPrincipal.dn != null ? !this.dn.equalsIgnoreCase(anotherPrincipal.dn) : (this.equalsCaseInsensitive ? !this.name.equalsIgnoreCase(anotherPrincipal.name) : !this.name.equals(anotherPrincipal.name)))) : (this.equalsCaseInsensitive ? !this.name.equalsIgnoreCase(anotherPrincipal.name) : !this.name.equals(anotherPrincipal.name))) {
            return false;
        }
        if (this.idd == null || this.idd.isEmpty()) {
            if (anotherPrincipal.idd != null && !anotherPrincipal.idd.isEmpty()) {
                return false;
            }
        } else if (this.equalsCaseInsensitive) {
            if (!this.idd.equalsIgnoreCase(anotherPrincipal.idd)) {
                return false;
            }
            if (!this.idd.equals(anotherPrincipal.idd)) {
                return false;
            }
        }
        if (useSignature) {
            byte[] anotherSignature = anotherPrincipal.getSignature();
            if (this.signature == anotherSignature) {
                return true;
            }
            if (this.signature == null || anotherSignature == null) {
                return false;
            }
            if (this.signature.length != anotherSignature.length) {
                return false;
            }
            for (int i = 0; i < this.signature.length; ++i) {
                if (this.signature[i] == anotherSignature[i]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.idd != null && !this.idd.isEmpty()) {
            return this.name + " [" + this.idd + "]";
        }
        return this.name;
    }

    @Override
    public int hashCode() {
        if (this.equalsCaseInsensitive) {
            int h = this.name.toLowerCase().hashCode();
            if (this.idd != null && !this.idd.isEmpty()) {
                h = h * 31 + this.idd.toLowerCase().hashCode();
            }
            return h;
        }
        int h = this.name.hashCode();
        if (this.idd != null && !this.idd.isEmpty()) {
            h = h * 31 + this.idd.hashCode();
        }
        return h;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    @Override
    public byte[] getSalt() {
        return this.salt;
    }

    public void setSalt(byte[] salt) {
        this.salt = salt;
    }

    private String getDecoratedName() {
        String decoratedName = this.name;
        if (this.idd != null && !this.idd.isEmpty()) {
            decoratedName = decoratedName + "::" + this.idd;
        }
        return decoratedName;
    }

    @Override
    public byte[] getSignedData() {
        if (this.equalsCaseInsensitive) {
            return this.getDecoratedName().toLowerCase().getBytes();
        }
        return this.getDecoratedName().getBytes();
    }

    protected byte[] getSignedDataCaseSensitive() {
        return this.getDecoratedName().getBytes();
    }

    @Override
    public String getGuid() {
        return this.guid;
    }

    protected void setGuid(String guid) {
        this.guid = guid;
    }

    @Override
    public String getDn() {
        return this.dn;
    }

    protected void setDn(String dn) {
        this.dn = dn;
    }

    public boolean isPrincipalFactoryCreated() {
        return this.principalFactoryCreated;
    }

    @Override
    public String getIdentityDomain() {
        return this.idd;
    }

    public void setIdentityDomain(String identityDomain) {
        if (!this.isIddSet && this.idd == null && identityDomain != null) {
            this.isIddSet = true;
            this.idd = identityDomain;
        }
    }

    static {
        try {
            GetSignatureProperty getSignatureProperty = new GetSignatureProperty();
            useSignature = (Boolean)AccessController.doPrivileged(getSignatureProperty);
        }
        catch (SecurityException ex) {
            useSignature = true;
        }
    }

    private static class GetSignatureProperty
    implements PrivilegedAction {
        private GetSignatureProperty() {
        }

        public Object run() {
            String signatureProperty = System.getProperty("weblogic.security.principal.useSignatureInEquals", "true");
            return Boolean.valueOf(signatureProperty);
        }
    }
}

