/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.subject;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public final class SubjectProxy
implements AbstractSubject {
    public static SubjectProxy ANON = new SubjectProxy(new Subject());
    private final Subject subject;

    public SubjectProxy(Subject subject) {
        this.subject = subject;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public Set getPrincipals() {
        return this.subject.getPrincipals();
    }

    @Override
    public Set getPublicCredentials() {
        return this.subject.getPublicCredentials();
    }

    @Override
    public Set getPrivateCredentials(AbstractSubject kernelId) {
        return this.subject.getPrivateCredentials();
    }

    @Override
    public Set getPrincipals(Class c) {
        return this.subject.getPrincipals(c);
    }

    @Override
    public Set getPublicCredentials(Class c) {
        return this.subject.getPublicCredentials(c);
    }

    @Override
    public Set getPrivateCredentials(AbstractSubject kernelId, Class c) {
        return this.subject.getPrivateCredentials(c);
    }

    @Override
    public boolean isReadOnly() {
        return this.subject.isReadOnly();
    }

    @Override
    public void setReadOnly(AbstractSubject kernelId) {
        this.subject.setReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doAs(AbstractSubject kernelId, PrivilegedAction action) {
        if (action == null) {
            throw new SecurityException("Null PrivilegedAction");
        }
        SubjectManager.getSubjectManager().pushSubject(kernelId, this);
        Object actionResult = null;
        try {
            actionResult = action.run();
        }
        finally {
            SubjectManager.getSubjectManager().popSubject(kernelId);
        }
        return actionResult;
    }

    @Override
    public Object doAs(AbstractSubject kernelId, PrivilegedExceptionAction action) throws PrivilegedActionException {
        if (action == null) {
            throw new SecurityException("Null PrivilegedActionException");
        }
        SubjectManager.getSubjectManager().pushSubject(kernelId, this);
        Object actionResult = null;
        try {
            actionResult = action.run();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            SubjectManager.getSubjectManager().popSubject(kernelId);
        }
        return actionResult;
    }

    public String toString() {
        return "SubjectProxy[" + System.identityHashCode(this.subject) + "]";
    }
}

