/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import weblogic.kernel.Kernel;
import weblogic.security.SSL.WLSSSLNioSocket;
import weblogic.socket.MuxableSocket;
import weblogic.socket.NIOConnection;
import weblogic.socket.NIOOutputSink;
import weblogic.socket.NIOSocketInfo;
import weblogic.socket.NIOSocketMuxer;
import weblogic.socket.NetworkInterfaceInfo;
import weblogic.socket.SocketLogger;
import weblogic.socket.WriteHandler;

class NIOOutputStream
extends OutputStream
implements GatheringByteChannel,
NIOConnection,
NIOOutputSink {
    private static ConcurrentHashMap<Integer, DirectBufferPool> pools = new ConcurrentHashMap();
    private final GatheringByteChannel wc;
    private final NIOSocketMuxer nioSocketMuxer;
    private ByteBuffer lastByteBuffer;
    private byte[] lastByteArray;
    private NetworkInterfaceInfo nwInfo;
    private final SocketChannel sockChannel;
    private boolean isBlocking = true;
    private final BlockingWriter blockingWriter;
    private NonBlockingWriter nonBlockingWriter;

    NIOOutputStream(NIOSocketMuxer nioSocketMuxer, SocketChannel sc, NetworkInterfaceInfo info) {
        this.nioSocketMuxer = nioSocketMuxer;
        this.sockChannel = sc;
        this.nwInfo = info;
        Socket sock = sc.socket();
        if (sock instanceof WLSSSLNioSocket) {
            WritableByteChannel channel = ((WLSSSLNioSocket)((Object)sock)).getWritableByteChannel();
            this.wc = channel instanceof GatheringByteChannel ? (GatheringByteChannel)channel : this.getGatheringByteChannel(channel);
            SocketLogger.logDebug("NIOOutputStream constructed with writableByteChannel: " + this.wc);
        } else {
            this.wc = sc;
        }
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
            SocketLogger.logDebug("NIOOutputStream created");
        }
        this.blockingWriter = new BlockingWriter(this);
    }

    boolean onWritable() throws IOException {
        assert (!this.isBlocking);
        return this.nonBlockingWriter.onWritable();
    }

    @Override
    public boolean canWrite() {
        return this.getWriter().canWrite();
    }

    @Override
    public void notifyWritePossible(WriteHandler writeHandler) {
        this.getWriter().notifyWritePossible(writeHandler);
    }

    @Override
    public synchronized boolean isBlocking() {
        return this.isBlocking;
    }

    @Override
    public synchronized void configureBlocking() throws InterruptedException {
        try {
            this.configureBlocking(-1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void configureBlocking(long timeout, TimeUnit timeUnit) throws TimeoutException, InterruptedException {
        if (this.isBlocking) {
            return;
        }
        this.nonBlockingWriter.awaitCompletion(timeout, timeUnit);
        this.isBlocking = true;
    }

    @Override
    public synchronized void configureNonBlocking(MuxableSocket ms) {
        if (!this.isBlocking) {
            return;
        }
        if (this.nonBlockingWriter == null) {
            this.nonBlockingWriter = new NonBlockingWriter(this);
        }
        this.nonBlockingWriter.muxableSocket = ms;
        this.nonBlockingWriter.socketInfo = (NIOSocketInfo)ms.getSocketInfo();
        this.isBlocking = false;
    }

    @Override
    public void close() throws IOException {
        if (this.wc.isOpen()) {
            this.wc.close();
        }
        this.blockingWriter.close();
        if (this.nonBlockingWriter != null) {
            this.nonBlockingWriter.close();
        }
        this.lastByteBuffer = null;
        this.lastByteArray = null;
    }

    private GatheringByteChannel getGatheringByteChannel(final WritableByteChannel channel) {
        return new GatheringByteChannel(){

            @Override
            public boolean isOpen() {
                return channel.isOpen();
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return channel.write(src);
            }

            @Override
            public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                long sz = 0L;
                int end = offset + length;
                if (end > srcs.length) {
                    throw new IndexOutOfBoundsException();
                }
                int i = offset;
                while (i < end) {
                    sz += (long)channel.write(srcs[i]);
                    if (srcs[i].hasRemaining()) continue;
                    ++i;
                }
                return sz;
            }

            @Override
            public long write(ByteBuffer[] srcs) throws IOException {
                return this.write(srcs, 0, srcs.length);
            }
        };
    }

    private ByteBuffer getByteBuffer(byte[] b, int off, int len) {
        if (b != this.lastByteArray) {
            this.lastByteArray = b;
            this.lastByteBuffer = ByteBuffer.wrap(b);
        }
        return (ByteBuffer)this.lastByteBuffer.position(off).limit(off + len);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ByteBuffer buf = this.getByteBuffer(b, off, len);
        this.getWriter().write(buf);
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
            SocketLogger.logDebug("NIOOutputStream.write: expected to write " + len + " bytes");
        }
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.getWriter().write(srcs, offset, length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int len = src.remaining();
        this.getWriter().write(src);
        return len;
    }

    private Writer getWriter() {
        return this.isBlocking ? this.blockingWriter : this.nonBlockingWriter;
    }

    private static void convertToSocketException(Exception e) throws IOException {
        SocketException se = new SocketException("Socket closed");
        se.initCause(e);
        throw se;
    }

    private static void notifyWriteHandler(WriteHandler writeHandler) {
        try {
            writeHandler.onWritable();
        }
        catch (Exception e) {
            writeHandler.onError(e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.wc.isOpen();
    }

    @Override
    public InetAddress getLocalInetAddress() {
        return this.nwInfo.getLocalInetAddress();
    }

    @Override
    public int getMTU() {
        return this.nwInfo.getMTU();
    }

    private int getDirectBufferSize() {
        return this.nwInfo.getDirectBufferSize();
    }

    @Override
    public int getOptimalNumberOfBuffers() {
        return this.nwInfo.getOptimalNumberOfBuffers();
    }

    @Override
    public boolean supportsGatheredWrites() {
        return this.nwInfo.supportsGatheredWrites();
    }

    @Override
    public GatheringByteChannel getGatheringByteChannel() {
        return this;
    }

    @Override
    public boolean supportsScatteredReads() {
        return false;
    }

    @Override
    public ScatteringByteChannel getScatteringByteChannel() {
        throw new UnsupportedOperationException();
    }

    private static class DirectBufferPool {
        private volatile int r = 0;
        private volatile int w = 0;
        private static final AtomicIntegerFieldUpdater<DirectBufferPool> rPos = AtomicIntegerFieldUpdater.newUpdater(DirectBufferPool.class, "r");
        private static final int MAX_POOL_SIZE = Integer.getInteger("MAX_DIRECT_POOL_SIZE", 10240);
        private ByteBuffer[] bufferArray = new ByteBuffer[16];

        private DirectBufferPool() {
        }

        private static int pow2(int v) {
            assert (v <= MAX_POOL_SIZE);
            return Integer.highestOneBit(v - 1) << 1;
        }

        public ByteBuffer borrow() {
            ByteBuffer bb = null;
            int rp = this.r;
            while (rp != this.w) {
                ByteBuffer b = this.bufferArray[this.indexOf(rp)];
                if (rPos.compareAndSet(this, rp, rp + 1)) {
                    bb = b;
                    break;
                }
                rp = this.r;
            }
            return bb;
        }

        private int indexOf(int rp) {
            return rp & this.bufferArray.length - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void borrow(ByteBuffer[] dest, int offset, int length) {
            if (length == 1) {
                dest[offset] = this.borrow();
                return;
            }
            DirectBufferPool directBufferPool = this;
            synchronized (directBufferPool) {
                int rp;
                int max;
                while ((max = Math.min(length, this.w - (rp = this.r))) > 0 && !rPos.compareAndSet(this, rp, rp + max)) {
                }
                if (max == 0) {
                    return;
                }
                int c = (rp = this.indexOf(rp)) + max >= this.bufferArray.length ? this.bufferArray.length - rp : max;
                System.arraycopy(this.bufferArray, rp, dest, offset, c);
                offset += c;
                if ((max -= c) == 0) {
                    return;
                }
                System.arraycopy(this.bufferArray, 0, dest, offset, max);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(ByteBuffer[] src, int offset, int length) {
            DirectBufferPool directBufferPool = this;
            synchronized (directBufferPool) {
                int wp = this.w;
                int max = this.r + this.bufferArray.length - wp;
                if (length > max && this.bufferArray.length < MAX_POOL_SIZE) {
                    int rp = this.r;
                    while (rp != wp && !rPos.compareAndSet(this, rp, wp)) {
                        rp = this.r;
                    }
                    ByteBuffer[] dd = new ByteBuffer[DirectBufferPool.pow2(this.bufferArray.length + length)];
                    System.arraycopy(this.bufferArray, 0, dd, 0, this.bufferArray.length);
                    this.bufferArray = dd;
                    max = length;
                    this.r = rp;
                }
                for (int i = offset; i < length && max > 0; ++i) {
                    if (src[i] == null) continue;
                    src[i].clear();
                    this.bufferArray[this.indexOf((int)wp)] = src[i];
                    ++wp;
                    --max;
                }
                this.w = wp;
            }
        }
    }

    private static class MultiBuffersWrite
    implements WriteBuffer {
        private final ByteBuffer[] buffers;
        private int offset;
        private int length;

        public MultiBuffersWrite(ByteBuffer[] buffers, int offset, int length) {
            this.buffers = buffers;
            this.offset = offset;
            this.length = length;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        @Override
        public boolean hasRemaining() {
            return this.length > 0;
        }

        @Override
        public long writeTo(GatheringByteChannel wc) throws IOException {
            long written = wc.write(this.buffers, this.offset, this.length);
            if (written > 0L) {
                while (this.length > 0 && !this.buffers[this.offset].hasRemaining()) {
                    ++this.offset;
                    --this.length;
                }
            }
            return written;
        }
    }

    private static class SingleBufferWrite
    implements WriteBuffer {
        private final ByteBuffer buffer;

        public SingleBufferWrite(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public boolean hasRemaining() {
            return this.buffer.hasRemaining();
        }

        @Override
        public long writeTo(GatheringByteChannel wc) throws IOException {
            return wc.write(this.buffer);
        }
    }

    private static interface Writer {
        public void write(ByteBuffer var1) throws IOException;

        public long write(ByteBuffer[] var1, int var2, int var3) throws IOException;

        public boolean canWrite();

        public void notifyWritePossible(WriteHandler var1);

        public void close();
    }

    private static class NonBlockingWriter
    implements Writer {
        private volatile int queueSize;
        private static final AtomicIntegerFieldUpdater<NonBlockingWriter> queueSizeUpdater = AtomicIntegerFieldUpdater.newUpdater(NonBlockingWriter.class, "queueSize");
        private final BlockingQueue<WriteBuffer> queue = new LinkedBlockingQueue<WriteBuffer>();
        private final AtomicReference<WriteHandler> writeHandlerRef = new AtomicReference();
        private final NIOSocketMuxer nioSocketMuxer;
        private final GatheringByteChannel wc;
        private MuxableSocket muxableSocket;
        private NIOSocketInfo socketInfo;
        private volatile boolean isClosed;

        private NonBlockingWriter(NIOOutputStream nioOutputStream) {
            this.nioSocketMuxer = nioOutputStream.nioSocketMuxer;
            this.wc = nioOutputStream.wc;
        }

        @Override
        public void write(ByteBuffer buffer) throws IOException {
            if (this.isClosed) {
                throw new IOException("The stream is closed");
            }
            if (!buffer.hasRemaining()) {
                return;
            }
            try {
                boolean isFirstQueueItem;
                boolean bl = isFirstQueueItem = queueSizeUpdater.getAndIncrement(this) == 0;
                if (isFirstQueueItem) {
                    this.writeNonBlocking(buffer);
                    if (!buffer.hasRemaining()) {
                        int remainingItems = queueSizeUpdater.decrementAndGet(this);
                        if (remainingItems > 0) {
                            this.nioSocketMuxer.enableSelectionKeyInterest(this.muxableSocket, this.socketInfo, 4);
                        }
                        return;
                    }
                }
                if (!this.queue.add(this.cloneAndWrapBuffer(buffer))) {
                    assert (!isFirstQueueItem);
                    queueSizeUpdater.decrementAndGet(this);
                    throw new IOException("The Write queue is overflowed. Please use properly OutputSink canWrite/notifyWritePossible methods");
                }
                if (isFirstQueueItem) {
                    this.nioSocketMuxer.enableSelectionKeyInterest(this.muxableSocket, this.socketInfo, 4);
                }
            }
            catch (IOException e) {
                WriteHandler writeHandler = this.writeHandlerRef.getAndSet(null);
                if (writeHandler != null) {
                    writeHandler.onError(e);
                }
                throw e;
            }
        }

        @Override
        public long write(ByteBuffer[] buffers, int offset, int length) throws IOException {
            if (this.isClosed) {
                throw new IOException("The stream is closed");
            }
            long buffersSize = 0L;
            for (int i = 0; i < length; ++i) {
                buffersSize += (long)buffers[i + offset].remaining();
            }
            if (buffersSize == 0L) {
                return 0L;
            }
            try {
                boolean isFirstQueueItem;
                long written = 0L;
                boolean bl = isFirstQueueItem = queueSizeUpdater.getAndIncrement(this) == 0;
                if (isFirstQueueItem && buffersSize == (written = this.writeNonBlocking(buffers, offset, length, buffersSize))) {
                    int remainingItems = queueSizeUpdater.decrementAndGet(this);
                    if (remainingItems > 0) {
                        this.nioSocketMuxer.enableSelectionKeyInterest(this.muxableSocket, this.socketInfo, 4);
                    }
                    return buffersSize;
                }
                if (!this.queue.add(this.cloneAndWrapBuffer(buffers, offset, length, buffersSize - written))) {
                    assert (!isFirstQueueItem);
                    queueSizeUpdater.decrementAndGet(this);
                    throw new IOException("The Write queue is overflowed. Please use properly OutputSink canWrite/notifyWritePossible methods");
                }
                if (isFirstQueueItem) {
                    this.nioSocketMuxer.enableSelectionKeyInterest(this.muxableSocket, this.socketInfo, 4);
                }
                return buffersSize;
            }
            catch (IOException e) {
                WriteHandler writeHandler = this.writeHandlerRef.getAndSet(null);
                if (writeHandler != null) {
                    writeHandler.onError(e);
                }
                throw e;
            }
        }

        @Override
        public boolean canWrite() {
            return this.isClosed || this.queueSize == 0;
        }

        @Override
        public void notifyWritePossible(WriteHandler writeHandler) {
            if (this.canWrite()) {
                NIOOutputStream.notifyWriteHandler(writeHandler);
                return;
            }
            if (!this.writeHandlerRef.compareAndSet(null, writeHandler)) {
                throw new IllegalStateException("WriteHandler is already set");
            }
            if (this.canWrite() && this.writeHandlerRef.compareAndSet(writeHandler, null)) {
                NIOOutputStream.notifyWriteHandler(writeHandler);
            }
        }

        public void awaitCompletion(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
            if (this.canWrite()) {
                return;
            }
            final CountDownLatch latch = new CountDownLatch(1);
            this.notifyWritePossible(new WriteHandler(){

                @Override
                public void onWritable() throws Exception {
                    latch.countDown();
                }

                @Override
                public void onError(Throwable t) {
                    latch.countDown();
                }
            });
            if (timeout >= 0L) {
                if (!latch.await(timeout, timeUnit)) {
                    throw new TimeoutException();
                }
            } else {
                latch.await();
            }
        }

        @Override
        public void close() {
            this.isClosed = true;
            WriteHandler writeHandler = this.writeHandlerRef.getAndSet(null);
            if (writeHandler != null) {
                writeHandler.onError(new IOException("The stream is closed"));
            }
        }

        boolean onWritable() throws IOException {
            try {
                boolean isReregister = false;
                int size = this.queueSize;
                for (int i = 0; i < size; ++i) {
                    WriteBuffer buffer = (WriteBuffer)this.queue.peek();
                    if (buffer == null) {
                        isReregister = true;
                        break;
                    }
                    buffer.writeTo(this.wc);
                    if (buffer.hasRemaining()) {
                        isReregister = true;
                        break;
                    }
                    this.queue.remove();
                    queueSizeUpdater.decrementAndGet(this);
                }
                if (isReregister || this.queueSize > 0) {
                    this.nioSocketMuxer.enableSelectionKeyInterest(this.muxableSocket, this.socketInfo, 4);
                    return false;
                }
                WriteHandler writeHandler = this.writeHandlerRef.getAndSet(null);
                if (writeHandler != null) {
                    NIOOutputStream.notifyWriteHandler(writeHandler);
                }
                return true;
            }
            catch (IOException e) {
                WriteHandler writeHandler = this.writeHandlerRef.getAndSet(null);
                if (writeHandler != null) {
                    writeHandler.onError(e);
                }
                throw e;
            }
        }

        private int writeNonBlocking(ByteBuffer byteBuffer) throws IOException {
            int written = 0;
            try {
                int writtenNow;
                while (byteBuffer.hasRemaining() && (writtenNow = this.wc.write(byteBuffer)) != 0) {
                    written += writtenNow;
                }
            }
            catch (ClosedChannelException cce) {
                NIOOutputStream.convertToSocketException(cce);
            }
            return written;
        }

        private long writeNonBlocking(ByteBuffer[] byteBuffers, int offset, int length, long buffersSize) throws IOException {
            long written;
            try {
                long writtenNow;
                for (written = 0L; written < buffersSize && (writtenNow = this.wc.write(byteBuffers, offset, length)) != 0L; written += writtenNow) {
                }
            }
            catch (ClosedChannelException cce) {
                NIOOutputStream.convertToSocketException(cce);
            }
            return written;
        }

        private WriteBuffer cloneAndWrapBuffer(ByteBuffer byteBuffer) {
            ByteBuffer copy = ByteBuffer.allocate(byteBuffer.remaining());
            copy.put(byteBuffer);
            copy.flip();
            return new SingleBufferWrite(copy);
        }

        private WriteBuffer cloneAndWrapBuffer(ByteBuffer[] buffers, int offset, int length, long buffersSize) {
            if (buffersSize <= Integer.MAX_VALUE) {
                ByteBuffer singleBuffer = ByteBuffer.allocate((int)buffersSize);
                for (int i = 0; i < length; ++i) {
                    singleBuffer.put(buffers[i + offset]);
                }
                assert (!singleBuffer.hasRemaining());
                singleBuffer.flip();
                return new SingleBufferWrite(singleBuffer);
            }
            ByteBuffer[] copy = new ByteBuffer[length];
            for (int i = 0; i < length; ++i) {
                ByteBuffer srcBuf = buffers[i + offset];
                ByteBuffer dstBuf = ByteBuffer.allocate(srcBuf.remaining());
                dstBuf.put(srcBuf);
                assert (!dstBuf.hasRemaining());
                dstBuf.flip();
                copy[i] = dstBuf;
            }
            return new MultiBuffersWrite(copy, 0, length);
        }
    }

    private static class BlockingWriter
    implements Writer {
        private final DirectBufferPool pool;
        private final NIOOutputStream nioOutputStream;
        private final NIOSocketMuxer nioSocketMuxer;
        private final GatheringByteChannel wc;
        private final SocketChannel sockChannel;

        public BlockingWriter(NIOOutputStream nioOutputStream) {
            this.nioOutputStream = nioOutputStream;
            this.nioSocketMuxer = nioOutputStream.nioSocketMuxer;
            this.wc = nioOutputStream.wc;
            this.sockChannel = nioOutputStream.sockChannel;
            this.pool = this.initPool();
        }

        @Override
        public void write(ByteBuffer buffer) throws IOException {
            try {
                while (buffer.hasRemaining() && this.wc.write(buffer) != 0) {
                }
            }
            catch (ClosedChannelException cce) {
                NIOOutputStream.convertToSocketException(cce);
            }
            this.flush(new SingleBufferWrite(buffer));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            long sz = 0L;
            int end = offset + length;
            for (int k = offset; k < end; ++k) {
                sz += (long)srcs[k].remaining();
            }
            int directBufferSize = this.nioOutputStream.getDirectBufferSize();
            ByteBuffer[] directBuffers = new ByteBuffer[(int)((sz + (long)directBufferSize - 1L) / (long)directBufferSize)];
            this.pool.borrow(directBuffers, 0, directBuffers.length);
            int currPos = 0;
            int i = offset;
            while (i < end) {
                int r;
                if (!srcs[i].hasRemaining()) {
                    ++i;
                    continue;
                }
                if (directBuffers[currPos] == null) {
                    directBuffers[currPos] = this.pool.borrow();
                    if (directBuffers[currPos] == null) {
                        directBuffers[currPos] = ByteBuffer.allocateDirect(directBufferSize);
                    }
                }
                if ((r = directBuffers[currPos].remaining()) <= srcs[i].remaining()) {
                    int oldlim = srcs[i].limit();
                    srcs[i].limit(srcs[i].position() + r);
                    directBuffers[currPos].put(srcs[i]);
                    directBuffers[currPos++].flip();
                    srcs[i].limit(oldlim);
                    continue;
                }
                directBuffers[currPos].put(srcs[i]);
                ++i;
            }
            if (currPos < directBuffers.length && directBuffers[currPos].position() > 0) {
                directBuffers[currPos++].flip();
            }
            try {
                this.writeAsWriteBuffer(directBuffers, 0, currPos);
            }
            finally {
                this.pool.release(directBuffers, 0, directBuffers.length);
            }
            return sz;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean canWrite() {
            return true;
        }

        @Override
        public void notifyWritePossible(WriteHandler writeHandler) {
            NIOOutputStream.notifyWriteHandler(writeHandler);
        }

        private void writeAsWriteBuffer(ByteBuffer[] buffers, int offset, int length) throws IOException {
            MultiBuffersWrite multiBuffersWrite = new MultiBuffersWrite(buffers, offset, length);
            try {
                while (multiBuffersWrite.hasRemaining() && multiBuffersWrite.writeTo(this.wc) != 0L) {
                }
            }
            catch (ClosedChannelException cce) {
                NIOOutputStream.convertToSocketException(cce);
            }
            this.flush(multiBuffersWrite);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flush(WriteBuffer buffer) throws IOException {
            if (buffer.hasRemaining()) {
                Selector writeSelector = this.nioSocketMuxer.findOrCreateSelector();
                assert (this.sockChannel.keyFor(writeSelector) == null);
                try {
                    SelectionKey key = this.sockChannel.register(writeSelector, 4);
                    long n = 500L;
                    while (buffer.hasRemaining()) {
                        if (writeSelector.select(n) > 0) {
                            writeSelector.selectedKeys().clear();
                            buffer.writeTo(this.wc);
                        } else if (writeSelector.keys().size() == 0) {
                            if (key.isValid()) {
                                key.interestOps(4);
                                n = 0L;
                            } else {
                                key = this.sockChannel.register(writeSelector, 4);
                            }
                        }
                        if (!Thread.interrupted() || !Kernel.DEBUG || !Kernel.getDebug().getDebugMuxerDetail()) continue;
                        SocketLogger.logDebug("NIOOutputStream [" + this + "] has been interrupted.");
                    }
                }
                catch (ClosedChannelException cce) {
                    NIOOutputStream.convertToSocketException(cce);
                }
                finally {
                    this.nioSocketMuxer.release(writeSelector);
                }
            }
        }

        private DirectBufferPool initPool() {
            int directBufferSize = this.nioOutputStream.getDirectBufferSize();
            DirectBufferPool temp = (DirectBufferPool)pools.get(directBufferSize);
            if (temp == null) {
                DirectBufferPool t = new DirectBufferPool();
                temp = pools.putIfAbsent(directBufferSize, t);
                if (temp == null) {
                    temp = t;
                }
            }
            return temp;
        }
    }

    private static interface WriteBuffer {
        public boolean hasRemaining();

        public long writeTo(GatheringByteChannel var1) throws IOException;
    }
}

