/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.Kernel;
import weblogic.socket.AsyncOutputStream;
import weblogic.socket.MuxableSocket;
import weblogic.socket.NIOConnection;
import weblogic.socket.NIOInputStream;
import weblogic.socket.NIOOutputStream;
import weblogic.socket.NIOSocketInfo;
import weblogic.socket.NetworkInterfaceInfo;
import weblogic.socket.ServerSocketMuxer;
import weblogic.socket.SocketLogger;
import weblogic.socket.WeblogicServerSocket;
import weblogic.socket.WeblogicSocket;
import weblogic.socket.WeblogicSocketImpl;
import weblogic.socket.internal.SocketEnvironment;
import weblogic.socket.utils.SDPSocketUtils;
import weblogic.utils.collections.ConcurrentPool;
import weblogic.utils.io.Chunk;

class NIOSocketMuxer
extends ServerSocketMuxer {
    private static final int MULTIPLIER = 1540483477;
    private static final int OP_READ_IDX = NIOSocketMuxer.op2Idx(1);
    private static final int OP_WRITE_IDX = NIOSocketMuxer.op2Idx(4);
    private final Selector[] selectors;
    private final ArrayList<NIOSocketInfo>[][] registerLists;
    private final ArrayList<NIOSocketInfo>[][] interestLists;
    private final AtomicInteger[] willNotice;
    private int nextId;
    public static final DebugLogger debugPPP;
    protected static final int MUXERS;
    protected final int SELECTORS;
    private final ConcurrentPool<Selector> selectorPool = new ConcurrentPool(128);

    public NIOSocketMuxer() throws IOException {
        this(MUXERS);
        this.startSocketReaderThreads("weblogic.socket.Muxer");
    }

    protected NIOSocketMuxer(int nSelectors) throws IOException {
        this.SELECTORS = nSelectors;
        this.selectors = new Selector[this.SELECTORS];
        this.registerLists = new ArrayList[this.SELECTORS][2];
        this.interestLists = new ArrayList[this.SELECTORS][2];
        this.willNotice = new AtomicInteger[this.SELECTORS];
        for (int i = 0; i < this.SELECTORS; ++i) {
            this.selectors[i] = Selector.open();
            this.willNotice[i] = new AtomicInteger(1);
            for (int j = 0; j < 2; ++j) {
                this.registerLists[i][j] = new ArrayList();
                this.interestLists[i][j] = new ArrayList();
            }
        }
    }

    private int selectorIndex(SocketChannel sc) {
        int start;
        if (this.SELECTORS <= 1 || sc == null) {
            return 0;
        }
        int result = start = sc.hashCode();
        result *= 1540483477;
        result ^= result >> 24;
        result *= 1540483477;
        result ^= result >> 13;
        result *= 1540483477;
        result ^= result >> 15;
        int index = result % this.SELECTORS;
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
            SocketLogger.logDebug("NIOSocketMuxer | hash start = " + start + " | hash result = " + result + " | index = " + index);
        }
        return index;
    }

    private int selectorIndex(NIOSocketInfo nInfo) {
        return this.SELECTORS > 1 ? nInfo.getSelectorIndex() : 0;
    }

    @Override
    public boolean isAsyncMuxer() {
        return true;
    }

    @Override
    public void register(MuxableSocket ms) throws IOException {
        SocketChannel sc = ms.getSocket().getChannel();
        if (sc == null) {
            throw new IllegalArgumentException(SocketChannel.class + ": " + sc);
        }
        sc.configureBlocking(false);
        int selectorIndex = this.selectorIndex(sc);
        ms.setSocketInfo(new NIOSocketInfo(ms, selectorIndex));
        super.register(ms);
    }

    @Override
    public void read(MuxableSocket ms) {
        this.internalRead(ms, (NIOSocketInfo)ms.getSocketInfo());
    }

    @Override
    public void register(Collection<MuxableSocket> muxableSockets) {
        Iterator<MuxableSocket> mSockets = muxableSockets.iterator();
        while (mSockets.hasNext()) {
            MuxableSocket ms = mSockets.next();
            SocketChannel sc = ms.getSocket().getChannel();
            if (sc == null) {
                mSockets.remove();
                this.cancelIo(ms);
                throw new IllegalArgumentException(SocketChannel.class + ": " + sc);
            }
            try {
                sc.configureBlocking(false);
            }
            catch (IOException ioe) {
                SocketLogger.logDebugThrowable("Unexpected socket channel state", ioe);
                mSockets.remove();
                this.cancelIo(ms);
                continue;
            }
            int selectorIndex = this.selectorIndex(sc);
            ms.setSocketInfo(new NIOSocketInfo(ms, selectorIndex));
        }
        super.register(muxableSockets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(Collection<MuxableSocket> muxableSockets) {
        ArrayList[] tmpRegisterLists = new ArrayList[this.SELECTORS];
        for (int i = 0; i < this.SELECTORS; ++i) {
            tmpRegisterLists[i] = new ArrayList();
        }
        for (MuxableSocket ms : muxableSockets) {
            int index;
            NIOSocketInfo nInfo = (NIOSocketInfo)ms.getSocketInfo();
            if (!this.initiateIO(nInfo)) continue;
            try {
                SocketChannel sc;
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                    SocketLogger.logDebug("read: sockInfo=" + nInfo);
                }
                if ((sc = nInfo.getSocketChannel()) == null) {
                    ms.hasException(new IOException("SocketChannel not available"));
                    continue;
                }
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail() && sc.isBlocking()) {
                    SocketLogger.logDebugThrowable("Unexpected socket channel state", new Exception("The SocketChannel is in  blocking mode!"));
                }
                index = this.selectorIndex(nInfo);
                if (nInfo.getSelectionKey() == null) {
                    tmpRegisterLists[index].add(nInfo);
                } else {
                    if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                        SocketLogger.logDebug("set interest ops for: sockInfo=" + nInfo);
                    }
                    nInfo.getSelectionKey().interestOps(1);
                }
            }
            catch (Throwable t) {
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                    SocketLogger.logDebugThrowable("register for Selection failed for ms=" + ms.getSocketInfo() + " with: ", (Exception)t);
                }
                index = this.selectorIndex(nInfo);
                tmpRegisterLists[index].remove(nInfo);
                this.deliverHasException(ms, t);
            }
            for (int i = 0; i < this.SELECTORS; ++i) {
                if (tmpRegisterLists[i].isEmpty()) continue;
                ArrayList<NIOSocketInfo> arrayList = this.registerLists[i][OP_READ_IDX];
                synchronized (arrayList) {
                    this.registerLists[i][OP_READ_IDX].addAll(tmpRegisterLists[i]);
                }
                this.wakeup(i);
            }
        }
    }

    @Override
    protected void cancelIo(MuxableSocket ms) {
        super.cancelIo(ms);
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
            SocketLogger.logDebug("explicitly calling cleanupSocket for ms=" + ms);
        }
        this.cleanupSocket(ms, ms.getSocketInfo());
    }

    @Override
    protected void closeSocket(Socket s) {
        SocketChannel sc;
        block13: {
            if (!s.isOutputShutdown()) {
                try {
                    s.shutdownOutput();
                }
                catch (Exception ignore) {
                    if (!Kernel.DEBUG || !Kernel.getDebug().getDebugMuxerDetail()) break block13;
                    SocketLogger.logDebugThrowable("shutdownOutput error for socket=" + s, ignore);
                }
            }
        }
        if ((sc = s.getChannel()) != null) {
            block14: {
                if (sc.isOpen()) {
                    if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                        SocketLogger.logDebug("close socket=" + s);
                    }
                    try {
                        sc.close();
                    }
                    catch (Exception ignore) {
                        if (!Kernel.DEBUG || !Kernel.getDebug().getDebugMuxerDetail()) break block14;
                        SocketLogger.logDebugThrowable("close channel error for socket=" + s, ignore);
                    }
                }
            }
            this.wakeup(this.selectorIndex(sc));
        } else {
            for (int i = 0; i < this.selectors.length; ++i) {
                this.wakeup(i);
            }
        }
        try {
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerConnection()) {
                SocketLogger.logDebug("Closing raw socket " + s);
            }
            s.getOutputStream().close();
            s.getInputStream().close();
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void wakeup(int i) {
        if (this.willNotice[i].get() != 0 || !this.willNotice[i].compareAndSet(0, 1)) {
            return;
        }
        this.selectors[i].wakeup();
    }

    private void internalRead(MuxableSocket ms, NIOSocketInfo nInfo) {
        this.enableSelectionKeyInterest(ms, nInfo, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableSelectionKeyInterest(MuxableSocket ms, NIOSocketInfo nInfo, int selectionKeyInterest) {
        if (!this.initiateIO(nInfo)) {
            return;
        }
        try {
            SocketChannel sc;
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                SocketLogger.logDebug("read: sockInfo=" + nInfo);
            }
            if ((sc = nInfo.getSocketChannel()) == null) {
                ms.hasException(new IOException("SocketChannel not available"));
                return;
            }
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail() && sc.isBlocking()) {
                SocketLogger.logDebugThrowable("Unexpected socket channel state", new Exception("The SocketChannel is in  blocking mode!"));
            }
            int index = this.selectorIndex(nInfo);
            int opIdx = NIOSocketMuxer.op2Idx(selectionKeyInterest);
            if (nInfo.getSelectionKey() == null) {
                ArrayList<NIOSocketInfo> arrayList = this.registerLists[index][opIdx];
                synchronized (arrayList) {
                    this.registerLists[index][opIdx].add(nInfo);
                }
            }
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                SocketLogger.logDebug("set interest ops for: sockInfo=" + nInfo);
            }
            ArrayList<NIOSocketInfo> arrayList = this.interestLists[index][opIdx];
            synchronized (arrayList) {
                this.interestLists[index][opIdx].add(nInfo);
            }
            this.wakeup(index);
        }
        catch (ThreadDeath ex) {
            throw ex;
        }
        catch (Throwable t) {
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                SocketLogger.logDebugThrowable("register for Selection failed for ms=" + ms.getSocketInfo() + " with: ", t);
            }
            this.deliverHasException(ms, t);
        }
    }

    @Override
    public Socket newSocket(InetAddress address, int port, int timeout) throws IOException {
        return this.newSocket(address, port, null, -1, timeout);
    }

    Selector findOrCreateSelector() throws IOException {
        Selector selector = this.selectorPool.poll();
        if (selector == null) {
            selector = Selector.open();
        }
        return selector;
    }

    void release(Selector selector) {
        block8: {
            block7: {
                if (selector == null) {
                    throw new IllegalArgumentException("Selector is null");
                }
                Set<SelectionKey> keys = selector.keys();
                for (SelectionKey key : keys) {
                    key.cancel();
                }
                try {
                    selector.selectNow();
                }
                catch (IOException ioe) {
                    if (!Kernel.DEBUG || !Kernel.getDebug().getDebugMuxerDetail()) break block7;
                    SocketLogger.logDebugThrowable("failed to selectNow on selector " + selector + " with: ", ioe);
                }
            }
            if (this.selectorPool.offer(selector)) {
                return;
            }
            try {
                selector.close();
            }
            catch (IOException ioe) {
                if (!Kernel.DEBUG || !Kernel.getDebug().getDebugMuxerDetail()) break block8;
                SocketLogger.logDebugThrowable("failed to close selector " + selector + " with: ", ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket newSocket(InetAddress address, int port, InetAddress localAddr, int localPort, int connectTimeoutMillis) throws IOException {
        if (connectTimeoutMillis < 0) {
            throw new IllegalArgumentException("newSocket: timeout can't be negative");
        }
        SocketChannel sc = SocketChannel.open();
        if (localAddr != null) {
            sc.socket().bind(new InetSocketAddress(localAddr, localPort));
        }
        Socket sock = sc.socket();
        NIOSocketMuxer.initSocket(sock);
        sc.configureBlocking(false);
        boolean connected = sc.connect(new InetSocketAddress(address, port));
        if (!connected) {
            Selector selector = this.findOrCreateSelector();
            assert (sc.keyFor(selector) == null);
            sc.register(selector, 8);
            boolean closeNeeded = false;
            try {
                if (selector.select(connectTimeoutMillis) == 0) {
                    closeNeeded = true;
                    throw new SocketTimeoutException("newSocket: Couldn't connect to (" + address + ", " + port + ") even after " + connectTimeoutMillis + " millisecs");
                }
            }
            finally {
                selector.selectedKeys().clear();
                this.release(selector);
                if (closeNeeded) {
                    sc.close();
                }
            }
        }
        if (sc.isConnectionPending()) {
            sc.finishConnect();
        }
        return this.createWeblogicSocket(sock);
    }

    @Override
    public Socket newSDPSocket(InetAddress address, int port, InetAddress localAddr, int localPort, int connectTimeoutMillis) throws IOException {
        Socket sock = SDPSocketUtils.createSDPSocket();
        sock = this.initSocket(sock, address, port, localAddr, localPort, connectTimeoutMillis);
        return this.createWeblogicSocket(sock);
    }

    @Override
    public WeblogicSocket newWeblogicSocket(Socket sock) throws IOException {
        NIOSocketMuxer.initSocket(sock);
        if (SocketEnvironment.getSocketEnvironment().serverThrottleEnabled()) {
            return this.createWeblogicSocketImpl(sock);
        }
        return this.createWeblogicSocket(sock);
    }

    private WeblogicSocket createWeblogicSocketImpl(Socket sock) {
        final NetworkInterfaceInfo nwInfo = NetworkInterfaceInfo.getNetworkInterfaceInfo(sock.getLocalAddress());
        return new WeblogicSocketImpl(sock){
            NIOInputStream nioIn;
            NIOOutputStream nioOut;

            @Override
            public InputStream getInputStream() throws IOException {
                if (this.nioIn == null) {
                    this.nioIn = new NIOInputStream(NIOSocketMuxer.this, this.getSocket().getChannel(), nwInfo);
                }
                return this.nioIn;
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                if (this.nioOut == null) {
                    this.nioOut = new NIOOutputStream(NIOSocketMuxer.this, this.getSocket().getChannel(), nwInfo);
                }
                return this.nioOut;
            }
        };
    }

    private WeblogicSocket createWeblogicSocket(Socket sock) {
        final NetworkInterfaceInfo nwInfo = NetworkInterfaceInfo.getNetworkInterfaceInfo(sock.getLocalAddress());
        return new WeblogicSocket(sock){
            NIOInputStream nioIn;
            NIOOutputStream nioOut;

            @Override
            public InputStream getInputStream() throws IOException {
                if (this.nioIn == null) {
                    this.nioIn = new NIOInputStream(NIOSocketMuxer.this, this.getSocket().getChannel(), nwInfo);
                }
                return this.nioIn;
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                if (this.nioOut == null) {
                    this.nioOut = new NIOOutputStream(NIOSocketMuxer.this, this.getSocket().getChannel(), nwInfo);
                }
                return this.nioOut;
            }
        };
    }

    @Override
    public ServerSocket newServerSocket(InetAddress listenAddress, int port, int backlog) throws IOException {
        ServerSocketChannel ssc;
        block4: {
            ssc = ServerSocketChannel.open();
            try {
                ssc.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            }
            catch (IOException e) {
                if (!Kernel.DEBUG || !Kernel.getDebug().getDebugMuxerDetail()) break block4;
                SocketLogger.logDebugThrowable("Error setting SO_REUSEADDR option to ServerSocket listening on " + listenAddress + ":" + port, e);
            }
        }
        if (listenAddress == null) {
            ssc.socket().bind(new InetSocketAddress(port), backlog);
        } else {
            ssc.socket().bind(new InetSocketAddress(listenAddress, port), backlog);
        }
        ssc.configureBlocking(true);
        return new WeblogicServerSocket(ssc.socket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processSockets() {
        int id;
        NIOSocketMuxer nIOSocketMuxer = this;
        synchronized (nIOSocketMuxer) {
            id = this.nextId++;
        }
        if (id > this.SELECTORS) {
            throw new IllegalStateException("index > SELECTORS | " + id + " > " + this.SELECTORS);
        }
        ArrayList<SelectionKey> al = new ArrayList<SelectionKey>(0);
        while (true) {
            try {
                this.selectFrom(id, al);
                for (int i = al.size() - 1; i >= 0; --i) {
                    this.process(al.remove(i));
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                SocketLogger.logUncaughtThrowable(t);
            }
            this.takeABreak();
        }
    }

    void takeABreak() {
        try {
            if (DELAYPOLLWAKEUP > 0L) {
                Thread.sleep(DELAYPOLLWAKEUP);
            }
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
    }

    void process(SelectionKey key) {
        MuxableSocket ms;
        NIOSocketInfo info = (NIOSocketInfo)key.attachment();
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
            SocketLogger.logDebug("clear interest ops for: sockInfo=" + info);
        }
        if (!this.completeIO(ms = info.getMuxableSocket(), info)) {
            return;
        }
        try {
            int readyOps = key.readyOps();
            if ((readyOps & 1) != 0) {
                this.readReadySocket(ms, info, 0L);
            }
            if ((readyOps & 4) != 0) {
                this.writeReadySocket(info);
            }
        }
        catch (Throwable t) {
            this.deliverHasException(ms, t);
        }
    }

    void selectFrom(int idx, ArrayList<SelectionKey> al) throws IOException {
        Selector selector = this.selectors[idx];
        ArrayList<NIOSocketInfo> registerReadList = this.registerLists[idx][OP_READ_IDX];
        ArrayList<NIOSocketInfo> registerWriteList = this.registerLists[idx][OP_WRITE_IDX];
        ArrayList<NIOSocketInfo> readList = this.interestLists[idx][OP_READ_IDX];
        ArrayList<NIOSocketInfo> writeList = this.interestLists[idx][OP_WRITE_IDX];
        AtomicInteger noticeId = this.willNotice[idx];
        while (true) {
            noticeId.set(0);
            noticeId.get();
            if (registerReadList.size() > 0) {
                this.registerNewSockets(idx, registerReadList, 1);
            }
            if (registerWriteList.size() > 0) {
                this.registerNewSockets(idx, registerWriteList, 4);
            }
            if (readList.size() > 0) {
                this.setInterestOps(readList, 1);
            }
            if (writeList.size() > 0) {
                this.setInterestOps(writeList, 4);
            }
            int nSelected = selector.select();
            if (Thread.interrupted() && Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                SocketLogger.logDebug("NIOSocketMuxer [" + this + "] has been interrupted.");
            }
            if (nSelected == 0) continue;
            noticeId.set(1);
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                SocketLogger.logDebug("select returns " + nSelected + " keys");
            }
            Set<SelectionKey> sk = selector.selectedKeys();
            for (SelectionKey k : sk) {
                try {
                    k.interestOps(k.interestOps() & ~k.readyOps());
                    al.add(k);
                }
                catch (CancelledKeyException ignore) {
                    NIOSocketInfo info = (NIOSocketInfo)k.attachment();
                    this.deliverEndOfStream(info.getMuxableSocket());
                }
            }
            sk.clear();
            if (al.size() != 0) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInterestOps(ArrayList<NIOSocketInfo> interestList, int op) {
        ArrayList<NIOSocketInfo> arrayList = interestList;
        synchronized (arrayList) {
            for (NIOSocketInfo nInfo : interestList) {
                try {
                    nInfo.getSelectionKey().interestOps(op);
                }
                catch (Exception ex) {
                    if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                        SocketLogger.logDebugThrowable("Couldn't set interest " + (op == 1 ? "read" : "write") + " for ms = " + nInfo.getMuxableSocket() + " with: ", ex);
                    }
                    this.deliverHasException(nInfo.getMuxableSocket(), ex);
                }
            }
            interestList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewSockets(int idx, ArrayList<NIOSocketInfo> registerList, int selectionKeyOp) {
        NIOSocketInfo[] nIOSocketInfoArray = registerList;
        synchronized (registerList) {
            int newSocketCount = registerList.size();
            if (newSocketCount == 0) {
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
            NIOSocketInfo[] curRegisterList = registerList.toArray(new NIOSocketInfo[newSocketCount]);
            registerList.clear();
            // ** MonitorExit[var5_4] (shouldn't be in output)
            for (NIOSocketInfo info : curRegisterList) {
                MuxableSocket ms;
                SelectionKey key = info.getSelectionKey();
                if (key != null) continue;
                SocketChannel sc = info.getSocketChannel();
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                    SocketLogger.logDebug("SocketChannel.register: sockInfo=" + info);
                }
                try {
                    key = sc.register(this.selectors[idx], selectionKeyOp, info);
                    info.setSelectionKey(key);
                }
                catch (CancelledKeyException cke) {
                    ms = info.getMuxableSocket();
                    this.deliverHasException(ms, cke);
                }
                catch (ClosedChannelException cce) {
                    ms = info.getMuxableSocket();
                    this.deliverHasException(ms, cce);
                }
            }
            return;
        }
    }

    @Override
    protected int readFromSocket(MuxableSocket ms) throws IOException {
        InputStream is = ms.getSocketInputStream();
        if (is == null) {
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                SocketLogger.logDebug("Socket has been closed and cleaned up: " + ms + " will return EOS from read");
            }
            return -1;
        }
        if (ms.supportsScatteredRead() && is instanceof NIOInputStream && ((NIOConnection)((Object)is)).supportsScatteredReads()) {
            return (int)ms.read((NIOConnection)((Object)is));
        }
        return super.readFromSocket(ms);
    }

    private void writeReadySocket(NIOSocketInfo info) throws IOException {
        OutputStream os = info.getMuxableSocket().getSocket().getOutputStream();
        assert (os instanceof NIOOutputStream);
        ((NIOOutputStream)os).onWritable();
    }

    @Override
    protected void internalWrite(AsyncOutputStream s) {
        OutputStream os = s.getOutputStream();
        if (os == null) {
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                SocketLogger.logDebug("Socket has been closed and cleaned up");
            }
            return;
        }
        Chunk c = s.getOutputBuffer();
        if (c != null && c.next != null && s.supportsGatheringWrite() && os instanceof NIOConnection && ((NIOConnection)((Object)os)).supportsGatheredWrites()) {
            try {
                s.write((NIOConnection)((Object)os));
            }
            catch (IOException ioe) {
                s.handleException(ioe);
            }
        } else if (os instanceof NIOOutputStream) {
            NIOOutputStream nos = (NIOOutputStream)os;
            while ((c = s.getOutputBuffer()) != null) {
                try {
                    nos.write(c.getWriteByteBuffer());
                    s.handleWrite(c);
                }
                catch (IOException ioe) {
                    s.handleException(ioe);
                    return;
                }
            }
        } else {
            super.internalWrite(s);
        }
    }

    private static int op2Idx(int selectionKeyOp) {
        return selectionKeyOp == 1 ? 0 : 1;
    }

    static {
        NIOSocketMuxer.initThreadCount(3, "weblogic.socket.Muxer", "");
        debugPPP = DebugLogger.getDebugLogger("DebugNIO");
        MUXERS = rdrThreads;
    }
}

