/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSocket;
import weblogic.security.utils.SSLSetupLogging;
import weblogic.socket.MaxMessageSizeExceededException;
import weblogic.socket.MuxableSocket;
import weblogic.socket.NIOConnection;
import weblogic.socket.SSLFilter;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketLogger;
import weblogic.socket.SocketMuxer;
import weblogic.utils.AssertionError;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedInputStream;

public final class SSLFilterImpl
implements SSLFilter {
    private static final boolean ASSERT = true;
    private static final boolean DEBUG = false;
    private boolean activated = false;
    private final InputStream in;
    private Chunk head;
    private Chunk tail;
    private int pos;
    private int availBytes;
    private MuxableSocket delegate;
    private final SSLSocket sslSocket;
    private InputStream clearText;
    private SocketInfo sockInfo;
    private ChunkedInputStream cis = null;

    public SSLFilterImpl(InputStream is, SSLSocket ssl) throws IOException {
        this.in = is;
        this.sslSocket = ssl;
        this.head = this.tail = Chunk.getChunk();
        SSLSetupLogging.info("Filtering JSSE SSLSocket");
    }

    public String toString() {
        return "SSLFilterImpl[" + this.getDelegate() + "]";
    }

    @Override
    public MuxableSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(MuxableSocket mx) {
        this.delegate = mx;
    }

    @Override
    public void asyncOn() {
        this.activated = true;
    }

    @Override
    public void asyncOff() {
        this.activated = false;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChunkedInputStream getInputStream() throws IOException {
        if (this.cis == null) {
            SSLFilterImpl sSLFilterImpl = this;
            synchronized (sSLFilterImpl) {
                if (this.cis == null) {
                    this.cis = new ChunkedInputStream(this.head, 0, this.in);
                }
                ChunkedInputStream chunkedInputStream = this.cis;
                synchronized (chunkedInputStream) {
                }
            }
        }
        return this.cis;
    }

    @Override
    public int available() throws IOException {
        if (!this.activated) {
            return this.in.available();
        }
        return this.availBytes;
    }

    @Override
    public void activate() throws IOException {
        SSLSetupLogging.info("SSLFilteriImpl.activate()");
        this.activateNoRegister();
        if (this.delegate.isMessageComplete()) {
            SocketMuxer.getMuxer().register(this);
            this.delegate.dispatch();
        } else {
            SocketMuxer.getMuxer().register(this);
            SocketMuxer.getMuxer().read(this);
        }
    }

    @Override
    public void activateNoRegister() throws IOException {
        SSLSetupLogging.info("activateNoRegister()");
        this.clearText = this.sslSocket.getInputStream();
        try {
            int nread = 0;
            for (int clearTextAvail = 0; clearTextAvail > 0; clearTextAvail -= nread) {
                SSLSetupLogging.info("clearTextAvail = " + clearTextAvail);
                byte[] buf = this.delegate.getBuffer();
                int off = this.delegate.getBufferOffset();
                nread = this.clearText.read(buf, off, Math.min(buf.length - off, clearTextAvail));
                this.delegate.incrementBufferOffset(nread);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
        this.activated = true;
        SSLSetupLogging.info("SSLFilterImpl.activate(): activated: " + this.in.hashCode() + " " + this.clearText.hashCode());
    }

    @Override
    public int getIdleTimeoutMillis() {
        return this.delegate.getIdleTimeoutMillis();
    }

    @Override
    public byte[] getBuffer() {
        if (this.tail.end == this.tail.buf.length) {
            this.tail = this.tail.next = Chunk.getChunk();
        }
        return this.tail.buf;
    }

    @Override
    public int getBufferOffset() {
        return this.tail.end;
    }

    private static void p(String s) {
        System.out.println("SSLFilterImpl: " + s);
    }

    @Override
    public void incrementBufferOffset(int i) throws MaxMessageSizeExceededException {
        this.availBytes += i;
        this.tail.end += i;
    }

    @Override
    public boolean isMessageComplete() {
        while (true) {
            byte[] b = this.delegate.getBuffer();
            int off = this.delegate.getBufferOffset();
            try {
                int nread = this.clearText.read(b, off, b.length - off);
                if (nread == -1) {
                    try {
                        SocketMuxer.getMuxer().deliverEndOfStream(this);
                    }
                    catch (Throwable t) {
                        if (t instanceof SocketException) break;
                        SocketLogger.logDebugThrowable("isMessageComplete", t);
                    }
                    break;
                }
                this.delegate.incrementBufferOffset(nread);
                continue;
            }
            catch (InterruptedIOException ioe) {
            }
            catch (MaxMessageSizeExceededException mmsee) {
                SocketMuxer.getMuxer().deliverHasException(this, mmsee);
            }
            catch (IOException ignore) {
                if (!(ignore instanceof SocketException)) {
                    SocketLogger.logDebugThrowable("isMessageComplete", ignore);
                }
                SocketMuxer.getMuxer().deliverHasException(this, ignore);
                continue;
            }
            catch (Throwable t) {
                SocketLogger.logDebugThrowable("isMessageComplete", t);
                SocketMuxer.getMuxer().deliverHasException(this, t);
                continue;
            }
            break;
        }
        boolean result = this.delegate.isMessageComplete();
        return result;
    }

    @Override
    public void dispatch() {
        this.delegate.dispatch();
    }

    @Override
    public InputStream getSocketInputStream() {
        return this.in;
    }

    @Override
    public void setSoTimeout(int to) throws SocketException {
        this.delegate.setSoTimeout(to);
    }

    @Override
    public Socket getSocket() {
        return this.sslSocket;
    }

    @Override
    public boolean closeSocketOnError() {
        return true;
    }

    @Override
    public void hasException(Throwable t) {
        if (!(t instanceof SocketException)) {
            SSLSetupLogging.debug(3, t, "hasException");
        }
        this.delegate.hasException(t);
    }

    @Override
    public void endOfStream() {
        this.delegate.endOfStream();
    }

    @Override
    public boolean timeout() {
        return this.delegate.timeout();
    }

    @Override
    public boolean requestTimeout() {
        return this.delegate.requestTimeout();
    }

    @Override
    public int getCompleteMessageTimeoutMillis() {
        return this.delegate.getCompleteMessageTimeoutMillis();
    }

    @Override
    public void setSocketFilter(MuxableSocket remx) {
        throw new AssertionError("Re-register Muxer not allowed on SSLFilterImpl");
    }

    @Override
    public MuxableSocket getSocketFilter() {
        return this;
    }

    @Override
    public void setSocketInfo(SocketInfo info) {
        this.sockInfo = info;
    }

    @Override
    public SocketInfo getSocketInfo() {
        return this.sockInfo;
    }

    @Override
    public void ensureForceClose() {
        try {
            this.sslSocket.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean supportsScatteredRead() {
        return false;
    }

    @Override
    public long read(NIOConnection connection) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void incrementBufferOffset(Chunk c, int availBytes) throws MaxMessageSizeExceededException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.delegate.getByteBuffer();
    }
}

