/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import weblogic.socket.MuxableSocket;

public class SocketInfo {
    static final int OKAY = 0;
    static final int PROTOCOL_ERROR = 1;
    static final int CLOSE_ONLY = 2;
    static final int IO_PENDING = 4;
    static final int EXCEPTION_PENDING = 8;
    static final int IDLE_TIMEOUT = 16;
    static final int MSG_TIMEOUT = 32;
    protected MuxableSocket ms;
    private long lastIoInitiatedTimeMillis = -1L;
    private long lastMessageReadingStartedTimeMillis = -1L;
    private boolean markedClose = false;
    private boolean exceptionHandlingCompleted = false;

    public SocketInfo(MuxableSocket ms) {
        this.setMuxableSocket(ms);
    }

    protected String fieldsToString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("ms = ").append(this.ms).append(", ").append("socket = ").append(this.ms.getSocket()).append(", ").append("lastIoInitiatedTimeMillis = ").append(this.lastIoInitiatedTimeMillis).append(", ").append("lastMessageReadingStartedTimeMillis = ").append(this.lastMessageReadingStartedTimeMillis).append(", ").append("markedClose = ").append(this.markedClose).append(", ").append("exceptionHandlingCompleted = ").append(this.exceptionHandlingCompleted);
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getName()).append("[").append(this.fieldsToString()).append("]");
        return sb.toString();
    }

    public int getFD() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean touch() {
        SocketInfo socketInfo = this;
        synchronized (socketInfo) {
            if (this.isCloseOnly()) {
                return false;
            }
            if (this.lastIoInitiatedTimeMillis != -1L) {
                this.lastIoInitiatedTimeMillis = System.currentTimeMillis();
            }
            return true;
        }
    }

    final MuxableSocket getMuxableSocket() {
        return this.ms;
    }

    final void setMuxableSocket(MuxableSocket ms) {
        this.ms = ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean ioInitiated() {
        SocketInfo socketInfo = this;
        synchronized (socketInfo) {
            if (this.isCloseOnly() || this.ioPending()) {
                return false;
            }
            this.lastIoInitiatedTimeMillis = System.currentTimeMillis();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int ioCompleted() {
        SocketInfo socketInfo = this;
        synchronized (socketInfo) {
            if (!this.ioPending()) {
                return 1;
            }
            this.lastIoInitiatedTimeMillis = -1L;
            if (this.isCloseOnly()) {
                if (!this.exceptionHandlingCompleted) {
                    return 10;
                }
                return 2;
            }
        }
        return 0;
    }

    final synchronized void messageInitiated() {
        if (this.lastMessageReadingStartedTimeMillis == -1L) {
            this.lastMessageReadingStartedTimeMillis = System.currentTimeMillis();
        }
    }

    final synchronized void messageCompleted() {
        this.lastMessageReadingStartedTimeMillis = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int close() {
        SocketInfo socketInfo = this;
        synchronized (socketInfo) {
            if (this.isCloseOnly()) {
                return 1;
            }
            this.setCloseOnly();
            if (this.ioPending()) {
                return 4;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int exceptionHandlingCompleted() {
        SocketInfo socketInfo = this;
        synchronized (socketInfo) {
            this.exceptionHandlingCompleted = true;
            if (this.ioPending()) {
                return 4;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int checkTimeout(long idleTimeout, long msgTimeout) {
        int status;
        SocketInfo socketInfo = this;
        synchronized (socketInfo) {
            if (this.isCloseOnly()) {
                return 2;
            }
            if (!this.ioPending()) {
                return 0;
            }
            if (this.messagePending()) {
                if (msgTimeout <= 0L) {
                    return 0;
                }
                long interval = this.getMessageIntervalMillis(msgTimeout);
                if (interval <= msgTimeout) {
                    return 0;
                }
                status = 32;
            } else {
                if (idleTimeout <= 0L) {
                    return 0;
                }
                long interval = this.getIdleIntervalMillis(idleTimeout);
                if (interval <= idleTimeout) {
                    return 0;
                }
                status = 16;
            }
            if (!this.ms.requestTimeout()) {
                return 0;
            }
            this.setCloseOnly();
        }
        return status;
    }

    synchronized boolean isCloseOnly() {
        return this.markedClose;
    }

    private void setCloseOnly() {
        this.markedClose = true;
    }

    private boolean ioPending() {
        return this.lastIoInitiatedTimeMillis != -1L;
    }

    private boolean messagePending() {
        return this.lastMessageReadingStartedTimeMillis != -1L;
    }

    private long getIdleIntervalMillis(long idleTimeout) {
        if (idleTimeout == 0L) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        return now - this.lastIoInitiatedTimeMillis;
    }

    private long getMessageIntervalMillis(long msgTimeout) {
        if (msgTimeout == 0L) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        return now - this.lastMessageReadingStartedTimeMillis;
    }

    protected void cleanup() {
    }
}

