/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.health.OOMENotifier;
import weblogic.kernel.ExecuteRequest;
import weblogic.kernel.ExecuteThreadManager;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.platform.VM;
import weblogic.server.ServiceFailureException;
import weblogic.socket.AsyncOutputStream;
import weblogic.socket.MaxMessageSizeExceededException;
import weblogic.socket.MuxableSocket;
import weblogic.socket.NIOInputStream;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketLogger;
import weblogic.socket.SocketOptionException;
import weblogic.socket.SocketReaderRequest;
import weblogic.socket.internal.SocketEnvironment;
import weblogic.socket.utils.ProxyUtils;
import weblogic.socket.utils.SDPSocketUtils;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.AssertionError;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.io.Chunk;
import weblogic.work.WorkManagerFactory;

public abstract class SocketMuxer {
    private static final String TIMER_MANAGER_NAME = "MuxerTimerManager";
    private static final int TIMER_MANAGER_INTERVAL = 5000;
    private static final String DELAYPOLLWAKEUPPROP = "weblogic.socket.SocketMuxer.DELAY_POLL_WAKEUP";
    protected static final long DELAYPOLLWAKEUP = SocketMuxer.initMuxerDelayPollProp();
    private static final int EOS = -1;
    private static final String sockCreateTimeoutProp = "weblogic.client.socket.ConnectTimeout";
    private static final int sockCreateTimeout = SocketMuxer.initSockCreateTimeoutProp();
    protected static final String SOCKET_READERS_QUEUE_NAME = "weblogic.socket.Muxer";
    protected final ConcurrentHashMap<MuxableSocket, Object> sockets = new ConcurrentHashMap(4096);
    private static final Object ISPRESENT = new Object();
    private static boolean isAvailable = false;
    private static final String osName = SocketMuxer.initOSNameProp();
    private static final boolean isLinux = "linux".equals(osName);
    private static final boolean isAix = "aix".equals(osName);
    private static OOMENotifier oomeNotifier;
    protected static int rdrThreads;

    private static int initSockCreateTimeoutProp() {
        if (!KernelStatus.isServer()) {
            try {
                return Integer.getInteger(sockCreateTimeoutProp, 0) * 1000;
            }
            catch (SecurityException se) {
                return 0;
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
        }
        return 0;
    }

    private static long initMuxerDelayPollProp() {
        if (KernelStatus.isServer()) {
            return Long.getLong(DELAYPOLLWAKEUPPROP, 0L);
        }
        return 0L;
    }

    private static String initOSNameProp() {
        String s = "UNKNOWN";
        try {
            s = System.getProperty("os.name", "UNKNOWN").toLowerCase(Locale.ENGLISH);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return s;
    }

    public static SocketMuxer getMuxer() {
        return SingletonMaker.singleton;
    }

    public static boolean isAvailable() {
        return isAvailable;
    }

    static SocketMuxer initSocketMuxerOnServer() throws ServiceFailureException {
        return SingletonMaker.singleton;
    }

    static void initOOMENotifier(OOMENotifier oomeNotifier) {
        SocketMuxer.oomeNotifier = oomeNotifier;
    }

    /*
     * Exception decompiling
     */
    private static SocketMuxer makeTheMuxer() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getNativeMuxerClassName() {
        String muxerClassName = null;
        try {
            muxerClassName = Kernel.getConfig().getMuxerClass();
            if (muxerClassName != null && !muxerClassName.isEmpty()) {
                return muxerClassName;
            }
            muxerClassName = SocketMuxer.chooseMuxerClassBySettings();
        }
        catch (SecurityException se) {
            muxerClassName = "weblogic.socket.JavaSocketMuxer";
        }
        SocketLogger.logNoMuxerSpecified(muxerClassName);
        return muxerClassName;
    }

    private static String chooseMuxerClassBySettings() throws SecurityException {
        if (!VM.getVM().isNativeThreads()) {
            return "weblogic.socket.JavaSocketMuxer";
        }
        if (!Kernel.getConfig().isNativeIOEnabled()) {
            return "weblogic.socket.JavaSocketMuxer";
        }
        if (osName.startsWith("windows")) {
            return "weblogic.socket.NTSocketMuxer";
        }
        if (Kernel.getConfig().isDevPollDisabled()) {
            return "weblogic.socket.PosixSocketMuxer";
        }
        if (osName.equals("hp-ux") || osName.equals("sunos")) {
            return "weblogic.socket.DevPollSocketMuxer";
        }
        return "weblogic.socket.PosixSocketMuxer";
    }

    private static String getLinkError(String muxerClassName) {
        String path = null;
        try {
            path = System.getProperty("java.library.path", "java.library.path");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if ("weblogic.socket.NTSocketMuxer".equals(muxerClassName)) {
            return "Please ensure that wlntio.dll is in: '" + path + "'";
        }
        if ("weblogic.socket.PosixSocketMuxer".equals(muxerClassName)) {
            return "Please ensure that libmuxer library is in :'" + path + "'";
        }
        return "Please ensure that a native performance library is in: '" + path + "'";
    }

    @Deprecated
    protected void initSocketReaderThreads(int defaultNumberOfReaders, String queueName, String oldQueueName) {
        SocketMuxer.initThreadCount(defaultNumberOfReaders, queueName, oldQueueName);
        this.startSocketReaderThreads(queueName);
    }

    public int getNumberOfReaders() {
        return rdrThreads;
    }

    protected static void initThreadCount(int defaultNumberOfReaders, String queueName, String oldQueueName) {
        int nreaders;
        ExecuteThreadManager queue = Kernel.getExecuteThreadManager(queueName);
        if (queue != null && queue.getName().equalsIgnoreCase(queueName)) {
            nreaders = queue.getExecuteThreadCount();
        } else {
            nreaders = Kernel.getConfig().getSocketReaders();
            if (nreaders <= 0 && (nreaders = Integer.getInteger(oldQueueName, -1).intValue()) <= 0) {
                int numberOfCPUs = Runtime.getRuntime().availableProcessors();
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                    SocketLogger.logDebug("Number of CPUs=" + numberOfCPUs);
                }
                if ((nreaders = numberOfCPUs > 0 ? numberOfCPUs + 1 : defaultNumberOfReaders) > 4) {
                    nreaders = 4;
                }
            }
            Kernel.addExecuteQueue(queueName, nreaders);
        }
        rdrThreads = nreaders;
    }

    protected void startSocketReaderThreads(String queueName) {
        if (rdrThreads == -1) {
            throw new IllegalStateException("Socket Reader threads not initialized");
        }
        SocketLogger.logAllocSocketReaders(rdrThreads);
        for (int i = 0; i < rdrThreads; ++i) {
            Kernel.execute((ExecuteRequest)new SocketReaderRequest(), queueName);
        }
    }

    public boolean isAsyncMuxer() {
        return false;
    }

    public Socket newSocket(InetAddress address, int port) throws IOException {
        return this.newSocket(address, port, sockCreateTimeout);
    }

    public Socket newSocket(InetAddress address, int port, int timeout) throws IOException {
        Socket sock = new Socket();
        SocketMuxer.initSocket(sock);
        sock.connect(new InetSocketAddress(address, port), timeout);
        return sock;
    }

    public Socket newClientSocket(InetAddress host, int port, int timeout) throws IOException {
        if (ProxyUtils.canProxy(host, false)) {
            return ProxyUtils.getClientProxy(host.getHostAddress(), port, timeout);
        }
        return this.newSocket(host, port, timeout);
    }

    public Socket newClientSocket(InetAddress host, int port, InetAddress localHost, int localPort, int timeout) throws IOException {
        if (ProxyUtils.canProxy(host, false)) {
            return ProxyUtils.getClientProxy(host.getHostAddress(), port, localHost, localPort, timeout);
        }
        return this.newSocket(host, port, localHost, localPort, timeout);
    }

    public Socket newClientSocket(InetAddress host, int port) throws IOException {
        return this.newClientSocket(host, port, 0);
    }

    public Socket newSSLClientSocket(InetAddress host, int port, int timeout) throws IOException {
        if (ProxyUtils.canProxy(host, true)) {
            return ProxyUtils.getSSLClientProxy(host.getHostAddress(), port, timeout);
        }
        return null;
    }

    public Socket newSSLClientSocket(InetAddress host, int port, InetAddress localHost, int localPort, int timeout) throws IOException {
        if (ProxyUtils.canProxy(host, true)) {
            return ProxyUtils.getSSLClientProxy(host.getHostAddress(), port, localHost != null ? localHost.getHostAddress() : null, localPort, timeout);
        }
        return null;
    }

    public Socket newSSLClientSocket(InetAddress host, int port) throws IOException {
        return this.newSSLClientSocket(host, port, 0);
    }

    public Socket newSocket(InetAddress address, int port, InetAddress localAddr, int localPort, int connectTimeoutMillis) throws IOException {
        Socket sock = new Socket();
        return this.initSocket(sock, address, port, localAddr, localPort, connectTimeoutMillis);
    }

    public Socket newSDPSocket(InetAddress address, int port, InetAddress localAddr, int localPort, int connectTimeoutMillis) throws IOException {
        Socket sock = SDPSocketUtils.createSDPSocket();
        return this.initSocket(sock, address, port, localAddr, localPort, connectTimeoutMillis);
    }

    protected Socket initSocket(Socket sock, InetAddress address, int port, InetAddress localAddr, int localPort, int connectTimeoutMillis) throws IOException {
        SocketMuxer.initSocket(sock);
        sock.bind(new InetSocketAddress(localAddr, localPort));
        sock.connect(new InetSocketAddress(address, port), connectTimeoutMillis);
        return sock;
    }

    public Socket newProxySocket(InetAddress host, int port, InetAddress localAddr, int localPort, InetAddress proxyHost, int proxyPort, int connectTimeoutMillis) throws IOException {
        Socket sock = this.newSocket(proxyHost, proxyPort, localAddr, localPort, connectTimeoutMillis);
        return ProxyUtils.getProxySocket(sock, host.getHostName(), port, proxyHost.getHostName(), proxyPort);
    }

    public Socket newWeblogicSocket(Socket sock) throws IOException {
        SocketMuxer.initSocket(sock);
        SocketEnvironment sockEnv = SocketEnvironment.getSocketEnvironment();
        if (sockEnv.serverThrottleEnabled()) {
            return sockEnv.getWeblogicSocket(sock);
        }
        return sock;
    }

    static void initSocket(Socket sock) throws SocketOptionException {
        try {
            sock.setTcpNoDelay(true);
        }
        catch (SocketException se) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SocketOptionException(se.getMessage());
        }
    }

    protected void closeSocket(Socket s) {
        this.closeSocket(s, true);
    }

    private void closeSocket(Socket s, boolean shouldCloseSocket) {
        try {
            if (isLinux || isAix) {
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerConnection()) {
                    SocketLogger.logDebug("Closing input and output of socket " + s);
                }
                try {
                    s.shutdownInput();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    s.shutdownOutput();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (shouldCloseSocket) {
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerConnection()) {
                    SocketLogger.logDebug("Closing raw socket " + s);
                }
                s.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected SocketMuxer() throws IOException {
        TimerManager tm = TimerManagerFactory.getTimerManagerFactory().getTimerManager(TIMER_MANAGER_NAME, WorkManagerFactory.getInstance().getSystem());
        tm.scheduleAtFixedRate((TimerListener)new TimerListenerImpl(), 0L, 5000L);
    }

    public void register(MuxableSocket ms) throws IOException {
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
            SocketLogger.logDebug("register: sockInfo=" + ms.getSocketInfo());
        }
        this.sockets.put(ms, ISPRESENT);
    }

    public void register(Collection<MuxableSocket> muxableSockets) {
        HashMap<MuxableSocket, Object> toRegister = new HashMap<MuxableSocket, Object>();
        for (MuxableSocket tmp : muxableSockets) {
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                SocketLogger.logDebug("register: sockInfo=" + tmp.getSocketInfo());
            }
            toRegister.put(tmp, ISPRESENT);
        }
        this.sockets.putAll(toRegister);
    }

    public void reRegister(MuxableSocket oldSock, MuxableSocket newSock) {
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
            SocketLogger.logDebug("reRegister: oldSockInfo=" + oldSock.getSocketInfo() + ", newSock=" + newSock);
        }
        this.sockets.remove(oldSock);
        SocketInfo info = oldSock.getSocketInfo();
        oldSock.setSocketInfo(null);
        info.setMuxableSocket(newSock);
        newSock.setSocketInfo(info);
        this.sockets.put(newSock, ISPRESENT);
    }

    public abstract void read(MuxableSocket var1);

    public abstract void read(Collection<MuxableSocket> var1);

    public final void closeSocket(MuxableSocket ms) {
        this.deliverEndOfStream(ms);
    }

    protected abstract void processSockets();

    public final int getNumSockets() {
        return this.sockets.size();
    }

    public final Iterator<MuxableSocket> getSocketsIterator() {
        return ((ConcurrentHashMap.KeySetView)this.sockets.keySet()).iterator();
    }

    public final MuxableSocket[] getSockets() {
        Set socketSet = this.sockets.keySet();
        MuxableSocket[] ret = new MuxableSocket[socketSet.size()];
        return socketSet.toArray(ret);
    }

    final boolean initiateIO(SocketInfo info) {
        return info.ioInitiated();
    }

    final boolean completeIO(MuxableSocket ms, SocketInfo info) {
        int status = info.ioCompleted();
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
            SocketLogger.logDebug("completeIO: " + status + ", info=" + info);
        }
        if (status == 1) {
            return false;
        }
        if ((status & 2) != 0) {
            if ((status & 8) == 0) {
                this.cleanupSocket(ms, info);
            }
            return false;
        }
        return true;
    }

    public final void finishExceptionHandling(MuxableSocket ms) {
        SocketInfo info = ms.getSocketInfo();
        int status = info.exceptionHandlingCompleted();
        if (status == 0) {
            this.cleanupSocket(ms, info);
        } else if (status == 4) {
            this.cancelIo(ms);
        }
    }

    public final void deliverEndOfStream(MuxableSocket ms) {
        this.deliverExceptionAndCleanup(ms, null);
    }

    public final void deliverHasException(MuxableSocket ms, Throwable ex) {
        if (oomeNotifier != null && ex instanceof OutOfMemoryError) {
            oomeNotifier.notifyOOME((OutOfMemoryError)ex);
        }
        this.deliverExceptionAndCleanup(ms, ex);
    }

    private void deliverExceptionAndCleanup(MuxableSocket ms, Throwable ex) {
        MuxableSocket cleanupMS;
        if (ms == null) {
            throw new AssertionError(ex);
        }
        SocketInfo info = ms.getSocketInfo();
        MuxableSocket socketFilter = ms.getSocketFilter();
        if (info == null && socketFilter != null) {
            info = socketFilter.getSocketInfo();
        }
        if (info == null) {
            if (Kernel.DEBUG && (Kernel.getDebug().getDebugMuxer() || Kernel.getDebug().getDebugMuxerConnection())) {
                SocketLogger.logDebug("Unable to find internal data record for socket " + ms);
            }
            return;
        }
        int status = info.close();
        if (status == 1) {
            return;
        }
        if (Kernel.DEBUG && (Kernel.getDebug().getDebugMuxer() || Kernel.getDebug().getDebugMuxerConnection())) {
            StringBuffer sb = new StringBuffer(100);
            sb.append("deliver");
            if (ex == null) {
                sb.append("EndOfStream");
            } else {
                sb.append("HasException");
            }
            sb.append(": sockInfo=").append(info).append("\n");
            if (ex == null) {
                sb.append(StackTraceUtils.throwable2StackTrace(new Exception()));
            } else {
                sb.append(StackTraceUtils.throwable2StackTrace(ex));
            }
            SocketLogger.logDebug(sb.toString());
        }
        MuxableSocket muxableSocket = cleanupMS = socketFilter != null ? socketFilter : ms;
        if (ex == null) {
            cleanupMS.endOfStream();
        } else {
            cleanupMS.hasException(ex);
        }
        status = info.exceptionHandlingCompleted();
        if (status == 0) {
            this.cleanupSocket(cleanupMS, info);
            return;
        }
        if (status == 4) {
            this.cancelIo(cleanupMS);
            return;
        }
        throw new AssertionError("Socket ms=" + info + " in unexpected state: " + status);
    }

    protected void cancelIo(MuxableSocket ms) {
        if (isAix) {
            this.closeSocket(ms.getSocket(), false);
        } else {
            this.closeSocket(ms.getSocket());
        }
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
            SocketLogger.logDebug("cancelIo: ms=" + ms + ", sockInfo=" + ms.getSocketInfo());
        }
    }

    void cleanupSocket(MuxableSocket ms, SocketInfo info) {
        if (this.sockets.remove(ms) == null) {
            return;
        }
        if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
            SocketLogger.logDebug("cleanupSocket: sockInfo=" + ms.getSocketInfo());
        }
        try {
            if (info != null) {
                info.cleanup();
            }
        }
        finally {
            if (ms.closeSocketOnError()) {
                this.closeSocket(ms.getSocket());
            }
        }
    }

    final void readReadySocket(MuxableSocket ms, SocketInfo info, long timeoutMillis) {
        if (timeoutMillis > 0L) {
            long endOfTimeSliceMillis = System.currentTimeMillis() + timeoutMillis;
            while (this.readReadySocketOnce(ms, info)) {
                if (System.currentTimeMillis() > endOfTimeSliceMillis) {
                    this.read(ms);
                    break;
                }
                this.initiateIO(info);
            }
        } else if (this.readReadySocketOnce(ms, info)) {
            this.read(ms);
        }
    }

    private final boolean readReadySocketOnce(MuxableSocket ms, SocketInfo info) {
        int nread;
        block14: {
            Socket socket = null;
            nread = 0;
            try {
                socket = ms.getSocket();
                InputStream sis = ms.getSocketInputStream();
                if (sis == null) {
                    this.readCompleted(ms);
                    return false;
                }
                nread = this.readFromSocket(ms);
                if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                    SocketLogger.logDebug("read " + nread + " bytes");
                }
            }
            catch (InterruptedIOException e) {
                this.handleReadTimeout(ms);
                return false;
            }
            catch (IOException ioe) {
                this.readCompleted(ms);
                if (ioe instanceof MaxMessageSizeExceededException) {
                    SocketLogger.logIOException(socket.toString(), ioe);
                } else if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                    SocketLogger.logDebugThrowable("Error reading socket: '" + ms + "'", ioe);
                }
                this.deliverHasException(ms, ioe);
                return false;
            }
            catch (Throwable t) {
                if (!Kernel.DEBUG || !Kernel.getDebug().getDebugMuxerDetail()) break block14;
                t.printStackTrace();
            }
        }
        this.readCompleted(ms);
        if (nread == -1) {
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                SocketLogger.logDebug("EOF on socket: " + ms.getSocketInfo());
            }
            this.deliverEndOfStream(ms);
            return false;
        }
        if (ms.isMessageComplete()) {
            info.messageCompleted();
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxerDetail()) {
                SocketLogger.logDebug("dispatch " + info);
            }
        } else {
            info.messageInitiated();
            return true;
        }
        ms.dispatch();
        return false;
    }

    protected int readFromSocket(MuxableSocket ms) throws IOException {
        byte[] buf = ms.getBuffer();
        int offset = ms.getBufferOffset();
        int availableBuffer = buf.length - offset;
        int read = 0;
        InputStream sis = ms.getSocketInputStream();
        if (sis == null) {
            if (Kernel.DEBUG && Kernel.getDebug().getDebugMuxer()) {
                SocketLogger.logDebug("Socket has been closed and cleanedup: " + ms + " will return EOS from read");
            }
            return -1;
        }
        read = sis instanceof NIOInputStream ? ((NIOInputStream)sis).readNonBlocking(buf, offset, availableBuffer) : sis.read(buf, offset, availableBuffer);
        if (read > 0) {
            ms.incrementBufferOffset(read);
        }
        return read;
    }

    protected void handleReadTimeout(MuxableSocket ms) {
        this.read(ms);
    }

    protected void readCompleted(MuxableSocket ms) {
    }

    public final void write(AsyncOutputStream s) {
        this.internalWrite(s);
    }

    protected void internalWrite(AsyncOutputStream s) {
        OutputStream os = s.getOutputStream();
        Chunk c = null;
        while (os != null && (c = s.getOutputBuffer()) != null) {
            try {
                os.write(c.buf, 0, c.end);
                s.handleWrite(c);
            }
            catch (IOException ioe) {
                s.handleException(ioe);
                return;
            }
        }
    }

    protected TimerListener createTimeoutTrigger() {
        return new TimerListenerImpl();
    }

    static /* synthetic */ SocketMuxer access$000() {
        return SocketMuxer.makeTheMuxer();
    }

    static {
        rdrThreads = -1;
    }

    protected class TimerListenerImpl
    implements TimerListener {
        protected TimerListenerImpl() {
        }

        @Override
        public void timerExpired(Timer timer) {
            Iterator<MuxableSocket> socks = SocketMuxer.this.getSocketsIterator();
            block6: while (socks.hasNext()) {
                int status;
                MuxableSocket ms = socks.next();
                SocketInfo info = ms.getSocketInfo();
                if (info == null) continue;
                long idleTimeout = ms.getIdleTimeoutMillis();
                long msgTimeout = ms.getCompleteMessageTimeoutMillis();
                switch (info.checkTimeout(idleTimeout, msgTimeout)) {
                    case 0: {
                        continue block6;
                    }
                    case 2: {
                        if (ms.getSocket().isClosed()) {
                            SocketMuxer.this.cleanupSocket(ms, info);
                            continue block6;
                        }
                        if (!Kernel.DEBUG || !Kernel.getDebug().getDebugMuxer() && !Kernel.getDebug().getDebugMuxerConnection()) continue block6;
                        SocketLogger.logSocketMarkedCloseOnly(info.toString(), ms.toString());
                        continue block6;
                    }
                    case 16: {
                        if (Kernel.DEBUG && (Kernel.getDebug().getDebugMuxer() || Kernel.getDebug().getDebugMuxerTimeout())) {
                            SocketLogger.logDebug("Timeout on socket: '" + ms + "', sockInfo: " + ms.getSocketInfo() + ", timeout of: '" + idleTimeout / 1000L + " s");
                        }
                        if (ms.timeout()) break;
                        continue block6;
                    }
                    case 32: {
                        String msg = "A complete message could not be read on socket: '" + ms + "', in the configured timeout period of '" + msgTimeout / 1000L + "' secs";
                        if (Kernel.DEBUG && (Kernel.getDebug().getDebugMuxer() || Kernel.getDebug().getDebugMuxerTimeout())) {
                            SocketLogger.logDebug(msg + ", sockInfo=" + ms.getSocketInfo());
                        }
                        ms.hasException(new IOException(msg));
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                if ((status = info.exceptionHandlingCompleted()) == 0) {
                    SocketMuxer.this.cleanupSocket(ms, info);
                    continue;
                }
                if (status != 4) continue;
                SocketMuxer.this.cancelIo(ms);
            }
        }
    }

    protected static final class SingletonMaker {
        protected static final SocketMuxer singleton = SocketMuxer.access$000();

        protected SingletonMaker() {
        }
    }
}

