/*
 * Decompiled with CFR 0.152.
 */
package weblogic.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import weblogic.socket.SocketMuxer;

public final class WeblogicServerSocket
extends ServerSocket {
    private final ServerSocket serverSocket;

    public WeblogicServerSocket(ServerSocket serverSocket) throws IOException {
        this.serverSocket = serverSocket;
    }

    @Override
    public Socket accept() throws IOException {
        SocketChannel sc = this.serverSocket.getChannel().accept();
        if (sc == null) {
            return null;
        }
        sc.configureBlocking(false);
        return SocketMuxer.getMuxer().newWeblogicSocket(sc.socket());
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        this.serverSocket.bind(endpoint);
    }

    @Override
    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        this.serverSocket.bind(endpoint, backlog);
    }

    @Override
    public InetAddress getInetAddress() {
        return this.serverSocket.getInetAddress();
    }

    @Override
    public int getLocalPort() {
        return this.serverSocket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.serverSocket.getLocalSocketAddress();
    }

    @Override
    public void close() throws IOException {
        this.serverSocket.close();
    }

    @Override
    public ServerSocketChannel getChannel() {
        return this.serverSocket.getChannel();
    }

    @Override
    public boolean isBound() {
        return this.serverSocket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.serverSocket.isClosed();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.serverSocket.setSoTimeout(timeout);
    }

    @Override
    public int getSoTimeout() throws IOException {
        return this.serverSocket.getSoTimeout();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.serverSocket.setReuseAddress(on);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.serverSocket.getReuseAddress();
    }

    @Override
    public String toString() {
        return this.serverSocket.toString();
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.serverSocket.setReceiveBufferSize(size);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.serverSocket.getReceiveBufferSize();
    }
}

