/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import weblogic.store.ObjectHandler;
import weblogic.store.PersistentMapAsyncTX;
import weblogic.store.PersistentStoreConnection;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreTransaction;
import weblogic.store.StoreStatistics;
import weblogic.store.StoreWritePolicy;

public interface PersistentStore {
    public static final String CACHE_DIR_KEY = "CacheDirectory";
    public static final String INIT_SIZE_KEY = "InitialSize";
    public static final String MAX_FILE_SIZE_KEY = "MaxFileSize";
    public static final String MAX_WIN_SIZE_KEY = "MaxWindowBufferSize";
    public static final String MIN_WIN_SIZE_KEY = "MinWindowBufferSize";
    public static final String WRITE_POLICY_KEY = "SynchronousWritePolicy";
    public static final String FILE_LOCKING_KEY = "FileLockingEnabled";
    public static final String DOMAIN_KEY = "DomainName";
    public static final String DAEMON_KEY = "DaemonThreadInClientJVM";
    public static final String OPEN_FAILURES_ARE_FATAL = "OpenFailuresAreFatal";
    public static final String MAX_RETRY_SECONDS = "MaxRetrySeconds";
    public static final String WORKER_COUNT = "WorkerCount";
    public static final String WORKER_PREFERRED_BATCH_SIZE = "WorkerPreferredBatchSize";
    public static final String THREE_STEP_THRESHOLD = "ThreeStepThreshold";
    public static final String LB_STRATEGY = "LBStrategy";
    public static final String ORACLE_PIGGYBACK_COMMIT_ENABLED = "OraclePiggybackCommitEnabled";
    public static final String CONNECTION_CACHING_POLICY = "ConnectionCachingPolicy";
    public static final String ADDRESS_KEY = "Address";
    public static final String BLOCK_SIZE_KEY = "BlockSize";
    public static final String BUSY_WAIT_MICRO_SECONDS_KEY = "BusyWaitMicroSeconds";
    public static final String CANDIDATE_HANDLE_KEY = "CandidateHandle";
    public static final String STORE_CONFIG_NAME_KEY = "StoreConfigName";
    public static final String CONFIG_FILE_NAME_KEY = "ConfigFileName";
    public static final String IO_BUFFER_SIZE_KEY = "IoBufferSize";
    public static final String LOCAL_INDEX_KEY = "LocalIndex";
    public static final String MAX_REPLICA_COUNT_KEY = "MaxReplicaCount";
    public static final String MAXIMUM_MESSAGE_SIZE_PERCENT_KEY = "MaximumMessageSizePercent";
    public static final String MIN_REPLICA_COUNT_KEY = "MinReplicaCount";
    public static final String PORT_KEY = "Port";
    public static final String REGION_SIZE_KEY = "RegionSize";
    public static final String SLEEP_WAIT_MILLI_SECONDS_KEY = "SleepWaitMilliSeconds";
    public static final String SPACE_USAGE_LOGGING_START_PERCENT_KEY = "SpaceLoggingStartPercent";
    public static final String SPACE_USAGE_LOGGING_DELTA_PERCENT_KEY = "SpaceLoggingDeltaPercent";
    public static final String SPACE_USAGE_WARNING_PERCENT_KEY = "SpaceOverloadYellowPercent";
    public static final String SPACE_USAGE_ERROR_PERCENT_KEY = "SpaceOverloadRedPercent";
    public static final String SPACE_USAGE_BATCH_FACTOR_KEY = "SpaceOverloadBatchFactor";
    public static final String DEVICE_POLL_INTERVAL_KEY = "DevicePollIntervalMillis";
    public static final String IS_LOG_ERROR_FOR_MUST_BE_ME = "IslogErrorForMustBeMe";
    public static final String IS_MIGRATABLE = "IsMigratable";
    public static final String IS_RP_ENABLED = "IsRPEnabled";
    public static final String IS_DEFAULT_STORE = "IsDefaultStore";
    public static final List<String> VALID_REPLICATED_IO_KEYS = Collections.unmodifiableList(Arrays.asList("CandidateHandle", "Address", "BlockSize", "BusyWaitMicroSeconds", "StoreConfigName", "ConfigFileName", "IoBufferSize", "LocalIndex", "MaxReplicaCount", "MinReplicaCount", "Port", "RegionSize", "SleepWaitMilliSeconds"));

    public void open(HashMap var1) throws PersistentStoreException;

    @Deprecated
    public void open(StoreWritePolicy var1) throws PersistentStoreException;

    public void unregisterStoreMBean() throws PersistentStoreException;

    public void close() throws PersistentStoreException;

    public PersistentStoreConnection createConnection(String var1) throws PersistentStoreException;

    public PersistentStoreConnection createConnection(String var1, ObjectHandler var2) throws PersistentStoreException;

    public PersistentStoreConnection getConnection(String var1);

    public PersistentMapAsyncTX createPersistentMap(String var1) throws PersistentStoreException;

    public PersistentMapAsyncTX createPersistentMap(String var1, ObjectHandler var2) throws PersistentStoreException;

    public PersistentStoreTransaction begin();

    public StoreStatistics getStatistics();

    public String getName();

    public String getShortName();

    public Iterator getConnectionNames();

    public Iterator getMapConnectionNames();

    public boolean supportsFastReads();

    public Object getConfigValue(Object var1) throws PersistentStoreException;

    public void setConfigValue(Object var1, Object var2) throws PersistentStoreException;

    public PersistentStoreException getFatalException();
}

