/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.kernel.KernelStatus;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreException;
import weblogic.store.common.StoreDebug;
import weblogic.store.internal.PersistentStoreImpl;

public class PersistentStoreManager {
    private static final PersistentStoreManager singleton = new PersistentStoreManager();
    private static final String GLOBAL_ID = "0";
    private Map<String, PersistentStore> ejbTimerStoresByPartition = new HashMap<String, PersistentStore>();
    private final Map<String, Map<String, PersistentStore>> stores = new HashMap<String, Map<String, PersistentStore>>();
    private final Map<String, Map<String, PersistentStore>> storesByLogicalName = new HashMap<String, Map<String, PersistentStore>>();
    private PersistentStore defaultStore;
    private Lock defaultStoreLock = new ReentrantLock(true);

    private PersistentStoreManager() {
    }

    public static PersistentStoreManager getManager() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentStore getStore(String name) {
        PersistentStore store;
        Map<String, PersistentStore> storeMap;
        Map<String, PersistentStore> map = storeMap = this.getStoreMapForPartition();
        synchronized (map) {
            store = storeMap.get(name);
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentStore getStoreByLogicalName(String name) {
        PersistentStore store;
        Map<String, PersistentStore> storeMap;
        Map<String, PersistentStore> map = storeMap = this.getStoreLogicalNameMapForPartition();
        synchronized (map) {
            store = storeMap.get(name);
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentStore getDefaultStore() {
        PersistentStore store;
        ComponentInvocationContext cic;
        if (KernelStatus.isServer() && (cic = ComponentInvocationContextManager.getInstance().getCurrentComponentInvocationContext()) != null && !cic.isGlobalRuntime() && StoreDebug.defaultStoreVerbose.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Default store retrieved by partition ").append(cic.getApplicationName());
            sb.append(" use of the default store is only supported for the global runtime.");
            StoreDebug.defaultStoreVerbose.debug(sb.toString());
        }
        try {
            this.defaultStoreLock.lock();
            store = this.defaultStore;
        }
        finally {
            this.defaultStoreLock.unlock();
        }
        return store;
    }

    public void setDefaultStore(PersistentStore store) {
        try {
            this.defaultStoreLock.lock();
            this.defaultStore = store;
        }
        finally {
            this.defaultStoreLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentStore getEjbTimerStore() {
        PersistentStore ejbTimerStore = null;
        ComponentInvocationContext cic = ComponentInvocationContextManager.getInstance().getCurrentComponentInvocationContext();
        if (StoreDebug.ejbTimerStore.isDebugEnabled()) {
            StoreDebug.ejbTimerStore.debug("Retrieving EjbTimerStore for partition " + cic.getPartitionName() + " (" + cic.getPartitionId() + ").");
        }
        if (cic.isGlobalRuntime()) {
            if (StoreDebug.ejbTimerStore.isDebugEnabled()) {
                StoreDebug.ejbTimerStore.debug("Returing the default store.");
            }
            ejbTimerStore = this.getDefaultStore();
        } else {
            if (StoreDebug.ejbTimerStore.isDebugEnabled()) {
                StoreDebug.ejbTimerStore.debug("Returing an EjbTimerStore.");
            }
            Map<String, PersistentStore> map = this.ejbTimerStoresByPartition;
            synchronized (map) {
                ejbTimerStore = this.ejbTimerStoresByPartition.get(cic.getPartitionId());
            }
        }
        if (StoreDebug.ejbTimerStore.isDebugEnabled()) {
            StoreDebug.ejbTimerStore.debug("EjbTimerStore retrieval for partition " + cic.getPartitionName() + " (" + cic.getPartitionId() + ") done.");
        }
        return ejbTimerStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllEjbTimerStores() {
        if (StoreDebug.ejbTimerStore.isDebugEnabled()) {
            StoreDebug.ejbTimerStore.debug("Removing all EjbTimerStores.");
        }
        Map<String, PersistentStore> map = this.ejbTimerStoresByPartition;
        synchronized (map) {
            for (Map.Entry<String, PersistentStore> ejbTimerStoreEntry : this.ejbTimerStoresByPartition.entrySet()) {
                PersistentStore ejbTimerStore = ejbTimerStoreEntry.getValue();
                String partitionId = ejbTimerStoreEntry.getKey();
                Map<String, PersistentStore> storeMap = this.getStoreMapForPartition(partitionId);
                if (StoreDebug.ejbTimerStore.isDebugEnabled()) {
                    StoreDebug.ejbTimerStore.debug("Removing EjbTimerStore from PersistentStore map");
                }
                Map<String, PersistentStore> map2 = storeMap;
                synchronized (map2) {
                    storeMap.remove(ejbTimerStore.getName());
                }
                if (StoreDebug.ejbTimerStore.isDebugEnabled()) {
                    StoreDebug.ejbTimerStore.debug("EjbTimerStore removed from PersistentStore map");
                }
                try {
                    ejbTimerStore.close();
                }
                catch (Exception e) {
                    if (!StoreDebug.ejbTimerStore.isDebugEnabled()) continue;
                    StoreDebug.ejbTimerStore.debug("Exception while closing EjbTimerStore for partition " + partitionId, e);
                }
            }
            this.ejbTimerStoresByPartition.clear();
        }
        if (StoreDebug.ejbTimerStore.isDebugEnabled()) {
            StoreDebug.ejbTimerStore.debug("All EjbTimerStores have been removed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEjbTimerStore(String partitionId, String serverName, PersistentStore ejbTimerStore) {
        if (ejbTimerStore != null && partitionId != null && !partitionId.equals(GLOBAL_ID)) {
            if (StoreDebug.ejbTimerStore.isDebugEnabled()) {
                StoreDebug.ejbTimerStore.debug("Adding EjbTimerStore for server " + serverName + " for partitionId " + partitionId + "");
            }
            Map<String, PersistentStore> map = this.ejbTimerStoresByPartition;
            synchronized (map) {
                if (!this.ejbTimerStoresByPartition.containsKey(partitionId)) {
                    this.ejbTimerStoresByPartition.put(partitionId, ejbTimerStore);
                }
            }
            if (StoreDebug.ejbTimerStore.isDebugEnabled()) {
                StoreDebug.ejbTimerStore.debug("EjbTimerStore added for server " + serverName + " for partitionId " + partitionId + "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEjbTimerStore(String partitionId, String serverName) {
        if (partitionId != null && !partitionId.equals(GLOBAL_ID)) {
            if (StoreDebug.ejbTimerStore.isDebugEnabled()) {
                StoreDebug.ejbTimerStore.debug("Removing EjbTimerStore for server " + serverName + " for partitionId " + partitionId + "");
            }
            Map<String, PersistentStore> map = this.ejbTimerStoresByPartition;
            synchronized (map) {
                this.ejbTimerStoresByPartition.remove(partitionId);
            }
            if (StoreDebug.ejbTimerStore.isDebugEnabled()) {
                StoreDebug.ejbTimerStore.debug("EjbTimerStore removed for server " + serverName + " for partitionId " + partitionId + "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStore(String name, PersistentStore store) {
        Map<String, PersistentStore> storeMap;
        Map<String, PersistentStore> map = storeMap = this.getStoreMapForPartition();
        synchronized (map) {
            storeMap.put(name, store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStore(String name) {
        Map<String, PersistentStore> storeMap;
        Map<String, PersistentStore> map = storeMap = this.getStoreMapForPartition();
        synchronized (map) {
            storeMap.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoreByLogicalName(String name, PersistentStore store) {
        Map<String, PersistentStore> storeMap;
        Map<String, PersistentStore> map = storeMap = this.getStoreLogicalNameMapForPartition();
        synchronized (map) {
            storeMap.put(name, store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStoreByLogicalName(String name) {
        Map<String, PersistentStore> storeMap;
        Map<String, PersistentStore> map = storeMap = this.getStoreLogicalNameMapForPartition();
        synchronized (map) {
            storeMap.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeExists(String name) {
        boolean exists;
        Map<String, PersistentStore> storeMap;
        Map<String, PersistentStore> map = storeMap = this.getStoreMapForPartition();
        synchronized (map) {
            exists = storeMap.containsKey(name);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeExistsByLogicalName(String name) {
        boolean exists;
        Map<String, PersistentStore> storeLogicalNameMap;
        Map<String, PersistentStore> map = storeLogicalNameMap = this.getStoreLogicalNameMapForPartition();
        synchronized (map) {
            exists = storeLogicalNameMap.containsKey(name);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<PersistentStore> getAllStores() {
        ArrayList<PersistentStore> storesCopy = new ArrayList<PersistentStore>();
        try {
            this.defaultStoreLock.lock();
            if (this.defaultStore != null) {
                storesCopy.add(this.defaultStore);
            }
        }
        finally {
            this.defaultStoreLock.unlock();
        }
        Map<String, Map<String, PersistentStore>> map = this.stores;
        synchronized (map) {
            for (Map<String, PersistentStore> map2 : this.stores.values()) {
                storesCopy.addAll(map2.values());
            }
        }
        return Collections.unmodifiableList(storesCopy).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFileStore(String name) throws PersistentStoreException {
        PersistentStore deadStore;
        Map<String, Map<String, PersistentStore>> map = this.stores;
        synchronized (map) {
            Map<String, PersistentStore> storeMap = this.getStoreMapForPartition();
            deadStore = storeMap.remove(name);
        }
        if (deadStore != null) {
            deadStore.close();
        }
    }

    public void dump(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("PersistentStores");
        xsw.writeStartElement("DefaultStore");
        ((PersistentStoreImpl)this.defaultStore).dump(xsw);
        xsw.writeEndElement();
        Iterator<PersistentStore> allStores = this.getAllStores();
        while (allStores.hasNext()) {
            PersistentStoreImpl store = (PersistentStoreImpl)allStores.next();
            store.dump(xsw);
        }
        xsw.writeEndElement();
    }

    private Map<String, PersistentStore> getStoreLogicalNameMapForPartition() {
        return this.getStoreLogicalNameMapForPartition(this.getPartitionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, PersistentStore> getStoreLogicalNameMapForPartition(String partitionId) {
        Map<String, PersistentStore> logicalStoreMap;
        Map<String, Map<String, PersistentStore>> map = this.storesByLogicalName;
        synchronized (map) {
            logicalStoreMap = this.storesByLogicalName.get(partitionId);
            if (logicalStoreMap == null) {
                logicalStoreMap = new HashMap<String, PersistentStore>();
                this.storesByLogicalName.put(partitionId, logicalStoreMap);
            }
        }
        return logicalStoreMap;
    }

    private Map<String, PersistentStore> getStoreMapForPartition() {
        return this.getStoreMapForPartition(this.getPartitionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, PersistentStore> getStoreMapForPartition(String partitionId) {
        Map<String, PersistentStore> storeMap;
        Map<String, Map<String, PersistentStore>> map = this.stores;
        synchronized (map) {
            storeMap = this.stores.get(partitionId);
            if (storeMap == null) {
                storeMap = new HashMap<String, PersistentStore>();
                this.stores.put(partitionId, storeMap);
            }
        }
        return storeMap;
    }

    private String getPartitionId() {
        String partitionId = null;
        try {
            ComponentInvocationContext cic;
            if (KernelStatus.isServer() && (cic = ComponentInvocationContextManager.getInstance().getCurrentComponentInvocationContext()) != null) {
                partitionId = cic.getPartitionId();
            }
        }
        catch (Exception e) {
            StoreDebug.persistentStoreManager.debug(e.getMessage(), e);
        }
        return partitionId;
    }
}

