/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.internal;

import java.nio.ByteBuffer;
import weblogic.store.PersistentStoreException;
import weblogic.store.internal.DeleteRequest;
import weblogic.store.internal.PersistentHandleImpl;
import weblogic.store.internal.PersistentStoreConnectionImpl;
import weblogic.store.internal.ReadRequest;
import weblogic.store.internal.StoreRequest;
import weblogic.store.internal.UpdateRequest;
import weblogic.store.io.PersistentStoreIO;

final class CreateRequest
extends StoreRequest {
    private ByteBuffer[] data;

    CreateRequest(PersistentHandleImpl handle, PersistentStoreConnectionImpl connection, ByteBuffer[] data, int flags) {
        this(handle, connection, data, flags, -1L, -1L);
    }

    CreateRequest(PersistentHandleImpl handle, PersistentStoreConnectionImpl connection, ByteBuffer[] data, int flags, long flushGroup, long liveSequence) {
        super(handle, connection, flags, flushGroup, liveSequence);
        this.data = data;
    }

    @Override
    void run(PersistentStoreIO ios) throws PersistentStoreException {
        if (this.getCrashTestException() != null) {
            if (this.getCrashTestException() instanceof PersistentStoreException) {
                ios.setTestException(this.getCrashTestException());
            } else {
                this.setError(this.getCrashTestException());
            }
        }
        ios.create(this.handle.getStoreHandle(), this.typeCode, this.data, this.flags);
        this.connection.getStatisticsImpl().incrementCreateCount();
    }

    final synchronized void setCrashTestException(PersistentStoreException arg) {
        this.crashTestException = arg;
    }

    @Override
    boolean requiresFlush() {
        return true;
    }

    @Override
    void coalesce(StoreRequest other) {
        switch (other.getType()) {
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return;
            }
            case 2: {
                ReadRequest read = (ReadRequest)other;
                ByteBuffer[] bodyCopy = null;
                if (this.data != null) {
                    bodyCopy = new ByteBuffer[this.data.length];
                    for (int i = 0; i < bodyCopy.length; ++i) {
                        bodyCopy[i] = this.data[i].duplicate();
                    }
                }
                read.override(bodyCopy);
                read.finishIO();
                return;
            }
            case 3: {
                UpdateRequest update = (UpdateRequest)other;
                this.data = update.getData();
                update.finishIO();
                return;
            }
            case 4: {
                DeleteRequest delete = (DeleteRequest)other;
                delete.finishIO();
                if (!this.isIOFinished()) {
                    this.connection.getStoreImpl().releaseHandle(this.typeCode, this.handle);
                    this.finishIO();
                }
                return;
            }
        }
        throw new AssertionError((Object)("Unknown type: " + other.getType()));
    }

    @Override
    int getType() {
        return 1;
    }
}

