/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.internal;

import java.util.ArrayList;
import weblogic.store.ObjectHandler;
import weblogic.store.PersistentStoreException;
import weblogic.store.internal.PersistentStoreConnectionImpl;
import weblogic.store.internal.PersistentStoreRecordImpl;
import weblogic.store.internal.StoreRequest;
import weblogic.store.io.IORecord;
import weblogic.store.io.PersistentStoreIO;

class CursorRequest
extends StoreRequest {
    private final int batchSize;
    private final ObjectHandler handler;
    private PersistentStoreIO.Cursor ioCursor;
    private ArrayList retList;

    CursorRequest(PersistentStoreConnectionImpl conn, int batchSize, PersistentStoreIO.Cursor curs, ObjectHandler handler, int flags) {
        super(null, conn, flags);
        this.batchSize = batchSize;
        this.handler = handler;
        this.ioCursor = curs;
    }

    @Override
    void run(PersistentStoreIO ios) throws PersistentStoreException {
        if (this.ioCursor == null) {
            this.ioCursor = ios.createCursor(this.typeCode, this.flags);
        }
        ArrayList<PersistentStoreRecordImpl> rl = new ArrayList<PersistentStoreRecordImpl>(this.batchSize);
        for (int i = 0; i < this.batchSize; ++i) {
            IORecord iorec = this.ioCursor.next();
            if (iorec == null) {
                rl.add(null);
                break;
            }
            PersistentStoreRecordImpl psr = new PersistentStoreRecordImpl(iorec, this.handler, this.connection, true);
            rl.add(psr);
            this.connection.getStatisticsImpl().incrementReadCount();
            this.connection.getStoreImpl().getStatisticsImpl().incrementPhysicalReadCount();
        }
        this.retList = rl;
    }

    @Override
    Object getResult() {
        return this.retList;
    }

    @Override
    boolean requiresFlush() {
        return false;
    }

    @Override
    void coalesce(StoreRequest other) {
    }

    @Override
    int getType() {
        return 7;
    }

    PersistentStoreIO.Cursor getCursor() {
        return this.ioCursor;
    }
}

