/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.internal;

import weblogic.store.PersistentStoreException;
import weblogic.store.StoreLogger;
import weblogic.store.internal.PersistentHandleImpl;
import weblogic.store.internal.PersistentStoreConnectionImpl;
import weblogic.store.internal.StoreRequest;
import weblogic.store.io.PersistentStoreIO;

final class DeleteRequest
extends StoreRequest {
    DeleteRequest(PersistentHandleImpl handle, PersistentStoreConnectionImpl connection, int flags) {
        this(handle, connection, flags, -1L, -1L);
    }

    DeleteRequest(PersistentHandleImpl handle, PersistentStoreConnectionImpl connection, int flags, long flushGroup, long liveSequence) {
        super(handle, connection, flags, flushGroup, liveSequence);
        if (handle.getStoreHandle() == -1) {
            throw new AssertionError((Object)"Attempting to delete record that has already been deleted");
        }
    }

    @Override
    void run(PersistentStoreIO ios) throws PersistentStoreException {
        ios.delete(this.handle.getStoreHandle(), this.typeCode, this.flags);
        this.connection.getStatisticsImpl().incrementDeleteCount();
    }

    @Override
    protected boolean requiresFlush() {
        return true;
    }

    @Override
    void coalesce(StoreRequest other) {
        switch (other.getType()) {
            case 4: {
                other.finishIO();
                return;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return;
            }
        }
        other.finishIO();
        other.setError(new PersistentStoreException(StoreLogger.logStoreRecordNotFoundLoggable(this.handle.getStoreHandle())));
    }

    @Override
    public int getType() {
        return 4;
    }
}

