/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.internal;

import weblogic.store.PersistentStoreException;
import weblogic.store.internal.OperationStatisticsImpl;
import weblogic.store.internal.PersistentHandleImpl;
import weblogic.store.internal.PersistentStoreConnectionImpl;
import weblogic.store.internal.StoreRequest;
import weblogic.store.io.PersistentStoreIO;

class DropRequest
extends StoreRequest {
    private int currDeleteCount = 1;
    private PersistentStoreConnectionImpl sysConn;
    private PersistentHandleImpl sysConnPH;

    DropRequest(PersistentStoreConnectionImpl conn, PersistentStoreConnectionImpl sysConn, PersistentHandleImpl sysConnPH) {
        super(null, conn, 0);
        this.sysConn = sysConn;
        this.sysConnPH = sysConnPH;
    }

    @Override
    void run(PersistentStoreIO ios) throws PersistentStoreException {
        if (this.currDeleteCount <= 0) {
            return;
        }
        this.currDeleteCount = ios.drop(this.connection.getTypeCode());
        if (this.currDeleteCount > 0) {
            OperationStatisticsImpl stats = this.connection.getStatisticsImpl();
            stats.incrementDeleteCount(this.currDeleteCount);
            this.connection.getStoreImpl().scheduleSelf(this);
        } else {
            ios.delete(this.sysConnPH.getStoreHandle(), this.sysConn.getTypeCode(), this.flags);
        }
    }

    @Override
    boolean requiresFlush() {
        return true;
    }

    @Override
    void coalesce(StoreRequest other) {
    }

    @Override
    int getType() {
        return 5;
    }
}

