/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.internal;

import java.util.HashMap;
import java.util.LinkedList;
import weblogic.store.internal.LockManager;

public final class LockManagerImpl
implements LockManager {
    private final HashMap locks = new HashMap();

    @Override
    public void lock(Object owner, Object key) {
        assert (owner != null);
        Lock l = this.getLock(owner, key);
        l.acquire(owner);
    }

    @Override
    public void lock(Object owner, Object key, LockManager.Listener listener) {
        assert (owner != null);
        Lock l = this.getLock(owner, key);
        l.acquire(owner, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Object owner, Object key) {
        Lock l;
        HashMap hashMap = this.locks;
        synchronized (hashMap) {
            l = (Lock)this.locks.get(key);
            if (l == null) {
                throw new IllegalStateException("not owner");
            }
        }
        l.release(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lock getLock(Object proposedOwner, Object key) {
        Lock l;
        HashMap hashMap = this.locks;
        synchronized (hashMap) {
            l = (Lock)this.locks.get(key);
            if (l == null) {
                l = new Lock(proposedOwner, key);
                this.locks.put(key, l);
            }
            l.useCount++;
        }
        return l;
    }

    final class Lock {
        private Object owner;
        private int recursionCnt;
        private int numSyncWaiters;
        private LinkedList asyncWaiters;
        private final Object key;
        private int useCount;

        private Lock(Object proposedOwner, Object argKey) {
            this.owner = proposedOwner;
            this.key = argKey;
        }

        public synchronized void acquire(Object owner) {
            while (this.owner != null && !this.owner.equals(owner)) {
                try {
                    ++this.numSyncWaiters;
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
                finally {
                    --this.numSyncWaiters;
                }
            }
            this.owner = owner;
            ++this.recursionCnt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire(Object owner, LockManager.Listener listener) {
            Lock lock = this;
            synchronized (lock) {
                if (this.owner != null && !this.owner.equals(owner)) {
                    if (this.asyncWaiters == null) {
                        this.asyncWaiters = new LinkedList();
                    }
                    this.asyncWaiters.add(new AwaitingListener(owner, listener));
                    return;
                }
                this.owner = owner;
                ++this.recursionCnt;
            }
            listener.onLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(Object owner) {
            AwaitingListener awaitingListener;
            Lock lock = this;
            synchronized (lock) {
                if (this.owner != owner) {
                    throw new IllegalStateException("not owner (" + this.owner + " != " + owner);
                }
                --this.recursionCnt;
                if (this.recursionCnt > 0) {
                    return;
                }
                this.owner = null;
                if (this.numSyncWaiters > 0) {
                    this.notify();
                    return;
                }
                if (this.asyncWaiters == null) {
                    HashMap hashMap = LockManagerImpl.this.locks;
                    synchronized (hashMap) {
                        --this.useCount;
                        if (this.useCount < 1) {
                            LockManagerImpl.this.locks.remove(this.key);
                        }
                    }
                    return;
                }
                awaitingListener = (AwaitingListener)this.asyncWaiters.removeFirst();
                if (this.asyncWaiters.isEmpty()) {
                    this.asyncWaiters = null;
                }
                this.owner = awaitingListener.owner;
                ++this.recursionCnt;
            }
            awaitingListener.listener.onLock();
        }

        private final class AwaitingListener {
            final Object owner;
            final LockManager.Listener listener;

            AwaitingListener(Object owner, LockManager.Listener listener) {
                this.owner = owner;
                this.listener = listener;
            }
        }
    }
}

