/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.internal;

import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.common.CompletionRequest;
import weblogic.kernel.KernelStatus;
import weblogic.store.DefaultObjectHandler;
import weblogic.store.ObjectHandler;
import weblogic.store.OperationStatistics;
import weblogic.store.PersistentHandle;
import weblogic.store.PersistentMap;
import weblogic.store.PersistentMapAsyncTX;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreConnection;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreFatalException;
import weblogic.store.PersistentStoreRecord;
import weblogic.store.PersistentStoreTestException;
import weblogic.store.PersistentStoreTransaction;
import weblogic.store.RuntimeHandler;
import weblogic.store.RuntimeUpdater;
import weblogic.store.StoreLogger;
import weblogic.store.StoreStatistics;
import weblogic.store.StoreWritePolicy;
import weblogic.store.common.PartitionNameUtils;
import weblogic.store.common.StoreDebug;
import weblogic.store.internal.DropRequest;
import weblogic.store.internal.FlushUnit;
import weblogic.store.internal.PersistentHandleImpl;
import weblogic.store.internal.PersistentMapImpl;
import weblogic.store.internal.PersistentStoreConnectionImpl;
import weblogic.store.internal.PersistentStoreTransactionImpl;
import weblogic.store.internal.PollRequest;
import weblogic.store.internal.ReadRequest;
import weblogic.store.internal.ReopenRequest;
import weblogic.store.internal.StoreRequest;
import weblogic.store.internal.StoreStatisticsImpl;
import weblogic.store.internal.TransactionUnit;
import weblogic.store.io.IOListener;
import weblogic.store.io.PersistentStoreIO;
import weblogic.store.io.file.BaseStoreIO;
import weblogic.store.io.file.ReplicatedStoreIO;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.concurrent.ConcurrentBlockingQueue;
import weblogic.utils.concurrent.ConcurrentFactory;

public class PersistentStoreImpl
implements PersistentStore,
Runnable {
    private static final boolean VERBOSE_DIAGNOSTICS;
    public static final String DEFAULT_STORE_NAME_PREFIX = "_WLS_";
    public static final String JDBC_TLOG_DECORATION = "JTA_JDBCTLOGStore";
    private static final String THREAD_PREFIX = "weblogic.store.";
    private static boolean openFailureTestEnabled;
    private static final String SYNC_DESERIALIZERS;
    private static final HashSet<String> syncDeserializerSet;
    private String storeName;
    private String storeShortName;
    private RuntimeHandler adminHandler;
    private RuntimeUpdater mbean;
    PersistentStoreIO ios;
    private final ConcurrentBlockingQueue pendingRequests = ConcurrentFactory.createConcurrentBlockingQueue();
    private final ReusableCompletionRequest shutdownTask = new ReusableCompletionRequest();
    private final CallerClassUtil callerClassUtil = new CallerClassUtil();
    private Timer daemonPollTimer;
    private int devicePollInterval;
    private PersistentStoreConnectionImpl systemConnection;
    StoreStatisticsImpl statistics;
    private int nextTypeCode = 1;
    static final int INVALID_TYPECODE = -1;
    protected static final byte MAP_TYPE = 1;
    protected static final byte DEFAULT_TYPE = 0;
    final Map<ConnectionKey, ConnectionInfo> connections = Collections.synchronizedMap(new HashMap());
    protected final HashMap<String, PersistentMap> maps = new HashMap();
    volatile boolean isOpen;
    private PersistentStoreException fatalException;
    private boolean healthSetterComplete = true;
    final HashMap<String, Object> config = new HashMap();
    private WorkManager wm;
    private static final int LOAD_DIST_SIZE = 100;
    private static final int HIGH_LOAD_THRESHOLD = 80;
    private static final int LOW_LOAD_THRESHOLD = 20;
    private boolean enforceWorkerFlush = false;

    private static int getDevicePollIntervalMillis(String name) {
        int interval = Math.abs(ReplicatedStoreIO.getIntConfiguration(null, "DevicePollIntervalMillis", name, ".DevicePollIntervalMillis", 1000));
        if (interval == 0) {
            interval = 1000;
        }
        if (interval > 1000) {
            interval = 1000;
        }
        if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
            StoreDebug.storeIOPhysical.debug("PersistentStoreImpl: " + name + "." + ".DevicePollIntervalMillis" + ":" + interval);
        }
        return interval;
    }

    public PersistentStoreImpl(String storeName, PersistentStoreIO ios) throws PersistentStoreException {
        this(storeName, ios, null);
    }

    public PersistentStoreImpl() {
    }

    public PersistentStoreImpl(String name, PersistentStoreIO ios, RuntimeHandler adminHandler) throws PersistentStoreException {
        this.init_internal(name, ios);
        this.adminHandler = adminHandler;
        if (adminHandler != null) {
            this.mbean = adminHandler.createStoreMBean(this);
        }
    }

    private void init_internal(String name, PersistentStoreIO ios) {
        this.storeName = name;
        this.storeShortName = PartitionNameUtils.stripDecoratedPartitionName(name);
        this.devicePollInterval = PersistentStoreImpl.getDevicePollIntervalMillis(this.storeName);
        this.statistics = new StoreStatisticsImpl(name);
        this.ios = ios;
        if (ios.supportsFastReads()) {
            ((BaseStoreIO)ios).setStats(this.statistics);
        }
    }

    protected void init(String storeName, PersistentStoreIO ios, RuntimeHandler handler) throws PersistentStoreException {
        this.adminHandler = handler;
        this.init(storeName, ios);
    }

    protected void init(String storeName, PersistentStoreIO ios) throws PersistentStoreException {
        if (this.storeName != null) {
            throw new PersistentStoreException("Already constructed store " + storeName);
        }
        this.init_internal(storeName, ios);
    }

    public void setWorkManager(WorkManager wm) {
        this.wm = wm;
    }

    @Override
    public boolean supportsFastReads() {
        return this.ios.supportsFastReads();
    }

    public RuntimeUpdater getMBean() {
        return this.mbean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFatalException(PersistentStoreFatalException e) {
        PersistentStoreException exceptionToLog = null;
        if (StoreDebug.storeAdmin.isDebugEnabled()) {
            StoreDebug.storeAdmin.debug("setFatalException: e: " + e.getMessage());
        }
        PersistentStoreImpl persistentStoreImpl = this;
        synchronized (persistentStoreImpl) {
            if (e == null) {
                this.fatalException = null;
            } else if (this.fatalException == null) {
                this.fatalException = e.getCause() != null && e.getCause() instanceof PersistentStoreException ? (PersistentStoreException)e.getCause() : e;
                exceptionToLog = this.fatalException;
            }
        }
        if (StoreDebug.storeAdmin.isDebugEnabled()) {
            StoreDebug.storeAdmin.debug("setFatalException: exceptionToLog: " + exceptionToLog.getMessage());
        }
        if (exceptionToLog != null) {
            if (!this.isSpecialStore()) {
                StoreLogger.logFatalExceptionEncountered(this.storeName, exceptionToLog.toString(), exceptionToLog);
            }
            this.healthFailed(exceptionToLog);
        }
    }

    @Override
    public synchronized PersistentStoreException getFatalException() {
        return this.fatalException;
    }

    public synchronized boolean isHealthSetterComplete() {
        return this.healthSetterComplete;
    }

    public synchronized void setHealthSetterComplete(boolean healthSetterComplete) {
        this.healthSetterComplete = healthSetterComplete;
    }

    private boolean isTLOGJDBCStore() {
        return this.storeName.contains(JDBC_TLOG_DECORATION);
    }

    private boolean isDefaultStoreOfOtherServer() {
        return this.storeName.startsWith(DEFAULT_STORE_NAME_PREFIX) && !this.isDefaultStore();
    }

    private boolean isMigratable() {
        if (!this.config.containsKey("IsMigratable")) {
            return false;
        }
        try {
            return (Boolean)this.config.get("IsMigratable");
        }
        catch (Exception e) {
            if (StoreDebug.storeIOLogical.isDebugEnabled()) {
                StoreDebug.storeIOLogical.debug("Bad value in config for PersistentStore.IS_MIGRATABLE; defaulting to FALSE", e);
            }
            return false;
        }
    }

    private boolean isRPEnabled() {
        if (!this.config.containsKey("IsRPEnabled")) {
            return false;
        }
        try {
            return (Boolean)this.config.get("IsRPEnabled");
        }
        catch (Exception e) {
            if (StoreDebug.storeIOLogical.isDebugEnabled()) {
                StoreDebug.storeIOLogical.debug("Bad value in config for PersistentStore.IS_RP_ENABLED; defaulting to FALSE", e);
            }
            return false;
        }
    }

    private boolean isDefaultStore() {
        if (!this.config.containsKey("IsDefaultStore")) {
            return false;
        }
        try {
            return (Boolean)this.config.get("IsDefaultStore");
        }
        catch (Exception e) {
            if (StoreDebug.storeIOLogical.isDebugEnabled()) {
                StoreDebug.storeIOLogical.debug("Bad value in config for PersistentStore.IS_DEFAULT_STORE; defaulting to FALSE", e);
            }
            return false;
        }
    }

    public boolean isSpecialStore() {
        if (StoreDebug.storeAdmin.isDebugEnabled()) {
            StoreDebug.storeAdmin.debug("PersistentStoreImpl.isSpecialStore(): name: " + this.storeName + " isTLOGJDBCStore: " + this.isTLOGJDBCStore() + " isDefaultStoreOfOtherServer: " + this.isDefaultStoreOfOtherServer() + " isMigratable: " + this.isMigratable() + " isRPEnabled: " + this.isRPEnabled());
        }
        return this.isTLOGJDBCStore() || this.isDefaultStoreOfOtherServer() || this.isMigratable() || this.isRPEnabled();
    }

    @Override
    public PersistentStoreConnection createConnection(String name) throws PersistentStoreException {
        return this.createConnectionInternal(name, (byte)0);
    }

    private static boolean deserializeOnline(Class caller) {
        String callerName = caller.getName();
        int nextDot = callerName.indexOf(46);
        while (nextDot >= 0) {
            String prefix = callerName.substring(0, nextDot);
            if (syncDeserializerSet.contains(prefix)) {
                return true;
            }
            nextDot = callerName.indexOf(46, nextDot + 1);
        }
        return syncDeserializerSet.contains(callerName);
    }

    @Override
    public PersistentStoreConnection createConnection(String name, ObjectHandler handler) throws PersistentStoreException {
        PersistentStoreConnectionImpl ret = (PersistentStoreConnectionImpl)this.createConnectionInternal(name, (byte)0);
        ret.setObjectHandler(handler);
        return ret;
    }

    @Override
    public PersistentStoreConnection getConnection(String name) {
        return this.getConnectionInternal(name, (byte)0);
    }

    public PersistentStoreConnection getMapConnection(String name) {
        return this.getConnectionInternal(name, (byte)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistentStoreConnection getConnectionInternal(String name, byte kind) {
        ConnectionKey key = new ConnectionKey(name, kind);
        Map<ConnectionKey, ConnectionInfo> map = this.connections;
        synchronized (map) {
            ConnectionInfo connInfo = this.connections.get(key);
            return connInfo == null ? null : connInfo.getConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentStoreConnection createConnectionInternal(String name, byte kind) throws PersistentStoreException {
        this.checkOpen();
        if (!PersistentStoreImpl.checkName(name)) {
            throw new PersistentStoreException(StoreLogger.logInvalidStoreConnectionNameLoggable(name));
        }
        ConnectionKey key = new ConnectionKey(name, kind);
        Map<ConnectionKey, ConnectionInfo> map = this.connections;
        synchronized (map) {
            PersistentStoreConnectionImpl conn;
            ConnectionInfo connInfo = this.connections.get(key);
            if (connInfo == null) {
                connInfo = new ConnectionInfo(this.nextTypeCode++, name, kind);
                this.connections.put(key, connInfo);
                PersistentStoreTransaction ptx = this.begin();
                PersistentHandle handle = this.systemConnection.create(ptx, connInfo, 0);
                ptx.commit();
                connInfo.setHandle((PersistentHandleImpl)handle);
            }
            if ((conn = connInfo.getConnection()) == null) {
                conn = new PersistentStoreConnectionImpl(key, this, connInfo.typeCode);
                int initialObjectCount = this.ios.getNumObjects(connInfo.typeCode);
                conn.getStatisticsImpl().setInitialObjectCount(initialObjectCount);
                connInfo.setConnection(conn);
                this.registerConnection(conn);
            }
            conn.setObjectHandler(DefaultObjectHandler.THE_ONE);
            Class caller = this.callerClassUtil.getCallerClass();
            conn.onlineDeserializationPossible = this.supportsFastReads() && PersistentStoreImpl.deserializeOnline(caller);
            return conn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistentMapAsyncTX createPersistentMap(String name) throws PersistentStoreException {
        HashMap<String, PersistentMap> hashMap = this.maps;
        synchronized (hashMap) {
            PersistentMapAsyncTX pMap = (PersistentMapAsyncTX)this.maps.get(name);
            if (pMap == null) {
                PersistentStoreConnection keys = this.createConnectionInternal(name, (byte)1);
                PersistentStoreConnection values = this.createConnectionInternal(name + ".values", (byte)1);
                pMap = new PersistentMapImpl(keys, values);
                this.maps.put(name, pMap);
            }
            return pMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistentMapAsyncTX createPersistentMap(String name, ObjectHandler handler) throws PersistentStoreException {
        HashMap<String, PersistentMap> hashMap = this.maps;
        synchronized (hashMap) {
            PersistentMapAsyncTX pMap = (PersistentMapAsyncTX)this.maps.get(name);
            if (pMap == null) {
                PersistentStoreConnection keys = this.createConnectionInternal(name, (byte)1);
                PersistentStoreConnection values = this.createConnectionInternal(name + ".values", (byte)1);
                pMap = new PersistentMapImpl(keys, values, handler);
                this.maps.put(name, pMap);
            }
            return pMap;
        }
    }

    PersistentStoreIO.Cursor createCursor(int typeCode, int flags) throws PersistentStoreException {
        return this.ios.createCursor(typeCode, flags);
    }

    @Override
    public PersistentStoreTransaction begin() {
        return new PersistentStoreTransactionImpl(this);
    }

    @Override
    @Deprecated
    public void open(StoreWritePolicy wp) throws PersistentStoreException {
        HashMap<String, StoreWritePolicy> config = new HashMap<String, StoreWritePolicy>();
        config.put("SynchronousWritePolicy", wp);
        this.open(config);
    }

    @Override
    public synchronized void open(HashMap config) throws PersistentStoreException {
        if (this.isOpen) {
            throw new PersistentStoreException(StoreLogger.logStoreAlreadyOpenLoggable(this.storeName));
        }
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(PersistentStoreImpl.class.getClassLoader());
        String originalThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(originalThreadName + " [Store:" + this.storeName + "]");
            this.recoverStoreConnections(config);
        }
        catch (PersistentStoreException pse) {
            Boolean openFailuresAreFatal;
            block19: {
                if (this.ios != null) {
                    try {
                        this.ios.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                openFailuresAreFatal = Boolean.TRUE;
                if (config.containsKey("OpenFailuresAreFatal")) {
                    try {
                        openFailuresAreFatal = (Boolean)config.get("OpenFailuresAreFatal");
                    }
                    catch (Exception e) {
                        openFailuresAreFatal = Boolean.TRUE;
                        if (!StoreDebug.storeIOLogical.isDebugEnabled()) break block19;
                        StoreDebug.storeIOLogical.debug("Bad value in config for PersistentStore.OPEN_FAILURES_ARE_FATAL; defaulting to TRUE", e);
                    }
                }
            }
            PersistentStoreFatalException psfe = pse instanceof PersistentStoreFatalException ? (PersistentStoreFatalException)pse : new PersistentStoreFatalException(pse);
            if (openFailuresAreFatal.booleanValue()) {
                this.setFatalException(psfe);
            } else {
                if (StoreDebug.storeIOLogical.isDebugEnabled()) {
                    StoreDebug.storeIOLogical.debug("Non-fatal error while openeing store " + this.storeName + " mbean: " + this.mbean, pse);
                }
                StoreLogger.logNonFatalFailureWhileOpening(this.storeName);
                if (this.mbean != null) {
                    if (StoreDebug.storeIOLogical.isDebugEnabled()) {
                        StoreDebug.storeIOLogical.debug("Calling mbean.setHealthWarn()");
                    }
                    this.mbean.setHealthWarn(StoreLogger.logNonFatalFailureWhileOpeningLoggable(this.storeName).getMessage());
                }
            }
            throw psfe;
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
            Thread.currentThread().setContextClassLoader(ccl);
        }
        if (this.ios instanceof ReplicatedStoreIO) {
            this.daemonPollTimer = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)new DevicePollTimerListener(), this.devicePollInterval, (long)this.devicePollInterval);
        }
    }

    private void recoverStoreConnections(HashMap<String, Object> externalConfig) throws PersistentStoreException {
        if (StoreDebug.storeIOLogical.isDebugEnabled()) {
            StoreDebug.storeIOLogical.debug("PersistentStoreImpl.recoverStoreConnections");
        }
        if (externalConfig != null) {
            this.setConfigInternal(externalConfig);
        }
        int recovered = this.ios.open(externalConfig);
        if (openFailureTestEnabled && this.storeName.contains("JMSStoreMT1")) {
            throw new PersistentStoreException("TESTING BUG32312961");
        }
        this.statistics.setInitialObjectCount(recovered);
        ConnectionKey systemKey = new ConnectionKey("wlsystem", -1);
        this.systemConnection = new PersistentStoreConnectionImpl(systemKey, this, 0);
        PersistentStoreConnection.Cursor cursor = this.systemConnection.createCursor(64);
        ArrayList<DropRequest> deletedConnList = new ArrayList<DropRequest>();
        PersistentStoreRecord rec = cursor.next();
        while (rec != null) {
            ConnectionInfo connInfo = (ConnectionInfo)rec.getData();
            connInfo.setHandle((PersistentHandleImpl)rec.getHandle());
            if (connInfo.typeCode >= this.nextTypeCode) {
                this.nextTypeCode = connInfo.typeCode + 1;
            }
            ConnectionKey key = new ConnectionKey(connInfo.connectionName, connInfo.kind);
            connInfo.connection = new PersistentStoreConnectionImpl(key, this, connInfo.typeCode);
            int initialObjectCount = this.ios.getNumObjects(connInfo.typeCode);
            connInfo.connection.getStatisticsImpl().setInitialObjectCount(initialObjectCount);
            if (connInfo.getDeleted()) {
                DropRequest dr = new DropRequest(connInfo.connection, this.systemConnection, connInfo.getHandle());
                deletedConnList.add(dr);
            } else {
                this.registerConnection(connInfo.connection);
                this.connections.put(key, connInfo);
            }
            rec = cursor.next();
        }
        if (this.wm == null) {
            Thread storeThread = new Thread(this);
            if (StoreDebug.storeIOLogical.isDebugEnabled()) {
                StoreDebug.storeIOLogical.debug("PersistentStoreImpl.recoverStoreConnections: workmanager undefined; starting daemon thread " + storeThread);
            }
            boolean useClientDaemon = false;
            if (KernelStatus.isEmbedded()) {
                useClientDaemon = true;
            } else {
                Object daemonValue = this.config.get("DaemonThreadInClientJVM");
                if (daemonValue != null) {
                    useClientDaemon = (Boolean)daemonValue;
                }
            }
            storeThread.setDaemon(useClientDaemon);
            storeThread.start();
        } else {
            try {
                if (StoreDebug.storeIOLogical.isDebugEnabled()) {
                    StoreDebug.storeIOLogical.debug("PersistentStoreImpl.recoverStoreConnections: using defined workmanager");
                }
                this.wm.schedule(new Work(){

                    @Override
                    public void run() {
                        PersistentStoreImpl.this.run();
                    }

                    @Override
                    public boolean isDaemon() {
                        return true;
                    }

                    @Override
                    public void release() {
                    }

                    public String toString() {
                        return PersistentStoreImpl.THREAD_PREFIX + PersistentStoreImpl.this.storeName;
                    }
                });
            }
            catch (WorkException we) {
                throw new AssertionError((Object)we);
            }
        }
        this.isOpen = true;
        Iterator iter = deletedConnList.iterator();
        while (iter.hasNext()) {
            this.schedule((DropRequest)iter.next());
        }
    }

    PersistentHandleImpl allocateHandle(int typeCode) {
        int handle = this.ios.allocateHandle(typeCode);
        if (handle == -1) {
            throw new AssertionError();
        }
        return new PersistentHandleImpl(typeCode, handle);
    }

    boolean isHandleReadable(PersistentHandleImpl phi) {
        return this.ios.isHandleReadable(phi.getTypeCode(), phi.getStoreHandle());
    }

    void ensureHandleAllocated(PersistentHandleImpl phi) {
        this.ios.ensureHandleAllocated(phi.getTypeCode(), phi.getStoreHandle());
    }

    void releaseHandle(int typeCode, PersistentHandleImpl handle) {
        if (handle.getStoreHandle() != -1) {
            this.ios.releaseHandle(typeCode, handle.getStoreHandle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(StoreRequest sr) {
        boolean storeClosed = false;
        ConcurrentBlockingQueue concurrentBlockingQueue = this.pendingRequests;
        synchronized (concurrentBlockingQueue) {
            if (this.isOpen) {
                this.pendingRequests.offer(sr);
            } else {
                storeClosed = true;
            }
        }
        if (storeClosed) {
            sr.handleError(new PersistentStoreException(StoreLogger.logStoreNotOpenLoggable(this.storeName)));
        }
    }

    void scheduleSelf(StoreRequest sr) {
        if (this.isOpen) {
            this.pendingRequests.offer(sr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(List<StoreRequest> newRequests, CompletionRequest cr) {
        if (newRequests.isEmpty()) {
            cr.setResult(null);
            return;
        }
        StoreRequest first = newRequests.get(0);
        first.setCompletionRequest(cr);
        boolean storeClosed = false;
        ConcurrentBlockingQueue concurrentBlockingQueue = this.pendingRequests;
        synchronized (concurrentBlockingQueue) {
            if (this.isOpen) {
                this.pendingRequests.offer(newRequests);
            } else {
                storeClosed = true;
            }
        }
        if (storeClosed) {
            first.handleError(new PersistentStoreException(StoreLogger.logStoreNotOpenLoggable(this.storeName)));
        }
    }

    private ArrayList coalesceRequests(ArrayList<StoreRequest> requests) {
        HashMap<PersistentHandleImpl, StoreRequest> handleMap = new HashMap<PersistentHandleImpl, StoreRequest>(requests.size());
        block4: for (StoreRequest sr : requests) {
            StoreRequest pending;
            switch (sr.getType()) {
                case 3: {
                    pending = (StoreRequest)handleMap.get(sr.getHandle());
                    if (pending == null) {
                        handleMap.put(sr.getHandle(), sr);
                        continue block4;
                    }
                    pending.coalesce(sr);
                    StoreRequest tmp = pending;
                    while (tmp.next != null && tmp.next.getType() != 2) {
                        tmp = tmp.next;
                    }
                    sr.next = tmp.next;
                    tmp.next = sr;
                    continue block4;
                }
                case 2: {
                    pending = (StoreRequest)handleMap.get(sr.getHandle());
                    if (pending == null) {
                        handleMap.put(sr.getHandle(), sr);
                        continue block4;
                    }
                    pending.coalesce(sr);
                    StoreRequest tmp = pending;
                    while (tmp.next != null) {
                        tmp = tmp.next;
                    }
                    tmp.next = sr;
                    continue block4;
                }
            }
            pending = handleMap.put(sr.getHandle(), sr);
            if (pending != null) {
                pending.coalesce(sr);
            }
            sr.next = pending;
        }
        int prevdel = -1;
        for (int i = 0; i < requests.size(); ++i) {
            StoreRequest ri = requests.get(i);
            if (ri.getType() != 4) continue;
            requests.set(i, requests.get(++prevdel));
            requests.set(prevdel, ri);
        }
        return requests;
    }

    ArrayList<StoreRequest> getOutstandingWork() {
        ArrayList<StoreRequest> requests = new ArrayList<StoreRequest>();
        Object next = null;
        while (next == null) {
            try {
                next = this.pendingRequests.take();
            }
            catch (InterruptedException interruptedException) {}
        }
        do {
            if (next == this.shutdownTask) {
                PersistentStoreException closedEx = new PersistentStoreException(StoreLogger.logStoreNotOpenLoggable(this.storeName));
                for (StoreRequest sr : requests) {
                    sr.handleError(closedEx);
                }
                try {
                    this.closeSub();
                    this.ios.close();
                    this.shutdownTask.setResult(new Object());
                }
                catch (Throwable e) {
                    this.shutdownTask.setResult(e);
                }
                return null;
            }
            if (next instanceof List) {
                requests.addAll((List)next);
                continue;
            }
            requests.add((StoreRequest)next);
        } while ((next = this.pendingRequests.poll()) != null);
        return this.coalesceRequests(requests);
    }

    private TransactionUnit coalesceOneRequest(Map<PersistentHandle, StoreRequest> handleMap, StoreRequest sr) {
        TransactionUnit unit = null;
        if (sr.getType() == 3 || sr.getType() == 2) {
            StoreRequest pending = handleMap.get(sr.getHandle());
            if (pending == null) {
                handleMap.put(sr.getHandle(), sr);
            } else {
                unit = pending.getTransactionUnit();
                StoreRequest tmp = null;
                if (sr.getType() == 3) {
                    if (pending.getType() == 2) {
                        handleMap.put(sr.getHandle(), sr);
                        sr.next = pending;
                    } else {
                        pending.coalesce(sr);
                        tmp = pending;
                        while (tmp.next != null && tmp.next.getType() != 2) {
                            tmp = tmp.next;
                        }
                        sr.next = tmp.next;
                        tmp.next = sr;
                    }
                } else {
                    pending.coalesce(sr);
                    tmp = pending;
                    while (tmp.next != null) {
                        tmp = tmp.next;
                    }
                    tmp.next = sr;
                }
            }
        } else {
            StoreRequest pending = handleMap.put(sr.getHandle(), sr);
            if (pending != null) {
                unit = pending.getTransactionUnit();
                pending.coalesce(sr);
            }
            sr.next = pending;
        }
        return unit;
    }

    private void linkTransactionUnit(StoreRequest sr, TransactionUnit thisUnit, TransactionUnit otherUnit) {
        if (otherUnit != null && otherUnit != thisUnit) {
            thisUnit.addLink(otherUnit);
            otherUnit.addLink(thisUnit);
        }
        sr.setTransactionUnit(thisUnit);
    }

    private void linkTopicUnit(StoreRequest sr, TransactionUnit thisUnit, Map<Long, TransactionUnit> topicFlushGroups) {
        if (sr.getFlushGroup() != -1L) {
            TransactionUnit topicUnit = topicFlushGroups.get(sr.getFlushGroup());
            if (topicUnit == null) {
                topicUnit = new TransactionUnit();
                topicFlushGroups.put(sr.getFlushGroup(), topicUnit);
            }
            thisUnit.addLink(topicUnit);
            topicUnit.addLink(thisUnit);
        }
    }

    List<FlushUnit> getWorkInCoalesceSets() {
        Object next = null;
        while (next == null) {
            try {
                next = this.pendingRequests.take();
            }
            catch (InterruptedException interruptedException) {}
        }
        ArrayList<TransactionUnit> tuList = new ArrayList<TransactionUnit>(100);
        int totalRequests = 0;
        do {
            if (next == this.shutdownTask) {
                PersistentStoreException closedEx = new PersistentStoreException(StoreLogger.logStoreNotOpenLoggable(this.storeName));
                for (TransactionUnit unit : tuList) {
                    if (unit.getRequests() != null) {
                        for (StoreRequest reqObj : unit.getRequests()) {
                            reqObj.handleError(closedEx);
                        }
                        continue;
                    }
                    unit.getOneRequest().handleError(closedEx);
                }
                try {
                    this.closeSub();
                    this.ios.close();
                    this.shutdownTask.setResult(new Object());
                }
                catch (Throwable e) {
                    this.shutdownTask.setResult(e);
                }
                return null;
            }
            if (next instanceof List) {
                List listOfReq = (List)next;
                tuList.add(new TransactionUnit(listOfReq));
                totalRequests += listOfReq.size();
                continue;
            }
            tuList.add(new TransactionUnit((StoreRequest)next));
            ++totalRequests;
        } while ((next = this.pendingRequests.poll()) != null);
        HashMap<PersistentHandle, StoreRequest> handleRequestMap = new HashMap<PersistentHandle, StoreRequest>(totalRequests * 4 / 3 + 1);
        HashMap<Long, TransactionUnit> topicFlushGroups = new HashMap<Long, TransactionUnit>();
        for (TransactionUnit unit : tuList) {
            if (unit.getRequests() != null) {
                List<StoreRequest> batch = unit.getRequests();
                for (StoreRequest sr : batch) {
                    TransactionUnit connectedUnit = this.coalesceOneRequest(handleRequestMap, sr);
                    this.linkTransactionUnit(sr, unit, connectedUnit);
                    this.linkTopicUnit(sr, unit, topicFlushGroups);
                }
                continue;
            }
            StoreRequest sr = unit.getOneRequest();
            TransactionUnit connectedUnit = this.coalesceOneRequest(handleRequestMap, sr);
            assert (connectedUnit != unit);
            this.linkTransactionUnit(sr, unit, connectedUnit);
            this.linkTopicUnit(sr, unit, topicFlushGroups);
        }
        LinkedList<FlushUnit> allSets = new LinkedList<FlushUnit>();
        for (TransactionUnit tu : tuList) {
            FlushUnit fu = tu.getFlushUnit();
            if (fu == null) {
                fu = new FlushUnit();
                fu.addTransactionUnit(tu);
                tu.setFlushUnit(fu);
                Set<TransactionUnit> links = tu.getLinks();
                if (links != null) {
                    TransactionUnit iter;
                    LinkedList<TransactionUnit> nodeQueue = new LinkedList<TransactionUnit>();
                    for (TransactionUnit oneLink : links) {
                        if (oneLink.getFlushUnit() == null) {
                            nodeQueue.add(oneLink);
                            oneLink.setFlushUnit(fu);
                            if (!oneLink.isTopicUnit()) continue;
                            fu.markTopicLoad();
                            continue;
                        }
                        assert (false) : "transaction unit already marked";
                    }
                    while ((iter = (TransactionUnit)nodeQueue.poll()) != null) {
                        if (iter.getLinks() == null) continue;
                        for (TransactionUnit oneLink : iter.getLinks()) {
                            FlushUnit oneFU = oneLink.getFlushUnit();
                            if (oneFU == null) {
                                nodeQueue.add(oneLink);
                                oneLink.setFlushUnit(fu);
                                if (!oneLink.isTopicUnit()) continue;
                                fu.markTopicLoad();
                                continue;
                            }
                            if (oneFU != fu) assert (false) : "transaction unit is marked wrong";
                        }
                    }
                }
                allSets.add(fu);
                continue;
            }
            fu.addTransactionUnit(tu);
        }
        for (FlushUnit fu : allSets) {
            fu.sortRequests();
        }
        return allSets;
    }

    @Override
    public void run() {
        if (this.ios.supportsAsyncIO()) {
            this.asynchronousFlush();
        } else {
            this.synchronousFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronousFlush() {
        ArrayList<StoreRequest> ioWork;
        block8: while ((ioWork = this.getOutstandingWork()) != null) {
            Object object;
            boolean requiresFlush = false;
            Throwable error = null;
            for (StoreRequest req : ioWork) {
                req.doTheIO(this.ios);
                req.finishIO();
                requiresFlush |= req.requiresFlush();
                if (req.getError() == null) continue;
                if (req instanceof ReadRequest) {
                    if (StoreDebug.storeIOLogical.isDebugEnabled()) {
                        StoreDebug.storeIOLogical.debug("synchronousFlush: isFailureFatal " + req.isRequestFailureFatal());
                    }
                    if (!req.isRequestFailureFatal()) continue;
                }
                error = req.getError();
                break;
            }
            PersistentStoreFatalException assignFatalException = null;
            if (error == null && requiresFlush) {
                PersistentStoreFatalException fatalPse;
                if (StoreDebug.storeIOLogical.isDebugEnabled()) {
                    StoreDebug.storeIOLogical.debug("synchronousFlush: error == null && requiresFlush");
                }
                try {
                    this.ios.flush();
                    this.statistics.incrementPhysicalWriteCount();
                }
                catch (PersistentStoreFatalException fatalPse2) {
                    assignFatalException = fatalPse2;
                    this.setFatalException(fatalPse2);
                    error = fatalPse2;
                }
                catch (PersistentStoreException pse) {
                    error = pse;
                }
                catch (Error e) {
                    assignFatalException = fatalPse = new PersistentStoreFatalException(new PersistentStoreException(e.toString(), (Throwable)e));
                    this.setFatalException(fatalPse);
                    error = fatalPse;
                }
                catch (RuntimeException rte) {
                    assignFatalException = fatalPse = new PersistentStoreFatalException(new PersistentStoreException(rte.toString(), (Throwable)rte));
                    this.setFatalException(fatalPse);
                    error = fatalPse;
                }
            }
            if (error != null && assignFatalException == null) {
                if (StoreDebug.storeIOLogical.isDebugEnabled()) {
                    StoreDebug.storeIOLogical.debug("synchronousFlush: error != null && assignFatalException == null");
                }
                object = this;
                synchronized (object) {
                    if (this.fatalException == null) {
                        if (error instanceof PersistentStoreTestException) {
                            PersistentStoreTestException pste = (PersistentStoreTestException)error;
                            if (StoreDebug.storeIOLogical.isDebugEnabled()) {
                                StoreDebug.storeIOLogical.debug("synchronousFlush: PersistentStoreTestException: " + pste.toString());
                            }
                            if (pste.shouldFailOnFlush()) {
                                assignFatalException = new PersistentStoreFatalException((PersistentStoreException)error);
                            }
                        } else {
                            assignFatalException = error instanceof PersistentStoreFatalException ? (PersistentStoreFatalException)error : (error instanceof PersistentStoreException ? new PersistentStoreFatalException((PersistentStoreException)error) : new PersistentStoreFatalException(new PersistentStoreException(error)));
                        }
                    }
                }
                if (StoreDebug.storeIOLogical.isDebugEnabled()) {
                    StoreDebug.storeIOLogical.debug("synchronousFlush: assignFatalException: " + (assignFatalException == null ? "null" : assignFatalException.getMessage()));
                }
                if (assignFatalException != null) {
                    this.setFatalException(assignFatalException);
                }
            }
            if (StoreDebug.storeIOLogical.isDebugEnabled()) {
                StoreDebug.storeIOLogical.debug("synchronousFlush: for all work: " + (error != null ? "assigning error" : "handle results"));
            }
            object = ioWork.iterator();
            while (true) {
                if (!object.hasNext()) continue block8;
                StoreRequest req = (StoreRequest)object.next();
                if (error != null) {
                    req.handleError(error);
                    continue;
                }
                if (req.getError() != null) {
                    req.handleError(req.getError());
                    continue;
                }
                req.handleResult();
            }
            break;
        }
        return;
    }

    /*
     * Exception decompiling
     */
    private void asynchronousFlush() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 20[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public StoreStatistics getStatistics() {
        return this.statistics;
    }

    StoreStatisticsImpl getStatisticsImpl() {
        return this.statistics;
    }

    @Override
    public String getName() {
        return this.storeName;
    }

    @Override
    public String getShortName() {
        return this.storeShortName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(PersistentStoreConnectionImpl conn) throws PersistentStoreException {
        PersistentHandleImpl handle;
        this.checkOpen();
        ConnectionInfo connectionInfo = null;
        Map<ConnectionKey, ConnectionInfo> map = this.connections;
        synchronized (map) {
            ConnectionKey key = conn.getKey();
            connectionInfo = this.connections.remove(key);
            if (connectionInfo == null) {
                return;
            }
            handle = connectionInfo.getHandle();
        }
        this.unregisterConnection(conn);
        connectionInfo.setDeleted();
        PersistentStoreTransaction ptx = this.begin();
        this.systemConnection.update(ptx, handle, connectionInfo, 0);
        ptx.commit();
        this.schedule(new DropRequest(conn, this.systemConnection, handle));
    }

    @Override
    public void unregisterStoreMBean() throws PersistentStoreException {
        if (this.mbean != null && this.adminHandler != null) {
            this.adminHandler.unregisterStoreMBean(this.mbean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws PersistentStoreException {
        this.unregisterStoreMBean();
        ConcurrentBlockingQueue concurrentBlockingQueue = this.pendingRequests;
        // MONITORENTER : concurrentBlockingQueue
        if (!this.isOpen) {
            // MONITOREXIT : concurrentBlockingQueue
            return;
        }
        this.isOpen = false;
        this.pendingRequests.offer(this.shutdownTask);
        // MONITOREXIT : concurrentBlockingQueue
        if (this.daemonPollTimer != null) {
            this.daemonPollTimer.cancel();
        }
        this.ios.prepareToClose();
        Throwable shutdownException = null;
        try {
            this.shutdownTask.getResult();
            return;
        }
        catch (Throwable t) {
            shutdownException = t;
        }
        finally {
            this.shutdownTask.reset();
            try {
                Map<ConnectionKey, ConnectionInfo> map = this.connections;
            }
            catch (Throwable t) {
                if (shutdownException == null) {
                    shutdownException = t;
                }
            }
            finally {
                if (this.connections != null) {
                    this.connections.clear();
                }
                if (this.maps != null) {
                    this.maps.clear();
                }
                if (shutdownException instanceof PersistentStoreException) {
                    throw (PersistentStoreException)shutdownException;
                }
                if (shutdownException != null) {
                    throw new PersistentStoreException(shutdownException);
                }
            }
        }
    }

    static boolean checkName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '\"': 
                case '*': 
                case ',': 
                case ':': 
                case '=': 
                case '?': {
                    return false;
                }
            }
        }
        return true;
    }

    final synchronized void checkOpen() throws PersistentStoreException {
        if (!this.isOpen) {
            throw new PersistentStoreException(StoreLogger.logStoreNotOpenLoggable(this.storeName));
        }
    }

    @Override
    public Iterator getConnectionNames() {
        return this.getConnectionNamesInternal(0);
    }

    @Override
    public Iterator getMapConnectionNames() {
        return this.getConnectionNamesInternal(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator getConnectionNamesInternal(int kind) {
        LinkedList<String> list = new LinkedList<String>();
        Map<ConnectionKey, ConnectionInfo> map = this.connections;
        synchronized (map) {
            for (ConnectionInfo connInfo : this.connections.values()) {
                if (connInfo.kind != kind) continue;
                list.addFirst(connInfo.connectionName);
            }
            return list.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getConfigValue(Object key) throws PersistentStoreException {
        PersistentStoreImpl persistentStoreImpl = this;
        synchronized (persistentStoreImpl) {
            this.checkOpen();
            return this.config.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfigValue(Object key, Object value) throws PersistentStoreException {
        PersistentStoreImpl persistentStoreImpl = this;
        synchronized (persistentStoreImpl) {
            this.checkOpen();
            Object oldValue = this.config.get(key);
            if (oldValue == null) {
                if (value == null) {
                    return;
                }
            } else if (oldValue.equals(value)) {
                return;
            }
        }
        HashMap<String, Object> newConfig = new HashMap<String, Object>(this.config);
        newConfig.put((String)key, value);
        ReopenRequest sr = new ReopenRequest(this.systemConnection, newConfig);
        CompletionRequest cr = new CompletionRequest();
        this.schedule(Arrays.asList(sr), cr);
        try {
            cr.getResult();
        }
        catch (PersistentStoreException pse) {
            throw pse;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable thr) {
            throw new AssertionError((Object)thr);
        }
    }

    public void dump(XMLStreamWriter xsw) throws XMLStreamException {
        this.dump(xsw, true);
    }

    public void dump(XMLStreamWriter xsw, boolean complete) throws XMLStreamException {
        xsw.writeStartElement("PersistentStore");
        xsw.writeAttribute("Name", this.getName());
        xsw.writeAttribute("Open", "" + this.isOpen);
        xsw.writeStartElement("IOLayer");
        this.ios.dump(xsw);
        xsw.writeEndElement();
        xsw.writeStartElement("Statistics");
        xsw.writeStartElement("NumObjects");
        xsw.writeCharacters("" + this.statistics.getObjectCount());
        xsw.writeEndElement();
        xsw.writeStartElement("Creates");
        xsw.writeCharacters("" + this.statistics.getCreateCount());
        xsw.writeEndElement();
        xsw.writeStartElement("Reads");
        xsw.writeCharacters("" + this.statistics.getReadCount());
        xsw.writeEndElement();
        xsw.writeStartElement("Updates");
        xsw.writeCharacters("" + this.statistics.getUpdateCount());
        xsw.writeEndElement();
        xsw.writeStartElement("Deletes");
        xsw.writeCharacters("" + this.statistics.getDeleteCount());
        xsw.writeEndElement();
        xsw.writeStartElement("PhysicalWrites");
        xsw.writeCharacters("" + this.statistics.getPhysicalWriteCount());
        xsw.writeEndElement();
        xsw.writeStartElement("PhysicalReads");
        xsw.writeCharacters("" + this.statistics.getPhysicalReadCount());
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeStartElement("Connections");
        if (!complete) {
            return;
        }
        for (ConnectionInfo connInfo : this.connections.values()) {
            this.dumpConnectionInternal(xsw, connInfo, false);
        }
        xsw.writeEndElement();
        xsw.writeEndElement();
    }

    public void dumpConnection(XMLStreamWriter xsw, String name, boolean dumpContents) throws XMLStreamException {
        this.checkAndDumpConnection(xsw, name, (byte)0, dumpContents);
    }

    public void dumpPersistentMap(XMLStreamWriter xsw, String name, boolean dumpContents) throws XMLStreamException {
        this.checkAndDumpConnection(xsw, name, (byte)1, dumpContents);
    }

    private void checkAndDumpConnection(XMLStreamWriter xsw, String connName, byte kind, boolean dumpContents) throws XMLStreamException {
        ConnectionKey connKey = new ConnectionKey(connName, kind);
        ConnectionInfo connInfo = this.connections.get(connKey);
        if (connInfo == null) {
            connInfo = new ConnectionInfo(-1, connName, kind);
        }
        this.dumpConnectionInternal(xsw, connInfo, dumpContents);
    }

    private void dumpConnectionInternal(XMLStreamWriter xsw, ConnectionInfo connInfo, boolean dumpContents) throws XMLStreamException {
        xsw.writeStartElement("Connection");
        xsw.writeAttribute("Name", connInfo.connectionName);
        String kind = connInfo.kind == 1 ? "map" : "normal";
        xsw.writeAttribute("Kind", kind);
        int typeCode = connInfo.typeCode;
        if (typeCode == -1) {
            xsw.writeStartElement("ErrorMessage");
            xsw.writeCharacters("Invalid or unknown connection");
            xsw.writeEndElement();
            xsw.writeEndElement();
            return;
        }
        xsw.writeAttribute("Typecode", "" + typeCode);
        OperationStatistics stats = connInfo.connection.getStatistics();
        xsw.writeStartElement("Statistics");
        xsw.writeStartElement("NumObjects");
        xsw.writeCharacters("" + stats.getObjectCount());
        xsw.writeEndElement();
        xsw.writeStartElement("Creates");
        xsw.writeCharacters("" + stats.getCreateCount());
        xsw.writeEndElement();
        xsw.writeStartElement("Reads");
        xsw.writeCharacters("" + stats.getReadCount());
        xsw.writeEndElement();
        xsw.writeStartElement("Updates");
        xsw.writeCharacters("" + stats.getUpdateCount());
        xsw.writeEndElement();
        xsw.writeStartElement("Deletes");
        xsw.writeCharacters("" + stats.getDeleteCount());
        xsw.writeEndElement();
        xsw.writeEndElement();
        if (VERBOSE_DIAGNOSTICS || dumpContents) {
            xsw.writeStartElement("Records");
            if (this.ios instanceof BaseStoreIO) {
                ((BaseStoreIO)this.ios).dump(xsw, typeCode, dumpContents);
            } else {
                this.ios.dump(xsw, typeCode);
            }
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConfigInternal(HashMap<String, Object> config) {
        PersistentStoreImpl persistentStoreImpl = this;
        synchronized (persistentStoreImpl) {
            this.config.putAll(config);
        }
    }

    protected void closeSub() throws PersistentStoreException {
    }

    void healthFailed(PersistentStoreException exceptionToLog) {
        if (this.mbean != null) {
            this.mbean.setHealthFailed(exceptionToLog);
        }
    }

    void registerConnection(PersistentStoreConnection conn) throws PersistentStoreException {
        if (this.adminHandler != null) {
            this.adminHandler.registerConnectionMBean(this.mbean, conn);
        }
    }

    void unregisterConnection(PersistentStoreConnection conn) throws PersistentStoreException {
        if (this.adminHandler != null) {
            this.adminHandler.unregisterConnectionMBean(this.mbean, conn);
        }
    }

    protected RuntimeHandler getRuntimeHandler() {
        return this.adminHandler;
    }

    static {
        String[] syncPackages;
        VERBOSE_DIAGNOSTICS = Debug.getCategory("weblogic.store.VerboseDiagnostics").isEnabled();
        openFailureTestEnabled = Boolean.getBoolean("weblogic.jdbcstore.OpenFailureTest");
        SYNC_DESERIALIZERS = System.getProperty("weblogic.store.SynchronousDeserializationSet", "weblogic.store:weblogic.jms:weblogic.messaging");
        syncDeserializerSet = new HashSet();
        for (String sp : syncPackages = SYNC_DESERIALIZERS.split(":")) {
            syncDeserializerSet.add(sp);
        }
    }

    private final class DevicePollTimerListener
    implements NakedTimerListener {
        private DevicePollTimerListener() {
        }

        @Override
        public void timerExpired(Timer timer) {
            if (PersistentStoreImpl.this.pendingRequests.isEmpty()) {
                PersistentStoreImpl.this.pendingRequests.offer(new PollRequest());
            }
        }
    }

    private static final class ConnectionInfo
    implements Serializable {
        private static final long serialVersionUID = 2566438085361406921L;
        private final int typeCode;
        private final byte kind;
        private final String connectionName;
        private boolean isDel;
        private transient PersistentHandleImpl handle;
        private transient PersistentStoreConnectionImpl connection;

        private ConnectionInfo(int typeCode, String connectionName, byte kind) {
            this.typeCode = typeCode;
            this.connectionName = connectionName;
            this.kind = kind;
        }

        private void setHandle(PersistentHandleImpl handle) {
            this.handle = handle;
        }

        private PersistentHandleImpl getHandle() {
            return this.handle;
        }

        private void setConnection(PersistentStoreConnectionImpl conn) {
            this.connection = conn;
        }

        private PersistentStoreConnectionImpl getConnection() {
            return this.connection;
        }

        public int hashCode() {
            return this.connectionName.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ConnectionInfo)) {
                return false;
            }
            ConnectionInfo other = (ConnectionInfo)o;
            return other.typeCode == this.typeCode && other.kind == this.kind && other.isDel == this.isDel && this.connectionName.equals(other.connectionName);
        }

        public String toString() {
            return "Store connection " + this.typeCode + (this.kind == 1 ? " map, " : " default, ") + (this.isDel ? "(deleted) " : "") + this.connectionName.hashCode();
        }

        private synchronized boolean getDeleted() {
            return this.isDel;
        }

        private synchronized void setDeleted() {
            this.isDel = true;
        }
    }

    static final class ConnectionKey {
        private final String connectionName;
        private final byte kind;

        ConnectionKey(String connectionName, byte kind) {
            this.connectionName = connectionName;
            this.kind = kind;
        }

        String getName() {
            return this.connectionName;
        }

        public int hashCode() {
            return this.connectionName.hashCode() ^ this.kind;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConnectionKey)) {
                return false;
            }
            ConnectionKey other = (ConnectionKey)o;
            return this.kind == other.kind && this.connectionName.equals(other.connectionName);
        }
    }

    private class LoadCompletionListener
    implements IOListener {
        private List<StoreRequest> ioWork;

        private LoadCompletionListener(List<StoreRequest> ioWork) {
            this.ioWork = ioWork;
        }

        @Override
        public void ioCompleted(Object result) {
            for (StoreRequest req : this.ioWork) {
                if (result instanceof PersistentStoreFatalException) {
                    PersistentStoreImpl.this.setFatalException((PersistentStoreFatalException)result);
                    req.handleError((PersistentStoreFatalException)result);
                    continue;
                }
                if (result instanceof Throwable) {
                    req.handleError((Throwable)result);
                    continue;
                }
                req.handleResult();
            }
        }
    }

    private static class CallerClassUtil
    extends SecurityManager {
        private CallerClassUtil() {
        }

        private Class getCallerClass() {
            Class<?>[] stack = this.getClassContext();
            int i = 2;
            Class<?> cls = stack[i];
            while (i < stack.length) {
                if (cls != this.getClass() && !cls.getName().startsWith(PersistentStoreImpl.THREAD_PREFIX)) {
                    return cls;
                }
                cls = stack[i++];
            }
            return stack[stack.length - 1];
        }
    }

    private static final class ReusableCompletionRequest {
        private Object result = this;

        private ReusableCompletionRequest() {
        }

        private synchronized void setResult(Object result) {
            this.result = result;
            this.notify();
        }

        private synchronized void getResult() throws Throwable {
            while (this.result == this) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (this.result instanceof Throwable) {
                throw (Throwable)this.result;
            }
        }

        private synchronized void reset() {
            this.result = this;
        }
    }
}

