/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.nio.ByteBuffer;
import weblogic.store.ByteBufferObjectHandler;
import weblogic.store.CustomObjectInput;
import weblogic.store.ObjectHandler;
import weblogic.store.PersistentHandle;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreRecord;
import weblogic.store.StoreLogger;
import weblogic.store.internal.PersistentHandleImpl;
import weblogic.store.internal.PersistentStoreConnectionImpl;
import weblogic.store.internal.PersistentStoreInputStreamImpl;
import weblogic.store.io.IORecord;

final class PersistentStoreRecordImpl
implements PersistentStoreRecord {
    private final PersistentHandleImpl handle;
    private final PersistentStoreConnectionImpl connection;
    private final ByteBuffer[] data;
    private Object body;
    private final ObjectHandler handler;

    PersistentStoreRecordImpl(PersistentHandleImpl handle, ByteBuffer[] data, ObjectHandler handler, PersistentStoreConnectionImpl connection, boolean readOverride) throws PersistentStoreException {
        this.handle = handle;
        this.connection = connection;
        if (readOverride) {
            this.data = data;
            this.handler = handler;
        } else if (connection.deserializationDeferred()) {
            for (int i = 0; i < data.length; ++i) {
                ByteBuffer b = data[i];
                if (b == null) continue;
                ByteBuffer copyBuf = ByteBuffer.allocate(b.remaining());
                copyBuf.put(b);
                copyBuf.position(0);
                data[i] = copyBuf;
            }
            this.data = data;
            this.handler = handler;
        } else {
            this.initBody(data, handler);
            this.data = null;
            this.handler = null;
        }
    }

    PersistentStoreRecordImpl(IORecord iorec, ObjectHandler handler, PersistentStoreConnectionImpl connection, boolean dynamicCursor) throws PersistentStoreException {
        this.handle = new PersistentHandleImpl(iorec.getTypeCode(), iorec.getHandle());
        ByteBuffer d = iorec.getData();
        this.connection = connection;
        if (dynamicCursor && connection.deserializationDeferred()) {
            if (d == null) {
                this.data = null;
            } else {
                ByteBuffer copyBuf = ByteBuffer.allocate(d.remaining());
                copyBuf.put(d);
                copyBuf.position(0);
                this.data = new ByteBuffer[]{copyBuf};
            }
            this.handler = handler;
        } else {
            ByteBuffer[] byteBufferArray;
            if (d == null) {
                byteBufferArray = null;
            } else {
                ByteBuffer[] byteBufferArray2 = new ByteBuffer[1];
                byteBufferArray = byteBufferArray2;
                byteBufferArray2[0] = d;
            }
            this.initBody(byteBufferArray, handler);
            this.data = null;
            this.handler = null;
        }
    }

    private void initBody(ByteBuffer[] data, ObjectHandler handler) throws PersistentStoreException {
        if (data != null) {
            if (handler instanceof ByteBufferObjectHandler) {
                ByteBuffer copy = ByteBuffer.allocate(data[0].remaining());
                copy.put(data[0]);
                copy.clear();
                this.body = copy;
            } else {
                try {
                    ObjectInput objectInput = handler instanceof CustomObjectInput ? ((CustomObjectInput)((Object)handler)).getObjectInput(data) : new PersistentStoreInputStreamImpl(data);
                    this.body = handler.readObject(objectInput);
                }
                catch (IOException ioe) {
                    throw new PersistentStoreException(StoreLogger.logReadFailedLoggable(), (Throwable)ioe);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new PersistentStoreException(StoreLogger.logReadFailedLoggable(), (Throwable)cnfe);
                }
            }
        }
    }

    @Override
    public PersistentHandle getHandle() {
        return this.handle;
    }

    @Override
    public Object getData() throws PersistentStoreException {
        if (this.body == null) {
            this.initBody(this.data, this.handler);
        }
        return this.body;
    }
}

