/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.internal;

import java.util.HashMap;
import java.util.Iterator;
import weblogic.common.CompletionListener;
import weblogic.common.CompletionRequest;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreTransaction;
import weblogic.store.common.StoreDebug;
import weblogic.store.internal.LockManager;

public abstract class PersistentTransactionImpl
implements PersistentStoreTransaction,
CompletionListener {
    private boolean completed;
    private HashMap locksHeld;

    @Override
    public final void commit(CompletionRequest completionRequest) {
        this.commit(completionRequest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void commit(CompletionRequest completionRequest, boolean isSync) {
        boolean needUnlockListener;
        if (StoreDebug.storeIOLogical.isDebugEnabled()) {
            StoreDebug.storeIOLogical.debug("trying commit, ptx=" + this);
        }
        PersistentTransactionImpl persistentTransactionImpl = this;
        synchronized (persistentTransactionImpl) {
            this.complete();
            needUnlockListener = this.locksHeld != null;
        }
        if (!isSync && needUnlockListener) {
            completionRequest.addFirstListener(this);
        }
        this.commitInternal(completionRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void commit() throws PersistentStoreException {
        boolean isLocked;
        PersistentTransactionImpl persistentTransactionImpl;
        try {
            CompletionRequest cr = new CompletionRequest();
            this.commit(cr, true);
            this.waitForResult(cr);
            persistentTransactionImpl = this;
        }
        catch (Throwable throwable) {
            boolean isLocked2;
            PersistentTransactionImpl persistentTransactionImpl2 = this;
            synchronized (persistentTransactionImpl2) {
                isLocked2 = this.locksHeld != null;
            }
            if (isLocked2) {
                this.unlockAll();
            }
            throw throwable;
        }
        synchronized (persistentTransactionImpl) {
            isLocked = this.locksHeld != null;
        }
        if (isLocked) {
            this.unlockAll();
        }
    }

    private final void waitForResult(CompletionRequest cr) throws PersistentStoreException {
        try {
            cr.getResult();
        }
        catch (PersistentStoreException pse) {
            throw pse;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable thr) {
            throw new AssertionError((Object)thr);
        }
    }

    @Override
    public final void rollback() throws PersistentStoreException {
        CompletionRequest cr = new CompletionRequest();
        this.rollback(cr);
        this.waitForResult(cr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rollback(CompletionRequest completionRequest) {
        boolean needUnlockListener;
        if (StoreDebug.storeIOLogical.isDebugEnabled()) {
            StoreDebug.storeIOLogical.debug("trying rollback, ptx=" + this);
        }
        PersistentTransactionImpl persistentTransactionImpl = this;
        synchronized (persistentTransactionImpl) {
            this.complete();
            needUnlockListener = this.locksHeld != null;
        }
        if (needUnlockListener) {
            completionRequest.addFirstListener(this);
        }
        this.rollbackInternal(completionRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPendingWork() {
        PersistentTransactionImpl persistentTransactionImpl = this;
        synchronized (persistentTransactionImpl) {
            return !this.completed && this.hasPendingWorkInternal();
        }
    }

    private void complete() {
        if (this.completed) {
            throw new IllegalStateException("No transaction in process");
        }
        this.completed = true;
    }

    public void lock(LockManager lockManager, Object key) {
        if (this.hasLock(lockManager, key)) {
            return;
        }
        lockManager.lock(this, key);
        this.newLock(lockManager, key);
    }

    void lock(final LockManager lockManager, final Object key, final LockManager.Listener listener) {
        if (this.hasLock(lockManager, key)) {
            listener.onLock();
            return;
        }
        lockManager.lock(this, key, new LockManager.Listener(){

            @Override
            public void onLock() {
                PersistentTransactionImpl.this.newLock(lockManager, key);
                listener.onLock();
            }
        });
    }

    private synchronized boolean newLock(LockManager lockManager, Object key) {
        LockManager old;
        if (this.locksHeld == null) {
            this.locksHeld = new HashMap();
        }
        if ((old = this.locksHeld.put(key, lockManager)) == null) {
            return true;
        }
        if (old == lockManager) {
            return false;
        }
        this.locksHeld.put(key, old);
        throw new IllegalStateException("same key with multiple lockManagers");
    }

    synchronized boolean hasLock(LockManager lockManager, Object key) {
        if (this.locksHeld == null) {
            return false;
        }
        Object old = this.locksHeld.get(key);
        if (old == null) {
            return false;
        }
        if (old == lockManager) {
            return true;
        }
        throw new IllegalStateException("multiple lockManagers with same key");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockAll() {
        while (true) {
            LockManager lockManager;
            Object key;
            PersistentTransactionImpl persistentTransactionImpl = this;
            synchronized (persistentTransactionImpl) {
                if (this.locksHeld == null) {
                    return;
                }
                Iterator iterator = this.locksHeld.keySet().iterator();
                if (!iterator.hasNext()) {
                    return;
                }
                key = iterator.next();
                lockManager = (LockManager)this.locksHeld.get(key);
                iterator.remove();
            }
            lockManager.unlock(this, key);
        }
    }

    abstract void commitInternal(CompletionRequest var1);

    abstract void rollbackInternal(CompletionRequest var1);

    abstract boolean hasPendingWorkInternal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        HashMap lockSnapshot = this.locksHeld;
        String str = super.toString() + "[ thread=" + Thread.currentThread();
        if (lockSnapshot == null) {
            return str + " ]";
        }
        PersistentTransactionImpl persistentTransactionImpl = this;
        synchronized (persistentTransactionImpl) {
            return str + " locks=" + this.locksHeld.keySet() + " ]";
        }
    }

    @Override
    public void onCompletion(CompletionRequest completionRequest, Object result) {
        this.unlockAll();
    }

    @Override
    public void onException(CompletionRequest completionRequest, Throwable reason) {
        this.unlockAll();
    }
}

