/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.io.file;

import com.bea.security.utils.random.SecureRandomData;
import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import weblogic.kernel.KernelStatus;
import weblogic.store.PersistentStoreException;
import weblogic.store.StoreLogger;
import weblogic.store.StoreWritePolicy;
import weblogic.store.common.StoreDebug;
import weblogic.store.internal.StoreStatisticsImpl;
import weblogic.store.io.file.BaseStoreIO;
import weblogic.store.io.file.DirectBufferPool;
import weblogic.store.io.file.DiskScheduler;
import weblogic.store.io.file.FileStoreIO;
import weblogic.store.io.file.StoreDir;
import weblogic.store.io.file.StoreFile;
import weblogic.store.io.file.StoreHeap;
import weblogic.store.io.file.checksum.Checksummer;
import weblogic.store.io.file.checksum.ChecksummerFactory;
import weblogic.store.io.file.direct.DirectIOManager;

public final class Heap {
    private static boolean HANDLE_TRACKING;
    private static final int MAGIC_GEN_RETRY_MAX = 10;
    public static final boolean LARGE_DEFAULTS;
    private static final String WLS_STORE_CACHE = "WLStoreCache";
    public static final String OS_TMP_DIR;
    public static final String DEFAULT_FILE_SUFFIX = "dat";
    public static final String DEFAULT_REPLICATED_SUFFIX;
    public static final String DEFAULT_REGION_DIR;
    private static final Integer DEFAULT_BLOCK_SIZE;
    private static final int DEFAULT_IO_SIZE;
    private static final int DEFAULT_MIN_MAP_SIZE;
    private static final int DEFAULT_MAX_MAP_SIZE;
    private static final String WL_CLIENT = "WLClient";
    private static final String GLOBAL_DIRECT_IO_MODE;
    private static final String GLOBAL_AVOID_DIRECT_IO;
    private static final int MAX_INC_FILE_SIZE = 0xA00000;
    public static final short HEAP_VERSION_3 = 3;
    public static final short HEAP_VERSION_2 = 2;
    public static final short HEAP_VERSION_1 = 1;
    public static final short HEAP_VERSION_CURRENT = 3;
    private static final byte RECORD_VERSION_CURRENT = 5;
    private static final byte RECORD_VERSION_PREVIOUS = 4;
    private static final byte RECORD_VERSION_OLD = 2;
    private static final boolean ENABLE_FILESTORE_CLEAN_ON_BOOT;
    private static final boolean SKIP_SPACE_UPDATES;
    static final String DIRECT_MODE_DUAL_READ_BUFFERED = "read-buffered";
    static final String DIRECT_MODE_SINGLE_BUFFERED = "single-handle-buffered";
    static final String DIRECT_MODE_SINGLE_UNBUFFERED = "single-handle-unbuffered";
    static final String DIRECT_MODE_SINGLE_NONE = "single-handle-non-direct";
    private final LinkedList<ReadLogNode> readLog = new LinkedList();
    private final String dirName;
    private String storeName;
    private String regionName;
    private final String suffix;
    private int hashCode;
    private String localBlockSizePropertyName;
    private Integer localBlockSizeProperty;
    private StoreDir dir;
    private Checksummer writeChecksummer = ChecksummerFactory.getNewInstance();
    private Checksummer readChecksummer = ChecksummerFactory.getNewInstance();
    private final DiskScheduler scheduler = new DiskScheduler();
    private final Set<StoreFile> flushList = new HashSet<StoreFile>();
    private final boolean autoCreateDirs;
    private int directAlignment;
    private final BaseStoreIO baseStoreIO;
    private final DirectIOManager directIOManager;
    private ByteBuffer directZeroBuffer;
    private DirectBufferPool bufferPool;
    private int blockSize;
    private StoreHeap allocator;
    private short lastFileWritten;
    private short heapVersion;
    private long maxFileSize = 0x50000000L;
    private int extentBlocks;
    private int maxExtentBlocks;
    private String cacheDir;
    private String tempDirPrefix;
    String uuidStr;
    private Map<String, Object> config = new HashMap<String, Object>();
    private StoreWritePolicy writePolicy;
    private boolean supportOSDirectIO;
    private boolean singleHandleDirectIO;
    private int ioSize;
    private int minMapSize;
    private int maxMapSize;
    private boolean locking;
    boolean isReplicatedStore = false;
    private StoreStatisticsImpl stats;
    boolean enforceExplicitIO;
    private short recoveryFileNum;
    private int recoveryBlock;
    private long recoveryFilePos;
    private int recoveryFileBlocks;
    private boolean recoveryComplete;
    private long uuidLo;
    private long uuidHi;
    private int readLogRemaining;
    private boolean isOpen = false;
    private Map<Long, Object> ht;
    private static final long HEAP_RECORD_MAGIC = 1370321247807281150L;
    private static final int STATE_SALT = -123456789;
    private long heapRecordMagic;
    private static int OLD_HEADER_LENGTH;
    private static int HEADER_LENGTH;
    private static final int TAIL_LENGTH = 8;

    public Heap(String storeName, String dirName) throws PersistentStoreException {
        this(storeName, dirName, DEFAULT_FILE_SUFFIX, true);
    }

    public Heap(String storeName, String dirName, boolean autoCreateDirs) throws PersistentStoreException {
        this(storeName, dirName, DEFAULT_FILE_SUFFIX, autoCreateDirs);
    }

    public Heap(String storeName, String dirName, String suffix) throws PersistentStoreException {
        this(storeName, dirName, suffix, true);
    }

    public Heap(String storeName, String dirName, String suffix, boolean autoCreateDirs) throws PersistentStoreException {
        this(null, null, storeName, dirName, suffix, autoCreateDirs, false);
    }

    public Heap(BaseStoreIO baseStoreIO, DirectIOManager directIOManager, String storeName, String dirName, String suffix, boolean autoCreateDirs, boolean isReplicatedStore) throws PersistentStoreException {
        this.isReplicatedStore = isReplicatedStore;
        this.storeName = storeName;
        this.regionName = this.computeRegionName(null);
        this.baseStoreIO = baseStoreIO;
        this.autoCreateDirs = autoCreateDirs;
        if (isReplicatedStore) {
            this.supportOSDirectIO = true;
            this.singleHandleDirectIO = true;
            this.suffix = DEFAULT_REPLICATED_SUFFIX;
            this.dirName = dirName + DEFAULT_REGION_DIR;
        } else {
            this.suffix = suffix;
            this.dirName = dirName;
            this.hashCode = this.storeName.hashCode();
            this.localBlockSizePropertyName = "weblogic.store." + storeName + ".BlockSize";
            this.localBlockSizeProperty = Heap.getBlockSizeFromProperty(this.localBlockSizePropertyName);
            this.dir = new StoreDir(this, dirName, storeName, suffix);
        }
        this.directIOManager = directIOManager == null ? DirectIOManager.getFileManager() : directIOManager;
        if (!$assertionsDisabled) {
            HANDLE_TRACKING = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }

    String getDirName() {
        return this.dirName;
    }

    String getSuffix() {
        return this.suffix;
    }

    public String getName() {
        return this.storeName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setConfig(HashMap<String, Object> config) {
        if (config == null) {
            config = new HashMap();
        }
        if (this.baseStoreIO != null) {
            config = this.baseStoreIO.adjustConfig(config);
        }
        this.config = config;
    }

    public HashMap getConfig() {
        return (HashMap)this.config;
    }

    public void setStats(StoreStatisticsImpl statistics) {
        this.stats = statistics;
        this.stats.init(this.getName(), this.getConfig());
    }

    public StoreStatisticsImpl getStats() {
        return this.stats;
    }

    public void setSynchronousWritePolicy(StoreWritePolicy policy) {
        this.writePolicy = policy;
    }

    public void setWriteChecksummer(Checksummer writeChecksummer) {
        this.writeChecksummer = writeChecksummer;
    }

    public void setReadChecksummer(Checksummer readChecksummer) {
        this.readChecksummer = readChecksummer;
    }

    public void setChecksummer(Checksummer checksummer) {
        this.readChecksummer = checksummer;
        this.writeChecksummer = checksummer;
    }

    boolean isOpen() {
        return this.isOpen;
    }

    String computeRegionName(Map config) throws PersistentStoreException {
        StringBuilder theRegionName = new StringBuilder();
        if (config != null) {
            String domainName = (String)config.get("DomainName");
            if (domainName == null) {
                throw new PersistentStoreException("Domain name missing.");
            }
            theRegionName.append(domainName.toUpperCase()).append("_").append(this.storeName.toUpperCase()).append("_");
        } else {
            theRegionName.append(this.storeName.toUpperCase());
        }
        return theRegionName.toString();
    }

    public void open() throws PersistentStoreException {
        List<StoreFile> files;
        Integer ioSizeConfig;
        int tmpAlignment;
        if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
            StoreDebug.storeIOPhysicalVerbose.debug("open begin");
        }
        if (this.isReplicatedStore) {
            if (this.config.get("RegionSize") == null) {
                throw new AssertionError();
            }
            this.regionName = this.computeRegionName(this.config);
            this.hashCode = this.regionName.hashCode();
            this.dir = new StoreDir(this, this.dirName, this.regionName, this.suffix);
            this.localBlockSizePropertyName = "weblogic.store." + this.storeName + ".BlockSize";
            this.localBlockSizeProperty = Heap.getBlockSizeFromProperty(this.localBlockSizePropertyName);
            try {
                int length = this.dirName.length() - DEFAULT_REGION_DIR.length();
                this.dir.checkOK(this.autoCreateDirs, length);
            }
            catch (IOException e) {
                throw new PersistentStoreException(e);
            }
            catch (SecurityException e) {
                throw new PersistentStoreException(e);
            }
        }
        try {
            this.dir.checkOK(this.isReplicatedStore ? true : this.autoCreateDirs);
        }
        catch (IOException e) {
            throw new PersistentStoreException(e);
        }
        catch (SecurityException e) {
            throw new PersistentStoreException(e);
        }
        try {
            File tempFile = File.createTempFile("wls", ".dat", new File(this.dirName));
            tmpAlignment = this.directIOManager.checkAlignment(tempFile);
            tempFile.delete();
        }
        catch (IOException e) {
            tmpAlignment = -1;
        }
        this.directAlignment = tmpAlignment;
        this.locking = this.getLocking();
        if (this.isReplicatedStore) {
            StoreLogger.logOpeningReplicatedStore(this.storeName, this.regionName, this.getDirectoryName(), this.getDriver());
        } else {
            StoreLogger.logOpeningPersistentStore(this.storeName, this.getDirectoryName(), this.writePolicy.toString(), this.locking, this.getDriver());
        }
        if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
            StoreDebug.storeIOPhysical.debug("Config for " + (this.isReplicatedStore ? this.storeName + "(Region Name=" + this.regionName + ")" : this.storeName) + "\nwritePolicy=" + this.config.get("SynchronousWritePolicy") + "\nfileLocking=" + this.locking + "\nioSize=" + this.config.get("IoBufferSize") + "\nblockSize=" + this.config.get("BlockSize") + "\nminMapSize=" + this.config.get("MinWindowBufferSize") + "\nmaxMapSize=" + this.config.get("MaxWindowBufferSize") + "\nmaxFileSize=" + this.config.get("MaxFileSize"));
        }
        this.ioSize = (ioSizeConfig = (Integer)this.config.get("IoBufferSize")) == null || ioSizeConfig < 0 ? DEFAULT_IO_SIZE : Heap.adjustedIOSize("IOBufferSize", ioSizeConfig);
        Integer minMapSizeConfig = (Integer)this.config.get("MinWindowBufferSize");
        this.minMapSize = minMapSizeConfig == null || minMapSizeConfig < 0 ? DEFAULT_MIN_MAP_SIZE : Heap.power2("MinWindowBufferSize", minMapSizeConfig);
        Integer maxMapSizeConfig = (Integer)this.config.get("MaxWindowBufferSize");
        this.maxMapSize = maxMapSizeConfig == null || maxMapSizeConfig < 0 ? DEFAULT_MAX_MAP_SIZE : Heap.power2("MaxWindowBufferSize", maxMapSizeConfig);
        this.cacheDir = (String)this.config.get("CacheDirectory");
        if (this.cacheDir == null) {
            String domain = (String)this.config.get("DomainName");
            this.tempDirPrefix = OS_TMP_DIR + File.separator + (domain == null ? WL_CLIENT : domain);
        } else {
            this.cacheDir = this.cacheDir + File.separator + WLS_STORE_CACHE;
        }
        this.bufferPool = new DirectBufferPool(this.ioSize, this.stats);
        if (!this.isReplicatedStore && this.writePolicy.schedulerNeeded()) {
            this.scheduler.calibrate(this.dir.getDirName());
        } else {
            this.scheduler.disable();
        }
        this.allocator = new StoreHeap(this.scheduler.isEnabled());
        try {
            files = this.dir.open(this.bufferPool, this.autoCreateDirs);
        }
        catch (IOException e) {
            throw new PersistentStoreException(e);
        }
        if (!this.directIOManager.nativeFileCodeAvailable() && !this.writePolicy.unforced() && KernelStatus.isServer()) {
            StoreLogger.logNativeDriverLoadFailure(this.storeName);
        }
        if (this.writePolicy == StoreWritePolicy.DIRECT_WRITE_WITH_CACHE) {
            if (this.directAlignment < 0) {
                this.writePolicy = StoreWritePolicy.DIRECT_WRITE;
            } else {
                this.supportOSDirectIO = true;
                this.singleHandleDirectIO = true;
            }
        }
        if (!this.isReplicatedStore && this.writePolicy == StoreWritePolicy.DIRECT_WRITE) {
            if (this.directAlignment > 0) {
                this.evaluateDirectIOModeProperties();
            } else if (DirectIOManager.getManager().nativeFileCodeAvailable() && KernelStatus.isServer()) {
                StoreLogger.logWritePolicyDowngraded(this.storeName);
            }
        }
        String failedOpen = null;
        try {
            for (StoreFile f : files) {
                failedOpen = f.getName();
                this.openStoreFile(f);
            }
        }
        catch (IOException ioe) {
            for (StoreFile f : files) {
                try {
                    f.close();
                }
                catch (IOException e) {}
            }
            if (this.isReplicatedStore) {
                throw new PersistentStoreException(StoreLogger.logRegionOpenErrorLoggable(this.storeName, failedOpen.toString()), (Throwable)ioe);
            }
            throw new PersistentStoreException(StoreLogger.logFileOpenErrorLoggable(this.storeName, failedOpen.toString()), (Throwable)ioe);
        }
        if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
            StoreDebug.storeIOPhysicalVerbose.debug("Opening dir=" + this.dir.getDirName() + " total file size = " + this.dir.getBytesUsed() + " bytes ");
        }
        if (this.dir.numFiles() == 0) {
            this.blockSize = -1;
            this.heapVersion = (short)3;
            this.heapRecordMagic = Heap.generateHeaderMagic();
            this.establishBlockSize(0);
            this.establishMaxFileSize();
            this.establishUUID();
            Long configInitialStoreBytes = (Long)this.config.get("InitialSize");
            if (configInitialStoreBytes != null && configInitialStoreBytes > 0L) {
                long maxFileBlocks = this.maxFileSize / (long)this.blockSize;
                try {
                    int nextBlocks;
                    for (long initStoreBlocks = configInitialStoreBytes / (long)this.blockSize; initStoreBlocks > 0L; initStoreBlocks -= (long)nextBlocks) {
                        nextBlocks = (int)Math.min(initStoreBlocks, maxFileBlocks);
                        this.reserveSpace(nextBlocks);
                    }
                }
                catch (IOException e) {
                    if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                        StoreDebug.storeIOPhysical.debug("Heap.open: Error trying to reserve more file space.", e);
                    }
                    throw new PersistentStoreException(e);
                }
            }
            this.completeRecovery();
        } else {
            this.recoveryComplete = false;
            this.recoveryFileNum = 0;
            this.blockSize = -1;
            this.getNextRecoveryFile();
        }
        this.isOpen = true;
    }

    public void removeStoreFiles() throws PersistentStoreException {
        if (this.dir == null) {
            return;
        }
        if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
            StoreDebug.storeIOPhysicalVerbose.debug("Purging store files in directory " + this.dirName);
        }
        try {
            this.dir.deleteFiles();
        }
        catch (Exception e) {
            throw new PersistentStoreException("Cannot purge store", (Throwable)e);
        }
    }

    private void openStoreFile(StoreFile file) throws IOException {
        file.ioSize = this.ioSize;
        file.minMapSize = this.minMapSize;
        file.maxMapSize = this.maxMapSize;
        file.locking = this.locking;
        file.stats = this.stats;
        file.enforceExplicitIO = this.enforceExplicitIO;
        if (this.supportOSDirectIO) {
            if (this.singleHandleDirectIO) {
                file.openSingleHandleDirect(this.writePolicy);
            } else {
                file.openDirect(this.writePolicy);
            }
        } else {
            file.open(this.writePolicy);
        }
    }

    FileChannel fileChannelFactory(File file, String mode, boolean exclusive) throws IOException {
        if (this.baseStoreIO == null) {
            return FileStoreIO.staticOpen(this, file, mode, exclusive);
        }
        return this.baseStoreIO.fileChannelFactory(this.config, file, mode, exclusive);
    }

    private void openCacheFile(StoreFile file) throws IOException {
        if (this.cacheDir == null) {
            this.cacheDir = this.tempDirPrefix + File.separator + this.uuidStr;
        }
        file.openCacheFile(this.cacheDir, this.isReplicatedStore ? this.regionName : this.storeName);
    }

    public int getBlockSize() {
        return this.blockSize - HEADER_LENGTH;
    }

    public final int getInternalBlockSize() {
        return this.blockSize;
    }

    long getMaxFileSize() {
        return this.maxFileSize;
    }

    public short getHeapVersion() {
        return this.heapVersion;
    }

    private final int getNextExtentSize() {
        int ret = this.extentBlocks;
        this.extentBlocks = Math.min(this.extentBlocks * 2, this.maxExtentBlocks);
        return ret;
    }

    private void reserveSpace(int blocks) throws IOException, PersistentStoreException {
        long bytes;
        block25: {
            StoreFile lastFile;
            if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
                StoreDebug.storeIOPhysicalVerbose.debug("reserveSpace begin");
            }
            blocks = Math.max(blocks, this.getNextExtentSize());
            bytes = blocks * this.blockSize;
            if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                StoreDebug.storeIOPhysical.debug("Heap: Trying to reserve " + bytes + " bytes more file space.");
            }
            if (bytes > this.maxFileSize) {
                if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                    StoreDebug.storeIOPhysical.debug("Heap: bytes " + bytes + " exceeds maxFileSize " + this.maxFileSize);
                }
                throw new PersistentStoreException(StoreLogger.logRecordTooLongLoggable(this.maxFileSize));
            }
            if (this.dir.numFiles() > 0 && (lastFile = this.dir.get(this.dir.numFiles() - 1)).checkFileBytesQuota(bytes, this.maxFileSize)) {
                try {
                    int startBlock = (int)(lastFile.size() / (long)this.blockSize);
                    lastFile.expand(bytes);
                    this.allocator.expand(lastFile.getFileNum(), startBlock, blocks);
                    this.updateStats(lastFile);
                    if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                        StoreDebug.storeIOPhysical.debug("Heap: Expanded file " + lastFile.getFileNum() + " by " + bytes + " bytes to " + lastFile.size() + " bytes.");
                    }
                    return;
                }
                catch (IOException i) {
                    if (!StoreHeap.DEBUG_SPACE_UPDATES || !this.isReplicatedStore || !StoreDebug.storeIOPhysical.isDebugEnabled()) break block25;
                    StoreDebug.storeIOPhysical.debug("RS: " + this.storeName + " got exception when expand the current file, will create a new file. ");
                }
            }
        }
        if (this.dir.numFiles() >= Short.MAX_VALUE) {
            if (this.isReplicatedStore) {
                throw new PersistentStoreException(StoreLogger.logTooManyRegionsCreatedLoggable(Short.MAX_VALUE));
            }
            throw new PersistentStoreException(StoreLogger.logTooManyFilesCreatedLoggable(Short.MAX_VALUE));
        }
        short newFileNum = (short)this.dir.numFiles();
        File newFile = this.dir.createFile(newFileNum);
        StoreFile newStoreFile = new StoreFile(this, this.dir, newFile, newFileNum, this.bufferPool);
        try {
            ByteBuffer fileHeaderBuf;
            boolean firstAttempt = true;
            while (true) {
                this.openStoreFile(newStoreFile);
                try {
                    if (newStoreFile.hasCacheFile()) {
                        this.openCacheFile(newStoreFile);
                    }
                    newStoreFile.expand(bytes + (long)this.blockSize);
                }
                catch (IOException ioEx) {
                    this.checkLockedMapException(newStoreFile, firstAttempt, ioEx);
                    firstAttempt = false;
                    continue;
                }
                break;
            }
            HeapFileHeader fileHeader = new HeapFileHeader(this.heapVersion, this.blockSize, this.uuidLo, this.uuidHi, this.heapRecordMagic);
            if (newStoreFile.mapped()) {
                fileHeaderBuf = newStoreFile.getDirectMappedBuffer(0L, 0 + this.blockSize);
                fileHeader.serialize(fileHeaderBuf);
            } else {
                fileHeaderBuf = fileHeader.getBuffer();
            }
            if (this.writeExplicit()) {
                newStoreFile.write(0L, fileHeaderBuf);
            }
            newStoreFile.flush0();
            this.allocator.expand(newFileNum, 1, blocks);
            this.dir.addNewFile(newStoreFile);
            this.updateStats(newStoreFile);
            if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                StoreDebug.storeIOPhysical.debug("Heap: Created new file " + newFileNum + " in dir " + this.dir.getDirName() + " with " + bytes + " bytes.");
            }
            return;
        }
        catch (IOException iii) {
            block26: {
                try {
                    newStoreFile.close();
                }
                catch (IOException fileHeaderBuf) {
                    // empty catch block
                }
                try {
                    newFile.delete();
                }
                catch (SecurityException se) {
                    if (!StoreDebug.storeIOPhysical.isDebugEnabled()) break block26;
                    StoreDebug.storeIOPhysical.debug("Heap: SecurityException: " + se.toString(), se);
                }
            }
            IOException lastIOException = iii;
            if (lastIOException != null) {
                throw lastIOException;
            }
            throw new AssertionError((Object)"Internal error expanding file store");
        }
    }

    private void checkLockedMapException(StoreFile f, boolean firstAttempt, IOException ioEx) throws IOException {
        if (firstAttempt && this.locking && f.getFileNum() == 0 && f.mapped()) {
            if (f.hasCacheFile()) {
                File cf = f.getCacheFile();
                if (cf != null) {
                    StoreLogger.logFileMappingError(this.isReplicatedStore ? this.storeName + "(Region Name=" + this.regionName + ")" : this.storeName, cf.toString(), ioEx);
                }
            } else if (StoreDebug.cacheDebug.isDebugEnabled()) {
                StoreDebug.cacheDebug.debug("Fall back on conventional IO for a locked file: " + f, ioEx);
            }
            try {
                f.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.writePolicy.unforced()) {
                this.enforceExplicitIO = true;
            } else {
                this.writePolicy = StoreWritePolicy.DIRECT_WRITE;
                this.singleHandleDirectIO = true;
                this.supportOSDirectIO = false;
            }
        } else {
            throw ioEx;
        }
    }

    @Deprecated
    public long[] multiWrite(List<List<ByteBuffer>> records, boolean autoFlush) throws PersistentStoreException {
        return this.multiWrite(records);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] multiWrite(List<List<ByteBuffer>> records) throws PersistentStoreException {
        StoreFile writeFile;
        long[] handles;
        Object heapHeader;
        if (!this.recoveryComplete) {
            throw new PersistentStoreException(StoreLogger.logRecoveryNotCompleteLoggable());
        }
        int numRecords = records.size();
        int[] numBlocks = new int[numRecords];
        HeapHeader[] headers = new HeapHeader[numRecords];
        short[] paddings = new short[numRecords];
        int totalNumBlocks = 0;
        Iterator<List<ByteBuffer>> iter = records.iterator();
        for (int i = 0; i < numRecords; ++i) {
            List<ByteBuffer> record = iter.next();
            heapHeader = new HeapHeader(record);
            short padding = Heap.getPadding(((HeapHeader)heapHeader).totalLength, (short)this.blockSize);
            int blocks = (((HeapHeader)heapHeader).totalLength + padding) / this.blockSize;
            headers[i] = heapHeader;
            paddings[i] = padding;
            numBlocks[i] = blocks;
            totalNumBlocks += blocks;
        }
        heapHeader = this;
        synchronized (heapHeader) {
            handles = this.allocator.alloc(this.lastFileWritten, this.scheduler.getNextBlock(), numBlocks);
            if (handles == null) {
                try {
                    this.reserveSpace(totalNumBlocks);
                }
                catch (IOException ioe) {
                    if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                        StoreDebug.storeIOPhysical.debug("Heap.multiWrite: Error trying to reserve more file space.", ioe);
                    }
                    throw new PersistentStoreException(ioe);
                }
                catch (RuntimeException rte) {
                    if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                        StoreDebug.storeIOPhysical.debug("Heap.multiWrite: Error trying to reserve more file space.", rte);
                    }
                    throw new PersistentStoreException(rte);
                }
                catch (Error err) {
                    if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                        StoreDebug.storeIOPhysical.debug("Heap.multiWrite: Error trying to reserve more file space.", err);
                    }
                    throw new PersistentStoreException(err);
                }
                handles = this.allocator.alloc(this.lastFileWritten, this.scheduler.getNextBlock(), numBlocks);
                if (handles == null) {
                    throw new AssertionError((Object)"Internal error: No room in the store");
                }
            }
            if (HANDLE_TRACKING) {
                for (int ht = 0; ht < handles.length; ++ht) {
                    this.addHandle(handles[ht]);
                }
            }
            this.lastFileWritten = StoreHeap.handleToFileNum(handles[0]);
            writeFile = this.dir.get(this.lastFileWritten);
            if (writeFile.getWritePolicy() != this.writePolicy) {
                try {
                    writeFile.close();
                    this.openStoreFile(writeFile);
                }
                catch (IOException ioe) {
                    throw new PersistentStoreException(StoreLogger.logErrorWritingToStoreLoggable(), (Throwable)ioe);
                }
            }
        }
        int writeBlock = StoreHeap.handleToFileBlock(handles[0]);
        StoreFileCursor fileCursor = new StoreFileCursor(writeFile, writeBlock, totalNumBlocks);
        this.scheduler.start();
        try {
            int index = 0;
            for (List<ByteBuffer> record : records) {
                fileCursor.writeDataWithChecksumInTail(headers[index], record, paddings[index]);
                ++index;
            }
            fileCursor.finalWrite();
            if (this.writePolicy == StoreWritePolicy.CACHE_FLUSH) {
                Heap heap = this;
                synchronized (heap) {
                    this.flushList.add(writeFile);
                }
                this.flush();
            }
            this.scheduler.stop(writeBlock + totalNumBlocks);
            this.updateStats(writeFile);
        }
        catch (IOException ioe) {
            throw new PersistentStoreException(StoreLogger.logErrorWritingToStoreLoggable(), (Throwable)ioe);
        }
        finally {
            fileCursor.realeaseBuffer();
        }
        return handles;
    }

    private boolean writeExplicit() {
        return this.writePolicy.writeExplicit() || this.enforceExplicitIO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(long handle) throws PersistentStoreException {
        boolean needsFlush;
        StoreFile deleteFile;
        if (!this.recoveryComplete) {
            throw new PersistentStoreException(StoreLogger.logRecoveryNotCompleteLoggable());
        }
        if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
            StoreDebug.storeIOPhysical.debug("Heap: Deleting record " + Heap.handleToString(handle));
        }
        Heap heap = this;
        synchronized (heap) {
            deleteFile = this.dir.get(StoreHeap.handleToFileNum(handle));
        }
        try {
            needsFlush = this.zeroOutMagic(deleteFile, StoreHeap.handleToFileBlock(handle), false);
        }
        catch (IOException ioe) {
            throw new PersistentStoreException(StoreLogger.logErrorWritingToStoreLoggable(), (Throwable)ioe);
        }
        Heap ioe = this;
        synchronized (ioe) {
            if (HANDLE_TRACKING) {
                this.checkHandle(handle);
            }
            if (needsFlush) {
                this.flushList.add(deleteFile);
            }
            this.allocator.free(handle);
            if (HANDLE_TRACKING) {
                this.removeHandle(handle);
            }
        }
        try {
            this.updateStats(deleteFile);
        }
        catch (IOException ioe2) {
            throw new PersistentStoreException(StoreLogger.logErrorWritingToStoreLoggable(), (Throwable)ioe2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(long handle) {
        if (handle == -1L) {
            return;
        }
        if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
            StoreDebug.storeIOPhysical.debug("Forgetting record " + Heap.handleToString(handle));
        }
        Heap heap = this;
        synchronized (heap) {
            if (HANDLE_TRACKING) {
                this.checkHandle(handle);
            }
            this.allocator.free(handle);
            if (HANDLE_TRACKING) {
                this.removeHandle(handle);
            }
        }
        try {
            this.updateStats(this.dir.get(StoreHeap.handleToFileNum(handle)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean zeroOutMagic(StoreFile file, int fileBlock, boolean flushNow) throws IOException {
        this.directZeroBuffer.clear();
        long filePos = fileBlock * this.blockSize;
        if (file.mapped()) {
            ByteBuffer mappedBlock = file.getDirectMappedBuffer(filePos, filePos + (long)this.blockSize);
            DirectIOManager.getFileMemoryManager().zeroBuffer(mappedBlock);
        }
        if (this.writeExplicit()) {
            file.write(filePos, this.directZeroBuffer);
        }
        if (this.writePolicy == StoreWritePolicy.CACHE_FLUSH) {
            if (flushNow) {
                file.flush();
            }
            return !flushNow;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws PersistentStoreException {
        ArrayList<StoreFile> tmpList;
        Heap heap = this;
        synchronized (heap) {
            if (this.flushList.isEmpty()) {
                return;
            }
            tmpList = new ArrayList<StoreFile>(this.flushList);
            this.flushList.clear();
        }
        IOException savedException = null;
        for (StoreFile curFile : tmpList) {
            try {
                curFile.flush();
            }
            catch (IOException ioe) {
                savedException = ioe;
            }
            if (!StoreDebug.storeIOPhysical.isDebugEnabled()) continue;
            StoreDebug.storeIOPhysical.debug("Heap: Flushed fileNum " + curFile.getFileNum());
        }
        if (savedException != null) {
            if (this.isReplicatedStore) {
                throw new PersistentStoreException(StoreLogger.logErrorFlushingRegionLoggable(), (Throwable)savedException);
            }
            throw new PersistentStoreException(StoreLogger.logErrorFlushingFileLoggable(), (Throwable)savedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeapRecord read(long handle) throws PersistentStoreException {
        ByteBuffer buf;
        StoreFile file;
        if (!this.recoveryComplete) {
            throw new PersistentStoreException(StoreLogger.logRecoveryNotCompleteLoggable());
        }
        if (HANDLE_TRACKING) {
            this.checkHandle(handle);
        }
        if (handle == 0L || handle == -1L) {
            throw new PersistentStoreException(StoreLogger.logInvalidRecordHandleLoggable(handle));
        }
        if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
            StoreDebug.storeIOPhysical.debug("Heap: Reading record " + Heap.handleToString(handle));
        }
        short fileNum = StoreHeap.handleToFileNum(handle);
        int fileBlock = StoreHeap.handleToFileBlock(handle);
        int numBlocks = StoreHeap.handleToNumBlocks(handle);
        if (fileNum < 0 || fileBlock < 0 || numBlocks <= 0) {
            throw new PersistentStoreException(StoreLogger.logInvalidRecordHandleLoggable(handle));
        }
        Heap heap = this;
        synchronized (heap) {
            file = this.dir.get(fileNum);
        }
        int heapRecordSize = numBlocks * this.blockSize;
        int filePos = fileBlock * this.blockSize;
        if (file.mapped()) {
            buf = file.mappedRead(filePos, heapRecordSize);
        } else {
            buf = ByteBuffer.allocate(heapRecordSize);
            try {
                file.read(filePos, buf);
            }
            catch (IOException ioe) {
                throw new PersistentStoreException(StoreLogger.logErrorReadingFromStoreLoggable(), (Throwable)ioe);
            }
        }
        if (!this.verifyMagic(buf)) {
            throw new PersistentStoreException(StoreLogger.logStoreRecordNotFoundLoggable(handle));
        }
        HeapHeader headerRec = new HeapHeader(buf);
        HeapRecord heapRecord = this.readRecord(headerRec, buf);
        heapRecord.setHandle(handle);
        return heapRecord;
    }

    public synchronized HeapRecord recover() throws PersistentStoreException {
        HeapRecord ret;
        int recBlocks;
        StoreFile file;
        if (this.recoveryComplete) {
            return null;
        }
        boolean storeIOPhysicalDebugEnabled = StoreDebug.storeIOPhysical.isDebugEnabled();
        while (true) {
            ByteBuffer recBuf;
            ByteBuffer headerBlock;
            if (this.recoveryBlock >= this.recoveryFileBlocks || this.writePolicy == StoreWritePolicy.NON_DURABLE) {
                if (this.writePolicy.configurable()) {
                    this.dir.get(this.recoveryFileNum).commitScan(this.heapVersion, this.blockSize, this.uuidLo, this.uuidHi, this.heapRecordMagic);
                }
                this.recoveryFileNum = (short)(this.recoveryFileNum + 1);
                if (this.recoveryFileNum >= this.dir.numFiles()) {
                    this.completeRecovery();
                    return null;
                }
                if (storeIOPhysicalDebugEnabled) {
                    StoreDebug.storeIOPhysical.debug("Heap: Switching recovery to file " + this.recoveryFileNum);
                }
                file = this.getNextRecoveryFile();
            } else {
                file = this.dir.get(this.recoveryFileNum);
            }
            ByteBuffer byteBuffer = headerBlock = file.mapped() ? file.mappedRecoveryRead(this.recoveryBlock * this.blockSize, this.blockSize) : this.readStoreFile(file, this.blockSize);
            if (!this.verifyMagic(headerBlock)) {
                if (!file.mapped()) {
                    this.rollbackReadMoveNextBlock();
                }
                ++this.recoveryBlock;
                continue;
            }
            HeapHeader headerRec = new HeapHeader(headerBlock);
            recBlocks = headerRec.getNumBlocks(this.blockSize);
            if (recBlocks > 1) {
                int multiBlockRecordSize = recBlocks * this.blockSize;
                recBuf = file.mapped() ? file.mappedRecoveryRead(this.recoveryBlock * this.blockSize, multiBlockRecordSize) : this.readStoreFile(file, multiBlockRecordSize);
                headerRec = new HeapHeader(recBuf);
            } else {
                recBuf = headerBlock;
            }
            try {
                ret = this.readRecord(headerRec, recBuf);
            }
            catch (PersistentStoreException pse) {
                if (storeIOPhysicalDebugEnabled) {
                    StoreDebug.storeIOPhysical.debug("Invalid record at block " + this.recoveryBlock + ": " + pse);
                }
                try {
                    if (ENABLE_FILESTORE_CLEAN_ON_BOOT) {
                        this.zeroOutMagic(file, this.recoveryBlock, true);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!file.mapped()) {
                    this.rollbackReadMoveNextBlock();
                }
                ++this.recoveryBlock;
                continue;
            }
            break;
        }
        long handle = this.allocator.allocForce(this.recoveryFileNum, this.recoveryBlock, recBlocks);
        assert (StoreHeap.handleToFileBlock(handle) == this.recoveryBlock);
        ret.setHandle(handle);
        if (HANDLE_TRACKING) {
            this.addHandle(handle);
        }
        if (storeIOPhysicalDebugEnabled) {
            StoreDebug.storeIOPhysical.debug("Recovered record with handle " + Heap.handleToString(handle));
        }
        if (!file.mapped()) {
            this.commitRead(recBlocks);
        }
        this.recoveryBlock += recBlocks;
        return ret;
    }

    private ByteBuffer readStoreFile(StoreFile file, int size) throws PersistentStoreException {
        int targetRemaining = size;
        while (this.readLogRemaining < size) {
            ByteBuffer buf = this.bufferPool.get();
            try {
                int count = file.readBulk(this.recoveryFilePos, buf, size - this.readLogRemaining);
                this.readLogRemaining += count;
                this.recoveryFilePos += (long)count;
                this.readLog.add(new ReadLogNode(buf));
            }
            catch (IOException ioe) {
                throw new PersistentStoreException(StoreLogger.logErrorReadingFromStoreLoggable(), (Throwable)ioe);
            }
        }
        ByteBuffer copyTarget = null;
        for (ReadLogNode rln : this.readLog) {
            ByteBuffer source = rln.buf;
            int sourceLimit = source.limit();
            int sourceRemaining = source.remaining();
            int chunk = Math.min(targetRemaining, sourceRemaining);
            source.limit(source.position() + chunk);
            if (copyTarget == null) {
                if (chunk == size) {
                    ByteBuffer slice = source.slice();
                    source.limit(sourceLimit);
                    return slice;
                }
                copyTarget = ByteBuffer.allocate(size);
            }
            copyTarget.put(source);
            source.position(source.limit() - chunk);
            source.limit(sourceLimit);
            if (!copyTarget.hasRemaining()) break;
            targetRemaining -= chunk;
        }
        copyTarget.clear();
        return copyTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreFile getNextRecoveryFile() throws PersistentStoreException {
        this.cleanupReadLog();
        this.recoveryFilePos = 0L;
        this.recoveryBlock = 0;
        StoreFile file = this.dir.get(this.recoveryFileNum);
        HeapFileHeader header = null;
        boolean firstAttempt = true;
        while (true) {
            try {
                if (!firstAttempt) {
                    this.openStoreFile(file);
                }
                if (file.mapped()) {
                    if (file.hasCacheFile()) {
                        ByteBuffer primaryHeaderBuf = this.bufferPool.get();
                        try {
                            primaryHeaderBuf.limit(8192);
                            file.read(0L, primaryHeaderBuf);
                            primaryHeaderBuf.position(0);
                            header = new HeapFileHeader(primaryHeaderBuf);
                            if (header.version == 1) {
                                throw new PersistentStoreException(this.writePolicy + "(" + file.getIOMode() + ") is not supported with 9.0- Stores.");
                            }
                            if (this.recoveryFileNum == 0) {
                                this.establishUUID(header.uuidLo, header.uuidHi);
                            }
                            this.openCacheFile(file);
                        }
                        finally {
                            this.bufferPool.put(primaryHeaderBuf);
                        }
                    } else {
                        header = file.mappedRecoveryInit(this.isReplicatedStore ? this.regionName : this.storeName);
                        if (this.recoveryFileNum == 0) {
                            this.establishUUID(header.uuidLo, header.uuidHi);
                        }
                    }
                } else {
                    ByteBuffer headerBuf = this.readStoreFile(file, 512);
                    header = new HeapFileHeader(headerBuf);
                    if (this.recoveryFileNum == 0) {
                        this.establishUUID(header.uuidLo, header.uuidHi);
                    }
                }
                if (this.recoveryFileNum != 0) break;
                this.heapRecordMagic = header.heapHeaderMagic;
            }
            catch (IOException e) {
                try {
                    this.checkLockedMapException(file, firstAttempt, e);
                }
                catch (IOException f) {
                    throw new PersistentStoreException(f);
                }
                firstAttempt = false;
                continue;
            }
            break;
        }
        if (this.recoveryFileNum == 0) {
            this.establishBlockSize(header.blockSize);
            this.establishMaxFileSize();
            this.heapVersion = header.version;
        } else {
            if (header.blockSize != this.blockSize) {
                throw new AssertionError((Object)"Mismatched file block sizes");
            }
            if (header.version != this.heapVersion) {
                throw new AssertionError((Object)"Mismatched heap file versions");
            }
            if ((header.uuidLo != this.uuidLo || header.uuidHi != this.uuidHi) && header.uuidLo != 0L && header.uuidHi != 0L) {
                throw new AssertionError((Object)"Mismatched uuid");
            }
        }
        if (file.hasCacheFile()) {
            try {
                file.verifyCacheFile(header, this.isReplicatedStore ? this.regionName : this.storeName);
            }
            catch (IOException e) {
                throw new PersistentStoreException(e);
            }
        }
        this.recoveryFileBlocks = (int)file.size() / this.blockSize;
        if (header.version == 2 || header.version == 3) {
            this.allocator.expand(this.recoveryFileNum, 1, this.recoveryFileBlocks - 1);
            this.recoveryBlock = 1;
            if (!file.mapped()) {
                this.rollbackReadMoveNextBlock();
            }
        } else if (header.version == 1) {
            this.allocator.expand(this.recoveryFileNum, 0, this.recoveryFileBlocks);
            this.recoveryBlock = 0;
        } else {
            throw new AssertionError((Object)("Unknown heap file version " + header.version));
        }
        return file;
    }

    private void completeRecovery() throws PersistentStoreException {
        if (this.recoveryComplete) {
            return;
        }
        StoreDebug.storeIOPhysical.debug("Heap: Reached end of recovery scan");
        try {
            for (StoreFile f : this.dir.getFiles()) {
                f.adjustFileSize(this.blockSize);
                this.updateStats(f);
            }
        }
        catch (IOException e) {
            throw new PersistentStoreException(e);
        }
        this.cleanupReadLog();
        this.recoveryComplete = true;
        if (StoreHeap.DEBUG_SPACE_UPDATES && this.isReplicatedStore && StoreDebug.storeIOPhysical.isDebugEnabled() && this.allocator != null) {
            StoreDebug.storeIOPhysical.debug("RS recovery: allocatedBlocks = " + this.allocator.getAllocatedBlocks());
        }
    }

    private void cleanupReadLog() throws PersistentStoreException {
        if (this.readLog.size() > 1) {
            throw new PersistentStoreException("At most one outstanding recovery buffer expected.");
        }
        if (!this.readLog.isEmpty()) {
            ReadLogNode rest = this.readLog.removeFirst();
            this.bufferPool.put(rest.buf);
        }
        this.bufferPool.close();
    }

    private void establishBlockSize(int newBlockSize) throws PersistentStoreException {
        Integer configBlockSize = (Integer)this.config.get("BlockSize");
        DirectIOManager ioManager = DirectIOManager.getFileMemoryManager();
        if (newBlockSize <= 0) {
            this.blockSize = this.localBlockSizeProperty != null ? this.localBlockSizeProperty : (DEFAULT_BLOCK_SIZE != null ? DEFAULT_BLOCK_SIZE : (configBlockSize != null && configBlockSize > 0 ? Heap.adjustedBlockSize("BlockSize in config.xml", configBlockSize) : (this.directAlignment <= 0 || this.directAlignment > 8192 ? 512 : this.directAlignment)));
        } else {
            this.blockSize = newBlockSize;
            if (this.isReplicatedStore) {
                this.blockSize = Heap.power2("ReplicatedStore " + this.getName() + ", block-size in config.xml", configBlockSize);
            }
            if (this.localBlockSizeProperty != null) {
                if (this.blockSize != this.localBlockSizeProperty) {
                    if (this.isReplicatedStore) {
                        StoreLogger.logReplicatedStoreBlockSizeIgnored(this.localBlockSizePropertyName, this.storeName, this.regionName);
                    } else {
                        StoreLogger.logBlockSizeIgnored(this.localBlockSizePropertyName, this.storeName);
                    }
                }
            } else if (DEFAULT_BLOCK_SIZE != null) {
                if (this.blockSize != DEFAULT_BLOCK_SIZE) {
                    if (this.isReplicatedStore) {
                        StoreLogger.logReplicatedStoreBlockSizeIgnored("weblogic.store.BlockSize", this.storeName, this.regionName);
                    } else {
                        StoreLogger.logBlockSizeIgnored("weblogic.store.BlockSize", this.storeName);
                    }
                }
            } else if (configBlockSize != null && configBlockSize > 0 && this.blockSize != configBlockSize) {
                if (this.isReplicatedStore) {
                    StoreLogger.logReplicatedStoreBlockSizeIgnored("in config.xml", this.storeName, this.regionName);
                } else {
                    StoreLogger.logBlockSizeIgnored("in config.xml", this.storeName);
                }
            }
        }
        if (this.stats != null) {
            this.stats.setBlockSize(this.blockSize);
        }
        boolean supportOSDirectIOFlopped = this.supportOSDirectIO;
        this.supportOSDirectIO = this.supportOSDirectIO && this.blockSize % this.directAlignment == 0;
        supportOSDirectIOFlopped = supportOSDirectIOFlopped && !this.supportOSDirectIO;
        this.directZeroBuffer = ioManager.getZeroBuffer(this.blockSize);
        Integer initialExtentOverride = Integer.getInteger("weblogic.store.InitialExtentSize");
        this.extentBlocks = initialExtentOverride == null ? 0x100000 / this.blockSize : Math.max(1, initialExtentOverride / this.blockSize);
        this.maxExtentBlocks = 0xA00000 / this.blockSize;
        if (supportOSDirectIOFlopped) {
            StoreLogger.logIncompatibleDirectIOAlignment(this.isReplicatedStore ? this.storeName + "(Region Name=" + this.regionName + ")" : this.storeName, this.directAlignment, this.blockSize);
            if (this.dir.numFiles() > 0) {
                StoreFile file = this.dir.get(this.recoveryFileNum);
                String prevMode = file.getIOMode();
                List<StoreFile> files = this.dir.getFiles();
                for (StoreFile toOpen : files) {
                    try {
                        toOpen.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        this.openStoreFile(toOpen);
                    }
                    catch (IOException e) {
                        for (StoreFile toClose : files) {
                            try {
                                toClose.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw new PersistentStoreException(e);
                    }
                }
                if (prevMode == DIRECT_MODE_SINGLE_UNBUFFERED) {
                    this.cleanupReadLog();
                    this.writePolicy = StoreWritePolicy.DIRECT_WRITE;
                    this.readStoreFile(file, 512);
                }
            }
        }
    }

    private void establishUUID() {
        UUID uuid = UUID.randomUUID();
        this.uuidLo = uuid.getLeastSignificantBits();
        this.uuidHi = uuid.getMostSignificantBits();
        this.uuidStr = uuid.toString();
    }

    private void establishUUID(long headerUuidLo, long headerUuidHi) {
        UUID uuid = new UUID(headerUuidHi, headerUuidLo);
        this.uuidLo = uuid.getLeastSignificantBits();
        this.uuidHi = uuid.getMostSignificantBits();
        this.uuidStr = uuid.toString();
    }

    private void evaluateDirectIOModeProperties() {
        String directMode;
        String directPropName;
        String localPropName = "weblogic.store." + this.storeName + ".DirectIOMode";
        String localDirectMode = System.getProperty(localPropName);
        if (localDirectMode == null) {
            directPropName = "weblogic.store.DirectIOMode";
            directMode = GLOBAL_DIRECT_IO_MODE;
        } else {
            directPropName = localPropName;
            directMode = localDirectMode;
        }
        if (this.isReplicatedStore) {
            this.supportOSDirectIO = true;
            this.singleHandleDirectIO = true;
        } else if (DIRECT_MODE_DUAL_READ_BUFFERED.equalsIgnoreCase(directMode)) {
            this.supportOSDirectIO = true;
            this.singleHandleDirectIO = false;
        } else if (DIRECT_MODE_SINGLE_UNBUFFERED.equalsIgnoreCase(directMode)) {
            this.supportOSDirectIO = true;
            this.singleHandleDirectIO = true;
        } else if (DIRECT_MODE_SINGLE_BUFFERED.equalsIgnoreCase(directMode)) {
            this.supportOSDirectIO = false;
        } else if (directMode != null) {
            this.supportOSDirectIO = true;
            this.singleHandleDirectIO = true;
            StoreLogger.logInvalidDirectModeIgnored(directPropName, directMode, this.storeName, DIRECT_MODE_SINGLE_UNBUFFERED);
        } else {
            this.singleHandleDirectIO = false;
            String localAvoidDirectIO = System.getProperty("weblogic.store." + this.storeName + ".AvoidDirectIO");
            String avoidDirectIO = localAvoidDirectIO == null ? GLOBAL_AVOID_DIRECT_IO : localAvoidDirectIO;
            this.supportOSDirectIO = avoidDirectIO == null || avoidDirectIO.length() == 0 || !String.valueOf(true).equalsIgnoreCase(avoidDirectIO);
        }
    }

    private void establishMaxFileSize() {
        if (this.isReplicatedStore) {
            Integer maxFileSizeProp = (Integer)this.config.get("RegionSize");
            if (maxFileSizeProp == null) {
                throw new AssertionError((Object)"No region size set.");
            }
            if (this.blockSize == 0) {
                throw new AssertionError((Object)"Block size not set.");
            }
            this.maxFileSize = Math.max(maxFileSizeProp, 0xA00000);
            this.maxFileSize -= this.maxFileSize % 0xA00000L;
            if (this.maxFileSize < 0x1000000L) {
                throw new AssertionError((Object)("Too Small " + this.maxFileSize));
            }
            if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                StoreDebug.storeIOPhysical.debug("Heap: Rep Region Size " + this.maxFileSize);
            }
            return;
        }
        try {
            Long maxFileSizeProp = Long.getLong("weblogic.store.MaxFileSize", (Long)this.config.get("MaxFileSize"));
            if (maxFileSizeProp == null) {
                return;
            }
            if (this.blockSize == 0) {
                this.establishBlockSize(0);
            }
            this.maxFileSize = maxFileSizeProp;
            this.maxFileSize = Math.max(this.maxFileSize, 0xA00000L);
            if (this.maxFileSize % 0xA00000L > 0L) {
                this.maxFileSize = (this.maxFileSize / 0xA00000L + 1L) * 0xA00000L;
            }
            if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                StoreDebug.storeIOPhysical.debug("Heap: Max File Size " + this.maxFileSize);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void empty() throws PersistentStoreException {
        this.establishBlockSize(0);
        for (short fileNum = 0; fileNum < this.dir.numFiles(); fileNum = (short)(fileNum + 1)) {
            StoreFile file = this.dir.get(fileNum);
            int fileSize = (int)file.size();
            this.allocator.expand(fileNum, 1, fileSize / this.blockSize - 1);
            try {
                this.updateStats(file);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.completeRecovery();
    }

    public synchronized void close() throws PersistentStoreException {
        PersistentStoreException firstException = null;
        try {
            this.flush();
        }
        catch (PersistentStoreException pse) {
            firstException = pse;
        }
        for (StoreFile file : this.dir.getFiles()) {
            try {
                if (!file.hasCacheFile()) break;
                file.commitClose(this.blockSize);
            }
            catch (IOException e) {
                if (firstException != null) continue;
                firstException = new PersistentStoreException(e);
            }
        }
        try {
            this.dir.close();
        }
        catch (IOException ioe) {
            firstException = new PersistentStoreException(ioe);
        }
        this.closeInternal();
        if (firstException != null) {
            throw firstException;
        }
    }

    private void closeInternal() {
        if (this.allocator != null) {
            this.allocator.clear();
        }
        this.flushList.clear();
        this.cleanupHandleTracking();
        if (this.bufferPool != null) {
            this.bufferPool.close();
        }
        this.reinitFields();
    }

    private void reinitFields() {
        this.allocator = null;
        this.blockSize = 0;
        this.bufferPool = null;
        this.config = new HashMap<String, Object>();
        this.directZeroBuffer = null;
        this.extentBlocks = 0;
        this.heapVersion = 0;
        this.ht = null;
        this.ioSize = 0;
        this.locking = false;
        this.maxExtentBlocks = 0;
        this.maxFileSize = 0x50000000L;
        this.maxMapSize = 0;
        this.minMapSize = 0;
        this.readLogRemaining = 0;
        this.recoveryBlock = 0;
        this.recoveryComplete = false;
        this.recoveryFileBlocks = 0;
        this.recoveryFileNum = 0;
        this.recoveryFilePos = 0L;
        this.singleHandleDirectIO = false;
        this.stats = null;
        this.supportOSDirectIO = false;
        this.uuidHi = 0L;
        this.uuidLo = 0L;
        this.uuidStr = null;
        this.writePolicy = null;
        this.tempDirPrefix = null;
        this.enforceExplicitIO = false;
    }

    private HeapRecord readRecord(HeapHeader heapHeader, ByteBuffer buf) throws PersistentStoreException {
        int baseErrorNumber;
        int state;
        if (heapHeader.version != 5) {
            StoreDebug.storeIOPhysical.debug(">>>>> Reading record of version " + heapHeader.version);
        }
        if (heapHeader.version == 5 || heapHeader.version == 4) {
            state = 0;
            baseErrorNumber = 2;
        } else if (heapHeader.version == 2) {
            state = heapHeader.state;
            baseErrorNumber = 5;
        } else {
            throw new PersistentStoreException("Attempting to recover from an unsupported store version '" + heapHeader.version + "'. The supported store version is '" + 5 + "'.");
        }
        assert (heapHeader.bodyChecksum != -1L);
        try {
            if (heapHeader.bodyLength > 0) {
                ByteBuffer body = buf.slice();
                body.limit(heapHeader.bodyLength);
                long calculatedChecksum = this.readChecksummer.calculateChecksum(body);
                if (heapHeader.bodyChecksum != calculatedChecksum) {
                    throw new PersistentStoreException(StoreLogger.logInvalidStoreRecordLoggable(baseErrorNumber));
                }
                return new HeapRecord(body, state);
            }
            if (heapHeader.bodyChecksum != 1L && heapHeader.bodyChecksum != 0L) {
                throw new PersistentStoreException(StoreLogger.logInvalidStoreRecordLoggable(baseErrorNumber + 1));
            }
            return new HeapRecord(null, state);
        }
        catch (BufferUnderflowException underflow) {
            throw new PersistentStoreException(StoreLogger.logInvalidStoreRecordLoggable(baseErrorNumber + 2));
        }
    }

    private String getStackTrace() {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            builder.append(element.toString()).append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return this.allocator != null ? this.allocator.toString() : "null";
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static short getPadding(int size, short alignment) {
        short padding = (short)(alignment - size % alignment);
        return padding == alignment ? (short)0 : padding;
    }

    static String handleToString(long handle) {
        StringBuffer buf = new StringBuffer(32);
        buf.append('[');
        buf.append(StoreHeap.handleToFileNum(handle));
        buf.append('.');
        buf.append(StoreHeap.handleToFileBlock(handle));
        buf.append('.');
        buf.append(StoreHeap.handleToNumBlocks(handle));
        buf.append(']');
        return buf.toString();
    }

    private synchronized void cleanupHandleTracking() {
        if (this.ht != null) {
            this.ht.clear();
        }
    }

    private synchronized void addHandle(long handle) {
        if (this.ht == null) {
            this.ht = new HashMap<Long, Object>();
        }
        if (this.ht.get(handle) != null) {
            throw new AssertionError((Object)("Assertion: Duplicate handle " + Heap.handleToString(handle)));
        }
        this.ht.put(handle, this.ht);
    }

    private synchronized void removeHandle(long handle) {
        if (this.ht == null) {
            this.ht = new HashMap<Long, Object>();
        }
        if (this.ht.get(handle) == null) {
            throw new AssertionError((Object)("Assertion: Unknown handle " + Heap.handleToString(handle)));
        }
        this.ht.remove(handle);
    }

    private synchronized void checkHandle(long handle) {
        if (this.ht == null) {
            this.ht = new HashMap<Long, Object>();
        }
        if (this.ht.get(handle) == null) {
            throw new AssertionError((Object)("Assertion: Unknown handle " + Heap.handleToString(handle)));
        }
    }

    public String getDirectoryName() {
        return this.dir.getDirName();
    }

    public boolean getSupportOSDirectIO() {
        return this.supportOSDirectIO;
    }

    private void rollbackReadMoveNextBlock() {
        ReadLogNode rln = this.readLog.getFirst();
        int pos = rln.buf.position();
        assert (pos + this.blockSize <= rln.buf.limit());
        rln.buf.position(pos + this.blockSize);
        if (!rln.buf.hasRemaining()) {
            this.readLog.removeFirst();
            this.bufferPool.put(rln.buf);
        }
        this.readLogRemaining -= this.blockSize;
    }

    private void commitRead(int blocks) {
        int chunk;
        int targetRemaining;
        this.readLogRemaining -= targetRemaining;
        Iterator iter = this.readLog.iterator();
        for (targetRemaining = blocks * this.blockSize; iter.hasNext() && targetRemaining > 0; targetRemaining -= chunk) {
            ReadLogNode rln = (ReadLogNode)iter.next();
            chunk = Math.min(targetRemaining, rln.buf.remaining());
            int pos = rln.buf.position();
            rln.buf.position(pos + chunk);
            if (rln.buf.hasRemaining()) continue;
            iter.remove();
            this.bufferPool.put(rln.buf);
        }
    }

    private boolean verifyMagic(ByteBuffer buf) {
        return buf.getLong(0) == this.heapRecordMagic;
    }

    private static boolean byteBufferEqual(ByteBuffer a, ByteBuffer b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null || a.remaining() != b.remaining()) {
            return false;
        }
        a = a.slice();
        b = b.slice();
        while (a.hasRemaining()) {
            if (a.get() == b.get()) continue;
            return false;
        }
        return true;
    }

    private static int power2(String name, int val) {
        int p = Integer.highestOneBit(val);
        if (val != p) {
            int newBlockSize = p;
            StoreLogger.logSizeNotPowerOfTwo(name, val, newBlockSize);
            return newBlockSize;
        }
        return val;
    }

    private static int adjustedBlockSize(String name, int val) {
        if (val < 512 || val > 8192) {
            StoreLogger.logOutOfBlockSizeRange(name, val, 512, 8192, 512);
            return 512;
        }
        return Heap.power2(name, val);
    }

    private static int adjustedIOSize(String name, int val) {
        if (val < 8192) {
            return 8192;
        }
        return Heap.power2(name, val);
    }

    private static Integer getBlockSizeFromProperty(String name) {
        String blockSizeStr = System.getProperty(name);
        if (blockSizeStr != null) {
            try {
                return Heap.adjustedBlockSize(name, Integer.decode(blockSizeStr));
            }
            catch (NumberFormatException e) {
                StoreLogger.logInvalidIntegerProperty(name, blockSizeStr, 512);
                return 512;
            }
        }
        return null;
    }

    String getIOMode() {
        String ioMode = this.dir.numFiles() > 0 ? this.dir.get(0).getIOMode() : (this.writePolicy.synchronous() ? (this.supportOSDirectIO ? (this.singleHandleDirectIO ? DIRECT_MODE_SINGLE_UNBUFFERED : DIRECT_MODE_DUAL_READ_BUFFERED) : DIRECT_MODE_SINGLE_BUFFERED) : DIRECT_MODE_SINGLE_NONE);
        return this.writePolicy + "(" + ioMode + ")";
    }

    String getDriver() {
        if (this.baseStoreIO == null) {
            return DirectIOManager.getFileMemoryManager().getDriver();
        }
        return this.baseStoreIO.getDriver();
    }

    boolean getLocking() {
        if (System.getProperty("weblogic.store.file.LockEnabled") != null) {
            boolean fileStoreGlobalLockEnabeld = Boolean.getBoolean("weblogic.store.file.LockEnabled");
            if (StoreDebug.storeIOPhysical.isDebugEnabled()) {
                StoreDebug.storeIOPhysical.debug(this.storeName + " Global Store File Lock Enabled: " + fileStoreGlobalLockEnabeld);
            }
            return fileStoreGlobalLockEnabeld;
        }
        Boolean lockingConfig = (Boolean)this.config.get("FileLockingEnabled");
        return lockingConfig == null ? true : lockingConfig;
    }

    private void updateStats(StoreFile file) throws IOException {
        StoreFile lastFile;
        if (this.stats == null || this.blockSize == 0 || !this.isReplicatedStore) {
            return;
        }
        if (SKIP_SPACE_UPDATES) {
            return;
        }
        int maximumMessageSizePercent = (Integer)this.config.get("MaximumMessageSizePercent");
        long max = this.maxFileSize * (long)maximumMessageSizePercent / 100L;
        this.stats.setMaximumWriteSize(max > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)max);
        file.updateStats(this.stats, this.maxFileSize);
        long extraBytes = 0L;
        if (this.dir.numFiles() > 0 && (extraBytes = this.maxFileSize - (lastFile = this.dir.get(this.dir.numFiles() - 1)).size()) < 0xA00000L) {
            extraBytes = 0L;
        }
        long extraBlocks = extraBytes / (long)this.blockSize;
        long deleteRecordOnlyBlocks = 0L;
        if (this.baseStoreIO != null) {
            deleteRecordOnlyBlocks = this.baseStoreIO.getDeleteRecordOnlyBlocks();
        }
        this.allocator.updateStats(this.stats, extraBlocks, deleteRecordOnlyBlocks, this.blockSize);
    }

    void pollDevice() throws IOException {
        if (StoreHeap.DEBUG_SPACE_UPDATES && this.isReplicatedStore && StoreDebug.storeIOPhysical.isDebugEnabled()) {
            StoreDebug.storeIOPhysical.debug("RS: " + this.storeName + " Heap: " + this.getName() + " pollDevice(): stats= " + this.stats + " blockSize = " + this.blockSize + " isReplicatedStore = " + this.isReplicatedStore + " SKIP_STORE_UPDATES = " + SKIP_SPACE_UPDATES);
        }
        if (this.stats == null || this.blockSize == 0 || !this.isReplicatedStore || this.dir.numFiles() == 0) {
            return;
        }
        if (SKIP_SPACE_UPDATES) {
            return;
        }
        StoreFile lastFile = this.dir.get(this.dir.numFiles() - 1);
        lastFile.updateStats(this.stats, this.maxFileSize);
    }

    BaseStoreIO getBaseStoreIO() {
        return this.baseStoreIO;
    }

    String getStringConfig(String key) {
        return (String)this.config.get(key);
    }

    void dumpStoreHeap() {
        this.allocator.dump();
    }

    private static long generateHeaderMagic() throws PersistentStoreException {
        RuntimeException rtException = null;
        long hdrMagic = 0L;
        int retryCount = 0;
        try {
            while ((hdrMagic = SecureRandomData.getInstance().getRandomLong()) == 0L && retryCount++ < 10) {
            }
        }
        catch (RuntimeException rt) {
            rtException = rt;
        }
        if (rtException != null || hdrMagic == 0L) {
            if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("header initialization error");
                if (hdrMagic == 0L) {
                    sb.append("; retry max reached");
                }
                StoreDebug.storeIOPhysicalVerbose.debug(sb.toString(), rtException);
            }
            throw new PersistentStoreException(StoreLogger.logErrorInitializingStore(), (Throwable)rtException);
        }
        return hdrMagic;
    }

    static {
        LARGE_DEFAULTS = Integer.getInteger("sun.arch.data.model", 32) >= 64 || Boolean.getBoolean("weblogic.store.LargeDefaults");
        OS_TMP_DIR = System.getProperty("java.io.tmpdir") + File.separator + WLS_STORE_CACHE;
        DEFAULT_REPLICATED_SUFFIX = "rgn".toUpperCase();
        DEFAULT_REGION_DIR = File.separator + "regions";
        DEFAULT_BLOCK_SIZE = Heap.getBlockSizeFromProperty("weblogic.store.BlockSize");
        DEFAULT_IO_SIZE = LARGE_DEFAULTS ? 0x800000 : 0x100000;
        DEFAULT_MIN_MAP_SIZE = LARGE_DEFAULTS ? 262144 : 65536;
        DEFAULT_MAX_MAP_SIZE = LARGE_DEFAULTS ? 0x10000000 : 0x400000;
        GLOBAL_DIRECT_IO_MODE = System.getProperty("weblogic.store.DirectIOMode");
        GLOBAL_AVOID_DIRECT_IO = System.getProperty("weblogic.store.AvoidDirectIO");
        String enableZeroOutMagicOnRecover = System.getProperty("weblogic.store.EnableFileStoreCleanOnBoot");
        ENABLE_FILESTORE_CLEAN_ON_BOOT = enableZeroOutMagicOnRecover == null ? false : enableZeroOutMagicOnRecover.equalsIgnoreCase("true");
        SKIP_SPACE_UPDATES = Boolean.getBoolean("weblogic.store.SkipSpaceUpdates");
        if (SKIP_SPACE_UPDATES && StoreDebug.storeIOPhysical.isDebugEnabled()) {
            StoreDebug.storeIOPhysical.debug(" *** skipping store space stat updates because -Dweblogic.store.SkipSpaceUpdates=true ***");
        }
        OLD_HEADER_LENGTH = 50;
        HEADER_LENGTH = 42;
    }

    private static class Utility {
        private Utility() {
        }

        static byte[] longToBytes(long value) {
            byte[] bytes = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)(value >>> 0)};
            return bytes;
        }
    }

    private class StoreFileCursor {
        private StoreFile storeFile;
        private long filePos;
        private long limit;
        private ByteBuffer directBuffer;
        private int lastHeaderOffset;

        StoreFileCursor(StoreFile storeFile, int startBlock, int numBlocks) throws PersistentStoreException {
            this.storeFile = storeFile;
            this.filePos = startBlock * Heap.this.blockSize;
            this.limit = this.filePos + (long)(numBlocks * Heap.this.blockSize);
            try {
                this.directBuffer = storeFile.mapped() ? this.getMappedBuffer(this.filePos, this.limit) : Heap.this.bufferPool.get();
            }
            catch (IOException ioe) {
                throw new PersistentStoreException(StoreLogger.logErrorWritingToStoreLoggable(), (Throwable)ioe);
            }
            if (this.directBuffer == null) {
                throw new PersistentStoreException(StoreLogger.logCreateFailedLoggable());
            }
        }

        ByteBuffer getMappedBuffer(long start, long end) throws IOException {
            if (start == end) {
                return null;
            }
            return this.storeFile.getDirectMappedBuffer(start, Math.min(end, start + (long)Heap.this.ioSize));
        }

        void writeDataWithChecksumInTail(HeapHeader header, List<ByteBuffer> record, short padding) throws IOException {
            this.appendHeader(header);
            long checksum = this.appendRecord(record, Heap.this.writeChecksummer);
            this.appendChecksum(checksum);
            this.blockAlignRecord(padding);
        }

        private void appendHeader(HeapHeader header) throws IOException {
            if (this.directBuffer.remaining() < HEADER_LENGTH) {
                assert (this.directBuffer.remaining() == 0);
                this.writeToStore();
            }
            header.write(this.directBuffer);
            this.lastHeaderOffset = this.directBuffer.position();
        }

        private long appendRecord(List<ByteBuffer> record, Checksummer checksummer) throws IOException {
            checksummer.reset();
            int startPos = this.directBuffer.position();
            for (ByteBuffer data : record) {
                int dataLimit = data.limit();
                while (data.position() < dataLimit) {
                    int chunkSize = Math.min(dataLimit - data.position(), this.directBuffer.remaining());
                    data.limit(data.position() + chunkSize);
                    this.directBuffer.put(data);
                    if (this.directBuffer.hasRemaining()) continue;
                    checksummer.update(this.directBuffer, startPos, this.directBuffer.position() - startPos);
                    this.writeToStore();
                    startPos = this.directBuffer.position();
                }
            }
            if (this.directBuffer.position() != startPos) {
                checksummer.update(this.directBuffer, startPos, this.directBuffer.position() - startPos);
            }
            return checksummer.getValue();
        }

        private void appendChecksum(long checksum) throws IOException {
            int remainingBytes = this.directBuffer.remaining();
            if (remainingBytes < 8) {
                byte[] bytes = Utility.longToBytes(checksum);
                this.directBuffer.put(bytes, 0, remainingBytes);
                this.writeToStore();
                this.directBuffer.put(bytes, remainingBytes, 8 - remainingBytes);
            } else {
                this.directBuffer.putLong(checksum);
            }
        }

        private void blockAlignRecord(int paddingWidth) throws IOException {
            if (this.directBuffer.remaining() < paddingWidth) {
                this.writeToStore();
            }
            DirectIOManager.getFileMemoryManager().zeroBuffer(this.directBuffer, paddingWidth);
        }

        private void writeToStore() throws IOException {
            long newFilePos = this.filePos + (long)this.directBuffer.position();
            if (Heap.this.writeExplicit()) {
                this.directBuffer.flip();
                this.storeFile.write(this.filePos, this.directBuffer);
            }
            this.filePos = newFilePos;
            if (this.storeFile.mapped()) {
                this.directBuffer = this.getMappedBuffer(this.filePos, this.limit);
            } else {
                this.directBuffer.clear();
            }
        }

        private void finalWrite() throws IOException {
            if (Heap.this.writeExplicit() && this.dataLeftToBeWritten()) {
                this.directBuffer.flip();
                int numBytesToWrite = this.directBuffer.remaining();
                this.storeFile.write(this.filePos, this.directBuffer);
                this.filePos += (long)numBytesToWrite;
            }
        }

        private void realeaseBuffer() {
            if (!this.storeFile.mapped() && this.directBuffer != null) {
                Heap.this.bufferPool.put(this.directBuffer);
            }
        }

        private boolean dataLeftToBeWritten() {
            return this.filePos < this.limit;
        }
    }

    static final class HeapFileHeader {
        private static final long MAGIC = -4611194893197503948L;
        final boolean magicVerified;
        final short version;
        final int blockSize;
        final long uuidLo;
        final long uuidHi;
        final ByteBuffer signature;
        final long heapHeaderMagic;

        HeapFileHeader(short version, int blockSize, long uuidLo, long uuidHi, long heapHeaderMagic) {
            this.version = version;
            this.blockSize = blockSize;
            this.uuidLo = uuidLo;
            this.uuidHi = uuidHi;
            this.magicVerified = true;
            this.signature = null;
            this.heapHeaderMagic = heapHeaderMagic;
        }

        HeapFileHeader(ByteBuffer buf) {
            boolean bl = this.magicVerified = buf.getLong() == -4611194893197503948L;
            if (this.magicVerified) {
                this.version = buf.getShort();
                this.blockSize = buf.getInt();
                this.uuidLo = buf.getLong();
                this.uuidHi = buf.getLong();
                int oldLimit = buf.limit();
                buf.limit(buf.position() + 64);
                this.signature = buf.slice();
                if (this.version == 3) {
                    buf.limit(oldLimit);
                    buf.position(94);
                    this.heapHeaderMagic = buf.getLong();
                } else {
                    this.heapHeaderMagic = 1370321247807281150L;
                }
            } else {
                this.version = 1;
                this.blockSize = 256;
                this.uuidLo = 0L;
                this.uuidHi = 0L;
                this.signature = null;
                this.heapHeaderMagic = 0L;
            }
        }

        ByteBuffer getBuffer() {
            ByteBuffer buf = ByteBuffer.allocate(this.blockSize);
            this.serialize(buf);
            return buf;
        }

        void serialize(ByteBuffer dest) {
            dest.putLong(-4611194893197503948L);
            dest.putShort(this.version);
            dest.putInt(this.blockSize);
            dest.putLong(this.uuidLo);
            dest.putLong(this.uuidHi);
            if (dest.isDirect()) {
                DirectIOManager.getFileMemoryManager().zeroBuffer(dest);
            }
            if (this.version == 3) {
                dest.position(94);
                dest.putLong(this.heapHeaderMagic);
            }
            dest.limit(this.blockSize);
            dest.position(0);
        }

        boolean signatureZero() {
            if (this.signature == null) {
                return true;
            }
            for (int i = 0; i < 64; ++i) {
                if (this.signature.get(i) == 0) continue;
                return false;
            }
            return true;
        }

        boolean equalsTo(HeapFileHeader other) {
            return this.magicVerified == other.magicVerified && this.version == other.version && this.blockSize == other.blockSize && this.uuidLo == other.uuidLo && this.uuidHi == other.uuidHi && Heap.byteBufferEqual(this.signature, other.signature) && (this.version != 3 || this.heapHeaderMagic == other.heapHeaderMagic);
        }

        public String toString() {
            return this.getClass().getName() + "[version=" + this.version + " blockSize=" + this.blockSize + " uuidLo=" + this.uuidLo + " uuidHi=" + this.uuidHi + " zeroSignature=" + this.signatureZero() + "]";
        }
    }

    final class HeapHeader {
        private int state;
        private long headerChecksum;
        private final byte version;
        private int totalLength;
        private long bodyChecksum;
        private int bodyLength;

        HeapHeader(ByteBuffer buf) throws PersistentStoreException {
            int startPos = buf.position();
            buf.position(startPos + 12);
            this.headerChecksum = buf.getLong();
            this.version = buf.get();
            this.totalLength = buf.getInt();
            this.bodyChecksum = buf.getLong();
            this.bodyLength = this.totalLength - OLD_HEADER_LENGTH;
            if (this.isChecksumInTail()) {
                if (startPos + HEADER_LENGTH + this.bodyLength + 8 <= buf.limit()) {
                    this.bodyChecksum = buf.getLong(startPos + HEADER_LENGTH + this.bodyLength);
                    assert (buf.position() - startPos <= HEADER_LENGTH);
                    buf.position(startPos + HEADER_LENGTH);
                    if (this.headerChecksum != (long)(this.version + this.totalLength)) {
                        throw new PersistentStoreException(StoreLogger.logInvalidStoreRecordLoggable(30));
                    }
                }
            } else {
                assert (buf.position() - startPos <= OLD_HEADER_LENGTH);
                buf.position(startPos + OLD_HEADER_LENGTH);
                if (this.headerChecksum != (long)(this.version + this.totalLength) + this.bodyChecksum) {
                    throw new PersistentStoreException(StoreLogger.logInvalidStoreRecordLoggable(30));
                }
            }
            if (this.version == 2) {
                this.state = buf.getInt(8) - -123456789;
            } else if (this.version != 5 && this.version != 4) {
                throw new PersistentStoreException(StoreLogger.logInvalidStoreRecordVersionLoggable(this.version));
            }
        }

        boolean isChecksumInTail() {
            return this.version == 5;
        }

        HeapHeader(List<ByteBuffer> record) {
            this.totalLength = HEADER_LENGTH;
            for (ByteBuffer data : record) {
                this.bodyLength += data.remaining();
            }
            this.totalLength += this.bodyLength;
            this.totalLength += 8;
            this.version = (byte)5;
            this.headerChecksum = this.version + this.totalLength;
            this.bodyChecksum = -1L;
        }

        void write(ByteBuffer destBuffer) {
            int startPosition = destBuffer.position();
            destBuffer.putLong(Heap.this.heapRecordMagic);
            destBuffer.putInt(0);
            destBuffer.putLong(this.headerChecksum);
            destBuffer.put(this.version);
            destBuffer.putInt(this.totalLength);
            destBuffer.putLong(-1L);
            DirectIOManager.getFileMemoryManager().zeroBuffer(destBuffer, HEADER_LENGTH - (destBuffer.position() - startPosition));
        }

        int getNumBlocks(int blockSize) {
            int ret = this.totalLength / blockSize;
            if (this.totalLength % blockSize != 0) {
                ++ret;
            }
            return ret;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("HeapHeader [ version = ");
            buf.append(this.version);
            buf.append(" total length = ");
            buf.append(this.totalLength);
            buf.append(" body checksum = ");
            buf.append(this.bodyChecksum);
            buf.append(" header checksum = ");
            buf.append(this.headerChecksum);
            buf.append(" ]");
            return buf.toString();
        }
    }

    public static final class HeapRecord {
        private long handle;
        private final ByteBuffer body;
        private final int oldState;

        private HeapRecord(ByteBuffer body, int oldState) {
            this.body = body;
            this.oldState = oldState;
        }

        void setHandle(long handle) {
            this.handle = handle;
        }

        public long getHandle() {
            return this.handle;
        }

        public ByteBuffer getBody() {
            return this.body;
        }

        public int getOldState() {
            return this.oldState;
        }
    }

    private static final class ReadLogNode {
        private final ByteBuffer buf;

        private ReadLogNode(ByteBuffer buf) {
            this.buf = buf;
        }
    }
}

