/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.io.file;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.Callable;
import weblogic.store.PersistentStoreException;
import weblogic.store.StoreLogger;
import weblogic.store.StoreWritePolicy;
import weblogic.store.common.StoreDebug;
import weblogic.store.common.StoreRCMUtils;
import weblogic.store.internal.StoreStatisticsImpl;
import weblogic.store.io.file.DirectBufferPool;
import weblogic.store.io.file.FileStoreIO;
import weblogic.store.io.file.Heap;
import weblogic.store.io.file.StoreDir;
import weblogic.store.io.file.direct.DirectFileChannel;
import weblogic.store.io.file.direct.DirectIOManager;
import weblogic.store.io.file.direct.FileMapping;

public final class StoreFile {
    private static final boolean veryVerboseDebug = System.getProperty("weblogic.store.DebugVerboseFileIO") != null;
    private final StoreDir dir;
    private final Heap heap;
    private final File file;
    private final DirectBufferPool bufferPool;
    private final short fileNum;
    private StoreWritePolicy writePolicy;
    private FileChannel readChannel;
    private FileChannel writeChannel;
    private FileMapping cache;
    private long fileSize;
    private boolean open;
    private String ioMode;
    int ioSize;
    int minMapSize;
    int maxMapSize;
    boolean locking;
    boolean enforceExplicitIO;
    StoreStatisticsImpl stats;
    private static final boolean DEBUG_SPACE_UPDATES = Boolean.getBoolean("weblogic.store.DebugSpaceUpdates");

    StoreFile(Heap heap, StoreDir dir, File file, short fileNum, DirectBufferPool bufferPool) {
        this.heap = heap;
        this.file = file;
        this.fileNum = fileNum;
        this.dir = dir;
        this.bufferPool = bufferPool;
        if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
            StoreDebug.storeIOPhysicalVerbose.debug("StoreFile construct {dir.getDirName " + dir.getDirName() + " dir.absolute " + dir.getDirAbsolutePath() + "} { file.getAbsolutePath() " + file.getAbsolutePath() + " }");
        }
    }

    private void reinitFields() {
        this.writePolicy = null;
        this.readChannel = null;
        this.writeChannel = null;
        this.cache = null;
        this.fileSize = 0L;
        this.open = false;
        this.ioMode = null;
        this.ioSize = 0;
        this.minMapSize = 0;
        this.maxMapSize = 0;
        this.locking = false;
        this.stats = null;
        this.enforceExplicitIO = false;
    }

    StoreWritePolicy getWritePolicy() {
        return this.writePolicy;
    }

    private static void throwIOException(Throwable linked) throws IOException {
        IOException ioe = new IOException(linked.toString());
        ioe.initCause(linked);
        throw ioe;
    }

    private void openInternal(boolean directIO, boolean diabloDualHandleDirectMode) throws IOException {
        try {
            StoreDir.checkFile(this.file);
            if (this.writePolicy.synchronous()) {
                if (directIO) {
                    this.readChannel = this.writeChannel = this.fileChannelFactory(this.file, "rwD", this.locking);
                    this.ioMode = "single-handle-unbuffered";
                    if (diabloDualHandleDirectMode) {
                        try {
                            this.readChannel = this.fileChannelFactory(this.file, "r", false);
                            this.ioMode = "read-buffered";
                        }
                        catch (IOException ioe) {
                            StoreLogger.logDualHandleOpenFailed(this.file.getPath(), ioe);
                        }
                    }
                } else {
                    this.readChannel = this.writeChannel = this.fileChannelFactory(this.file, "rwd", this.locking);
                    this.ioMode = "single-handle-buffered";
                }
            } else {
                this.readChannel = this.writeChannel = this.fileChannelFactory(this.file, "rw", this.locking);
                this.ioMode = "single-handle-non-direct";
            }
        }
        catch (SecurityException se) {
            StoreFile.throwIOException(se);
        }
        this.fileSize = this.readChannel.size();
        if (this.mapped()) {
            this.cache = new FileMapping(this.writeChannel, this.ioSize, this.minMapSize, this.maxMapSize, this.stats, this.file);
        }
        this.open = true;
        if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
            StoreDebug.storeIOPhysicalVerbose.debug("Opened file name=" + this.file.getName() + " size=" + this.fileSize + " directIO=" + directIO + " singleHandle=" + (this.writeChannel == this.readChannel));
        }
    }

    FileChannel fileChannelFactory(File file, String mode, boolean exclusive) throws IOException {
        if (this.heap == null) {
            return FileStoreIO.staticOpen(this.heap, file, mode, exclusive);
        }
        return this.heap.fileChannelFactory(file, mode, exclusive);
    }

    void open(StoreWritePolicy synchronousWritePolicy) throws IOException {
        this.writePolicy = synchronousWritePolicy;
        this.openInternal(false, false);
    }

    void openDirect(StoreWritePolicy synchronousWritePolicy) throws IOException {
        this.writePolicy = synchronousWritePolicy;
        this.openInternal(true, true);
    }

    void openSingleHandleDirect(StoreWritePolicy synchronousWritePolicy) throws IOException {
        this.writePolicy = synchronousWritePolicy;
        this.openInternal(true, false);
    }

    void adjustFileSize(int blockSize) throws IOException {
        if (blockSize != 0 && this.fileSize % (long)blockSize != 0L) {
            long newFileSize = this.fileSize / (long)blockSize * (long)blockSize;
            if (this.mapped()) {
                this.cache.reopen(newFileSize, this.fileSize);
            }
            this.fileSize = newFileSize;
            this.writeChannel.truncate(this.fileSize);
        }
        if (this.dir != null) {
            this.dir.incBytesUsed(this.fileSize);
        }
    }

    private long writeBuffer(ByteBuffer directBuffer, ByteBuffer data, long filePos) throws IOException {
        long curPos = filePos;
        int dataLimit = data.limit();
        while (data.position() < dataLimit) {
            int chunk = Math.min(dataLimit - data.position(), directBuffer.remaining());
            data.limit(data.position() + chunk);
            directBuffer.put(data);
            if (directBuffer.hasRemaining()) continue;
            directBuffer.position(0);
            this.writeChannel.write(directBuffer, curPos);
            directBuffer.position(0);
            curPos += (long)directBuffer.capacity();
        }
        return curPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(long filePos, ByteBuffer data) throws IOException {
        block11: {
            if (veryVerboseDebug && StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
                StoreDebug.storeIOPhysicalVerbose.debug("Writing to file filePos=" + filePos + " len=" + data.remaining());
            }
            if (this.hasCacheFile()) {
                int dataPosition = data.position();
                int dataRemaining = data.remaining();
                int bytes = 0;
                try {
                    bytes = this.writeChannel.write(data, filePos);
                    if (bytes < dataRemaining) {
                        throw new EOFException("Write incomplete: expected=" + dataRemaining + ", actual=" + bytes);
                    }
                    break block11;
                }
                catch (IOException e) {
                    data.position(dataPosition + bytes);
                    DirectIOManager.getFileMemoryManager().zeroBuffer(data, dataRemaining - bytes);
                    throw e;
                }
            }
            if (data.isDirect()) {
                this.writeChannel.write(data, filePos);
            } else {
                ByteBuffer directBuffer = this.bufferPool.get();
                try {
                    long curPos = this.writeBuffer(directBuffer, data, filePos);
                    if (directBuffer.position() > 0) {
                        directBuffer.flip();
                        this.writeChannel.write(directBuffer, curPos);
                    }
                }
                finally {
                    this.bufferPool.put(directBuffer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(long filePos, ByteBuffer buf) throws IOException {
        if (veryVerboseDebug && StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
            StoreDebug.storeIOPhysicalVerbose.debug("Reading from file filePos=" + filePos + " len=" + buf.remaining());
        }
        int origPos = buf.position();
        if (buf.isDirect()) {
            int lengthToRead = buf.remaining();
            int count = this.readChannel.read(buf, filePos);
            if (count < lengthToRead) {
                throw new EOFException("premature EOF: expected=" + (filePos + (long)lengthToRead) + ", actual=" + (filePos + (long)count));
            }
        } else {
            ByteBuffer directBuffer = this.bufferPool.get();
            try {
                long curPos = filePos;
                while (buf.hasRemaining()) {
                    directBuffer.clear();
                    int chunk = Math.min(buf.remaining(), directBuffer.remaining());
                    directBuffer.limit(chunk);
                    int count = this.readChannel.read(directBuffer, curPos);
                    if (count < chunk) {
                        throw new EOFException("premature EOF: expected=" + (curPos + (long)chunk) + ", actual=" + (curPos + (long)count));
                    }
                    directBuffer.flip();
                    buf.put(directBuffer);
                    curPos += (long)chunk;
                }
            }
            finally {
                this.bufferPool.put(directBuffer);
            }
        }
        buf.position(origPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readBulk(long filePos, ByteBuffer buf, int minBytes) throws IOException {
        ByteBuffer directBuf = buf.isDirect() ? buf : this.bufferPool.get();
        int expected = Math.min(minBytes, directBuf.remaining());
        try {
            int count = this.readChannel.read(directBuf, filePos);
            if (count < expected) {
                throw new EOFException("premature EOF: expected=" + (filePos + (long)expected) + ", actual=" + (filePos + (long)count));
            }
            if (count > 0) {
                directBuf.limit(directBuf.position());
                directBuf.position(directBuf.position() - count);
                if (!buf.isDirect()) {
                    buf.put(directBuf);
                    buf.limit(buf.position());
                    buf.position(buf.position() - count);
                }
            }
            int n = count;
            return n;
        }
        finally {
            if (!buf.isDirect()) {
                this.bufferPool.put(directBuf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void expand(long amt) throws IOException {
        try {
            if (this.mapped()) {
                long size = this.fileSize + amt;
                this.cache.reopen(size, this.fileSize);
            } else {
                long pos = this.fileSize;
                long expandAmt = amt;
                ByteBuffer tmpBuf = this.bufferPool.get();
                try {
                    int chunk;
                    DirectIOManager.getFileMemoryManager().zeroBuffer(tmpBuf);
                    do {
                        tmpBuf.clear();
                        chunk = (int)Math.min((long)tmpBuf.capacity(), expandAmt);
                        tmpBuf.limit(chunk);
                        this.write(pos, tmpBuf);
                        pos += (long)chunk;
                    } while ((expandAmt -= (long)chunk) > 0L);
                }
                finally {
                    this.bufferPool.put(tmpBuf);
                }
            }
            if (!this.writePolicy.unforced()) {
                this.writeChannel.force(true);
            }
            if (this.readChannel != this.writeChannel) {
                ((DirectFileChannel)this.readChannel).resetSizeAfterExpansion();
            }
            this.fileSize += amt;
            if (this.dir != null) {
                this.dir.incBytesUsed(amt);
            }
            if (StoreDebug.storeIOPhysicalVerbose.isDebugEnabled()) {
                StoreDebug.storeIOPhysicalVerbose.debug("expand() amt=" + amt + " new fileSize=" + this.fileSize);
            }
        }
        catch (IOException e) {
            try {
                this.writeChannel.truncate(this.fileSize);
                if (this.mapped()) {
                    this.cache.reopen(this.fileSize, this.fileSize);
                }
                if (!this.writePolicy.unforced()) {
                    this.writeChannel.force(true);
                }
            }
            finally {
                throw e;
            }
        }
        catch (OutOfMemoryError oome) {
            try {
                this.writeChannel.truncate(this.fileSize);
                if (this.writePolicy != StoreWritePolicy.DISABLED && this.writePolicy != StoreWritePolicy.NON_DURABLE) {
                    this.writeChannel.force(true);
                }
            }
            catch (IOException iOException) {
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            throw new IOException(oome.toString());
        }
    }

    synchronized long size() {
        return this.fileSize;
    }

    short getFileNum() {
        return this.fileNum;
    }

    public String getName() {
        return this.file.getName();
    }

    boolean checkFileBytesQuota(long amt, long bytesQuota) {
        return this.fileSize + amt <= bytesQuota;
    }

    synchronized void flush() throws IOException {
        if (this.writePolicy == StoreWritePolicy.CACHE_FLUSH) {
            this.writeChannel.force(false);
        }
    }

    synchronized void close() throws IOException {
        IOException ioEx = null;
        try {
            block13: {
                if (this.mapped()) {
                    try {
                        if (StoreDebug.cacheDebug.isDebugEnabled()) {
                            StoreDebug.cacheDebug.debug("closing cache: " + this.cache);
                        }
                        if (this.cache != null) {
                            this.cache.close();
                        }
                    }
                    catch (IOException cacheEx) {
                        if (StoreDebug.cacheDebug.isDebugEnabled()) {
                            StoreDebug.cacheDebug.debug("closing cache failed: " + this.cache, cacheEx);
                        }
                        if (ioEx != null) break block13;
                        ioEx = cacheEx;
                    }
                }
            }
            try {
                IOException tIoe = null;
                class CloseChannels
                implements Callable<IOException> {
                    CloseChannels() {
                    }

                    @Override
                    public IOException call() {
                        IOException ioe;
                        block7: {
                            block6: {
                                ioe = null;
                                try {
                                    if (StoreFile.this.writeChannel != null) {
                                        StoreFile.this.writeChannel.close();
                                    }
                                }
                                catch (IOException we) {
                                    if (ioe != null) break block6;
                                    ioe = we;
                                }
                            }
                            try {
                                if (StoreFile.this.readChannel != null && StoreFile.this.writeChannel != StoreFile.this.readChannel) {
                                    StoreFile.this.readChannel.close();
                                }
                            }
                            catch (IOException re) {
                                if (ioe != null) break block7;
                                ioe = re;
                            }
                        }
                        return ioe;
                    }
                }
                tIoe = StoreRCMUtils.accountAsGlobal(new CloseChannels());
                if (tIoe != null && ioEx == null) {
                    ioEx = tIoe;
                }
            }
            catch (Exception e) {
                StoreRCMUtils.throwIOorRuntimeException(e);
            }
            if (ioEx != null) {
                throw ioEx;
            }
        }
        finally {
            this.reinitFields();
        }
    }

    void rename(File newName) {
        this.file.renameTo(newName);
    }

    public boolean equals(Object obj) {
        return obj instanceof StoreFile && ((StoreFile)obj).fileNum == this.fileNum;
    }

    public int hashCode() {
        return this.fileNum;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    String getIOMode() {
        return this.ioMode;
    }

    String getDriver() {
        return this.heap.getDriver();
    }

    ByteBuffer mappedRead(long position, int size) throws PersistentStoreException {
        try {
            return this.cache.getMappedBuffer(position, position + (long)size, false);
        }
        catch (IOException e) {
            throw new PersistentStoreException(e);
        }
    }

    ByteBuffer mappedRecoveryRead(long position, int size) throws PersistentStoreException {
        try {
            this.cache.setPrefetched(true);
            ByteBuffer byteBuffer = this.cache.getMappedBuffer(position, position + (long)size, false);
            return byteBuffer;
        }
        catch (IOException e) {
            throw new PersistentStoreException(e);
        }
        finally {
            this.cache.setPrefetched(false);
        }
    }

    Heap.HeapFileHeader mappedRecoveryInit(String storeName) throws IOException {
        long minSize = Math.max(this.fileSize, 8192L);
        this.cache.open(minSize, minSize, null, false);
        ByteBuffer cacheHeaderBuf = this.cache.getMappedBuffer(0L, 512L, true);
        if (this.fileNum == 0) {
            StoreLogger.logCacheInfo(storeName, this.cache.toString());
        }
        return new Heap.HeapFileHeader(cacheHeaderBuf);
    }

    void commitScan(short version, int blockSize, long uuidLo, long uuidHi, long heapRecordMagic) throws PersistentStoreException {
        ByteBuffer headerBuf = null;
        try {
            if (this.mapped()) {
                headerBuf = this.getDirectMappedBuffer(0L, blockSize);
                if (this.hasCacheFile()) {
                    this.cache.setInitialized();
                }
            } else {
                headerBuf = this.bufferPool.get();
                headerBuf.limit(blockSize);
                this.read(0L, headerBuf);
                headerBuf.position(0);
            }
            Heap.HeapFileHeader currentHeader = new Heap.HeapFileHeader(headerBuf);
            headerBuf.position(0);
            if (StoreDebug.cacheDebug.isDebugEnabled()) {
                StoreDebug.cacheDebug.debug("Checking current header: " + currentHeader);
            }
            if (!currentHeader.magicVerified || currentHeader.signatureZero() && currentHeader.uuidLo == uuidLo) {
                return;
            }
            Heap.HeapFileHeader header = new Heap.HeapFileHeader(version, blockSize, uuidLo, uuidHi, heapRecordMagic);
            headerBuf.position(0);
            header.serialize(headerBuf);
            if (StoreDebug.cacheDebug.isDebugEnabled()) {
                StoreDebug.cacheDebug.debug("Replacing with new header: " + header + " serialized into " + headerBuf);
            }
            if (!this.hasCacheFile() && this.mapped()) {
                this.cache.reopenFlush(this.fileSize, this.fileSize);
            } else {
                this.writeChannel.write(headerBuf, 0L);
                this.flush();
            }
        }
        catch (IOException e) {
            throw new PersistentStoreException(e);
        }
        finally {
            if (!this.mapped() && headerBuf != null) {
                this.bufferPool.put(headerBuf);
            }
        }
    }

    void commitClose(int blockSize) throws IOException {
        ByteBuffer buf = this.bufferPool.get();
        try {
            buf.limit(blockSize);
            DirectIOManager.getFileMemoryManager().zeroBuffer(buf);
            buf.position(0);
            this.cache.commitClose(buf);
        }
        finally {
            this.bufferPool.put(buf);
        }
    }

    boolean mapped() {
        return !this.enforceExplicitIO && (DirectIOManager.getMemMapManager().nativeFileCodeAvailable() && this.writePolicy.genuineMemoryMap() || this.hasCacheFile());
    }

    boolean hasCacheFile() {
        return this.writePolicy.usesCacheFile() && this.ioMode == "single-handle-unbuffered";
    }

    ByteBuffer getDirectMappedBuffer(long start, long end) throws IOException {
        return this.cache.getMappedBuffer(start, end, true);
    }

    void openCacheFile(String dir, String storeName) throws IOException {
        long minSize = Math.max(this.fileSize, 8192L);
        this.cache.open(minSize, minSize, dir, this.locking);
        if (this.fileNum == 0) {
            StoreLogger.logCacheInfo(storeName, this.cache.toString());
        }
    }

    void verifyCacheFile(Heap.HeapFileHeader primaryHeader, String storeName) throws IOException {
        ByteBuffer cacheHeaderBuf = this.cache.getMappedBuffer(0L, 512L, true);
        Heap.HeapFileHeader cacheHeader = new Heap.HeapFileHeader(cacheHeaderBuf);
        if (primaryHeader.signatureZero() || !cacheHeader.equalsTo(primaryHeader)) {
            if (primaryHeader.uuidLo != 0L) {
                StoreLogger.logCacheSignatureVerificationFailed(storeName, this.file.toString(), this.cache.getCacheFile().toString());
            }
            this.cache.ensureReinit();
            this.cache.initFromPrimary();
        }
    }

    File getCacheFile() {
        return this.cache.getCacheFile();
    }

    void flush0() throws IOException {
        if (this.mapped()) {
            if (!this.hasCacheFile()) {
                this.cache.reopenFlush(this.fileSize, this.fileSize);
            }
        } else if (this.writePolicy.unforced() || this.writePolicy == StoreWritePolicy.CACHE_FLUSH) {
            this.writeChannel.force(false);
        }
    }

    void updateStats(StoreStatisticsImpl stats, long maxFileSize) throws IOException {
        if (this.writeChannel instanceof DirectFileChannel) {
            DirectFileChannel dfc = (DirectFileChannel)this.writeChannel;
            long limit = dfc.getDeviceLimit();
            long used = dfc.getDeviceUsed();
            if (limit <= 0L || used < 0L) {
                if (DEBUG_SPACE_UPDATES) {
                    System.out.println("*** STORE DEBUG SPACE device limit/used/percent " + limit + "/" + used + "/" + 0);
                }
                stats.setDeviceUsedPercent(0);
                return;
            }
            long percent = used * 100L / limit;
            if (percent > 100L) {
                percent = 100L;
            }
            if (DEBUG_SPACE_UPDATES) {
                System.out.println("*** STORE DEBUG SPACE heap= " + this.heap.getName() + " device limit/used/percent" + limit + "/" + used + "/" + percent);
            }
            stats.setDeviceUsedPercent((int)percent);
            long oneRegionPercent = 100L * maxFileSize / limit;
            stats.setOneRegionPercent((int)oneRegionPercent);
        } else {
            stats.setDeviceUsedPercent(0);
            stats.setOneRegionPercent(0);
        }
    }
}

