/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.io.file.checksum;

import weblogic.store.common.StoreDebug;
import weblogic.store.io.file.checksum.Adler32Checksummer;
import weblogic.store.io.file.checksum.Checksummer;
import weblogic.store.io.file.checksum.FaFChecksummer;
import weblogic.store.io.file.checksum.NIOAdler32Checksummer;

public class ChecksummerFactory {
    private static Checksummer checksummer = ChecksummerFactory.instantiateChecksummer();

    private static Checksummer instantiateChecksummer() {
        Checksummer checksummer = null;
        try {
            checksummer = new FaFChecksummer();
            StoreDebug.storeIOPhysical.debug("> Using weblogic.store.io.file.checksum.FaFChecksummer in ChecksummerFactory.instantiateChecksummer");
        }
        catch (Throwable ex) {
            try {
                checksummer = new NIOAdler32Checksummer();
                StoreDebug.storeIOPhysical.debug("> Using weblogic.store.io.file.checksum.NIOAdler32Checksummer in ChecksummerFactory.instantiateChecksummer");
            }
            catch (Throwable e) {
                checksummer = new Adler32Checksummer();
                StoreDebug.storeIOPhysical.debug("> Using weblogic.store.io.file.checksum.Adler32Checksummer in ChecksummerFactory.instantiateChecksummer");
            }
        }
        return checksummer;
    }

    public static Checksummer getInstance() {
        return checksummer;
    }

    public static Checksummer getNewInstance() {
        return ChecksummerFactory.instantiateChecksummer();
    }
}

