/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.io.file.checksum;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;
import weblogic.store.io.file.checksum.Checksummer;
import weblogic.store.io.file.checksum.ChecksummerInstantiationException;

public class FaFChecksummer
extends Adler32
implements Checksummer {
    private Method updateMethod;

    public FaFChecksummer() throws ChecksummerInstantiationException {
        try {
            this.updateMethod = Class.forName("com.oracle.util.Checksums").getDeclaredMethod("update", Adler32.class, ByteBuffer.class);
        }
        catch (Exception e) {
            throw new ChecksummerInstantiationException(e);
        }
    }

    public void update(Adler32 adler32, ByteBuffer buf) {
        try {
            this.updateMethod.invoke((Object)this, adler32, buf);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public long calculateChecksum(ByteBuffer buffer) {
        this.reset();
        this.update(buffer, buffer.position(), buffer.remaining());
        return this.getValue();
    }

    @Override
    public void update(ByteBuffer buffer, int offset, int len) {
        assert (offset >= 0 && len >= 0 && offset + len <= buffer.limit());
        int pos = buffer.position();
        int lim = buffer.limit();
        buffer.position(offset);
        buffer.limit(len + offset);
        try {
            this.updateMethod.invoke(null, this, buffer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        buffer.limit(lim);
        buffer.position(pos);
    }
}

