/*
 * Decompiled with CFR 0.152.
 */
package weblogic.store.io.file.checksum;

import java.nio.ByteBuffer;
import weblogic.store.io.file.checksum.Checksummer;
import weblogic.store.io.file.checksum.NIOAdler32;

public class NIOAdler32Checksummer
implements Checksummer {
    private static final String ADLER32_LIB = "ADLER32_LIB";
    private byte[] ONE_BYTE = new byte[1];
    private NIOAdler32 nioAlder32 = new NIOAdler32();

    @Override
    public void update(int b) {
        this.ONE_BYTE[0] = (byte)b;
        this.update(this.ONE_BYTE, 0, 1);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.nioAlder32.update(b, off, len);
    }

    @Override
    public long getValue() {
        return this.nioAlder32.getValue();
    }

    @Override
    public void reset() {
        this.nioAlder32.reset();
    }

    @Override
    public void update(ByteBuffer buffer, int offset, int len) {
        if (offset < 0 || len < 0 || len + offset > buffer.capacity()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.nioAlder32.update(buffer, offset, len);
    }

    @Override
    public long calculateChecksum(ByteBuffer buffer) {
        this.reset();
        this.update(buffer, buffer.position(), buffer.remaining());
        return this.getValue();
    }

    static {
        System.loadLibrary(System.getProperty(ADLER32_LIB, "adler32"));
    }
}

