/*
 * Decompiled with CFR 0.152.
 */
package weblogic.timers.internal;

import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class ScheduleExpressionUtil {
    private static final String[] VALID_MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] VALID_DAY_OF_WEEK = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final int[] CALENDAR_DAYS_OF_WEEK = new int[]{1, 2, 3, 4, 5, 6, 7, 1};
    private static final String[] VALID_WEEK_OF_MONTH = new String[]{null, "1st", "2nd", "3rd", "4th", "5th"};
    private static final String LAST_STRING = "Last";
    private static final byte NOT_INITIALIZED = -1;
    static final int NOT_FOUND = -100;

    private static void setArray(byte[] values, byte value) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = value;
        }
    }

    private static void setArray(int start, int end, boolean[] values, boolean value) {
        int stopPos = end;
        if (end > values.length - 1) {
            stopPos = values.length - 1;
        }
        for (int i = start; i <= stopPos; ++i) {
            values[i] = value;
        }
    }

    static boolean parseHHMMSSvalue(String userValue, byte[] values, String fieldName) throws IllegalArgumentException {
        boolean hasList;
        if (userValue == null || userValue.trim().isEmpty()) {
            throw new IllegalArgumentException(fieldName + " cannot be null or empty");
        }
        ScheduleExpressionUtil.setArray(values, (byte)-1);
        StringTokenizer st = new StringTokenizer(userValue, ",");
        boolean bl = hasList = userValue.indexOf(",") > -1;
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException("Invalid " + fieldName + " value: '" + userValue + "'");
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (hasList && "*".equals(token)) {
                throw new IllegalArgumentException("List items in " + fieldName + " cannot be wildcards");
            }
            int pos = token.indexOf(45);
            if (pos != -1) {
                ScheduleExpressionUtil.fillInRange(token.substring(0, pos), token.substring(pos + 1, token.length()), values, fieldName);
                continue;
            }
            pos = token.indexOf(47);
            if (pos != -1) {
                if (hasList) {
                    throw new IllegalArgumentException("List items cannot be increments in " + fieldName);
                }
                ScheduleExpressionUtil.fillInIncrement(token.substring(0, pos), token.substring(pos + 1, token.length()), values, fieldName);
                continue;
            }
            ScheduleExpressionUtil.fillInValue(token, values, fieldName);
        }
        return true;
    }

    private static void updateBefore(int currPos, byte value, byte[] values) {
        if (values[currPos] == -1 || values[currPos] <= currPos || values[currPos] > currPos && values[currPos] > value) {
            values[currPos] = value;
        }
    }

    private static void updateAfter(int currPos, byte value, byte[] values) {
        if (values[currPos] == -1 || values[currPos] < currPos && values[currPos] > value) {
            values[currPos] = value;
        }
    }

    private static void fillInValue(String token, byte[] values, String fieldName) throws IllegalArgumentException {
        byte value = 0;
        if ("*".equals(token = token.trim())) {
            ScheduleExpressionUtil.fillInRange((byte)0, (byte)values.length, values);
            return;
        }
        value = ScheduleExpressionUtil.parseByte(token);
        if (value < 0 || value >= values.length) {
            throw new IllegalArgumentException("Illegal value '" + value + "' in " + fieldName);
        }
        ScheduleExpressionUtil.fillInValue(value, values);
    }

    private static void fillInValue(byte value, byte[] values) {
        int max = values.length;
        for (int i = 0; i < max; ++i) {
            if (i < value) {
                ScheduleExpressionUtil.updateBefore(i, value, values);
                continue;
            }
            ScheduleExpressionUtil.updateAfter(i, value, values);
        }
    }

    private static void fillInRange(String x, String y, byte[] values, String fieldName) throws IllegalArgumentException {
        byte start = ScheduleExpressionUtil.parseByte(x.trim());
        byte end = ScheduleExpressionUtil.parseByte(y.trim());
        int max = values.length;
        if (start >= max || end >= max || start < 0 || end < 0) {
            throw new IllegalArgumentException("Range value must be in the range of [0," + max + "] in " + fieldName);
        }
        if (start <= end) {
            ScheduleExpressionUtil.fillInRange(start, end, values);
        } else {
            ScheduleExpressionUtil.fillInRange(start, (byte)max, values);
            ScheduleExpressionUtil.fillInRange((byte)0, end, values);
        }
    }

    private static void fillInRange(byte start, byte end, byte[] values) {
        int max = values.length;
        for (int i = 0; i < max; ++i) {
            if (i >= start && i < end) {
                values[i] = (byte)((i + 1) % max);
                continue;
            }
            if (i < start) {
                ScheduleExpressionUtil.updateBefore(i, start, values);
                continue;
            }
            if (i < end) continue;
            ScheduleExpressionUtil.updateAfter(i, start, values);
        }
    }

    private static void fillInIncrement(String x, String y, byte[] values, String fieldName) throws IllegalArgumentException {
        byte max;
        x = x.trim();
        byte start = -1;
        byte interval = ScheduleExpressionUtil.parseByte(y.trim());
        start = "*".equals(x) ? (byte)0 : (byte)ScheduleExpressionUtil.parseByte(x);
        if (start >= (max = values.length) || interval >= max || start < 0 || interval < 0) {
            throw new IllegalArgumentException("Increment value must be in the range of [0," + max + "] in " + fieldName);
        }
        byte curr = start;
        while (curr < max) {
            ScheduleExpressionUtil.fillInValue(curr, values);
            if (interval == 0) {
                return;
            }
            curr = (byte)(curr + interval);
        }
    }

    private static byte parseByte(String x) throws IllegalArgumentException {
        try {
            return Byte.parseByte(x);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static int parseInt(String x) throws IllegalArgumentException {
        try {
            return Integer.parseInt(x.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static boolean parseDayValues(String dayOfMonthAttribute, String dayOfWeekAttribute, byte[] days, int forYear, int forMonth) throws IllegalArgumentException {
        if (days == null) {
            return false;
        }
        boolean dayOfMonthSpecified = true;
        boolean dayOfWeekSpecified = true;
        if (dayOfMonthAttribute == null || dayOfMonthAttribute.trim().isEmpty()) {
            throw new IllegalArgumentException("dayOfMonth can not be null or empty!");
        }
        if ("*".equals(dayOfMonthAttribute = dayOfMonthAttribute.trim())) {
            dayOfMonthSpecified = false;
        }
        if (dayOfWeekAttribute == null || dayOfWeekAttribute.trim().isEmpty()) {
            throw new IllegalArgumentException("dayOfWeek can not be null or empty!");
        }
        if ((dayOfWeekAttribute = dayOfWeekAttribute.trim()).isEmpty() || "*".equals(dayOfWeekAttribute)) {
            dayOfWeekSpecified = false;
        }
        if (!dayOfWeekSpecified && !dayOfMonthSpecified) {
            return false;
        }
        ScheduleExpressionUtil.setArray(days, (byte)-1);
        if (dayOfWeekSpecified) {
            ScheduleExpressionUtil.parseDayOfWeekValue(dayOfWeekAttribute, days, forYear, forMonth);
        }
        if (dayOfMonthSpecified) {
            ScheduleExpressionUtil.parseDayOfMonthValue(dayOfMonthAttribute, days, forYear, forMonth);
        }
        return true;
    }

    static void parseDayOfWeekValue(String dayOfWeekAttribute, byte[] days, int forYear, int forMonth) throws IllegalArgumentException {
        Calendar aCal = Calendar.getInstance();
        aCal.set(forYear, forMonth, 1);
        int daysInMonth = aCal.getActualMaximum(5);
        StringTokenizer st = new StringTokenizer(dayOfWeekAttribute, ",");
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException("Invalid dayOfWeek value: '" + dayOfWeekAttribute + "'");
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int pos = token.indexOf(45);
            if (pos > 0) {
                int i;
                int y;
                int x = ScheduleExpressionUtil.getDayOfWeek(token.substring(0, pos));
                if (x <= (y = ScheduleExpressionUtil.getDayOfWeek(token.substring(pos + 1, token.length())))) {
                    for (i = x; i <= y; ++i) {
                        ScheduleExpressionUtil.fillInDayOfWeek(i, days, aCal, daysInMonth);
                    }
                    continue;
                }
                for (i = x; i < CALENDAR_DAYS_OF_WEEK.length; ++i) {
                    ScheduleExpressionUtil.fillInDayOfWeek(i, days, aCal, daysInMonth);
                }
                for (i = 1; i <= y; ++i) {
                    ScheduleExpressionUtil.fillInDayOfWeek(i, days, aCal, daysInMonth);
                }
                continue;
            }
            ScheduleExpressionUtil.fillInDayOfWeek(ScheduleExpressionUtil.getDayOfWeek(token), days, aCal, daysInMonth);
        }
    }

    static void fillInDayOfWeek(int dayOfWeek, byte[] days, Calendar cal, int daysInMonth) {
        cal.set(7, CALENDAR_DAYS_OF_WEEK[dayOfWeek]);
        cal.set(8, 1);
        for (int date = cal.get(5); date <= daysInMonth; date += 7) {
            ScheduleExpressionUtil.fillInValue((byte)date, days);
        }
    }

    static void parseDayOfMonthValue(String dayOfMonthAttribute, byte[] days, int forYear, int forMonth) throws IllegalArgumentException {
        Calendar aCal = Calendar.getInstance();
        aCal.set(forYear, forMonth, 1);
        int daysInMonth = aCal.getActualMaximum(5);
        StringTokenizer st = new StringTokenizer(dayOfMonthAttribute, ",");
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException("Invalid dayOfMonth value: '" + dayOfMonthAttribute + "'");
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int pos = token.indexOf(45, 1);
            if (pos > 0) {
                int i;
                int y;
                int x = ScheduleExpressionUtil.getDayOfMonth(token.substring(0, pos), aCal, daysInMonth);
                if (x <= (y = ScheduleExpressionUtil.getDayOfMonth(token.substring(pos + 1, token.length()), aCal, daysInMonth))) {
                    for (i = x; i <= y && i <= daysInMonth; ++i) {
                        ScheduleExpressionUtil.fillInValue((byte)i, days);
                    }
                    continue;
                }
                for (i = x; i <= daysInMonth; ++i) {
                    ScheduleExpressionUtil.fillInValue((byte)i, days);
                }
                for (i = 0; i <= y; ++i) {
                    ScheduleExpressionUtil.fillInValue((byte)i, days);
                }
                continue;
            }
            int dayOfMonth = ScheduleExpressionUtil.getDayOfMonth(token, aCal, daysInMonth);
            if (dayOfMonth > daysInMonth) continue;
            ScheduleExpressionUtil.fillInValue((byte)ScheduleExpressionUtil.getDayOfMonth(token, aCal, daysInMonth), days);
        }
    }

    static boolean parseMonthValue(String monthAttribute, boolean[] months) throws IllegalArgumentException {
        if (monthAttribute == null || monthAttribute.trim().isEmpty()) {
            throw new IllegalArgumentException("Month attribute cannot be null or empty");
        }
        if ((monthAttribute = monthAttribute.trim()).length() == 0 || "*".equals(monthAttribute)) {
            ScheduleExpressionUtil.setArray(0, months.length - 1, months, true);
            return false;
        }
        StringTokenizer st = new StringTokenizer(monthAttribute, ",");
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException("Invalid month value: '" + monthAttribute + "'");
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int pos = token.indexOf(45);
            if (pos != -1) {
                int y;
                int x = ScheduleExpressionUtil.getMonth(token.substring(0, pos));
                if (x <= (y = ScheduleExpressionUtil.getMonth(token.substring(pos + 1, token.length())))) {
                    ScheduleExpressionUtil.setArray(x, y, months, true);
                    continue;
                }
                ScheduleExpressionUtil.setArray(x, VALID_MONTHS.length, months, true);
                ScheduleExpressionUtil.setArray(0, y, months, true);
                continue;
            }
            months[ScheduleExpressionUtil.getMonth((String)token)] = true;
        }
        return true;
    }

    private static int getMonth(String month) throws IllegalArgumentException {
        month = month.trim();
        int monthIndex = -1;
        for (int i = 0; i < VALID_MONTHS.length && monthIndex == -1; ++i) {
            if (!VALID_MONTHS[i].equalsIgnoreCase(month)) continue;
            monthIndex = i;
        }
        if (monthIndex == -1 && ((monthIndex = ScheduleExpressionUtil.parseByte(month) - 1) < 0 || monthIndex >= VALID_MONTHS.length)) {
            throw new IllegalArgumentException("Invalid value for month attribute: " + month);
        }
        return monthIndex;
    }

    private static int getDayOfWeek(String dayOfWeek) throws IllegalArgumentException {
        dayOfWeek = dayOfWeek.trim();
        int index = -1;
        for (int i = 0; i < VALID_DAY_OF_WEEK.length && index == -1; ++i) {
            if (!VALID_DAY_OF_WEEK[i].equalsIgnoreCase(dayOfWeek)) continue;
            index = i;
        }
        if (index == -1 && ((index = (int)ScheduleExpressionUtil.parseByte(dayOfWeek)) < 0 || index > 7)) {
            throw new IllegalArgumentException("dayOfWeek attribute must be in the range of [0, 7]: " + dayOfWeek);
        }
        return index;
    }

    private static int getDayOfMonth(String dayOfMonth, Calendar cal, int daysInMonth) throws IllegalArgumentException {
        dayOfMonth = dayOfMonth.trim();
        try {
            int date = ScheduleExpressionUtil.parseByte(dayOfMonth);
            if (date >= -7 && date <= -1 || date >= 1 && date <= 31) {
                if (date < 0) {
                    date = daysInMonth + date;
                }
                return date;
            }
        }
        catch (IllegalArgumentException date) {
            // empty catch block
        }
        if (LAST_STRING.equalsIgnoreCase(dayOfMonth)) {
            return daysInMonth;
        }
        int weekOfMonth = -100;
        int dayOfWeek = -100;
        int pos = dayOfMonth.lastIndexOf(" ");
        if (pos > 0) {
            int i;
            String weekOfMonthString = dayOfMonth.substring(0, pos).trim();
            String dayOfWeekString = dayOfMonth.substring(pos + 1, dayOfMonth.length()).trim();
            if (LAST_STRING.equalsIgnoreCase(weekOfMonthString)) {
                weekOfMonth = -1;
            }
            for (i = 1; i < VALID_WEEK_OF_MONTH.length && weekOfMonth == -100; ++i) {
                if (!VALID_WEEK_OF_MONTH[i].equalsIgnoreCase(weekOfMonthString)) continue;
                weekOfMonth = i;
            }
            for (i = 0; i < VALID_DAY_OF_WEEK.length && dayOfWeek == -100; ++i) {
                if (!VALID_DAY_OF_WEEK[i].equalsIgnoreCase(dayOfWeekString)) continue;
                dayOfWeek = i;
            }
        }
        if (weekOfMonth == -100 || dayOfWeek == -100) {
            throw new IllegalArgumentException("Invalid dayOfMonth value: '" + dayOfMonth + "'");
        }
        cal.set(7, CALENDAR_DAYS_OF_WEEK[dayOfWeek]);
        cal.set(8, weekOfMonth);
        return cal.get(5);
    }

    static boolean isWildCardYearAttribute(String yearAttribute) {
        if (yearAttribute == null || yearAttribute.trim().isEmpty()) {
            throw new IllegalArgumentException("year can not be null or empty!");
        }
        return (yearAttribute = yearAttribute.trim()).length() == 0 || "*".equals(yearAttribute);
    }

    static int getNextValidYear(String yearAttribute, int startYear) throws IllegalArgumentException {
        if (ScheduleExpressionUtil.isWildCardYearAttribute(yearAttribute)) {
            return startYear;
        }
        yearAttribute = yearAttribute.trim();
        int candidate = -100;
        StringTokenizer st = new StringTokenizer(yearAttribute, ",");
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException("Invalid year value: '" + yearAttribute + "'");
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int pos = token.indexOf(45);
            if (pos != -1) {
                int x = ScheduleExpressionUtil.parseInt(token.substring(0, pos));
                int y = ScheduleExpressionUtil.parseInt(token.substring(pos + 1, token.length()));
                ScheduleExpressionUtil.assertValidYear(x);
                ScheduleExpressionUtil.assertValidYear(y);
                if (x > y) {
                    throw new IllegalArgumentException("start year cannot be greater than start year: " + yearAttribute);
                }
                if (x <= startYear && startYear <= y) {
                    return startYear;
                }
                if (x <= startYear || x >= candidate && candidate != -100) continue;
                candidate = x;
                continue;
            }
            int value = ScheduleExpressionUtil.parseInt(token);
            ScheduleExpressionUtil.assertValidYear(value);
            if (startYear == value) {
                return startYear;
            }
            if (value <= startYear || value >= candidate && candidate != -100) continue;
            candidate = value;
        }
        return candidate;
    }

    static void assertValidYear(int year) {
        if (year < 1970 || year > 9999) {
            throw new IllegalArgumentException("Invalid year value " + year);
        }
    }

    static TimeZone parseTimeZoneValue(String timeZoneAttribute) throws IllegalArgumentException {
        if (timeZoneAttribute == null) {
            return null;
        }
        if ((timeZoneAttribute = timeZoneAttribute.trim()).length() == 0) {
            return null;
        }
        String[] validTimeZones = TimeZone.getAvailableIDs();
        for (int i = 0; i < validTimeZones.length; ++i) {
            if (!validTimeZones[i].equals(timeZoneAttribute)) continue;
            return TimeZone.getTimeZone(timeZoneAttribute);
        }
        throw new IllegalArgumentException("Time Zone attribute specified is invalid");
    }
}

