/*
 * Decompiled with CFR 0.152.
 */
package weblogic.timers.internal;

import java.util.Arrays;
import weblogic.timers.CancelTimerListener;
import weblogic.timers.ScheduleExpression;
import weblogic.timers.StopTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.internal.TimerContext;
import weblogic.timers.internal.TimerManagerImpl;

public class TimerImpl
implements Timer,
Comparable,
Runnable {
    private TimerManagerImpl timerManager;
    private TimerListener listener;
    protected long timeout;
    private long period;
    long counter;
    volatile boolean stopped;
    volatile boolean cancelled;
    volatile boolean running;
    protected TimerContext context;
    protected int idx = -1;
    private static final int HISTORY_SIZE = 100;
    private HistoryMany history;
    private static final long UNUSED_HISTORY = -1L;
    private long oneExpirationTime = -1L;

    TimerImpl(TimerManagerImpl timerManager, TimerListener listener, long timeout, long period) {
        this(timerManager, listener);
        this.timeout = timeout;
        this.period = period;
    }

    TimerImpl(TimerManagerImpl timerManager, TimerListener listener) {
        this.timerManager = timerManager;
        this.listener = listener;
    }

    void cleanup() {
    }

    static TimerImpl[] getTimers() {
        TimerManagerImpl[] managers = TimerManagerImpl.getAllTimerManagers();
        TimerImpl[][] timersArray = new TimerImpl[managers.length][];
        for (int i = 0; i < timersArray.length; ++i) {
            timersArray[i] = managers[i].getTimers();
        }
        int size = 0;
        for (TimerImpl[] timers : timersArray) {
            size += timers.length;
        }
        TimerImpl[] result = new TimerImpl[size];
        int pos = 0;
        for (TimerImpl[] timers : timersArray) {
            int len = timers.length;
            System.arraycopy(timers, 0, result, pos, len);
            pos += len;
        }
        return result.length == 0 ? null : result;
    }

    TimerManagerImpl getTimerManager() {
        return this.timerManager;
    }

    void setCounter(long counter) {
        this.counter = counter;
    }

    void setStopped() {
        this.stopped = true;
    }

    void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public long getPeriod() {
        return this.period;
    }

    @Override
    public TimerListener getListener() {
        return this.listener;
    }

    @Override
    public String getListenerClassName() {
        return this.listener.getClass().getName();
    }

    @Override
    public boolean isCalendarTimer() {
        return false;
    }

    @Override
    public ScheduleExpression getSchedule() {
        return null;
    }

    public long getScheduledExecutionTime() throws IllegalStateException {
        return this.timeout;
    }

    @Override
    public boolean cancel() {
        return this.timerManager.cancel(this);
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public final void run() {
        try {
            if (this.context != null) {
                this.context.push();
            }
            if (this.stopped) {
                if (this.listener instanceof StopTimerListener) {
                    ((StopTimerListener)this.listener).timerStopped(this);
                }
            } else if (this.cancelled) {
                if (this.listener instanceof CancelTimerListener) {
                    ((CancelTimerListener)this.listener).timerCancelled(this);
                }
            } else {
                this.recordExpirationTime();
                this.listener.timerExpired(this);
            }
        }
        finally {
            if (this.context != null) {
                this.context.pop();
            }
            this.timerManager.complete(this);
        }
    }

    boolean isExpired() {
        return this.timeout <= System.currentTimeMillis();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    boolean incrementTimeout() {
        if (this.period == 0L) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (this.period > 0L) {
            long nextTimeout;
            long begin = nextTimeout = this.timeout;
            do {
                if ((nextTimeout += this.period) >= begin) continue;
                nextTimeout = this.timerManager.normalizeTimeout(this.period);
                break;
            } while (nextTimeout < currentTime);
            this.timeout = nextTimeout;
        } else {
            this.timeout = this.timerManager.normalizeTimeout(-this.period);
        }
        return true;
    }

    public int compareTo(Object object) {
        TimerImpl timer = (TimerImpl)object;
        if (this.timeout > timer.timeout) {
            return 1;
        }
        if (this.timeout < timer.timeout) {
            return -1;
        }
        if (this.counter > timer.counter) {
            return 1;
        }
        if (this.counter < timer.counter) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "" + this.timeout + "." + this.counter + "(" + this.period + ")";
    }

    private void recordExpirationTime() {
        HistoryMany stableHistory = this.history;
        if (stableHistory == null) {
            if (this.oneExpirationTime == -1L) {
                this.oneExpirationTime = System.currentTimeMillis();
                return;
            }
            this.history = stableHistory = new HistoryMany();
            stableHistory.recordExpirationTime(this.oneExpirationTime);
        }
        stableHistory.recordExpirationTime(System.currentTimeMillis());
    }

    long[] sortedExpirationTimes() {
        HistoryMany stableHistory = this.history;
        if (stableHistory == null) {
            if (this.oneExpirationTime == -1L) {
                return new long[0];
            }
            long[] events = new long[]{this.oneExpirationTime};
            return events;
        }
        return stableHistory.sortedExpirationTimes();
    }

    private static final class HistoryMany {
        private int historyIndex = 0;
        private long[] pastExpirationTimes = new long[100];

        private HistoryMany() {
        }

        private void recordExpirationTime(long time) {
            this.pastExpirationTimes[this.historyIndex] = time;
            this.historyIndex = this.historyIndex == 99 ? 0 : ++this.historyIndex;
        }

        private long[] sortedExpirationTimes() {
            int index;
            long[] list1 = new long[this.pastExpirationTimes.length];
            System.arraycopy(this.pastExpirationTimes, 0, list1, 0, list1.length);
            Arrays.sort(list1);
            for (index = 0; index < list1.length && list1[index] <= 0L; ++index) {
            }
            if (index > 0) {
                long[] finalList = new long[list1.length - index];
                System.arraycopy(list1, index, finalList, 0, finalList.length);
                return finalList;
            }
            return list1;
        }
    }
}

