/*
 * Decompiled with CFR 0.152.
 */
package weblogic.timers.internal;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.kernel.KernelStatus;
import weblogic.timers.RuntimeDomainSelector;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.timers.internal.TimerFactory;
import weblogic.timers.internal.TimerManagerImpl;
import weblogic.timers.internal.commonj.TimerManagerImpl;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class TimerManagerFactoryImpl
extends TimerManagerFactory {
    private static final String DEFAULT_TIMER_MANAGER = "weblogic.timers.DefaultTimerManager";
    TimerFactory timerFactory;
    private ConcurrentHashMap<String, TimerManager> defaultTimerManagersMap = new ConcurrentHashMap();

    public TimerManagerFactoryImpl() {
        if (KernelStatus.isServer()) {
            try {
                Class<?> c = Class.forName("weblogic.timers.internal.ServerTimerFactory");
                this.timerFactory = (TimerFactory)c.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        if (this.timerFactory == null) {
            this.timerFactory = new TimerFactory();
        }
    }

    @Override
    public synchronized TimerManager getDefaultTimerManager() {
        String domainId = RuntimeDomainSelector.getDomain();
        TimerManager defaultTimerManager = this.defaultTimerManagersMap.get(domainId);
        if (defaultTimerManager != null) {
            return defaultTimerManager;
        }
        weblogic.timers.internal.TimerManagerImpl newDefaultTimerManager = weblogic.timers.internal.TimerManagerImpl.getTimerManager(DEFAULT_TIMER_MANAGER, new WorkManagerExecutor(WorkManagerFactory.getInstance().getDefault()), this.timerFactory);
        defaultTimerManager = this.defaultTimerManagersMap.putIfAbsent(domainId, newDefaultTimerManager);
        if (defaultTimerManager == null) {
            return newDefaultTimerManager;
        }
        return defaultTimerManager;
    }

    @Override
    public TimerManager getTimerManager(String name, String policy) {
        WorkManager wm = WorkManagerFactory.getInstance().find(policy);
        if (wm == null) {
            throw new IllegalArgumentException("No work manager for policy " + policy);
        }
        return this.getTimerManager(name, wm);
    }

    @Override
    public TimerManager getTimerManager(String name, WorkManager wm) {
        if (DEFAULT_TIMER_MANAGER.equals(name)) {
            if (wm == WorkManagerFactory.getInstance().getDefault()) {
                return this.getDefaultTimerManager();
            }
            throw new IllegalArgumentException("Existing manager has different policy");
        }
        if (wm == null) {
            wm = WorkManagerFactory.getInstance().getDefault();
        }
        return weblogic.timers.internal.TimerManagerImpl.getTimerManager(name, new WorkManagerExecutor(wm), this.timerFactory);
    }

    @Override
    public TimerManager getTimerManager(String name) {
        return this.getTimerManager(name, (WorkManager)null);
    }

    @Override
    public commonj.timers.TimerManager getCommonjTimerManager(String name, WorkManager wm) {
        return this.getCommonjTimerManager(this.getTimerManager(name, wm));
    }

    @Override
    public commonj.timers.TimerManager getCommonjTimerManager(TimerManager manager) {
        return new TimerManagerImpl(manager);
    }

    @Override
    public void stopAllTimers() {
        Collection<TimerManager> defaultTimersManagers = this.defaultTimerManagersMap.values();
        for (TimerManager defaultTimerManager : defaultTimersManagers) {
            defaultTimerManager.stop();
        }
        weblogic.timers.internal.TimerManagerImpl.stopAllTimers();
    }

    synchronized void cleanupForPartition() {
        String domainId = RuntimeDomainSelector.getDomain();
        this.defaultTimerManagersMap.remove(domainId);
    }

    class WorkManagerExecutor
    implements TimerManagerImpl.Executor {
        private final WorkManager workManager;

        WorkManagerExecutor(WorkManager workManager) {
            this.workManager = workManager;
        }

        @Override
        public void execute(Runnable work) {
            this.workManager.schedule(work);
        }

        @Override
        public boolean equals(TimerManagerImpl.Executor other) {
            if (!(other instanceof WorkManagerExecutor)) {
                return false;
            }
            return this.workManager == ((WorkManagerExecutor)other).workManager;
        }

        public String toString() {
            return "TimerManagerFactoryImpl$WorkManagerExecutor - workManager is " + (this.workManager == null ? "null" : this.workManager.getClass() + ":" + this.workManager.toString());
        }
    }
}

